# Cited Artifact Contribution Type - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Cited Artifact Contribution Type**

## CodeSystem: Cited Artifact Contribution Type 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/cited-artifact-contribution-type | *Version*:1.0.0 | | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[HL7 (FHIR Project)](http://hl7.org/fhir) | *Computable Name*:CitedArtifactContributionType |

 
Citation contribution. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [CitedArtifactContributionType](ValueSet-cited-artifact-contribution-type.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "cited-artifact-contribution-type",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cds"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/cited-artifact-contribution-type",
  "version" : "1.0.0",
  "name" : "CitedArtifactContributionType",
  "title" : "Cited Artifact Contribution Type",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-01-20T16:55:11+11:00",
  "publisher" : "HL7 (FHIR Project)",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org/fhir"
        },
        {
          "system" : "email",
          "value" : "fhir@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "Citation contribution.",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/cited-artifact-contribution-type",
  "content" : "complete",
  "concept" : [
    {
      "code" : "conceptualization",
      "display" : "Conceptualization",
      "definition" : "Conceptualization (see https://jats4r.org/credit-taxonomy)."
    },
    {
      "code" : "data-curation",
      "display" : "Data curation",
      "definition" : "Data curation (see https://jats4r.org/credit-taxonomy)."
    },
    {
      "code" : "formal-analysis",
      "display" : "Formal analysis",
      "definition" : "Formal analysis (see https://jats4r.org/credit-taxonomy)."
    },
    {
      "code" : "funding-acquisition",
      "display" : "Funding acquisition",
      "definition" : "Funding acquisition (see https://jats4r.org/credit-taxonomy)."
    },
    {
      "code" : "investigation",
      "display" : "Investigation",
      "definition" : "Investigation (see https://jats4r.org/credit-taxonomy)."
    },
    {
      "code" : "methodology",
      "display" : "Methodology",
      "definition" : "Methodology (see https://jats4r.org/credit-taxonomy)."
    },
    {
      "code" : "project-administration",
      "display" : "Project administration",
      "definition" : "Project administration (see https://jats4r.org/credit-taxonomy)."
    },
    {
      "code" : "resources",
      "display" : "Resources",
      "definition" : "Resources (see https://jats4r.org/credit-taxonomy)."
    },
    {
      "code" : "software",
      "display" : "Software",
      "definition" : "Software (see https://jats4r.org/credit-taxonomy)."
    },
    {
      "code" : "supervision",
      "display" : "Supervision",
      "definition" : "Supervision (see https://jats4r.org/credit-taxonomy)."
    },
    {
      "code" : "validation",
      "display" : "Validation",
      "definition" : "Validation (see https://jats4r.org/credit-taxonomy)."
    },
    {
      "code" : "visualization",
      "display" : "Visualization",
      "definition" : "Visualization (see https://jats4r.org/credit-taxonomy)."
    },
    {
      "code" : "writing-original-draft",
      "display" : "Writing - original draft",
      "definition" : "Writing - original draft (see https://jats4r.org/credit-taxonomy)."
    },
    {
      "code" : "writing-review-editing",
      "display" : "Writing - review & editing",
      "definition" : "Writing - review & editing (see https://jats4r.org/credit-taxonomy)."
    }
  ]
}

```
