# Network Type Codes - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Network Type Codes**

## CodeSystem: Network Type Codes 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/benefit-network | *Version*:2.0.0 | | |
| Active as of 2025-11-12 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:NetworkTypeCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1177 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
This code system represents the contractual relationship between a provider and payer for administrative purposes for a specific patient, service, or product. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [NetworkTypeCodes](ValueSet-benefit-network.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "benefit-network",
  "meta" : {
    "lastUpdated" : "2025-05-09T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/benefit-network",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1177"
    }
  ],
  "version" : "2.0.0",
  "name" : "NetworkTypeCodes",
  "title" : "Network Type Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-12T19:01:04+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This code system represents the contractual relationship between a provider and payer for administrative purposes for a specific patient, service, or product.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/benefit-network",
  "content" : "complete",
  "concept" : [
    {
      "code" : "in",
      "display" : "In Network",
      "definition" : "Services rendered by a Network provider"
    },
    {
      "code" : "out",
      "display" : "Out of Network",
      "definition" : "Services rendered by a provider who is not in the Network"
    },
    {
      "code" : "negotiated",
      "display" : "Negotiated Service or Product",
      "definition" : "Special negotiated status for a service or product in relation to a patient's coverage that is established outside of a formal network contract"
    }
  ]
}

```
