# Appointment cancellation reason - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Appointment cancellation reason**

## CodeSystem: Appointment cancellation reason 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/appointment-cancellation-reason | *Version*:2.1.1 | | |
| Active as of 2025-11-12 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:AppointmentCancellationReason |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1382 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
This example value set defines a set of reasons for the cancellation of an appointment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [AppointmentCancellationReason](ValueSet-appointment-cancellation-reason.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "appointment-cancellation-reason",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/appointment-cancellation-reason",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1382"
    }
  ],
  "version" : "2.1.1",
  "name" : "AppointmentCancellationReason",
  "title" : "Appointment cancellation reason",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-12T19:01:04+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This example value set defines a set of reasons for the cancellation of an appointment.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/appointment-cancellation-reason",
  "content" : "complete",
  "concept" : [
    {
      "code" : "pat",
      "display" : "Patient",
      "concept" : [
        {
          "code" : "pat-crs",
          "display" : "Patient: Canceled via automated reminder system"
        },
        {
          "code" : "pat-cpp",
          "display" : "Patient: Canceled via Patient Portal"
        },
        {
          "code" : "pat-dec",
          "display" : "Patient: Deceased"
        },
        {
          "code" : "pat-fb",
          "display" : "Patient: Feeling Better"
        },
        {
          "code" : "pat-lt",
          "display" : "Patient: Lack of Transportation"
        },
        {
          "code" : "pat-mt",
          "display" : "Patient: No longer covered by insurance or other payers"
        },
        {
          "code" : "pat-mv",
          "display" : "Patient: Moved Residence"
        },
        {
          "code" : "pat-preg",
          "display" : "Patient: Pregnant"
        },
        {
          "code" : "pat-swl",
          "display" : "Patient: Scheduled from Wait List"
        },
        {
          "code" : "pat-ucp",
          "display" : "Patient: Unhappy/Changed Provider"
        }
      ]
    },
    {
      "code" : "prov",
      "display" : "Provider",
      "concept" : [
        {
          "code" : "prov-pers",
          "display" : "Provider: Personal"
        },
        {
          "code" : "prov-dch",
          "display" : "Provider: Discharged"
        },
        {
          "code" : "prov-edu",
          "display" : "Provider: Edu/Meeting"
        },
        {
          "code" : "prov-hosp",
          "display" : "Provider: Hospitalized"
        },
        {
          "code" : "prov-labs",
          "display" : "Provider: Labs Out of Acceptable Range"
        },
        {
          "code" : "prov-mri",
          "display" : "Provider: MRI Screening Form Marked Do Not Proceed"
        },
        {
          "code" : "prov-onc",
          "display" : "Provider: Oncology Treatment Plan Changes"
        }
      ]
    },
    {
      "code" : "maint",
      "display" : "Equipment Maintenance/Repair"
    },
    {
      "code" : "meds-inc",
      "display" : "Prep/Med Incomplete"
    },
    {
      "code" : "other",
      "display" : "Other",
      "concept" : [
        {
          "code" : "oth-cms",
          "display" : "Other: CMS Therapy Cap Service Not Authorized"
        },
        {
          "code" : "oth-err",
          "display" : "Other: Error"
        },
        {
          "code" : "oth-fin",
          "display" : "Other: Financial"
        },
        {
          "code" : "oth-iv",
          "display" : "Other: Improper IV Access/Infiltrate IV"
        },
        {
          "code" : "oth-int",
          "display" : "Other: No Interpreter Available"
        },
        {
          "code" : "oth-mu",
          "display" : "Other: Prep/Med/Results Unavailable"
        },
        {
          "code" : "oth-room",
          "display" : "Other: Room/Resource Maintenance"
        },
        {
          "code" : "oth-oerr",
          "display" : "Other: Schedule Order Error"
        },
        {
          "code" : "oth-swie",
          "display" : "Other: Silent Walk In Error"
        },
        {
          "code" : "oth-weath",
          "display" : "Other: Weather"
        }
      ]
    }
  ]
}

```
