# AllergyIntoleranceSubstanceExposureRisk - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **AllergyIntoleranceSubstanceExposureRisk**

## CodeSystem: AllergyIntoleranceSubstanceExposureRisk 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/allerg-intol-substance-exp-risk | *Version*:1.0.0 | |
| Draft as of 2020-04-09 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:AllergyIntoleranceSubstanceExposureRisk |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1275 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
The risk of an adverse reaction (allergy or intolerance) for this patient upon exposure to the substance (including pharmaceutical products). 

 This Code system is referenced in the content logical definition of the following value sets: 

* [AllergyIntoleranceSubstanceExposureRisk](ValueSet-allerg-intol-substance-exp-risk.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "allerg-intol-substance-exp-risk",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00"
  },
  "url" : "http://terminology.hl7.org/CodeSystem/allerg-intol-substance-exp-risk",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1275"
    }
  ],
  "version" : "1.0.0",
  "name" : "AllergyIntoleranceSubstanceExposureRisk",
  "title" : "AllergyIntoleranceSubstanceExposureRisk",
  "status" : "draft",
  "experimental" : false,
  "date" : "2020-04-09T21:10:28+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The risk of an adverse reaction (allergy or intolerance) for this patient upon exposure to the substance (including pharmaceutical products).",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/allerg-intol-substance-exp-risk",
  "content" : "complete",
  "concept" : [
    {
      "code" : "known-reaction-risk",
      "display" : "Known Reaction Risk",
      "definition" : "Known risk of allergy or intolerance reaction upon exposure to the specified substance."
    },
    {
      "code" : "no-known-reaction-risk",
      "display" : "No Known Reaction Risk",
      "definition" : "No known risk of allergy or intolerance reaction upon exposure to the specified substance."
    }
  ]
}

```
