# AdverseEventSeverity - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **AdverseEventSeverity**

## CodeSystem: AdverseEventSeverity 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/adverse-event-severity | *Version*:1.0.0 | |
| Draft as of 2020-04-09 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:AdverseEventSeverity |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1256 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
The severity of the adverse event itself, in direct relation to the subject. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [AdverseEventSeverity](ValueSet-adverse-event-severity.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "adverse-event-severity",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00"
  },
  "url" : "http://terminology.hl7.org/CodeSystem/adverse-event-severity",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1256"
    }
  ],
  "version" : "1.0.0",
  "name" : "AdverseEventSeverity",
  "title" : "AdverseEventSeverity",
  "status" : "draft",
  "experimental" : false,
  "date" : "2020-04-09T21:10:28+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The severity of the adverse event itself, in direct relation to the subject.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/adverse-event-severity",
  "content" : "complete",
  "concept" : [
    {
      "code" : "mild",
      "display" : "Mild"
    },
    {
      "code" : "moderate",
      "display" : "Moderate"
    },
    {
      "code" : "severe",
      "display" : "Severe"
    }
  ]
}

```
