# AdverseEventCategory - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **AdverseEventCategory**

## CodeSystem: AdverseEventCategory 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/adverse-event-category | *Version*:2.0.0 | | |
| Active as of 2024-08-28 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:AdverseEventCategory |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1251 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
Overall categorization of the event, e.g. product-related or situational. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [AdverseEventCategory](ValueSet-adverse-event-category.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "adverse-event-category",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pc"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/adverse-event-category",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1251"
    }
  ],
  "version" : "2.0.0",
  "name" : "AdverseEventCategory",
  "title" : "AdverseEventCategory",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-08-28T00:00:00+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Overall categorization of the event, e.g. product-related or situational.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/adverse-event-category",
  "content" : "complete",
  "concept" : [
    {
      "code" : "clinical-research",
      "display" : "Clinical Research",
      "definition" : "The adverse event pertains to clinical research."
    },
    {
      "code" : "wrong-patient",
      "display" : "Wrong Patient",
      "definition" : "The adverse event pertains to an event involving the wrong patient, who was not the intended subject."
    },
    {
      "code" : "procedure-mishap",
      "display" : "Procedure Mishap",
      "definition" : "The adverse event pertains to a procedure mishap."
    },
    {
      "code" : "medication-mishap",
      "display" : "Medication Mishap",
      "definition" : "The adverse event pertains to a medication mishap, such as wrong dose, route, rate, or duration of administration."
    },
    {
      "code" : "device",
      "display" : "Device",
      "definition" : "The adverse event pertains to a device."
    },
    {
      "code" : "unsafe-physical-environment",
      "display" : "Unsafe Physical Environment",
      "definition" : "The adverse event pertains to an unsafe physical environment."
    },
    {
      "code" : "hospital-aquired-infection",
      "display" : "Hospital Acquired Infection",
      "definition" : "The adverse event pertains to a hospital acquired infection."
    },
    {
      "code" : "wrong-body-site",
      "display" : "Wrong Body Site",
      "definition" : "The adverse event pertains to the wrong body site."
    }
  ]
}

```
