# Adjudication Value Codes - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Adjudication Value Codes**

## CodeSystem: Adjudication Value Codes 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/adjudication | *Version*:1.0.1 | | |
| Active as of 2025-11-12 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:AdjudicationValueCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1171 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
This value set includes a smattering of Adjudication Value codes which includes codes to indicate the amounts eligible under the plan, the amount of benefit, copays etc. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [AdjudicationValueCodes](ValueSet-adjudication.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "adjudication",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/adjudication",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1171"
    }
  ],
  "version" : "1.0.1",
  "name" : "AdjudicationValueCodes",
  "title" : "Adjudication Value Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-12T19:01:04+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This value set includes a smattering of Adjudication Value codes which includes codes to indicate the amounts eligible under the plan, the amount of benefit, copays etc.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/adjudication",
  "content" : "complete",
  "concept" : [
    {
      "code" : "submitted",
      "display" : "Submitted Amount",
      "definition" : "The total submitted amount for the claim or group or line item."
    },
    {
      "code" : "copay",
      "display" : "CoPay",
      "definition" : "Patient Co-Payment"
    },
    {
      "code" : "eligible",
      "display" : "Eligible Amount",
      "definition" : "Amount of the change which is considered for adjudication."
    },
    {
      "code" : "deductible",
      "display" : "Deductible",
      "definition" : "Amount deducted from the eligible amount prior to adjudication."
    },
    {
      "code" : "unallocdeduct",
      "display" : "Unallocated Deductible",
      "definition" : "The amount of deductible which could not allocated to other line items."
    },
    {
      "code" : "eligpercent",
      "display" : "Eligible %",
      "definition" : "Eligible Percentage."
    },
    {
      "code" : "tax",
      "display" : "Tax",
      "definition" : "The amount of tax."
    },
    {
      "code" : "benefit",
      "display" : "Benefit Amount",
      "definition" : "Amount payable under the coverage"
    }
  ]
}

```
