# ADA Tooth Surface Codes - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ADA Tooth Surface Codes**

## CodeSystem: ADA Tooth Surface Codes 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/ADAToothSurfaceCodes | *Version*:1.0.0 | | |
| Active as of 2024-08-28 | *Responsible:*American Dental Association | *Realm:*![](assets/images/usa.svg) | *Computable Name*:ADAToothSurfaceCodes |
| **Copyright/Legal**: No official copyright statement is available. For general information see paper form located here :[https://www.ada.org/-/media/project/ada-organization/ada/ada-org/files/publications/cdt/v2019adadentalclaimcompletioninstructions_v3_2022feb.pdf](https://www.ada.org/-/media/project/ada-organization/ada/ada-org/files/publications/cdt/v2019adadentalclaimcompletioninstructions_v3_2022feb.pdf) | | | |

 
Tooth Surface Codes are defined by the HIPAA standard electronic dental claim transaction (837D v5010) and the ADA Dental Claim Form. Surface codes can be used in a variety of combinations to define a multi-surface procedure (ie. MOD for a singular intervention which covers Mesial, Occlusal, and Distal surfaces). Tooth Surface Codes can be accessed through the[ADA Guide to Dental Procedures Reported with Area of the Oral Cavity or Tooth Anatomy (or Both).](https://www.ada.org/-/media/project/ada-organization/ada/ada-org/files/publications/cdt/final_areaoftheoralcavityandtoothanatomy.pdf?rev=fbd215c7d8c546aa967443e79f9d8e20&hash=2F759947EFD75EF5ABCCBF0F62CE1FE7) 

 This Code system is referenced in the content logical definition of the following value sets: 

* This CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "ADAToothSurfaceCodes",
  "url" : "http://terminology.hl7.org/CodeSystem/ADAToothSurfaceCodes",
  "version" : "1.0.0",
  "name" : "ADAToothSurfaceCodes",
  "title" : "ADA Tooth Surface Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-08-28T00:00:00-00:00",
  "publisher" : "American Dental Association",
  "contact" : [
    {
      "name" : "American Dental Association; 211 East Chicago Avenue Chicago, IL 60610-2678"
    }
  ],
  "description" : "Tooth Surface Codes are defined by the HIPAA standard electronic dental claim transaction (837D v5010) and the ADA Dental Claim Form.   Surface codes can be used in a variety of combinations to define a multi-surface procedure (ie. MOD for a singular intervention which covers Mesial, Occlusal, and Distal surfaces).   Tooth Surface Codes can be accessed through the [ADA Guide to Dental Procedures Reported with Area of the Oral Cavity or Tooth Anatomy (or Both).](https://www.ada.org/-/media/project/ada-organization/ada/ada-org/files/publications/cdt/final_areaoftheoralcavityandtoothanatomy.pdf?rev=fbd215c7d8c546aa967443e79f9d8e20&hash=2F759947EFD75EF5ABCCBF0F62CE1FE7)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "copyright" : "No official copyright statement is available. For general information see paper form located here : [https://www.ada.org/-/media/project/ada-organization/ada/ada-org/files/publications/cdt/v2019adadentalclaimcompletioninstructions_v3_2022feb.pdf](https://www.ada.org/-/media/project/ada-organization/ada/ada-org/files/publications/cdt/v2019adadentalclaimcompletioninstructions_v3_2022feb.pdf)",
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 7,
  "concept" : [
    {
      "code" : "M",
      "display" : "Mesial",
      "definition" : "The surface of a tooth that is closest to the midline (middle) of the face."
    },
    {
      "code" : "O",
      "display" : "Occlusal",
      "definition" : "The chewing surface of posterior teeth."
    },
    {
      "code" : "I",
      "display" : "Incisal",
      "definition" : "The biting edge of anterior teeth."
    },
    {
      "code" : "D",
      "display" : "Distal",
      "definition" : "The surface of a tooth that faces away from the midline of the face."
    },
    {
      "code" : "B",
      "display" : "Buccal",
      "definition" : "The surface of a posterior tooth facing the cheeks."
    },
    {
      "code" : "F",
      "display" : "Facial",
      "definition" : "The surface of a tooth facing the lips."
    },
    {
      "code" : "L",
      "display" : "Lingual",
      "definition" : "The surface of a tooth facing the tongue."
    }
  ]
}

```
