#  - HL7 Terminology (THO) v6.5.1

## : 



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "hxutg1-1-0-7",
  "type" : "collection",
  "entry" : [
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-ACR-ns-1-1-10",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-ACR-ns-1-1-10",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-ACR-ns-1-1-10\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-ACR-ns-1-1-10</b></p><a name=\"hx1g-ACR-ns-1-1-10\"> </a><a name=\"hchx1g-ACR-ns-1-1-10\"> </a><p>Provenance for <a href=\"NamingSystem-ACR.html\">NamingSystem American College of Radiology Finding Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-12</td></tr><tr><td>Recorded</td><td>2020-06-12 12:10:49+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/ACR"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-12"
        },
        "recorded" : "2020-06-12T12:10:49+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-AS4-ns-1-1-10",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-AS4-ns-1-1-10",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-AS4-ns-1-1-10\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-AS4-ns-1-1-10</b></p><a name=\"hx1g-AS4-ns-1-1-10\"> </a><a name=\"hchx1g-AS4-ns-1-1-10\"> </a><p>Provenance for <a href=\"NamingSystem-AS4.html\">NamingSystem ASTM E1238/E1467 Universal</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-12</td></tr><tr><td>Recorded</td><td>2020-06-12 12:11:58+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/AS4"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-12"
        },
        "recorded" : "2020-06-12T12:11:58+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-AS4E-ns-1-1-10",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-AS4E-ns-1-1-10",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-AS4E-ns-1-1-10\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-AS4E-ns-1-1-10</b></p><a name=\"hx1g-AS4E-ns-1-1-10\"> </a><a name=\"hchx1g-AS4E-ns-1-1-10\"> </a><p>Provenance for <a href=\"NamingSystem-AS4E.html\">NamingSystem AS4 Neurophysiology Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-12</td></tr><tr><td>Recorded</td><td>2020-06-12 12:12:23+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/AS4E"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-12"
        },
        "recorded" : "2020-06-12T12:12:23+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-C5-ns-1-1-10",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-C5-ns-1-1-10",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-C5-ns-1-1-10\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-C5-ns-1-1-10</b></p><a name=\"hx1g-C5-ns-1-1-10\"> </a><a name=\"hchx1g-C5-ns-1-1-10\"> </a><p>Provenance for <a href=\"NamingSystem-C5.html\">NamingSystem CPT-5</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-12</td></tr><tr><td>Recorded</td><td>2020-06-12 12:13:11+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/C5"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-12"
        },
        "recorded" : "2020-06-12T12:13:11+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-CAS-ns-1-1-10",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-CAS-ns-1-1-10",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-CAS-ns-1-1-10\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-CAS-ns-1-1-10</b></p><a name=\"hx1g-CAS-ns-1-1-10\"> </a><a name=\"hchx1g-CAS-ns-1-1-10\"> </a><p>Provenance for <a href=\"NamingSystem-CAS.html\">NamingSystem Chemical Abstract Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-12</td></tr><tr><td>Recorded</td><td>2020-06-12 12:13:33+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/CAS"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-12"
        },
        "recorded" : "2020-06-12T12:13:33+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-ahfs-ns-1-1-10",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-ahfs-ns-1-1-10",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-ahfs-ns-1-1-10\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-ahfs-ns-1-1-10</b></p><a name=\"hx1g-ahfs-ns-1-1-10\"> </a><a name=\"hchx1g-ahfs-ns-1-1-10\"> </a><p>Provenance for <a href=\"NamingSystem-ahfs.html\">NamingSystem AHFS Pharmacologic-Therapeutic Classification</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-12</td></tr><tr><td>Recorded</td><td>2020-06-12 12:14:49+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/ahfs"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-12"
        },
        "recorded" : "2020-06-12T12:14:49+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-art-ns-1-1-10",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-art-ns-1-1-10",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-art-ns-1-1-10\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-art-ns-1-1-10</b></p><a name=\"hx1g-art-ns-1-1-10\"> </a><a name=\"hchx1g-art-ns-1-1-10\"> </a><p>Provenance for <a href=\"NamingSystem-art.html\">NamingSystem WHO Adverse Reaction Terms</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-12</td></tr><tr><td>Recorded</td><td>2020-06-12 12:15:46+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/art"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-12"
        },
        "recorded" : "2020-06-12T12:15:46+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-v3-brazilianProcedureCodesSUS-ns-1-1-10",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-v3-brazilianProcedureCodesSUS-ns-1-1-10",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-v3-brazilianProcedureCodesSUS-ns-1-1-10\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-v3-brazilianProcedureCodesSUS-ns-1-1-10</b></p><a name=\"hx1g-v3-brazilianProcedureCodesSUS-ns-1-1-10\"> </a><a name=\"hchx1g-v3-brazilianProcedureCodesSUS-ns-1-1-10\"> </a><p>Provenance for <a href=\"NamingSystem-v3-brazilianProcedureCodesSUS.html\">NamingSystem Brazilian Procedure Codes SUS</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-12</td></tr><tr><td>Recorded</td><td>2020-06-12 12:17:01+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/v3-brazilianProcedureCodesSUS"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-12"
        },
        "recorded" : "2020-06-12T12:17:01+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-camncvs-ns-1-1-10",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-camncvs-ns-1-1-10",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-camncvs-ns-1-1-10\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-camncvs-ns-1-1-10</b></p><a name=\"hx1g-camncvs-ns-1-1-10\"> </a><a name=\"hchx1g-camncvs-ns-1-1-10\"> </a><p>Provenance for <a href=\"NamingSystem-camncvs.html\">NamingSystem CAMNCVS</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-12</td></tr><tr><td>Recorded</td><td>2020-06-12 12:17:47+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/camncvs"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-12"
        },
        "recorded" : "2020-06-12T12:17:47+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-CCC-ns-1-1-11",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-CCC-ns-1-1-11",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-CCC-ns-1-1-11\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-CCC-ns-1-1-11</b></p><a name=\"hx1g-CCC-ns-1-1-11\"> </a><a name=\"hchx1g-CCC-ns-1-1-11\"> </a><p>Provenance for <a href=\"NamingSystem-CCC.html\">NamingSystem Clinical Care Classification System</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-12</td></tr><tr><td>Recorded</td><td>2020-06-12 16:38:10+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/CCC"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-12"
        },
        "recorded" : "2020-06-12T16:38:10+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-v3-cci-ns-1-1-11",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-v3-cci-ns-1-1-11",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-v3-cci-ns-1-1-11\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-v3-cci-ns-1-1-11</b></p><a name=\"hx1g-v3-cci-ns-1-1-11\"> </a><a name=\"hchx1g-v3-cci-ns-1-1-11\"> </a><p>Provenance for <a href=\"NamingSystem-v3-cci.html\">NamingSystem Canadian Classification of Health Interventions</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-12</td></tr><tr><td>Recorded</td><td>2020-06-12 16:38:51+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/v3-cci"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-12"
        },
        "recorded" : "2020-06-12T16:38:51+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-CDT-ns-1-1-11",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-CDT-ns-1-1-11",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-CDT-ns-1-1-11\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-CDT-ns-1-1-11</b></p><a name=\"hx1g-CDT-ns-1-1-11\"> </a><a name=\"hchx1g-CDT-ns-1-1-11\"> </a><p>Provenance for <a href=\"NamingSystem-CDT.html\">NamingSystem Code on Dental Procedures and Nomenclature</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-12</td></tr><tr><td>Recorded</td><td>2020-06-12 16:39:24+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/CDT"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-12"
        },
        "recorded" : "2020-06-12T16:39:24+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-CDARUS-ns-1-1-11",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-CDARUS-ns-1-1-11",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-CDARUS-ns-1-1-11\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-CDARUS-ns-1-1-11</b></p><a name=\"hx1g-CDARUS-ns-1-1-11\"> </a><a name=\"hchx1g-CDARUS-ns-1-1-11\"> </a><p>Provenance for <a href=\"NamingSystem-CDARUS.html\">NamingSystem CDA_RUS</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-12</td></tr><tr><td>Recorded</td><td>2020-06-12 16:40:02+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/CDARUS"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-12"
        },
        "recorded" : "2020-06-12T16:40:02+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-CDCA-ns-1-1-11",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-CDCA-ns-1-1-11",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-CDCA-ns-1-1-11\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-CDCA-ns-1-1-11</b></p><a name=\"hx1g-CDCA-ns-1-1-11\"> </a><a name=\"hchx1g-CDCA-ns-1-1-11\"> </a><p>Provenance for <a href=\"NamingSystem-CDCA.html\">NamingSystem CDC Analyte Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-12</td></tr><tr><td>Recorded</td><td>2020-06-12 16:40:33+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/CDCA"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-12"
        },
        "recorded" : "2020-06-12T16:40:33+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-CDCM-ns-1-1-11",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-CDCM-ns-1-1-11",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-CDCM-ns-1-1-11\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-CDCM-ns-1-1-11</b></p><a name=\"hx1g-CDCM-ns-1-1-11\"> </a><a name=\"hchx1g-CDCM-ns-1-1-11\"> </a><p>Provenance for <a href=\"NamingSystem-CDCM.html\">NamingSystem CDC Methods/Instruments Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-12</td></tr><tr><td>Recorded</td><td>2020-06-12 16:43:35+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/CDCM"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-12"
        },
        "recorded" : "2020-06-12T16:43:35+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-CDCNHSN-ns-1-1-11",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-CDCNHSN-ns-1-1-11",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-CDCNHSN-ns-1-1-11\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-CDCNHSN-ns-1-1-11</b></p><a name=\"hx1g-CDCNHSN-ns-1-1-11\"> </a><a name=\"hchx1g-CDCNHSN-ns-1-1-11\"> </a><p>Provenance for <a href=\"NamingSystem-CDCNHSN.html\">NamingSystem NHSN Surveillance System Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-12</td></tr><tr><td>Recorded</td><td>2020-06-12 16:44:12+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/CDCNHSN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-12"
        },
        "recorded" : "2020-06-12T16:44:12+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-CDS-ns-1-1-11",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-CDS-ns-1-1-11",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-CDS-ns-1-1-11\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-CDS-ns-1-1-11</b></p><a name=\"hx1g-CDS-ns-1-1-11\"> </a><a name=\"hchx1g-CDS-ns-1-1-11\"> </a><p>Provenance for <a href=\"NamingSystem-CDS.html\">NamingSystem CDC Surveillance</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-12</td></tr><tr><td>Recorded</td><td>2020-06-12 16:44:39+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/CDS"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-12"
        },
        "recorded" : "2020-06-12T16:44:39+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-CE-ns-1-1-11",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-CE-ns-1-1-11",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-CE-ns-1-1-11\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-CE-ns-1-1-11</b></p><a name=\"hx1g-CE-ns-1-1-11\"> </a><a name=\"hchx1g-CE-ns-1-1-11\"> </a><p>Provenance for <a href=\"NamingSystem-CE.html\">NamingSystem CEN ECG diagnostic codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-12</td></tr><tr><td>Recorded</td><td>2020-06-12 16:45:05+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/CE"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-12"
        },
        "recorded" : "2020-06-12T16:45:05+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-CLP-ns-1-1-11",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-CLP-ns-1-1-11",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-CLP-ns-1-1-11\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-CLP-ns-1-1-11</b></p><a name=\"hx1g-CLP-ns-1-1-11\"> </a><a name=\"hchx1g-CLP-ns-1-1-11\"> </a><p>Provenance for <a href=\"NamingSystem-CLP.html\">NamingSystem CLIP</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-12</td></tr><tr><td>Recorded</td><td>2020-06-12 16:45:33+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/CLP"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-12"
        },
        "recorded" : "2020-06-12T16:45:33+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-cpnum-ns-1-1-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-cpnum-ns-1-1-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-cpnum-ns-1-1-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-cpnum-ns-1-1-12</b></p><a name=\"hx1g-cpnum-ns-1-1-12\"> </a><a name=\"hchx1g-cpnum-ns-1-1-12\"> </a><p>Provenance for <a href=\"NamingSystem-cpnum.html\">NamingSystem Gold Standard's Clinical Pharmacology Monograph Number</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-12</td></tr><tr><td>Recorded</td><td>2020-06-12 17:53:28+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/cpnum"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-12"
        },
        "recorded" : "2020-06-12T17:53:28+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-CPT-ns-1-1-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-CPT-ns-1-1-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-CPT-ns-1-1-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-CPT-ns-1-1-12</b></p><a name=\"hx1g-CPT-ns-1-1-12\"> </a><a name=\"hchx1g-CPT-ns-1-1-12\"> </a><p>Provenance for <a href=\"NamingSystem-CPT.html\">NamingSystem Current Procedural Terminology (CPT®)</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-12</td></tr><tr><td>Recorded</td><td>2020-06-12 17:54:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/CPT"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-12"
        },
        "recorded" : "2020-06-12T17:54:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-csaid-ns-1-1-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-csaid-ns-1-1-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-csaid-ns-1-1-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-csaid-ns-1-1-12</b></p><a name=\"hx1g-csaid-ns-1-1-12\"> </a><a name=\"hchx1g-csaid-ns-1-1-12\"> </a><p>Provenance for <a href=\"NamingSystem-csaid.html\">NamingSystem CAN/CSA-Z795-96</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-12</td></tr><tr><td>Recorded</td><td>2020-06-12 17:54:42+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/csaid"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-12"
        },
        "recorded" : "2020-06-12T17:54:42+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-CST-ns-1-1-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-CST-ns-1-1-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-CST-ns-1-1-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-CST-ns-1-1-12</b></p><a name=\"hx1g-CST-ns-1-1-12\"> </a><a name=\"hchx1g-CST-ns-1-1-12\"> </a><p>Provenance for <a href=\"NamingSystem-CST.html\">NamingSystem COSTART</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-12</td></tr><tr><td>Recorded</td><td>2020-06-12 17:55:16+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/CST"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-12"
        },
        "recorded" : "2020-06-12T17:55:16+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-CVX-ns-1-1-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-CVX-ns-1-1-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-CVX-ns-1-1-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-CVX-ns-1-1-12</b></p><a name=\"hx1g-CVX-ns-1-1-12\"> </a><a name=\"hchx1g-CVX-ns-1-1-12\"> </a><p>Provenance for <a href=\"NamingSystem-CVX.html\">NamingSystem Vaccine Administered Code Set (CVX)</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-12</td></tr><tr><td>Recorded</td><td>2020-06-12 17:55:46+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/CVX"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-12"
        },
        "recorded" : "2020-06-12T17:55:46+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-v3-dbSNP-ns-1-1-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-v3-dbSNP-ns-1-1-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-v3-dbSNP-ns-1-1-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-v3-dbSNP-ns-1-1-12</b></p><a name=\"hx1g-v3-dbSNP-ns-1-1-12\"> </a><a name=\"hchx1g-v3-dbSNP-ns-1-1-12\"> </a><p>Provenance for <a href=\"NamingSystem-v3-dbSNP.html\">NamingSystem Genetic Sequence polymorphism database</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-12</td></tr><tr><td>Recorded</td><td>2020-06-12 17:56:29+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/v3-dbSNP"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-12"
        },
        "recorded" : "2020-06-12T17:56:29+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-DCL-ns-1-1-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-DCL-ns-1-1-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-DCL-ns-1-1-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-DCL-ns-1-1-12</b></p><a name=\"hx1g-DCL-ns-1-1-12\"> </a><a name=\"hchx1g-DCL-ns-1-1-12\"> </a><p>Provenance for <a href=\"NamingSystem-DCL.html\">NamingSystem DICOM Class Label</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-12</td></tr><tr><td>Recorded</td><td>2020-06-12 17:56:59+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/DCL"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-12"
        },
        "recorded" : "2020-06-12T17:56:59+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-v3-DCM-ns-1-1-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-v3-DCM-ns-1-1-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-v3-DCM-ns-1-1-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-v3-DCM-ns-1-1-12</b></p><a name=\"hx1g-v3-DCM-ns-1-1-12\"> </a><a name=\"hchx1g-v3-DCM-ns-1-1-12\"> </a><p>Provenance for <a href=\"NamingSystem-v3-DCM.html\">NamingSystem DICOM Controlled Terminology</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-12</td></tr><tr><td>Recorded</td><td>2020-06-12 17:57:30+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/v3-DCM"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-12"
        },
        "recorded" : "2020-06-12T17:57:30+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-deeds-old-ns-1-1-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-deeds-old-ns-1-1-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-deeds-old-ns-1-1-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-deeds-old-ns-1-1-12</b></p><a name=\"hx1g-deeds-old-ns-1-1-12\"> </a><a name=\"hchx1g-deeds-old-ns-1-1-12\"> </a><p>Provenance for <a href=\"NamingSystem-deeds-old.html\">NamingSystem DEEDS(old)</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-12</td></tr><tr><td>Recorded</td><td>2020-06-12 17:58:10+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/deeds-old"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-12"
        },
        "recorded" : "2020-06-12T17:58:10+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-DEEDS-ns-1-1-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-DEEDS-ns-1-1-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-DEEDS-ns-1-1-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-DEEDS-ns-1-1-12</b></p><a name=\"hx1g-DEEDS-ns-1-1-12\"> </a><a name=\"hchx1g-DEEDS-ns-1-1-12\"> </a><p>Provenance for <a href=\"NamingSystem-DEEDS.html\">NamingSystem DEEDS vocabularies</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-12</td></tr><tr><td>Recorded</td><td>2020-06-12 17:58:40+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/DEEDS"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-12"
        },
        "recorded" : "2020-06-12T17:58:40+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-dicomMDLTY-ns-1-1-14",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-dicomMDLTY-ns-1-1-14",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-dicomMDLTY-ns-1-1-14\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-dicomMDLTY-ns-1-1-14</b></p><a name=\"hx1g-dicomMDLTY-ns-1-1-14\"> </a><a name=\"hchx1g-dicomMDLTY-ns-1-1-14\"> </a><p>Provenance for <a href=\"NamingSystem-dicomMDLTY.html\">NamingSystem DICOM modality codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-14</td></tr><tr><td>Recorded</td><td>2020-06-14 15:49:46+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/dicomMDLTY"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-14"
        },
        "recorded" : "2020-06-14T15:49:46+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-dicomqry-ns-1-1-14",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-dicomqry-ns-1-1-14",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-dicomqry-ns-1-1-14\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-dicomqry-ns-1-1-14</b></p><a name=\"hx1g-dicomqry-ns-1-1-14\"> </a><a name=\"hchx1g-dicomqry-ns-1-1-14\"> </a><p>Provenance for <a href=\"NamingSystem-dicomqry.html\">NamingSystem DICOM Query Label</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-14</td></tr><tr><td>Recorded</td><td>2020-06-14 15:50:56+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/dicomqry"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-14"
        },
        "recorded" : "2020-06-14T15:50:56+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-dmdICD10-ns-1-1-14",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-dmdICD10-ns-1-1-14",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-dmdICD10-ns-1-1-14\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-dmdICD10-ns-1-1-14</b></p><a name=\"hx1g-dmdICD10-ns-1-1-14\"> </a><a name=\"hchx1g-dmdICD10-ns-1-1-14\"> </a><p>Provenance for <a href=\"NamingSystem-dmdICD10.html\">NamingSystem ICD-10 German</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-14</td></tr><tr><td>Recorded</td><td>2020-06-14 15:51:51+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/dmdICD10"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-14"
        },
        "recorded" : "2020-06-14T15:51:51+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-E5-ns-1-1-14",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-E5-ns-1-1-14",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-E5-ns-1-1-14\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-E5-ns-1-1-14</b></p><a name=\"hx1g-E5-ns-1-1-14\"> </a><a name=\"hchx1g-E5-ns-1-1-14\"> </a><p>Provenance for <a href=\"NamingSystem-E5.html\">NamingSystem Euclides quantity codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-14</td></tr><tr><td>Recorded</td><td>2020-06-14 15:52:31+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/E5"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-14"
        },
        "recorded" : "2020-06-14T15:52:31+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-E6-ns-1-1-14",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-E6-ns-1-1-14",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-E6-ns-1-1-14\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-E6-ns-1-1-14</b></p><a name=\"hx1g-E6-ns-1-1-14\"> </a><a name=\"hchx1g-E6-ns-1-1-14\"> </a><p>Provenance for <a href=\"NamingSystem-E6.html\">NamingSystem Euclides Lab method codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-14</td></tr><tr><td>Recorded</td><td>2020-06-14 15:54:52+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/E6"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-14"
        },
        "recorded" : "2020-06-14T15:54:52+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-E7-ns-1-1-14",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-E7-ns-1-1-14",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-E7-ns-1-1-14\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-E7-ns-1-1-14</b></p><a name=\"hx1g-E7-ns-1-1-14\"> </a><a name=\"hchx1g-E7-ns-1-1-14\"> </a><p>Provenance for <a href=\"NamingSystem-E7.html\">NamingSystem Euclides Lab equipment codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-14</td></tr><tr><td>Recorded</td><td>2020-06-14 15:55:32+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/E7"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-14"
        },
        "recorded" : "2020-06-14T15:55:32+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-ENZC-ns-1-1-14",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-ENZC-ns-1-1-14",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-ENZC-ns-1-1-14\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-ENZC-ns-1-1-14</b></p><a name=\"hx1g-ENZC-ns-1-1-14\"> </a><a name=\"hchx1g-ENZC-ns-1-1-14\"> </a><p>Provenance for <a href=\"NamingSystem-ENZC.html\">NamingSystem Enzyme Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-14</td></tr><tr><td>Recorded</td><td>2020-06-14 15:56:12+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/ENZC"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-14"
        },
        "recorded" : "2020-06-14T15:56:12+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-epsg-ca-ns-1-1-14",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-epsg-ca-ns-1-1-14",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-epsg-ca-ns-1-1-14\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-epsg-ca-ns-1-1-14</b></p><a name=\"hx1g-epsg-ca-ns-1-1-14\"> </a><a name=\"hchx1g-epsg-ca-ns-1-1-14\"> </a><p>Provenance for <a href=\"NamingSystem-epsg-ca.html\">NamingSystem European Petroleum Survey Group Geodetic Parameter Dataset Coordinate Axis</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-14</td></tr><tr><td>Recorded</td><td>2020-06-14 15:56:51+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/epsg-ca"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-14"
        },
        "recorded" : "2020-06-14T15:56:51+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-EPSG-GeodeticParameterDataset-ns-1-1-14",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-EPSG-GeodeticParameterDataset-ns-1-1-14",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-EPSG-GeodeticParameterDataset-ns-1-1-14\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-EPSG-GeodeticParameterDataset-ns-1-1-14</b></p><a name=\"hx1g-EPSG-GeodeticParameterDataset-ns-1-1-14\"> </a><a name=\"hchx1g-EPSG-GeodeticParameterDataset-ns-1-1-14\"> </a><p>Provenance for <a href=\"NamingSystem-EPSG-GeodeticParameterDataset.html\">NamingSystem EPSG Geodetic Parameter Dataset</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-14</td></tr><tr><td>Recorded</td><td>2020-06-14 15:57:51+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/EPSG-GeodeticParameterDataset"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-14"
        },
        "recorded" : "2020-06-14T15:57:51+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-epsg-crs-ns-1-1-14",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-epsg-crs-ns-1-1-14",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-epsg-crs-ns-1-1-14\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-epsg-crs-ns-1-1-14</b></p><a name=\"hx1g-epsg-crs-ns-1-1-14\"> </a><a name=\"hchx1g-epsg-crs-ns-1-1-14\"> </a><p>Provenance for <a href=\"NamingSystem-epsg-crs.html\">NamingSystem European Petroleum Survey Group Geodetic Parameter Dataset Coordinate Reference System</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-14</td></tr><tr><td>Recorded</td><td>2020-06-14 15:59:52+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/epsg-crs"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-14"
        },
        "recorded" : "2020-06-14T15:59:52+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-opinions-cs-1-0-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-opinions-cs-1-0-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-opinions-cs-1-0-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-opinions-cs-1-0-15</b></p><a name=\"hx1g-opinions-cs-1-0-15\"> </a><a name=\"hchx1g-opinions-cs-1-0-15\"> </a><p>Provenance for <a href=\"CodeSystem/opinions\">CodeSystem/opinions</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-24</td></tr><tr><td>Recorded</td><td>2020-06-24 17:14:27+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/opinions"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-24"
        },
        "recorded" : "2020-06-24T17:14:27+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Set status to retired missed on original import"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-opinions-ns-1-0-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-opinions-ns-1-0-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-opinions-ns-1-0-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-opinions-ns-1-0-15</b></p><a name=\"hx1g-opinions-ns-1-0-15\"> </a><a name=\"hchx1g-opinions-ns-1-0-15\"> </a><p>Provenance for <a href=\"NamingSystem-opinions.html\">NamingSystem Online Product Identification Number Index of Nova Scotia</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-24</td></tr><tr><td>Recorded</td><td>2020-06-24 17:17:11+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/opinions"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-24"
        },
        "recorded" : "2020-06-24T17:17:11+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Set status to retired missed on original import"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-v3-hc-aic-ns-1-0-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-v3-hc-aic-ns-1-0-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-v3-hc-aic-ns-1-0-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-v3-hc-aic-ns-1-0-15</b></p><a name=\"hx1g-v3-hc-aic-ns-1-0-15\"> </a><a name=\"hchx1g-v3-hc-aic-ns-1-0-15\"> </a><p>Provenance for <a href=\"NamingSystem-v3-hc-aic.html\">NamingSystem Active Ingredient Code</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-24</td></tr><tr><td>Recorded</td><td>2020-06-24 17:19:19+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/v3-hc-aic"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-24"
        },
        "recorded" : "2020-06-24T17:19:19+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Set status to retired missed on original import"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-v3-hc-aic-cs-1-0-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-v3-hc-aic-cs-1-0-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-v3-hc-aic-cs-1-0-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-v3-hc-aic-cs-1-0-15</b></p><a name=\"hx1g-v3-hc-aic-cs-1-0-15\"> </a><a name=\"hchx1g-v3-hc-aic-cs-1-0-15\"> </a><p>Provenance for <a href=\"CodeSystem/v3-hc-aic\">CodeSystem/v3-hc-aic</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-24</td></tr><tr><td>Recorded</td><td>2020-06-24 17:20:29+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-hc-aic"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-24"
        },
        "recorded" : "2020-06-24T17:20:29+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Set status to retired missed on original import"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-v3-PeriodicIntervalOfTimeAbbreviation-ns-1-0-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-v3-PeriodicIntervalOfTimeAbbreviation-ns-1-0-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-v3-PeriodicIntervalOfTimeAbbreviation-ns-1-0-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-v3-PeriodicIntervalOfTimeAbbreviation-ns-1-0-15</b></p><a name=\"hx1g-v3-PeriodicIntervalOfTimeAbbreviation-ns-1-0-15\"> </a><a name=\"hchx1g-v3-PeriodicIntervalOfTimeAbbreviation-ns-1-0-15\"> </a><p>Provenance for <a href=\"NamingSystem-v3-PeriodicIntervalOfTimeAbbreviation.html\">NamingSystem PeriodicIntervalOfTimeAbbreviation</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-24</td></tr><tr><td>Recorded</td><td>2020-06-24 17:27:42+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/v3-PeriodicIntervalOfTimeAbbreviation"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-24"
        },
        "recorded" : "2020-06-24T17:27:42+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Set status to retired missed on original import"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-v3-ProcedureMethod-ns-1-0-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-v3-ProcedureMethod-ns-1-0-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-v3-ProcedureMethod-ns-1-0-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-v3-ProcedureMethod-ns-1-0-15</b></p><a name=\"hx1g-v3-ProcedureMethod-ns-1-0-15\"> </a><a name=\"hchx1g-v3-ProcedureMethod-ns-1-0-15\"> </a><p>Provenance for <a href=\"NamingSystem-v3-ProcedureMethod.html\">NamingSystem ProcedureMethod</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-24</td></tr><tr><td>Recorded</td><td>2020-06-24 17:29:11+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/v3-ProcedureMethod"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-24"
        },
        "recorded" : "2020-06-24T17:29:11+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Set status to retired missed on original import"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-v3-UnitOfMeasurePrefix-ns-1-0-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-v3-UnitOfMeasurePrefix-ns-1-0-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-v3-UnitOfMeasurePrefix-ns-1-0-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-v3-UnitOfMeasurePrefix-ns-1-0-15</b></p><a name=\"hx1g-v3-UnitOfMeasurePrefix-ns-1-0-15\"> </a><a name=\"hchx1g-v3-UnitOfMeasurePrefix-ns-1-0-15\"> </a><p>Provenance for <a href=\"NamingSystem-v3-UnitOfMeasurePrefix.html\">NamingSystem Unit of Measure Prefix</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-24</td></tr><tr><td>Recorded</td><td>2020-06-24 17:30:21+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/v3-UnitOfMeasurePrefix"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-24"
        },
        "recorded" : "2020-06-24T17:30:21+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Set status to retired missed on original import"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-v3-CodeSystem-cs-1-0-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-v3-CodeSystem-cs-1-0-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-v3-CodeSystem-cs-1-0-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-v3-CodeSystem-cs-1-0-15</b></p><a name=\"hx1g-v3-CodeSystem-cs-1-0-15\"> </a><a name=\"hchx1g-v3-CodeSystem-cs-1-0-15\"> </a><p>Provenance for <a href=\"CodeSystem-v3-CodeSystem.html\">CodeSystem CodeSystem</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-24</td></tr><tr><td>Recorded</td><td>2020-06-24 17:46:21+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-CodeSystem"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-24"
        },
        "recorded" : "2020-06-24T17:46:21+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Set status to retired for those missed on original import"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-DEEDS210-ns-1-0-16",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-DEEDS210-ns-1-0-16",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-DEEDS210-ns-1-0-16\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-DEEDS210-ns-1-0-16</b></p><a name=\"hx1g-DEEDS210-ns-1-0-16\"> </a><a name=\"hchx1g-DEEDS210-ns-1-0-16\"> </a><p>Provenance for <a href=\"NamingSystem-DEEDS210.html\">NamingSystem DEEDS2.10</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-30</td></tr><tr><td>Recorded</td><td>2020-06-30 17:32:54+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/DEEDS210"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-30"
        },
        "recorded" : "2020-06-30T17:32:54+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Correct URL of title extension"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-DEEDS402-ns-1-0-16",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-DEEDS402-ns-1-0-16",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-DEEDS402-ns-1-0-16\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-DEEDS402-ns-1-0-16</b></p><a name=\"hx1g-DEEDS402-ns-1-0-16\"> </a><a name=\"hchx1g-DEEDS402-ns-1-0-16\"> </a><p>Provenance for <a href=\"NamingSystem-DEEDS402.html\">NamingSystem DEEDS402</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-30</td></tr><tr><td>Recorded</td><td>2020-06-30 17:34:02+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/DEEDS402"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-30"
        },
        "recorded" : "2020-06-30T17:34:02+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Correct URL of title extension"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-DEEDS405-ns-1-0-16",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-DEEDS405-ns-1-0-16",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-DEEDS405-ns-1-0-16\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-DEEDS405-ns-1-0-16</b></p><a name=\"hx1g-DEEDS405-ns-1-0-16\"> </a><a name=\"hchx1g-DEEDS405-ns-1-0-16\"> </a><p>Provenance for <a href=\"NamingSystem-DEEDS405.html\">NamingSystem DEEDS405</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-30</td></tr><tr><td>Recorded</td><td>2020-06-30 17:34:43+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/DEEDS405"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-30"
        },
        "recorded" : "2020-06-30T17:34:43+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Correct URL of title extension"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-DEEDS407-ns-1-0-16",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-DEEDS407-ns-1-0-16",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-DEEDS407-ns-1-0-16\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-DEEDS407-ns-1-0-16</b></p><a name=\"hx1g-DEEDS407-ns-1-0-16\"> </a><a name=\"hchx1g-DEEDS407-ns-1-0-16\"> </a><p>Provenance for <a href=\"NamingSystem-DEEDS407.html\">NamingSystem DEEDS407</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-30</td></tr><tr><td>Recorded</td><td>2020-06-30 17:35:18+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/DEEDS407"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-30"
        },
        "recorded" : "2020-06-30T17:35:18+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Correct URL of title extension"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-DEEDS408-ns-1-0-16",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-DEEDS408-ns-1-0-16",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-DEEDS408-ns-1-0-16\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-DEEDS408-ns-1-0-16</b></p><a name=\"hx1g-DEEDS408-ns-1-0-16\"> </a><a name=\"hchx1g-DEEDS408-ns-1-0-16\"> </a><p>Provenance for <a href=\"NamingSystem-DEEDS408.html\">NamingSystem DEEDS408</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-30</td></tr><tr><td>Recorded</td><td>2020-06-30 17:35:48+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/DEEDS408"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-30"
        },
        "recorded" : "2020-06-30T17:35:48+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Correct URL of title extension"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-DEEDS412-ns-1-0-16",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-DEEDS412-ns-1-0-16",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-DEEDS412-ns-1-0-16\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-DEEDS412-ns-1-0-16</b></p><a name=\"hx1g-DEEDS412-ns-1-0-16\"> </a><a name=\"hchx1g-DEEDS412-ns-1-0-16\"> </a><p>Provenance for <a href=\"NamingSystem-DEEDS412.html\">NamingSystem DEEDS412</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-30</td></tr><tr><td>Recorded</td><td>2020-06-30 17:36:20+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/DEEDS412"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-30"
        },
        "recorded" : "2020-06-30T17:36:20+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Correct URL of title extension"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-DEEDS414-ns-1-0-16",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-DEEDS414-ns-1-0-16",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-DEEDS414-ns-1-0-16\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-DEEDS414-ns-1-0-16</b></p><a name=\"hx1g-DEEDS414-ns-1-0-16\"> </a><a name=\"hchx1g-DEEDS414-ns-1-0-16\"> </a><p>Provenance for <a href=\"NamingSystem-DEEDS414.html\">NamingSystem DEEDS414</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-30</td></tr><tr><td>Recorded</td><td>2020-06-30 17:36:47+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/DEEDS414"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-30"
        },
        "recorded" : "2020-06-30T17:36:47+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Correct URL of title extension"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-DEEDS415-ns-1-0-16",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-DEEDS415-ns-1-0-16",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-DEEDS415-ns-1-0-16\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-DEEDS415-ns-1-0-16</b></p><a name=\"hx1g-DEEDS415-ns-1-0-16\"> </a><a name=\"hchx1g-DEEDS415-ns-1-0-16\"> </a><p>Provenance for <a href=\"NamingSystem-DEEDS415.html\">NamingSystem DEEDS415</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-30</td></tr><tr><td>Recorded</td><td>2020-06-30 17:37:20+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/DEEDS415"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-30"
        },
        "recorded" : "2020-06-30T17:37:20+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Correct URL of title extension"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-DEEDS416-ns-1-0-16",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-DEEDS416-ns-1-0-16",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-DEEDS416-ns-1-0-16\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-DEEDS416-ns-1-0-16</b></p><a name=\"hx1g-DEEDS416-ns-1-0-16\"> </a><a name=\"hchx1g-DEEDS416-ns-1-0-16\"> </a><p>Provenance for <a href=\"NamingSystem-DEEDS416.html\">NamingSystem DEEDS416</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-30</td></tr><tr><td>Recorded</td><td>2020-06-30 17:37:55+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/DEEDS416"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-30"
        },
        "recorded" : "2020-06-30T17:37:55+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Correct URL of title extension"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-DEEDS418-ns-1-0-16",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-DEEDS418-ns-1-0-16",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-DEEDS418-ns-1-0-16\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-DEEDS418-ns-1-0-16</b></p><a name=\"hx1g-DEEDS418-ns-1-0-16\"> </a><a name=\"hchx1g-DEEDS418-ns-1-0-16\"> </a><p>Provenance for <a href=\"NamingSystem-DEEDS418.html\">NamingSystem DEEDS418</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-30</td></tr><tr><td>Recorded</td><td>2020-06-30 17:38:26+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/DEEDS418"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-30"
        },
        "recorded" : "2020-06-30T17:38:26+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Correct URL of title extension"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-DEEDS422-ns-1-0-16",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-DEEDS422-ns-1-0-16",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-DEEDS422-ns-1-0-16\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-DEEDS422-ns-1-0-16</b></p><a name=\"hx1g-DEEDS422-ns-1-0-16\"> </a><a name=\"hchx1g-DEEDS422-ns-1-0-16\"> </a><p>Provenance for <a href=\"NamingSystem-DEEDS422.html\">NamingSystem DEEDS422</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-30</td></tr><tr><td>Recorded</td><td>2020-06-30 17:38:55+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/DEEDS422"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-30"
        },
        "recorded" : "2020-06-30T17:38:55+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Correct URL of title extension"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-DEEDS424-ns-1-0-16",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-DEEDS424-ns-1-0-16",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-DEEDS424-ns-1-0-16\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-DEEDS424-ns-1-0-16</b></p><a name=\"hx1g-DEEDS424-ns-1-0-16\"> </a><a name=\"hchx1g-DEEDS424-ns-1-0-16\"> </a><p>Provenance for <a href=\"NamingSystem-DEEDS424.html\">NamingSystem DEEDS424</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-30</td></tr><tr><td>Recorded</td><td>2020-06-30 17:39:23+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/DEEDS424"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-30"
        },
        "recorded" : "2020-06-30T17:39:23+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Correct URL of title extension"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-DEEDS427-ns-1-0-16",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-DEEDS427-ns-1-0-16",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-DEEDS427-ns-1-0-16\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-DEEDS427-ns-1-0-16</b></p><a name=\"hx1g-DEEDS427-ns-1-0-16\"> </a><a name=\"hchx1g-DEEDS427-ns-1-0-16\"> </a><p>Provenance for <a href=\"NamingSystem-DEEDS427.html\">NamingSystem DEEDS427</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-30</td></tr><tr><td>Recorded</td><td>2020-06-30 17:39:51+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/DEEDS427"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-30"
        },
        "recorded" : "2020-06-30T17:39:51+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Correct URL of title extension"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-DEEDS506-ns-1-0-16",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-DEEDS506-ns-1-0-16",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-DEEDS506-ns-1-0-16\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-DEEDS506-ns-1-0-16</b></p><a name=\"hx1g-DEEDS506-ns-1-0-16\"> </a><a name=\"hchx1g-DEEDS506-ns-1-0-16\"> </a><p>Provenance for <a href=\"NamingSystem-DEEDS506.html\">NamingSystem DEEDS506</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-30</td></tr><tr><td>Recorded</td><td>2020-06-30 17:40:23+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/DEEDS506"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-30"
        },
        "recorded" : "2020-06-30T17:40:23+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Correct URL of title extension"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-DEEDS508-ns-1-0-16",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-DEEDS508-ns-1-0-16",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-DEEDS508-ns-1-0-16\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-DEEDS508-ns-1-0-16</b></p><a name=\"hx1g-DEEDS508-ns-1-0-16\"> </a><a name=\"hchx1g-DEEDS508-ns-1-0-16\"> </a><p>Provenance for <a href=\"NamingSystem-DEEDS508.html\">NamingSystem DEEDS508</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-30</td></tr><tr><td>Recorded</td><td>2020-06-30 17:40:53+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/DEEDS508"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-30"
        },
        "recorded" : "2020-06-30T17:40:53+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Correct URL of title extension"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-DEEDS519-ns-1-0-16",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-DEEDS519-ns-1-0-16",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-DEEDS519-ns-1-0-16\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-DEEDS519-ns-1-0-16</b></p><a name=\"hx1g-DEEDS519-ns-1-0-16\"> </a><a name=\"hchx1g-DEEDS519-ns-1-0-16\"> </a><p>Provenance for <a href=\"NamingSystem-DEEDS519.html\">NamingSystem DEEDS519</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-30</td></tr><tr><td>Recorded</td><td>2020-06-30 17:41:25+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/DEEDS519"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-30"
        },
        "recorded" : "2020-06-30T17:41:25+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Correct URL of title extension"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-FDBHICCode-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-FDBHICCode-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-FDBHICCode-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-FDBHICCode-ns-1-0-47</b></p><a name=\"hx1g-FDBHICCode-ns-1-0-47\"> </a><a name=\"hchx1g-FDBHICCode-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-FDBHICCode.html\">NamingSystem FDB HIC Code</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/FDBHICCode"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-FDDC-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-FDDC-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-FDDC-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-FDDC-ns-1-0-47</b></p><a name=\"hx1g-FDDC-ns-1-0-47\"> </a><a name=\"hchx1g-FDDC-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-FDDC.html\">NamingSystem First DataBank Drug Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/FDDC"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-FDDX-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-FDDX-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-FDDX-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-FDDX-ns-1-0-47</b></p><a name=\"hx1g-FDDX-ns-1-0-47\"> </a><a name=\"hchx1g-FDDX-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-FDDX.html\">NamingSystem First DataBank Diagnostic Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/FDDX"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-GCDF-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-GCDF-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-GCDF-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-GCDF-ns-1-0-47</b></p><a name=\"hx1g-GCDF-ns-1-0-47\"> </a><a name=\"hchx1g-GCDF-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-GCDF.html\">NamingSystem GCDF</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/GCDF"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-GCRT-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-GCRT-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-GCRT-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-GCRT-ns-1-0-47</b></p><a name=\"hx1g-GCRT-ns-1-0-47\"> </a><a name=\"hchx1g-GCRT-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-GCRT.html\">NamingSystem GCRT</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/GCRT"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-GMDN-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-GMDN-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-GMDN-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-GMDN-ns-1-0-47</b></p><a name=\"hx1g-GMDN-ns-1-0-47\"> </a><a name=\"hchx1g-GMDN-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-GMDN.html\">NamingSystem Global Medical Device Nomenclature</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/GMDN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-IC2-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-IC2-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-IC2-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-IC2-ns-1-0-47</b></p><a name=\"hx1g-IC2-ns-1-0-47\"> </a><a name=\"hchx1g-IC2-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-IC2.html\">NamingSystem ICHPPC-2</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/IC2"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-ICD-10DualCoding-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-ICD-10DualCoding-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-ICD-10DualCoding-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-ICD-10DualCoding-ns-1-0-47</b></p><a name=\"hx1g-ICD-10DualCoding-ns-1-0-47\"> </a><a name=\"hchx1g-ICD-10DualCoding-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-ICD-10DualCoding.html\">NamingSystem ICD-10 Dual Coding</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/ICD-10DualCoding"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-ICD-9CM-diagnosiscodes-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-ICD-9CM-diagnosiscodes-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-ICD-9CM-diagnosiscodes-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-ICD-9CM-diagnosiscodes-ns-1-0-47</b></p><a name=\"hx1g-ICD-9CM-diagnosiscodes-ns-1-0-47\"> </a><a name=\"hchx1g-ICD-9CM-diagnosiscodes-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-ICD-9CM-diagnosiscodes.html\">NamingSystem ICD-9-CM (diagnosis codes)</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/ICD-9CM-diagnosiscodes"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-ICD-9CM-procedurecodes-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-ICD-9CM-procedurecodes-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-ICD-9CM-procedurecodes-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-ICD-9CM-procedurecodes-ns-1-0-47</b></p><a name=\"hx1g-ICD-9CM-procedurecodes-ns-1-0-47\"> </a><a name=\"hchx1g-ICD-9CM-procedurecodes-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-ICD-9CM-procedurecodes.html\">NamingSystem ICD-9-CM (procedure codes)</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/ICD-9CM-procedurecodes"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-ICD-9DualCoding-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-ICD-9DualCoding-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-ICD-9DualCoding-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-ICD-9DualCoding-ns-1-0-47</b></p><a name=\"hx1g-ICD-9DualCoding-ns-1-0-47\"> </a><a name=\"hchx1g-ICD-9DualCoding-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-ICD-9DualCoding.html\">NamingSystem ICD-9 Dual Coding</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/ICD-9DualCoding"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-ICD10dut-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-ICD10dut-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-ICD10dut-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-ICD10dut-ns-1-0-47</b></p><a name=\"hx1g-ICD10dut-ns-1-0-47\"> </a><a name=\"hchx1g-ICD10dut-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-ICD10dut.html\">NamingSystem ICD10, Dutch Translation</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/ICD10dut"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-ICSD-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-ICSD-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-ICSD-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-ICSD-ns-1-0-47</b></p><a name=\"hx1g-ICSD-ns-1-0-47\"> </a><a name=\"hchx1g-ICSD-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-ICSD.html\">NamingSystem International Classification of Sleep Disorders</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/ICSD"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-IETF1766-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-IETF1766-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-IETF1766-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-IETF1766-ns-1-0-47</b></p><a name=\"hx1g-IETF1766-ns-1-0-47\"> </a><a name=\"hchx1g-IETF1766-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-IETF1766.html\">NamingSystem IETF RFC 1766</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/IETF1766"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-IUPC-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-IUPC-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-IUPC-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-IUPC-ns-1-0-47</b></p><a name=\"hx1g-IUPC-ns-1-0-47\"> </a><a name=\"hchx1g-IUPC-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-IUPC.html\">NamingSystem IUPAC/IFCC Component Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/IUPC"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-IUPP-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-IUPP-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-IUPP-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-IUPP-ns-1-0-47</b></p><a name=\"hx1g-IUPP-ns-1-0-47\"> </a><a name=\"hchx1g-IUPP-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-IUPP.html\">NamingSystem IUPAC/IFCC Property Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/IUPP"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-JC8-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-JC8-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-JC8-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-JC8-ns-1-0-47</b></p><a name=\"hx1g-JC8-ns-1-0-47\"> </a><a name=\"hchx1g-JC8-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-JC8.html\">NamingSystem Japanese Chemistry</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/JC8"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-MDDX-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-MDDX-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-MDDX-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-MDDX-ns-1-0-47</b></p><a name=\"hx1g-MDDX-ns-1-0-47\"> </a><a name=\"hchx1g-MDDX-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-MDDX.html\">NamingSystem Medispan Diagnostic Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/MDDX"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-MDRAE-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-MDRAE-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-MDRAE-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-MDRAE-ns-1-0-47</b></p><a name=\"hx1g-MDRAE-ns-1-0-47\"> </a><a name=\"hchx1g-MDRAE-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-MDRAE.html\">NamingSystem MedDRA Am Engl</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/MDRAE"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-MDRDUT-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-MDRDUT-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-MDRDUT-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-MDRDUT-ns-1-0-47</b></p><a name=\"hx1g-MDRDUT-ns-1-0-47\"> </a><a name=\"hchx1g-MDRDUT-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-MDRDUT.html\">NamingSystem MedDRA Dutch</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/MDRDUT"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-MDREA-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-MDREA-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-MDREA-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-MDREA-ns-1-0-47</b></p><a name=\"hx1g-MDREA-ns-1-0-47\"> </a><a name=\"hchx1g-MDREA-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-MDREA.html\">NamingSystem MedDRA Am Engl expanded</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/MDREA"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-MDREX-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-MDREX-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-MDREX-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-MDREX-ns-1-0-47</b></p><a name=\"hx1g-MDREX-ns-1-0-47\"> </a><a name=\"hchx1g-MDREX-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-MDREX.html\">NamingSystem MedDRA expanded</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/MDREX"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-MDRFRE-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-MDRFRE-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-MDRFRE-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-MDRFRE-ns-1-0-47</b></p><a name=\"hx1g-MDRFRE-ns-1-0-47\"> </a><a name=\"hchx1g-MDRFRE-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-MDRFRE.html\">NamingSystem MedDRA French</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/MDRFRE"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-MDRGER-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-MDRGER-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-MDRGER-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-MDRGER-ns-1-0-47</b></p><a name=\"hx1g-MDRGER-ns-1-0-47\"> </a><a name=\"hchx1g-MDRGER-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-MDRGER.html\">NamingSystem MedDRA German</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/MDRGER"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-MDRPOR-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-MDRPOR-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-MDRPOR-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-MDRPOR-ns-1-0-47</b></p><a name=\"hx1g-MDRPOR-ns-1-0-47\"> </a><a name=\"hchx1g-MDRPOR-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-MDRPOR.html\">NamingSystem MedDRA Portuguese</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/MDRPOR"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-MDRSPA-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-MDRSPA-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-MDRSPA-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-MDRSPA-ns-1-0-47</b></p><a name=\"hx1g-MDRSPA-ns-1-0-47\"> </a><a name=\"hchx1g-MDRSPA-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-MDRSPA.html\">NamingSystem MedDRA Spanish</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/MDRSPA"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-MEDC-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-MEDC-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-MEDC-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-MEDC-ns-1-0-47</b></p><a name=\"hx1g-MEDC-ns-1-0-47\"> </a><a name=\"hchx1g-MEDC-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-MEDC.html\">NamingSystem Medical Economics Drug Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/MEDC"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-MEDX-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-MEDX-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-MEDX-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-MEDX-ns-1-0-47</b></p><a name=\"hx1g-MEDX-ns-1-0-47\"> </a><a name=\"hchx1g-MEDX-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-MEDX.html\">NamingSystem Medical Economics Diagnostic Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/MEDX"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-MGPI-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-MGPI-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-MGPI-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-MGPI-ns-1-0-47</b></p><a name=\"hx1g-MGPI-ns-1-0-47\"> </a><a name=\"hchx1g-MGPI-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-MGPI.html\">NamingSystem Medispan GPI</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/MGPI"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-MeSH-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-MeSH-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-MeSH-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-MeSH-ns-1-0-47</b></p><a name=\"hx1g-MeSH-ns-1-0-47\"> </a><a name=\"hchx1g-MeSH-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-MeSH.html\">NamingSystem Medical Subject Headings</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/MeSH"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-MTHMDRSPA-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-MTHMDRSPA-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-MTHMDRSPA-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-MTHMDRSPA-ns-1-0-47</b></p><a name=\"hx1g-MTHMDRSPA-ns-1-0-47\"> </a><a name=\"hchx1g-MTHMDRSPA-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-MTHMDRSPA.html\">NamingSystem MTH MedDRA Spanish</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/MTHMDRSPA"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-MVX-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-MVX-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-MVX-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-MVX-ns-1-0-47</b></p><a name=\"hx1g-MVX-ns-1-0-47\"> </a><a name=\"hchx1g-MVX-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-MVX.html\">NamingSystem Manufacturers of Vaccines (MVX)</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/MVX"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-NHSNBSIRiskFactors-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-NHSNBSIRiskFactors-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-NHSNBSIRiskFactors-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-NHSNBSIRiskFactors-ns-1-0-47</b></p><a name=\"hx1g-NHSNBSIRiskFactors-ns-1-0-47\"> </a><a name=\"hchx1g-NHSNBSIRiskFactors-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-NHSNBSIRiskFactors.html\">NamingSystem NHSN BSI Risk Factors</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/NHSNBSIRiskFactors"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-NHSNHipReplacement-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-NHSNHipReplacement-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-NHSNHipReplacement-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-NHSNHipReplacement-ns-1-0-47</b></p><a name=\"hx1g-NHSNHipReplacement-ns-1-0-47\"> </a><a name=\"hchx1g-NHSNHipReplacement-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-NHSNHipReplacement.html\">NamingSystem NHSN Hip Replacement</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/NHSNHipReplacement"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-NHSNInfectionType-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-NHSNInfectionType-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-NHSNInfectionType-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-NHSNInfectionType-ns-1-0-47</b></p><a name=\"hx1g-NHSNInfectionType-ns-1-0-47\"> </a><a name=\"hchx1g-NHSNInfectionType-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-NHSNInfectionType.html\">NamingSystem NHSN Infection Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/NHSNInfectionType"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-NHSNKneeReplacement-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-NHSNKneeReplacement-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-NHSNKneeReplacement-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-NHSNKneeReplacement-ns-1-0-47</b></p><a name=\"hx1g-NHSNKneeReplacement-ns-1-0-47\"> </a><a name=\"hchx1g-NHSNKneeReplacement-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-NHSNKneeReplacement.html\">NamingSystem NHSN KneeR eplacement</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/NHSNKneeReplacement"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-NHSNLCBIPathways-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-NHSNLCBIPathways-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-NHSNLCBIPathways-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-NHSNLCBIPathways-ns-1-0-47</b></p><a name=\"hx1g-NHSNLCBIPathways-ns-1-0-47\"> </a><a name=\"hchx1g-NHSNLCBIPathways-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-NHSNLCBIPathways.html\">NamingSystem NHSN LCBI Pathways</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/NHSNLCBIPathways"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-NHSNOccasionOfDetection-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-NHSNOccasionOfDetection-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-NHSNOccasionOfDetection-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-NHSNOccasionOfDetection-ns-1-0-47</b></p><a name=\"hx1g-NHSNOccasionOfDetection-ns-1-0-47\"> </a><a name=\"hchx1g-NHSNOccasionOfDetection-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-NHSNOccasionOfDetection.html\">NamingSystem NHSN Occasion Of Detection</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/NHSNOccasionOfDetection"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-NHSNProcedureCategory-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-NHSNProcedureCategory-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-NHSNProcedureCategory-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-NHSNProcedureCategory-ns-1-0-47</b></p><a name=\"hx1g-NHSNProcedureCategory-ns-1-0-47\"> </a><a name=\"hchx1g-NHSNProcedureCategory-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-NHSNProcedureCategory.html\">NamingSystem NHSN Procedure Category</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/NHSNProcedureCategory"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-NHSNSSIAnatomicSite-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-NHSNSSIAnatomicSite-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-NHSNSSIAnatomicSite-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-NHSNSSIAnatomicSite-ns-1-0-47</b></p><a name=\"hx1g-NHSNSSIAnatomicSite-ns-1-0-47\"> </a><a name=\"hchx1g-NHSNSSIAnatomicSite-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-NHSNSSIAnatomicSite.html\">NamingSystem NHSN SSI Anatomic Site</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/NHSNSSIAnatomicSite"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-NHSNSSILocationType-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-NHSNSSILocationType-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-NHSNSSILocationType-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-NHSNSSILocationType-ns-1-0-47</b></p><a name=\"hx1g-NHSNSSILocationType-ns-1-0-47\"> </a><a name=\"hchx1g-NHSNSSILocationType-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-NHSNSSILocationType.html\">NamingSystem NHSN SSI Location Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/NHSNSSILocationType"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-NHSNSpinalFusionApproach-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-NHSNSpinalFusionApproach-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-NHSNSpinalFusionApproach-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-NHSNSpinalFusionApproach-ns-1-0-47</b></p><a name=\"hx1g-NHSNSpinalFusionApproach-ns-1-0-47\"> </a><a name=\"hchx1g-NHSNSpinalFusionApproach-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-NHSNSpinalFusionApproach.html\">NamingSystem NHSN Spinal Fusion Approach</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/NHSNSpinalFusionApproach"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-NHSNSpinalFusionLevel-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-NHSNSpinalFusionLevel-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-NHSNSpinalFusionLevel-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-NHSNSpinalFusionLevel-ns-1-0-47</b></p><a name=\"hx1g-NHSNSpinalFusionLevel-ns-1-0-47\"> </a><a name=\"hchx1g-NHSNSpinalFusionLevel-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-NHSNSpinalFusionLevel.html\">NamingSystem NHSN Spinal Fusion Level</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/NHSNSpinalFusionLevel"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-NHSNSummaryData-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-NHSNSummaryData-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-NHSNSummaryData-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-NHSNSummaryData-ns-1-0-47</b></p><a name=\"hx1g-NHSNSummaryData-ns-1-0-47\"> </a><a name=\"hchx1g-NHSNSummaryData-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-NHSNSummaryData.html\">NamingSystem NHSN Summary Data</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/NHSNSummaryData"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-NHSNVocabulary-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-NHSNVocabulary-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-NHSNVocabulary-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-NHSNVocabulary-ns-1-0-47</b></p><a name=\"hx1g-NHSNVocabulary-ns-1-0-47\"> </a><a name=\"hchx1g-NHSNVocabulary-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-NHSNVocabulary.html\">NamingSystem NHSN HAI Vocabulary</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/NHSNVocabulary"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-PHIndustryCDCCensus2010-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-PHIndustryCDCCensus2010-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-PHIndustryCDCCensus2010-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-PHIndustryCDCCensus2010-ns-1-0-47</b></p><a name=\"hx1g-PHIndustryCDCCensus2010-ns-1-0-47\"> </a><a name=\"hchx1g-PHIndustryCDCCensus2010-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-PHIndustryCDCCensus2010.html\">NamingSystem Industry CDC Census 2010</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/PHIndustryCDCCensus2010"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-PHOccupationCDCCensus2010-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-PHOccupationCDCCensus2010-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-PHOccupationCDCCensus2010-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-PHOccupationCDCCensus2010-ns-1-0-47</b></p><a name=\"hx1g-PHOccupationCDCCensus2010-ns-1-0-47\"> </a><a name=\"hchx1g-PHOccupationCDCCensus2010-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-PHOccupationCDCCensus2010.html\">NamingSystem Occupation CDC Census 2010</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/PHOccupationCDCCensus2010"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-PHOccupationalDataForHealthODH-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-PHOccupationalDataForHealthODH-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-PHOccupationalDataForHealthODH-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-PHOccupationalDataForHealthODH-ns-1-0-47</b></p><a name=\"hx1g-PHOccupationalDataForHealthODH-ns-1-0-47\"> </a><a name=\"hchx1g-PHOccupationalDataForHealthODH-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-PHOccupationalDataForHealthODH.html\">NamingSystem Occupational Data for Health (ODH)</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/PHOccupationalDataForHealthODH"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-CDCREC-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-CDCREC-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-CDCREC-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-CDCREC-ns-1-0-47</b></p><a name=\"hx1g-CDCREC-ns-1-0-47\"> </a><a name=\"hchx1g-CDCREC-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-CDCREC.html\">NamingSystem CDC Race and Ethnicity</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/CDCREC"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-POS-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-POS-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-POS-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-POS-ns-1-0-47</b></p><a name=\"hx1g-POS-ns-1-0-47\"> </a><a name=\"hchx1g-POS-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-POS.html\">NamingSystem POS Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/POS"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-SCDHEC-GISSpatialAccuracyTiers-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-SCDHEC-GISSpatialAccuracyTiers-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-SCDHEC-GISSpatialAccuracyTiers-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-SCDHEC-GISSpatialAccuracyTiers-ns-1-0-47</b></p><a name=\"hx1g-SCDHEC-GISSpatialAccuracyTiers-ns-1-0-47\"> </a><a name=\"hchx1g-SCDHEC-GISSpatialAccuracyTiers-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-SCDHEC-GISSpatialAccuracyTiers.html\">NamingSystem SCDHEC GIS Spatial Accuracy Tiers</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/SCDHEC-GISSpatialAccuracyTiers"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-SDM-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-SDM-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-SDM-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-SDM-ns-1-0-47</b></p><a name=\"hx1g-SDM-ns-1-0-47\"> </a><a name=\"hchx1g-SDM-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-SDM.html\">NamingSystem SNOMED-DICOM Microglossary</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/SDM"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-SNM3-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-SNM3-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-SNM3-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-SNM3-ns-1-0-47</b></p><a name=\"hx1g-SNM3-ns-1-0-47\"> </a><a name=\"hchx1g-SNM3-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-SNM3.html\">NamingSystem SNOMED International</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/SNM3"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-SNT-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-SNT-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-SNT-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-SNT-ns-1-0-47</b></p><a name=\"hx1g-SNT-ns-1-0-47\"> </a><a name=\"hchx1g-SNT-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-SNT.html\">NamingSystem SNOMED topology codes (anatomic sites)</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/SNT"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-UC-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-UC-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-UC-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-UC-ns-1-0-47</b></p><a name=\"hx1g-UC-ns-1-0-47\"> </a><a name=\"hchx1g-UC-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-UC.html\">NamingSystem UCDS</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/UC"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-UMD-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-UMD-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-UMD-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-UMD-ns-1-0-47</b></p><a name=\"hx1g-UMD-ns-1-0-47\"> </a><a name=\"hchx1g-UMD-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-UMD.html\">NamingSystem MDNS</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/UMD"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-UML-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-UML-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-UML-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-UML-ns-1-0-47</b></p><a name=\"hx1g-UML-ns-1-0-47\"> </a><a name=\"hchx1g-UML-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-UML.html\">NamingSystem Unified Medical Language</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/UML"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-UPC-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-UPC-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-UPC-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-UPC-ns-1-0-47</b></p><a name=\"hx1g-UPC-ns-1-0-47\"> </a><a name=\"hchx1g-UPC-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-UPC.html\">NamingSystem Universal Product Code</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/UPC"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-USCOC-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-USCOC-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-USCOC-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-USCOC-ns-1-0-47</b></p><a name=\"hx1g-USCOC-ns-1-0-47\"> </a><a name=\"hchx1g-USCOC-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-USCOC.html\">NamingSystem US Census Occupation Code</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/USCOC"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-USZIPCODES-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-USZIPCODES-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-USZIPCODES-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-USZIPCODES-ns-1-0-47</b></p><a name=\"hx1g-USZIPCODES-ns-1-0-47\"> </a><a name=\"hchx1g-USZIPCODES-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-USZIPCODES.html\">NamingSystem United States Postal Service</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/USZIPCODES"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-VHA-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-VHA-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-VHA-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-VHA-ns-1-0-47</b></p><a name=\"hx1g-VHA-ns-1-0-47\"> </a><a name=\"hchx1g-VHA-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-VHA.html\">NamingSystem US Department of Veterans Affairs</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/VHA"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-W1-W2-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-W1-W2-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-W1-W2-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-W1-W2-ns-1-0-47</b></p><a name=\"hx1g-W1-W2-ns-1-0-47\"> </a><a name=\"hchx1g-W1-W2-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-W1-W2.html\">NamingSystem WHO rec# drug codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:08+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/W1-W2"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:08+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-W4-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-W4-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-W4-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-W4-ns-1-0-47</b></p><a name=\"hx1g-W4-ns-1-0-47\"> </a><a name=\"hchx1g-W4-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-W4.html\">NamingSystem WHO rec# code with ASTM extension</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/W4"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-v3-WC-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-v3-WC-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-v3-WC-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-v3-WC-ns-1-0-47</b></p><a name=\"hx1g-v3-WC-ns-1-0-47\"> </a><a name=\"hchx1g-v3-WC-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-v3-WC.html\">NamingSystem WHO ATC</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/v3-WC"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-X12.3-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-X12.3-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-X12.3-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-X12.3-ns-1-0-47</b></p><a name=\"hx1g-X12.3-ns-1-0-47\"> </a><a name=\"hchx1g-X12.3-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-X12.3.html\">NamingSystem X12.3 Data Elementary Dictionary</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/X12.3"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-euclides-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-euclides-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-euclides-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-euclides-ns-1-0-47</b></p><a name=\"hx1g-euclides-ns-1-0-47\"> </a><a name=\"hchx1g-euclides-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-euclides.html\">NamingSystem EUCLIDES</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/euclides"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-externalCodeSystems-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-externalCodeSystems-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-externalCodeSystems-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-externalCodeSystems-ns-1-0-47</b></p><a name=\"hx1g-externalCodeSystems-ns-1-0-47\"> </a><a name=\"hchx1g-externalCodeSystems-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-externalCodeSystems.html\">NamingSystem HL7 Registered External Coding Systems</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/externalCodeSystems"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-v3-fda-FCE-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-v3-fda-FCE-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-v3-fda-FCE-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-v3-fda-FCE-ns-1-0-47</b></p><a name=\"hx1g-v3-fda-FCE-ns-1-0-47\"> </a><a name=\"hchx1g-v3-fda-FCE-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-v3-fda-FCE.html\">NamingSystem Food and Drug Administration Food Canning Establishments</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/v3-fda-FCE"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-v3-fda-FFRN-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-v3-fda-FFRN-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-v3-fda-FFRN-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-v3-fda-FFRN-ns-1-0-47</b></p><a name=\"hx1g-v3-fda-FFRN-ns-1-0-47\"> </a><a name=\"hchx1g-v3-fda-FFRN-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-v3-fda-FFRN.html\">NamingSystem Food and Drug Administration Food Facility Registration Numbers</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/v3-fda-FFRN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-fdk-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-fdk-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-fdk-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-fdk-ns-1-0-47</b></p><a name=\"hx1g-fdk-ns-1-0-47\"> </a><a name=\"hchx1g-fdk-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-fdk.html\">NamingSystem FDA K10</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/fdk"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-fipspub92-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-fipspub92-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-fipspub92-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-fipspub92-ns-1-0-47</b></p><a name=\"hx1g-fipspub92-ns-1-0-47\"> </a><a name=\"hchx1g-fipspub92-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-fipspub92.html\">NamingSystem FIPS_SOC</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/fipspub92"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-gtin-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-gtin-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-gtin-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-gtin-ns-1-0-47</b></p><a name=\"hx1g-gtin-ns-1-0-47\"> </a><a name=\"hchx1g-gtin-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-gtin.html\">NamingSystem GTIN Global Trade Item Number</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/gtin"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-v3-hc-aic-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-v3-hc-aic-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-v3-hc-aic-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-v3-hc-aic-ns-1-0-47</b></p><a name=\"hx1g-v3-hc-aic-ns-1-0-47\"> </a><a name=\"hchx1g-v3-hc-aic-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-v3-hc-aic.html\">NamingSystem Active Ingredient Code</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/v3-hc-aic"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-v3-hc-aigc-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-v3-hc-aigc-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-v3-hc-aigc-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-v3-hc-aigc-ns-1-0-47</b></p><a name=\"hx1g-v3-hc-aigc-ns-1-0-47\"> </a><a name=\"hchx1g-v3-hc-aigc-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-v3-hc-aigc.html\">NamingSystem Active Ingredient Group Code</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/v3-hc-aigc"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-v3-hc-aign-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-v3-hc-aign-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-v3-hc-aign-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-v3-hc-aign-ns-1-0-47</b></p><a name=\"hx1g-v3-hc-aign-ns-1-0-47\"> </a><a name=\"hchx1g-v3-hc-aign-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-v3-hc-aign.html\">NamingSystem Active Ingredient Group Number</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/v3-hc-aign"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-ca-hc-din-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-ca-hc-din-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-ca-hc-din-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-ca-hc-din-ns-1-0-47</b></p><a name=\"hx1g-ca-hc-din-ns-1-0-47\"> </a><a name=\"hchx1g-ca-hc-din-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-ca-hc-din.html\">NamingSystem Health Canada Drug Id Number</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/ca-hc-din"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-v3-hc-npn-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-v3-hc-npn-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-v3-hc-npn-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-v3-hc-npn-ns-1-0-47</b></p><a name=\"hx1g-v3-hc-npn-ns-1-0-47\"> </a><a name=\"hchx1g-v3-hc-npn-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-v3-hc-npn.html\">NamingSystem Health Canada Natural Product Number</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/v3-hc-npn"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-v3-hgnc-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-v3-hgnc-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-v3-hgnc-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-v3-hgnc-ns-1-0-47</b></p><a name=\"hx1g-v3-hgnc-ns-1-0-47\"> </a><a name=\"hchx1g-v3-hgnc-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-v3-hgnc.html\">NamingSystem HUGO Gene Nomenclature Committee Genes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/v3-hgnc"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-v3-hgvs-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-v3-hgvs-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-v3-hgvs-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-v3-hgvs-ns-1-0-47</b></p><a name=\"hx1g-v3-hgvs-ns-1-0-47\"> </a><a name=\"hchx1g-v3-hgvs-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-v3-hgvs.html\">NamingSystem Human Genome Variation Society nomenclature</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/v3-hgvs"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-hhcc-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-hhcc-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-hhcc-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-hhcc-ns-1-0-47</b></p><a name=\"hx1g-hhcc-ns-1-0-47\"> </a><a name=\"hchx1g-hhcc-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-hhcc.html\">NamingSystem Home Health Care</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/hhcc"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-hi-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-hi-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-hi-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-hi-ns-1-0-47</b></p><a name=\"hx1g-hi-ns-1-0-47\"> </a><a name=\"hchx1g-hi-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-hi.html\">NamingSystem Health Outcomes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/hi"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-hibccHIN-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-hibccHIN-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-hibccHIN-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-hibccHIN-ns-1-0-47</b></p><a name=\"hx1g-hibccHIN-ns-1-0-47\"> </a><a name=\"hchx1g-hibccHIN-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-hibccHIN.html\">NamingSystem HIBCC</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/hibccHIN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-hsloc-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-hsloc-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-hsloc-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-hsloc-ns-1-0-47</b></p><a name=\"hx1g-hsloc-ns-1-0-47\"> </a><a name=\"hchx1g-hsloc-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-hsloc.html\">NamingSystem NHSN Healthcare Facility Patient Care Location</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/hsloc"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-ib-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-ib-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-ib-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-ib-ns-1-0-47</b></p><a name=\"hx1g-ib-ns-1-0-47\"> </a><a name=\"hchx1g-ib-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-ib.html\">NamingSystem ISBT</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/ib"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-icd-o-3-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-icd-o-3-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-icd-o-3-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-icd-o-3-ns-1-0-47</b></p><a name=\"hx1g-icd-o-3-ns-1-0-47\"> </a><a name=\"hchx1g-icd-o-3-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-icd-o-3.html\">NamingSystem International Classification of Diseases for Oncology, version 3.</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/icd-o-3"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-icd-o-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-icd-o-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-icd-o-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-icd-o-ns-1-0-47</b></p><a name=\"hx1g-icd-o-ns-1-0-47\"> </a><a name=\"hchx1g-icd-o-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-icd-o.html\">NamingSystem International Classification of Diseases for Oncology</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/icd-o"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-icd10-CA-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-icd10-CA-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-icd10-CA-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-icd10-CA-ns-1-0-47</b></p><a name=\"hx1g-icd10-CA-ns-1-0-47\"> </a><a name=\"hchx1g-icd10-CA-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-icd10-CA.html\">NamingSystem Canadian DiagnosisCodes ICD-10-CA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/icd10-CA"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-icd10-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-icd10-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-icd10-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-icd10-ns-1-0-47</b></p><a name=\"hx1g-icd10-ns-1-0-47\"> </a><a name=\"hchx1g-icd10-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-icd10.html\">NamingSystem ICD-10</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/icd10"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-icd10CM-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-icd10CM-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-icd10CM-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-icd10CM-ns-1-0-47</b></p><a name=\"hx1g-icd10CM-ns-1-0-47\"> </a><a name=\"hchx1g-icd10CM-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-icd10CM.html\">NamingSystem International Classification of Diseases, 10th Revision, Clinical Modification (ICD-10-CM)</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/icd10CM"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-icd10PCS-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-icd10PCS-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-icd10PCS-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-icd10PCS-ns-1-0-47</b></p><a name=\"hx1g-icd10PCS-ns-1-0-47\"> </a><a name=\"hchx1g-icd10PCS-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-icd10PCS.html\">NamingSystem ICD-10 Procedure Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/icd10PCS"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-icd10ae-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-icd10ae-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-icd10ae-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-icd10ae-ns-1-0-47</b></p><a name=\"hx1g-icd10ae-ns-1-0-47\"> </a><a name=\"hchx1g-icd10ae-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-icd10ae.html\">NamingSystem ICD-10 American English</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/icd10ae"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-icd9-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-icd9-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-icd9-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-icd9-ns-1-0-47</b></p><a name=\"hx1g-icd9-ns-1-0-47\"> </a><a name=\"hchx1g-icd9-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-icd9.html\">NamingSystem ICD9</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/icd9"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-icd9cm-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-icd9cm-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-icd9cm-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-icd9cm-ns-1-0-47</b></p><a name=\"hx1g-icd9cm-ns-1-0-47\"> </a><a name=\"hchx1g-icd9cm-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-icd9cm.html\">NamingSystem ICD-9CM</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/icd9cm"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-icnp-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-icnp-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-icnp-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-icnp-ns-1-0-47</b></p><a name=\"hx1g-icnp-ns-1-0-47\"> </a><a name=\"hchx1g-icnp-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-icnp.html\">NamingSystem International Classification for Nursing Practice</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/icnp"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-icpc-BAQ-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-icpc-BAQ-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-icpc-BAQ-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-icpc-BAQ-ns-1-0-47</b></p><a name=\"hx1g-icpc-BAQ-ns-1-0-47\"> </a><a name=\"hchx1g-icpc-BAQ-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-icpc-BAQ.html\">NamingSystem International Classification of Primary Care 1993 Basque</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/icpc-BAQ"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-icpc-DAN-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-icpc-DAN-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-icpc-DAN-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-icpc-DAN-ns-1-0-47</b></p><a name=\"hx1g-icpc-DAN-ns-1-0-47\"> </a><a name=\"hchx1g-icpc-DAN-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-icpc-DAN.html\">NamingSystem International Classification of Primary Care 1993 Danish</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/icpc-DAN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-icpc-DUT-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-icpc-DUT-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-icpc-DUT-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-icpc-DUT-ns-1-0-47</b></p><a name=\"hx1g-icpc-DUT-ns-1-0-47\"> </a><a name=\"hchx1g-icpc-DUT-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-icpc-DUT.html\">NamingSystem International Classification of Primary Care 1993 Dutch</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/icpc-DUT"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-icpc-ENG-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-icpc-ENG-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-icpc-ENG-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-icpc-ENG-ns-1-0-47</b></p><a name=\"hx1g-icpc-ENG-ns-1-0-47\"> </a><a name=\"hchx1g-icpc-ENG-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-icpc-ENG.html\">NamingSystem International Classification of Primary Care 1993 (English)</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/icpc-ENG"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-icpc-FIN-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-icpc-FIN-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-icpc-FIN-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-icpc-FIN-ns-1-0-47</b></p><a name=\"hx1g-icpc-FIN-ns-1-0-47\"> </a><a name=\"hchx1g-icpc-FIN-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-icpc-FIN.html\">NamingSystem International Classification of Primary Care 1993 Finnish</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/icpc-FIN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-icpc-FRE-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-icpc-FRE-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-icpc-FRE-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-icpc-FRE-ns-1-0-47</b></p><a name=\"hx1g-icpc-FRE-ns-1-0-47\"> </a><a name=\"hchx1g-icpc-FRE-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-icpc-FRE.html\">NamingSystem International Classification of Primary Care 1993 French</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/icpc-FRE"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-icpc-GER-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-icpc-GER-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-icpc-GER-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-icpc-GER-ns-1-0-47</b></p><a name=\"hx1g-icpc-GER-ns-1-0-47\"> </a><a name=\"hchx1g-icpc-GER-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-icpc-GER.html\">NamingSystem International Classification of Primary Care 1993 German</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/icpc-GER"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-icpc-HEB-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-icpc-HEB-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-icpc-HEB-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-icpc-HEB-ns-1-0-47</b></p><a name=\"hx1g-icpc-HEB-ns-1-0-47\"> </a><a name=\"hchx1g-icpc-HEB-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-icpc-HEB.html\">NamingSystem International Classification of Primary Care 1993 Hebrew</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/icpc-HEB"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-icpc-HUN-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-icpc-HUN-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-icpc-HUN-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-icpc-HUN-ns-1-0-47</b></p><a name=\"hx1g-icpc-HUN-ns-1-0-47\"> </a><a name=\"hchx1g-icpc-HUN-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-icpc-HUN.html\">NamingSystem International Classification of Primary Care 1993 Hungarian</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/icpc-HUN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-icpc-ITA-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-icpc-ITA-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-icpc-ITA-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-icpc-ITA-ns-1-0-47</b></p><a name=\"hx1g-icpc-ITA-ns-1-0-47\"> </a><a name=\"hchx1g-icpc-ITA-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-icpc-ITA.html\">NamingSystem International Classification of Primary Care 1993 Italian</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/icpc-ITA"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-icpc-NOR-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-icpc-NOR-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-icpc-NOR-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-icpc-NOR-ns-1-0-47</b></p><a name=\"hx1g-icpc-NOR-ns-1-0-47\"> </a><a name=\"hchx1g-icpc-NOR-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-icpc-NOR.html\">NamingSystem International Classification of Primary Care 1993 Norwegian</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/icpc-NOR"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-icpc-POR-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-icpc-POR-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-icpc-POR-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-icpc-POR-ns-1-0-47</b></p><a name=\"hx1g-icpc-POR-ns-1-0-47\"> </a><a name=\"hchx1g-icpc-POR-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-icpc-POR.html\">NamingSystem International Classification of Primary Care 1993 Portuguese</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/icpc-POR"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-icpc-SPA-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-icpc-SPA-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-icpc-SPA-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-icpc-SPA-ns-1-0-47</b></p><a name=\"hx1g-icpc-SPA-ns-1-0-47\"> </a><a name=\"hchx1g-icpc-SPA-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-icpc-SPA.html\">NamingSystem International Classification of Primary Care 1993 Spanish</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/icpc-SPA"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-icpc-SWE-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-icpc-SWE-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-icpc-SWE-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-icpc-SWE-ns-1-0-47</b></p><a name=\"hx1g-icpc-SWE-ns-1-0-47\"> </a><a name=\"hchx1g-icpc-SWE-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-icpc-SWE.html\">NamingSystem International Classification of Primary Care 1993 Swedish</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/icpc-SWE"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-icpc-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-icpc-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-icpc-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-icpc-ns-1-0-47</b></p><a name=\"hx1g-icpc-ns-1-0-47\"> </a><a name=\"hchx1g-icpc-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-icpc.html\">NamingSystem International Classification of Primary Care, 1993 edition</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/icpc"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-icpc2-icd10-DUT-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-icpc2-icd10-DUT-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-icpc2-icd10-DUT-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-icpc2-icd10-DUT-ns-1-0-47</b></p><a name=\"hx1g-icpc2-icd10-DUT-ns-1-0-47\"> </a><a name=\"hchx1g-icpc2-icd10-DUT-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-icpc2-icd10-DUT.html\">NamingSystem ICPC2-ICD10ENG Thesaurus, Dutch Translation</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/icpc2-icd10-DUT"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-icpc2-icd10-ENG-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-icpc2-icd10-ENG-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-icpc2-icd10-ENG-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-icpc2-icd10-ENG-ns-1-0-47</b></p><a name=\"hx1g-icpc2-icd10-ENG-ns-1-0-47\"> </a><a name=\"hchx1g-icpc2-icd10-ENG-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-icpc2-icd10-ENG.html\">NamingSystem ICPC2-ICD10 Thesaurus (English)</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/icpc2-icd10-ENG"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-icpc2-icd10-THSRS-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-icpc2-icd10-THSRS-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-icpc2-icd10-THSRS-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-icpc2-icd10-THSRS-ns-1-0-47</b></p><a name=\"hx1g-icpc2-icd10-THSRS-ns-1-0-47\"> </a><a name=\"hchx1g-icpc2-icd10-THSRS-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-icpc2-icd10-THSRS.html\">NamingSystem ICPC2-ICD10 Thesaurus</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/icpc2-icd10-THSRS"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-icpc2E-DUT-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-icpc2E-DUT-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-icpc2E-DUT-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-icpc2E-DUT-ns-1-0-47</b></p><a name=\"hx1g-icpc2E-DUT-ns-1-0-47\"> </a><a name=\"hchx1g-icpc2E-DUT-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-icpc2E-DUT.html\">NamingSystem ICPC2E, Dutch Translation</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/icpc2E-DUT"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-icpc2E-ENG-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-icpc2E-ENG-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-icpc2E-ENG-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-icpc2E-ENG-ns-1-0-47</b></p><a name=\"hx1g-icpc2E-ENG-ns-1-0-47\"> </a><a name=\"hchx1g-icpc2E-ENG-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-icpc2E-ENG.html\">NamingSystem International Classification of Primary Care, second edition, English</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/icpc2E-ENG"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-icpc2E-P-AE-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-icpc2E-P-AE-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-icpc2E-P-AE-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-icpc2E-P-AE-ns-1-0-47</b></p><a name=\"hx1g-icpc2E-P-AE-ns-1-0-47\"> </a><a name=\"hchx1g-icpc2E-P-AE-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-icpc2E-P-AE.html\">NamingSystem ICPC2E 1998 Plus Am Engl</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/icpc2E-P-AE"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-icpc2E-P-AUS-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-icpc2E-P-AUS-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-icpc2E-P-AUS-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-icpc2E-P-AUS-ns-1-0-47</b></p><a name=\"hx1g-icpc2E-P-AUS-ns-1-0-47\"> </a><a name=\"hchx1g-icpc2E-P-AUS-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-icpc2E-P-AUS.html\">NamingSystem ICPC2P 1998 Plus Austral Mod</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/icpc2E-P-AUS"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-icpc2E-P-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-icpc2E-P-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-icpc2E-P-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-icpc2E-P-ns-1-0-47</b></p><a name=\"hx1g-icpc2E-P-ns-1-0-47\"> </a><a name=\"hchx1g-icpc2E-P-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-icpc2E-P.html\">NamingSystem ICPC2E 1998 Plus</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/icpc2E-P"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-v3-icpc2E-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-v3-icpc2E-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-v3-icpc2E-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-v3-icpc2E-ns-1-0-47</b></p><a name=\"hx1g-v3-icpc2E-ns-1-0-47\"> </a><a name=\"hchx1g-v3-icpc2E-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-v3-icpc2E.html\">NamingSystem International Classification of Primary Care, second edition (1998)</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/v3-icpc2E"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-ics-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-ics-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-ics-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-ics-ns-1-0-47</b></p><a name=\"hx1g-ics-ns-1-0-47\"> </a><a name=\"hchx1g-ics-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-ics.html\">NamingSystem ICCS</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/ics"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-ietf3066-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-ietf3066-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-ietf3066-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-ietf3066-ns-1-0-47</b></p><a name=\"hx1g-ietf3066-ns-1-0-47\"> </a><a name=\"hchx1g-ietf3066-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-ietf3066.html\">NamingSystem Tags for the Identification of Languages</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/ietf3066"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-iso21000-6-2004E-RDD-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-iso21000-6-2004E-RDD-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-iso21000-6-2004E-RDD-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-iso21000-6-2004E-RDD-ns-1-0-47</b></p><a name=\"hx1g-iso21000-6-2004E-RDD-ns-1-0-47\"> </a><a name=\"hchx1g-iso21000-6-2004E-RDD-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-iso21000-6-2004E-RDD.html\">NamingSystem ISO/IEC 21000-6:2004(E) Rights Data Dictionary</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/iso21000-6-2004E-RDD"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-v3-iso3166-1-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-v3-iso3166-1-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-v3-iso3166-1-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-v3-iso3166-1-ns-1-0-47</b></p><a name=\"hx1g-v3-iso3166-1-ns-1-0-47\"> </a><a name=\"hchx1g-v3-iso3166-1-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-v3-iso3166-1.html\">NamingSystem ISO 3166 Part 1 Country Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/v3-iso3166-1"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-iso3166-1edition2-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-iso3166-1edition2-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-iso3166-1edition2-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-iso3166-1edition2-ns-1-0-47</b></p><a name=\"hx1g-iso3166-1edition2-ns-1-0-47\"> </a><a name=\"hchx1g-iso3166-1edition2-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-iso3166-1edition2.html\">NamingSystem ISO 3166 Part 1 Country Codes, 2nd Edition</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/iso3166-1edition2"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-iso3166-1edition2alpha2-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-iso3166-1edition2alpha2-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-iso3166-1edition2alpha2-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-iso3166-1edition2alpha2-ns-1-0-47</b></p><a name=\"hx1g-iso3166-1edition2alpha2-ns-1-0-47\"> </a><a name=\"hchx1g-iso3166-1edition2alpha2-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-iso3166-1edition2alpha2.html\">NamingSystem ISO 3166 Part 1 Country Codes, 2nd Edition, Alpha-2</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/iso3166-1edition2alpha2"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-iso3166-1edition2alpha3-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-iso3166-1edition2alpha3-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-iso3166-1edition2alpha3-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-iso3166-1edition2alpha3-ns-1-0-47</b></p><a name=\"hx1g-iso3166-1edition2alpha3-ns-1-0-47\"> </a><a name=\"hchx1g-iso3166-1edition2alpha3-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-iso3166-1edition2alpha3.html\">NamingSystem ISO 3166 Part 1 Country Codes, 2nd Edition, Alpha-3</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/iso3166-1edition2alpha3"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-iso3166-1edition2numeric-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-iso3166-1edition2numeric-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-iso3166-1edition2numeric-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-iso3166-1edition2numeric-ns-1-0-47</b></p><a name=\"hx1g-iso3166-1edition2numeric-ns-1-0-47\"> </a><a name=\"hchx1g-iso3166-1edition2numeric-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-iso3166-1edition2numeric.html\">NamingSystem ISO 3166 Part 1 Country Codes, 2nd Edition, Numeric</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/iso3166-1edition2numeric"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-iso3166-2-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-iso3166-2-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-iso3166-2-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-iso3166-2-ns-1-0-47</b></p><a name=\"hx1g-iso3166-2-ns-1-0-47\"> </a><a name=\"hchx1g-iso3166-2-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-iso3166-2.html\">NamingSystem ISO 3166 Part 2 Country Subdivision Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/iso3166-2"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-iso4217-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-iso4217-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-iso4217-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-iso4217-ns-1-0-47</b></p><a name=\"hx1g-iso4217-ns-1-0-47\"> </a><a name=\"hchx1g-iso4217-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-iso4217.html\">NamingSystem ISO 4217 Currency Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/iso4217"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-iso639-1-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-iso639-1-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-iso639-1-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-iso639-1-ns-1-0-47</b></p><a name=\"hx1g-iso639-1-ns-1-0-47\"> </a><a name=\"hchx1g-iso639-1-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-iso639-1.html\">NamingSystem ISO 639-1: Codes for the representation of names of languages -- Part 1: Alpha-2 code</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/iso639-1"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-iso639-1ret-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-iso639-1ret-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-iso639-1ret-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-iso639-1ret-ns-1-0-47</b></p><a name=\"hx1g-iso639-1ret-ns-1-0-47\"> </a><a name=\"hchx1g-iso639-1ret-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-iso639-1ret.html\">NamingSystem ISO 639-1 Alpha-2 Language Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/iso639-1ret"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-iso639-2-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-iso639-2-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-iso639-2-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-iso639-2-ns-1-0-47</b></p><a name=\"hx1g-iso639-2-ns-1-0-47\"> </a><a name=\"hchx1g-iso639-2-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-iso639-2.html\">NamingSystem ISO 639-2: Codes for the representation of names of languages -- Part 2: Alpha-3 code</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/iso639-2"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-iso639-2ret-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-iso639-2ret-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-iso639-2ret-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-iso639-2ret-ns-1-0-47</b></p><a name=\"hx1g-iso639-2ret-ns-1-0-47\"> </a><a name=\"hchx1g-iso639-2ret-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-iso639-2ret.html\">NamingSystem ISO 639-2 Alpha-3 Language Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/iso639-2ret"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-iso639-3-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-iso639-3-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-iso639-3-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-iso639-3-ns-1-0-47</b></p><a name=\"hx1g-iso639-3-ns-1-0-47\"> </a><a name=\"hchx1g-iso639-3-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-iso639-3.html\">NamingSystem ISO 639-3 Language Codes Alpha 3</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/iso639-3"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-v3-loinc-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-v3-loinc-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-v3-loinc-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-v3-loinc-ns-1-0-47</b></p><a name=\"hx1g-v3-loinc-ns-1-0-47\"> </a><a name=\"hchx1g-v3-loinc-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-v3-loinc.html\">NamingSystem Logical Observation Identifier Names and Codes (LOINC)</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/v3-loinc"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-v3-lrg-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-v3-lrg-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-v3-lrg-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-v3-lrg-ns-1-0-47</b></p><a name=\"hx1g-v3-lrg-ns-1-0-47\"> </a><a name=\"hchx1g-v3-lrg-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-v3-lrg.html\">NamingSystem Locus Reference Genomic Sequences (LRG)</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/v3-lrg"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-v3-mdc-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-v3-mdc-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-v3-mdc-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-v3-mdc-ns-1-0-47</b></p><a name=\"hx1g-v3-mdc-ns-1-0-47\"> </a><a name=\"hchx1g-v3-mdc-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-v3-mdc.html\">NamingSystem ISO 11073-10101 Health informatics - Point-of-care</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/v3-mdc"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-mddid-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-mddid-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-mddid-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-mddid-ns-1-0-47</b></p><a name=\"hx1g-mddid-ns-1-0-47\"> </a><a name=\"hchx1g-mddid-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-mddid.html\">NamingSystem MDDID</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/mddid"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-mdr-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-mdr-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-mdr-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-mdr-ns-1-0-47</b></p><a name=\"hx1g-mdr-ns-1-0-47\"> </a><a name=\"hchx1g-mdr-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-mdr.html\">NamingSystem Medical Dictionary for Regulatory Activities</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/mdr"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-medcin-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-medcin-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-medcin-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-medcin-ns-1-0-47</b></p><a name=\"hx1g-medcin-ns-1-0-47\"> </a><a name=\"hchx1g-medcin-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-medcin.html\">NamingSystem MEDCIN</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/medcin"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-metabolicSyndrome-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-metabolicSyndrome-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-metabolicSyndrome-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-metabolicSyndrome-ns-1-0-47</b></p><a name=\"hx1g-metabolicSyndrome-ns-1-0-47\"> </a><a name=\"hchx1g-metabolicSyndrome-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-metabolicSyndrome.html\">NamingSystem METABOLIC SYNDROME</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/metabolicSyndrome"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-v3-mime-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-v3-mime-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-v3-mime-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-v3-mime-ns-1-0-47</b></p><a name=\"hx1g-v3-mime-ns-1-0-47\"> </a><a name=\"hchx1g-v3-mime-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-v3-mime.html\">NamingSystem MIME</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/v3-mime"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-mth-icpc2-icd10-7B-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-mth-icpc2-icd10-7B-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-mth-icpc2-icd10-7B-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-mth-icpc2-icd10-7B-ns-1-0-47</b></p><a name=\"hx1g-mth-icpc2-icd10-7B-ns-1-0-47\"> </a><a name=\"hchx1g-mth-icpc2-icd10-7B-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-mth-icpc2-icd10-7B.html\">NamingSystem ICPC2-ICD10 Thesaurus, 7-bit</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/mth-icpc2-icd10-7B"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-mth-icpc2-icd10-AE-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-mth-icpc2-icd10-AE-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-mth-icpc2-icd10-AE-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-mth-icpc2-icd10-AE-ns-1-0-47</b></p><a name=\"hx1g-mth-icpc2-icd10-AE-ns-1-0-47\"> </a><a name=\"hchx1g-mth-icpc2-icd10-AE-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-mth-icpc2-icd10-AE.html\">NamingSystem ICPC2-ICD10 Thesaurus, Am Engl</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/mth-icpc2-icd10-AE"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-mthicpc2E-AE-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-mthicpc2E-AE-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-mthicpc2E-AE-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-mthicpc2E-AE-ns-1-0-47</b></p><a name=\"hx1g-mthicpc2E-AE-ns-1-0-47\"> </a><a name=\"hchx1g-mthicpc2E-AE-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-mthicpc2E-AE.html\">NamingSystem ICPC2E Am Engl (Metathesaurus)</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/mthicpc2E-AE"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-multum-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-multum-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-multum-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-multum-ns-1-0-47</b></p><a name=\"hx1g-multum-ns-1-0-47\"> </a><a name=\"hchx1g-multum-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-multum.html\">NamingSystem Multum Lexicon</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/multum"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-naaccrCodes-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-naaccrCodes-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-naaccrCodes-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-naaccrCodes-ns-1-0-47</b></p><a name=\"hx1g-naaccrCodes-ns-1-0-47\"> </a><a name=\"hchx1g-naaccrCodes-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-naaccrCodes.html\">NamingSystem NAACCR</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/naaccrCodes"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-naics-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-naics-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-naics-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-naics-ns-1-0-47</b></p><a name=\"hx1g-naics-ns-1-0-47\"> </a><a name=\"hchx1g-naics-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-naics.html\">NamingSystem North American Industry Classification System</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/naics"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-nanda-i-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-nanda-i-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-nanda-i-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-nanda-i-ns-1-0-47</b></p><a name=\"hx1g-nanda-i-ns-1-0-47\"> </a><a name=\"hchx1g-nanda-i-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-nanda-i.html\">NamingSystem NANDA International</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/nanda-i"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-v3-nciThesaurus-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-v3-nciThesaurus-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-v3-nciThesaurus-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-v3-nciThesaurus-ns-1-0-47</b></p><a name=\"hx1g-v3-nciThesaurus-ns-1-0-47\"> </a><a name=\"hchx1g-v3-nciThesaurus-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-v3-nciThesaurus.html\">NamingSystem NCI Thesaurus</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/v3-nciThesaurus"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-nciVersionOfNDF-RT-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-nciVersionOfNDF-RT-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-nciVersionOfNDF-RT-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-nciVersionOfNDF-RT-ns-1-0-47</b></p><a name=\"hx1g-nciVersionOfNDF-RT-ns-1-0-47\"> </a><a name=\"hchx1g-nciVersionOfNDF-RT-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-nciVersionOfNDF-RT.html\">NamingSystem NCI Version of NDF-RT</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/nciVersionOfNDF-RT"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-v3-ndc-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-v3-ndc-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-v3-ndc-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-v3-ndc-ns-1-0-47</b></p><a name=\"hx1g-v3-ndc-ns-1-0-47\"> </a><a name=\"hchx1g-v3-ndc-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-v3-ndc.html\">NamingSystem National drug codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/v3-ndc"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-nddf-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-nddf-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-nddf-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-nddf-ns-1-0-47</b></p><a name=\"hx1g-nddf-ns-1-0-47\"> </a><a name=\"hchx1g-nddf-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-nddf.html\">NamingSystem National Drug Data File</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/nddf"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-nic-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-nic-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-nic-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-nic-ns-1-0-47</b></p><a name=\"hx1g-nic-ns-1-0-47\"> </a><a name=\"hchx1g-nic-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-nic.html\">NamingSystem Nursing Intervention Classification</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/nic"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-nmds-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-nmds-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-nmds-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-nmds-ns-1-0-47</b></p><a name=\"hx1g-nmds-ns-1-0-47\"> </a><a name=\"hchx1g-nmds-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-nmds.html\">NamingSystem Nursing Minimum Data Set</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/nmds"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-nmmds-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-nmmds-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-nmmds-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-nmmds-ns-1-0-47</b></p><a name=\"hx1g-nmmds-ns-1-0-47\"> </a><a name=\"hchx1g-nmmds-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-nmmds.html\">NamingSystem Nursing Management Minimum Data Set</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/nmmds"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-noc-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-noc-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-noc-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-noc-ns-1-0-47</b></p><a name=\"hx1g-noc-ns-1-0-47\"> </a><a name=\"hchx1g-noc-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-noc.html\">NamingSystem NOC</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/noc"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-nubc-UB92-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-nubc-UB92-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-nubc-UB92-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-nubc-UB92-ns-1-0-47</b></p><a name=\"hx1g-nubc-UB92-ns-1-0-47\"> </a><a name=\"hchx1g-nubc-UB92-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-nubc-UB92.html\">NamingSystem National Uniform Billing Council, UB 92</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/nubc-UB92"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-oms-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-oms-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-oms-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-oms-ns-1-0-47</b></p><a name=\"hx1g-oms-ns-1-0-47\"> </a><a name=\"hchx1g-oms-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-oms.html\">NamingSystem Omaha System</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/oms"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-opinions-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-opinions-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-opinions-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-opinions-ns-1-0-47</b></p><a name=\"hx1g-opinions-ns-1-0-47\"> </a><a name=\"hchx1g-opinions-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-opinions.html\">NamingSystem Online Product Identification Number Index of Nova Scotia</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/opinions"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-pclocd-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-pclocd-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-pclocd-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-pclocd-ns-1-0-47</b></p><a name=\"hx1g-pclocd-ns-1-0-47\"> </a><a name=\"hchx1g-pclocd-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-pclocd.html\">NamingSystem pan-Canadian LOINC Observation Code Database</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/pclocd"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-pnds-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-pnds-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-pnds-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-pnds-ns-1-0-47</b></p><a name=\"hx1g-pnds-ns-1-0-47\"> </a><a name=\"hchx1g-pnds-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-pnds.html\">NamingSystem Perioperative Nursing Data Set</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/pnds"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-rcFB-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-rcFB-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-rcFB-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-rcFB-ns-1-0-47</b></p><a name=\"hx1g-rcFB-ns-1-0-47\"> </a><a name=\"hchx1g-rcFB-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-rcFB.html\">NamingSystem The Read Codes Four Byte Set:</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/rcFB"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-rcV2-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-rcV2-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-rcV2-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-rcV2-ns-1-0-47</b></p><a name=\"hx1g-rcV2-ns-1-0-47\"> </a><a name=\"hchx1g-rcV2-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-rcV2.html\">NamingSystem The Read Codes Version 2</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/rcV2"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-read-Codes-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-read-Codes-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-read-Codes-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-read-Codes-ns-1-0-47</b></p><a name=\"hx1g-read-Codes-ns-1-0-47\"> </a><a name=\"hchx1g-read-Codes-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-read-Codes.html\">NamingSystem Read Classification</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/read-Codes"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-v3-refSeq-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-v3-refSeq-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-v3-refSeq-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-v3-refSeq-ns-1-0-47</b></p><a name=\"hx1g-v3-refSeq-ns-1-0-47\"> </a><a name=\"hchx1g-v3-refSeq-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-v3-refSeq.html\">NamingSystem Gene Reference Sequence Collection</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/v3-refSeq"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-v3-rxNorm-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-v3-rxNorm-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-v3-rxNorm-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-v3-rxNorm-ns-1-0-47</b></p><a name=\"hx1g-v3-rxNorm-ns-1-0-47\"> </a><a name=\"hchx1g-v3-rxNorm-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-v3-rxNorm.html\">NamingSystem RxNorm</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/v3-rxNorm"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-sic-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-sic-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-sic-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-sic-ns-1-0-47</b></p><a name=\"hx1g-sic-ns-1-0-47\"> </a><a name=\"hchx1g-sic-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-sic.html\">NamingSystem US Census Bureau</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/sic"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-snm-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-snm-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-snm-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-snm-ns-1-0-47</b></p><a name=\"hx1g-snm-ns-1-0-47\"> </a><a name=\"hchx1g-snm-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-snm.html\">NamingSystem Systemized Nomenclature of Medicine (SNOMED)</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/snm"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-v3-snomed-CT-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-v3-snomed-CT-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-v3-snomed-CT-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-v3-snomed-CT-ns-1-0-47</b></p><a name=\"hx1g-v3-snomed-CT-ns-1-0-47\"> </a><a name=\"hchx1g-v3-snomed-CT-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-v3-snomed-CT.html\">NamingSystem SNOMED CT International Edition</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/v3-snomed-CT"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-soc-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-soc-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-soc-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-soc-ns-1-0-47</b></p><a name=\"hx1g-soc-ns-1-0-47\"> </a><a name=\"hchx1g-soc-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-soc.html\">NamingSystem Standard Occupation Code</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/soc"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-standardBillingUnit-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-standardBillingUnit-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-standardBillingUnit-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-standardBillingUnit-ns-1-0-47</b></p><a name=\"hx1g-standardBillingUnit-ns-1-0-47\"> </a><a name=\"hchx1g-standardBillingUnit-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-standardBillingUnit.html\">NamingSystem Standard Billing Unit</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/standardBillingUnit"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-v3-ucum-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-v3-ucum-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-v3-ucum-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-v3-ucum-ns-1-0-47</b></p><a name=\"hx1g-v3-ucum-ns-1-0-47\"> </a><a name=\"hchx1g-v3-ucum-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-v3-ucum.html\">NamingSystem Unified Code for Units of Measure (UCUM)</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/v3-ucum"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-umls-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-umls-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-umls-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-umls-ns-1-0-47</b></p><a name=\"hx1g-umls-ns-1-0-47\"> </a><a name=\"hchx1g-umls-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-umls.html\">NamingSystem Unified Medical Language System</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/umls"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-url-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-url-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-url-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-url-ns-1-0-47</b></p><a name=\"hx1g-url-ns-1-0-47\"> </a><a name=\"hchx1g-url-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-url.html\">NamingSystem URL</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/url"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-usEPAsrs-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-usEPAsrs-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-usEPAsrs-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-usEPAsrs-ns-1-0-47</b></p><a name=\"hx1g-usEPAsrs-ns-1-0-47\"> </a><a name=\"hchx1g-usEPAsrs-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-usEPAsrs.html\">NamingSystem US EPA Substance Registry System</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/usEPAsrs"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-whoARTfl-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-whoARTfl-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-whoARTfl-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-whoARTfl-ns-1-0-47</b></p><a name=\"hx1g-whoARTfl-ns-1-0-47\"> </a><a name=\"hchx1g-whoARTfl-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-whoARTfl.html\">NamingSystem WHO Adverse Reaction Terms foreign language translations</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/whoARTfl"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-whoFRE-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-whoFRE-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-whoFRE-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-whoFRE-ns-1-0-47</b></p><a name=\"hx1g-whoFRE-ns-1-0-47\"> </a><a name=\"hchx1g-whoFRE-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-whoFRE.html\">NamingSystem WHO Adverse Reaction Terms French</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/whoFRE"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-whoGER-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-whoGER-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-whoGER-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-whoGER-ns-1-0-47</b></p><a name=\"hx1g-whoGER-ns-1-0-47\"> </a><a name=\"hchx1g-whoGER-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-whoGER.html\">NamingSystem WHO Adverse Reaction Terms German</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/whoGER"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-whoPOR-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-whoPOR-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-whoPOR-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-whoPOR-ns-1-0-47</b></p><a name=\"hx1g-whoPOR-ns-1-0-47\"> </a><a name=\"hchx1g-whoPOR-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-whoPOR.html\">NamingSystem WHO Adverse Reaction Terms Portuguese</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/whoPOR"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-whoSPA-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-whoSPA-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-whoSPA-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-whoSPA-ns-1-0-47</b></p><a name=\"hx1g-whoSPA-ns-1-0-47\"> </a><a name=\"hchx1g-whoSPA-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-whoSPA.html\">NamingSystem WHO Adverse Reaction Terms Spanish</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/whoSPA"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-v3-PeriodicIntervalOfTimeAbbreviation-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-v3-PeriodicIntervalOfTimeAbbreviation-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-v3-PeriodicIntervalOfTimeAbbreviation-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-v3-PeriodicIntervalOfTimeAbbreviation-ns-1-0-47</b></p><a name=\"hx1g-v3-PeriodicIntervalOfTimeAbbreviation-ns-1-0-47\"> </a><a name=\"hchx1g-v3-PeriodicIntervalOfTimeAbbreviation-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-v3-PeriodicIntervalOfTimeAbbreviation.html\">NamingSystem PeriodicIntervalOfTimeAbbreviation</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/v3-PeriodicIntervalOfTimeAbbreviation"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-v3-ProcedureMethod-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-v3-ProcedureMethod-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-v3-ProcedureMethod-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-v3-ProcedureMethod-ns-1-0-47</b></p><a name=\"hx1g-v3-ProcedureMethod-ns-1-0-47\"> </a><a name=\"hchx1g-v3-ProcedureMethod-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-v3-ProcedureMethod.html\">NamingSystem ProcedureMethod</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/v3-ProcedureMethod"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-v3-SpecialArrangement-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-v3-SpecialArrangement-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-v3-SpecialArrangement-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-v3-SpecialArrangement-ns-1-0-47</b></p><a name=\"hx1g-v3-SpecialArrangement-ns-1-0-47\"> </a><a name=\"hchx1g-v3-SpecialArrangement-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-v3-SpecialArrangement.html\">NamingSystem SpecialArrangement</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/v3-SpecialArrangement"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-v3-UnitOfMeasurePrefix-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-v3-UnitOfMeasurePrefix-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-v3-UnitOfMeasurePrefix-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-v3-UnitOfMeasurePrefix-ns-1-0-47</b></p><a name=\"hx1g-v3-UnitOfMeasurePrefix-ns-1-0-47\"> </a><a name=\"hchx1g-v3-UnitOfMeasurePrefix-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-v3-UnitOfMeasurePrefix.html\">NamingSystem Unit of Measure Prefix</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/v3-UnitOfMeasurePrefix"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-v3-policyHolderRole-ns-1-0-47",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-v3-policyHolderRole-ns-1-0-47",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-v3-policyHolderRole-ns-1-0-47\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-v3-policyHolderRole-ns-1-0-47</b></p><a name=\"hx1g-v3-policyHolderRole-ns-1-0-47\"> </a><a name=\"hchx1g-v3-policyHolderRole-ns-1-0-47\"> </a><p>Provenance for <a href=\"NamingSystem-v3-policyHolderRole.html\">NamingSystem Policy Holder Role</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-09</td></tr><tr><td>Recorded</td><td>2020-10-09 20:05:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/v3-policyHolderRole"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-09"
        },
        "recorded" : "2020-10-09T20:05:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fixed title extension URL to be consistent with latest Publisher"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-v3-snomed-CT-ns-1-0-66",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-v3-snomed-CT-ns-1-0-66",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-v3-snomed-CT-ns-1-0-66\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-v3-snomed-CT-ns-1-0-66</b></p><a name=\"hx1g-v3-snomed-CT-ns-1-0-66\"> </a><a name=\"hchx1g-v3-snomed-CT-ns-1-0-66\"> </a><p>Provenance for <a href=\"NamingSystem-v3-snomed-CT.html\">NamingSystem SNOMED CT International Edition</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-11-03</td></tr><tr><td>Recorded</td><td>2020-11-03 21:00:00+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/v3-snomed-CT"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-11-03"
        },
        "recorded" : "2020-11-03T21:00:00+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Updated metadata to align with HTA and associated UTG external CodeSystem"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-v3-loinc-ns-1-0-66",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-v3-loinc-ns-1-0-66",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-v3-loinc-ns-1-0-66\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-v3-loinc-ns-1-0-66</b></p><a name=\"hx1g-v3-loinc-ns-1-0-66\"> </a><a name=\"hchx1g-v3-loinc-ns-1-0-66\"> </a><p>Provenance for <a href=\"NamingSystem-v3-loinc.html\">NamingSystem Logical Observation Identifier Names and Codes (LOINC)</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-11-03</td></tr><tr><td>Recorded</td><td>2020-11-03 21:00:00+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/v3-loinc"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-11-03"
        },
        "recorded" : "2020-11-03T21:00:00+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Updated metadata to align with HTA and associated UTG external CodeSystem"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-v3-rxNorm-ns-1-0-66",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-v3-rxNorm-ns-1-0-66",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-v3-rxNorm-ns-1-0-66\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-v3-rxNorm-ns-1-0-66</b></p><a name=\"hx1g-v3-rxNorm-ns-1-0-66\"> </a><a name=\"hchx1g-v3-rxNorm-ns-1-0-66\"> </a><p>Provenance for <a href=\"NamingSystem-v3-rxNorm.html\">NamingSystem RxNorm</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-11-03</td></tr><tr><td>Recorded</td><td>2020-11-03 21:00:00+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/v3-rxNorm"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-11-03"
        },
        "recorded" : "2020-11-03T21:00:00+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Updated metadata to align with HTA and associated UTG external CodeSystem"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-v3-ucum-ns-1-0-66",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-v3-ucum-ns-1-0-66",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-v3-ucum-ns-1-0-66\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-v3-ucum-ns-1-0-66</b></p><a name=\"hx1g-v3-ucum-ns-1-0-66\"> </a><a name=\"hchx1g-v3-ucum-ns-1-0-66\"> </a><p>Provenance for <a href=\"NamingSystem-v3-ucum.html\">NamingSystem Unified Code for Units of Measure (UCUM)</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-11-03</td></tr><tr><td>Recorded</td><td>2020-11-03 21:00:00+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/v3-ucum"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-11-03"
        },
        "recorded" : "2020-11-03T21:00:00+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Updated metadata to align with HTA and associated UTG external CodeSystem"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-POAIndicators-vs-2-1-24",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-POAIndicators-vs-2-1-24",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-POAIndicators-vs-2-1-24\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-POAIndicators-vs-2-1-24</b></p><a name=\"hx1g-POAIndicators-vs-2-1-24\"> </a><a name=\"hchx1g-POAIndicators-vs-2-1-24\"> </a><p>Provenance for <a href=\"ValueSet-POAIndicators.html\">ValueSet Present on Admission Indicators</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2021-09-01</td></tr><tr><td>Recorded</td><td>2021-09-01 14:48:49-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>CQI</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/POAIndicators"
          }
        ],
        "occurredPeriod" : {
          "end" : "2021-09-01"
        },
        "recorded" : "2021-09-01T14:48:49-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Create Present On Admission Indicators Value Set; UP-219"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "CQI"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-CDCREC-ns-2-1-36",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-CDCREC-ns-2-1-36",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-CDCREC-ns-2-1-36\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-CDCREC-ns-2-1-36</b></p><a name=\"hx1g-CDCREC-ns-2-1-36\"> </a><a name=\"hchx1g-CDCREC-ns-2-1-36\"> </a><p>Provenance for <a href=\"NamingSystem-CDCREC.html\">NamingSystem CDC Race and Ethnicity</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2021-10-06</td></tr><tr><td>Recorded</td><td>2021-10-06 11:19:08-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>HTA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/CDCREC"
          }
        ],
        "occurredPeriod" : {
          "end" : "2021-10-06"
        },
        "recorded" : "2021-10-06T11:19:08-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Unify and Update CDC Race and Ethnicity (CDCREC) Entries; UP-237"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "HTA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-CDCREC-cs-2-1-36",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-CDCREC-cs-2-1-36",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-CDCREC-cs-2-1-36\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-CDCREC-cs-2-1-36</b></p><a name=\"hx1g-CDCREC-cs-2-1-36\"> </a><a name=\"hchx1g-CDCREC-cs-2-1-36\"> </a><p>Provenance for <a href=\"CodeSystem/CDCREC\">CodeSystem/CDCREC</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2021-10-06</td></tr><tr><td>Recorded</td><td>2021-10-06 11:38:23-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>HTA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/CDCREC"
          }
        ],
        "occurredPeriod" : {
          "end" : "2021-10-06"
        },
        "recorded" : "2021-10-06T11:38:23-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Unify and Update CDC Race and Ethnicity (CDCREC) Entries; UP-237"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "HTA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-v2-0005-cs-2-1-36",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-v2-0005-cs-2-1-36",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-v2-0005-cs-2-1-36\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-v2-0005-cs-2-1-36</b></p><a name=\"hx1g-v2-0005-cs-2-1-36\"> </a><a name=\"hchx1g-v2-0005-cs-2-1-36\"> </a><p>Provenance for <a href=\"CodeSystem-v2-0005.html\">CodeSystem PH_RaceAndEthnicity_CDC</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2021-10-06</td></tr><tr><td>Recorded</td><td>2021-10-06 11:39:52-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>HTA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v2-0005"
          }
        ],
        "occurredPeriod" : {
          "end" : "2021-10-06"
        },
        "recorded" : "2021-10-06T11:39:52-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Unify and Update CDC Race and Ethnicity (CDCREC) Entries; UP-237"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "HTA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-v2-tables-cs-2-1-36",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-v2-tables-cs-2-1-36",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-v2-tables-cs-2-1-36\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-v2-tables-cs-2-1-36</b></p><a name=\"hx1g-v2-tables-cs-2-1-36\"> </a><a name=\"hchx1g-v2-tables-cs-2-1-36\"> </a><p>Provenance for <a href=\"CodeSystem-v2-tables.html\">CodeSystem V2 Table List</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2021-10-06</td></tr><tr><td>Recorded</td><td>2021-10-06 11:40:21-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>HTA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v2-tables"
          }
        ],
        "occurredPeriod" : {
          "end" : "2021-10-06"
        },
        "recorded" : "2021-10-06T11:40:21-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Unify and Update CDC Race and Ethnicity (CDCREC) Entries; UP-237"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "HTA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-v2-0005-vs-2-1-36",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-v2-0005-vs-2-1-36",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-v2-0005-vs-2-1-36\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-v2-0005-vs-2-1-36</b></p><a name=\"hx1g-v2-0005-vs-2-1-36\"> </a><a name=\"hchx1g-v2-0005-vs-2-1-36\"> </a><p>Provenance for <a href=\"ValueSet-v2-0005.html\">ValueSet PHVS_Race_HL7_2x</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2021-10-06</td></tr><tr><td>Recorded</td><td>2021-10-06 11:41:00-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>HTA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v2-0005"
          }
        ],
        "occurredPeriod" : {
          "end" : "2021-10-06"
        },
        "recorded" : "2021-10-06T11:41:00-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Unify and Update CDC Race and Ethnicity (CDCREC) Entries; UP-237"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "HTA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-CVX-cs-2-1-35",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-CVX-cs-2-1-35",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-CVX-cs-2-1-35\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-CVX-cs-2-1-35</b></p><a name=\"hx1g-CVX-cs-2-1-35\"> </a><a name=\"hchx1g-CVX-cs-2-1-35\"> </a><p>Provenance for <a href=\"CodeSystem/CVX\">CodeSystem/CVX</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2021-10-24</td></tr><tr><td>Recorded</td><td>2021-10-24 19:59:36-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>HTA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/CVX"
          }
        ],
        "occurredPeriod" : {
          "end" : "2021-10-24"
        },
        "recorded" : "2021-10-24T19:59:36-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Unify and Update CVX per HTA;UP-239"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "HTA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-CVX-ns-2-1-35",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-CVX-ns-2-1-35",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-CVX-ns-2-1-35\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-CVX-ns-2-1-35</b></p><a name=\"hx1g-CVX-ns-2-1-35\"> </a><a name=\"hchx1g-CVX-ns-2-1-35\"> </a><p>Provenance for <a href=\"NamingSystem-CVX.html\">NamingSystem Vaccine Administered Code Set (CVX)</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2021-10-24</td></tr><tr><td>Recorded</td><td>2021-10-24 20:00:09-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>HTA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/CVX"
          }
        ],
        "occurredPeriod" : {
          "end" : "2021-10-24"
        },
        "recorded" : "2021-10-24T20:00:09-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Unify and Update CVX per HTA;UP-239"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "HTA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-v2-tables-cs-2-1-35",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-v2-tables-cs-2-1-35",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-v2-tables-cs-2-1-35\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-v2-tables-cs-2-1-35</b></p><a name=\"hx1g-v2-tables-cs-2-1-35\"> </a><a name=\"hchx1g-v2-tables-cs-2-1-35\"> </a><p>Provenance for <a href=\"CodeSystem-v2-tables.html\">CodeSystem V2 Table List</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2021-10-24</td></tr><tr><td>Recorded</td><td>2021-10-24 20:01:34-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>HTA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v2-tables"
          }
        ],
        "occurredPeriod" : {
          "end" : "2021-10-24"
        },
        "recorded" : "2021-10-24T20:01:34-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Unify and Update CVX per HTA;UP-239"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "HTA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-GLN-ns-3-0-3",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-GLN-ns-3-0-3",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-GLN-ns-3-0-3\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-GLN-ns-3-0-3</b></p><a name=\"hx1g-GLN-ns-3-0-3\"> </a><a name=\"hchx1g-GLN-ns-3-0-3\"> </a><p>Provenance for <a href=\"NamingSystem-GLN.html\">NamingSystem Global Location Number (GLN)</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-01-28</td></tr><tr><td>Recorded</td><td>2022-01-28 09:35:21-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>HTA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/GLN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-01-28"
        },
        "recorded" : "2022-01-28T09:35:21-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add Global Location Number (GLN) as Identifier System; UP-267"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "HTA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-AHANUBCPatientDischargeStatus-ns-3-1-10",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-AHANUBCPatientDischargeStatus-ns-3-1-10",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-AHANUBCPatientDischargeStatus-ns-3-1-10\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-AHANUBCPatientDischargeStatus-ns-3-1-10</b></p><a name=\"hx1g-AHANUBCPatientDischargeStatus-ns-3-1-10\"> </a><a name=\"hchx1g-AHANUBCPatientDischargeStatus-ns-3-1-10\"> </a><p>Provenance for <a href=\"NamingSystem-AHANUBCPatientDischargeStatus.html\">NamingSystem AHA NUBC Patient Discharge Status Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-07-21</td></tr><tr><td>Recorded</td><td>2022-07-21 12:51:36-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>HTA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/AHANUBCPatientDischargeStatus"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-07-21"
        },
        "recorded" : "2022-07-21T12:51:36-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add NUBC Code Systems per HTA; UP-324"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "HTA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-AHANUBCPatientDischargeStatus-cs-3-1-10",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-AHANUBCPatientDischargeStatus-cs-3-1-10",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-AHANUBCPatientDischargeStatus-cs-3-1-10\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-AHANUBCPatientDischargeStatus-cs-3-1-10</b></p><a name=\"hx1g-AHANUBCPatientDischargeStatus-cs-3-1-10\"> </a><a name=\"hchx1g-AHANUBCPatientDischargeStatus-cs-3-1-10\"> </a><p>Provenance for <a href=\"CodeSystem/AHANUBCPatientDischargeStatus\">CodeSystem/AHANUBCPatientDischargeStatus</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-07-21</td></tr><tr><td>Recorded</td><td>2022-07-21 12:52:03-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>HTA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/AHANUBCPatientDischargeStatus"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-07-21"
        },
        "recorded" : "2022-07-21T12:52:03-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add NUBC Code Systems per HTA; UP-324"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "HTA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-AHANUBCPointOfOriginNewborn-cs-3-1-10",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-AHANUBCPointOfOriginNewborn-cs-3-1-10",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-AHANUBCPointOfOriginNewborn-cs-3-1-10\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-AHANUBCPointOfOriginNewborn-cs-3-1-10</b></p><a name=\"hx1g-AHANUBCPointOfOriginNewborn-cs-3-1-10\"> </a><a name=\"hchx1g-AHANUBCPointOfOriginNewborn-cs-3-1-10\"> </a><p>Provenance for <a href=\"CodeSystem/AHANUBCPointOfOriginNewborn\">CodeSystem/AHANUBCPointOfOriginNewborn</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-07-21</td></tr><tr><td>Recorded</td><td>2022-07-21 12:53:10-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>HTA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/AHANUBCPointOfOriginNewborn"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-07-21"
        },
        "recorded" : "2022-07-21T12:53:10-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add NUBC Code Systems per HTA; UP-324"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "HTA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-AHANUBCPointOfOriginNewborn-ns-3-1-10",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-AHANUBCPointOfOriginNewborn-ns-3-1-10",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-AHANUBCPointOfOriginNewborn-ns-3-1-10\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-AHANUBCPointOfOriginNewborn-ns-3-1-10</b></p><a name=\"hx1g-AHANUBCPointOfOriginNewborn-ns-3-1-10\"> </a><a name=\"hchx1g-AHANUBCPointOfOriginNewborn-ns-3-1-10\"> </a><p>Provenance for <a href=\"NamingSystem-AHANUBCPointOfOriginNewborn.html\">NamingSystem AHA NUBC Point of Origin for Newborn</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-07-21</td></tr><tr><td>Recorded</td><td>2022-07-21 12:53:34-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>HTA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/AHANUBCPointOfOriginNewborn"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-07-21"
        },
        "recorded" : "2022-07-21T12:53:34-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add NUBC Code Systems per HTA; UP-324"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "HTA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-AHANUBCPointOfOriginNonnewborn-cs-3-1-10",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-AHANUBCPointOfOriginNonnewborn-cs-3-1-10",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-AHANUBCPointOfOriginNonnewborn-cs-3-1-10\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-AHANUBCPointOfOriginNonnewborn-cs-3-1-10</b></p><a name=\"hx1g-AHANUBCPointOfOriginNonnewborn-cs-3-1-10\"> </a><a name=\"hchx1g-AHANUBCPointOfOriginNonnewborn-cs-3-1-10\"> </a><p>Provenance for <a href=\"CodeSystem/AHANUBCPointOfOriginNonnewborn\">CodeSystem/AHANUBCPointOfOriginNonnewborn</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-07-21</td></tr><tr><td>Recorded</td><td>2022-07-21 13:04:10-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>HTA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/AHANUBCPointOfOriginNonnewborn"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-07-21"
        },
        "recorded" : "2022-07-21T13:04:10-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add NUBC Code Systems per HTA; UP-324"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "HTA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-AHANUBCPointOfOriginNonnewborn-ns-3-1-10",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-AHANUBCPointOfOriginNonnewborn-ns-3-1-10",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-AHANUBCPointOfOriginNonnewborn-ns-3-1-10\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-AHANUBCPointOfOriginNonnewborn-ns-3-1-10</b></p><a name=\"hx1g-AHANUBCPointOfOriginNonnewborn-ns-3-1-10\"> </a><a name=\"hchx1g-AHANUBCPointOfOriginNonnewborn-ns-3-1-10\"> </a><p>Provenance for <a href=\"NamingSystem-AHANUBCPointOfOriginNonnewborn.html\">NamingSystem AHA NUBC Point of Origin for Non-newborn</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-07-21</td></tr><tr><td>Recorded</td><td>2022-07-21 13:04:10-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>HTA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/AHANUBCPointOfOriginNonnewborn"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-07-21"
        },
        "recorded" : "2022-07-21T13:04:10-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add NUBC Code Systems per HTA; UP-324"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "HTA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-AHANUBCPriorityTypeOfAdmitOrVisit-cs-3-1-10",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-AHANUBCPriorityTypeOfAdmitOrVisit-cs-3-1-10",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-AHANUBCPriorityTypeOfAdmitOrVisit-cs-3-1-10\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-AHANUBCPriorityTypeOfAdmitOrVisit-cs-3-1-10</b></p><a name=\"hx1g-AHANUBCPriorityTypeOfAdmitOrVisit-cs-3-1-10\"> </a><a name=\"hchx1g-AHANUBCPriorityTypeOfAdmitOrVisit-cs-3-1-10\"> </a><p>Provenance for <a href=\"CodeSystem/AHANUBCPriorityTypeOfAdmitOrVisit\">CodeSystem/AHANUBCPriorityTypeOfAdmitOrVisit</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-07-21</td></tr><tr><td>Recorded</td><td>2022-07-21 13:05:10-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>HTA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/AHANUBCPriorityTypeOfAdmitOrVisit"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-07-21"
        },
        "recorded" : "2022-07-21T13:05:10-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add NUBC Code Systems per HTA; UP-324"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "HTA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-AHANUBCPriorityTypeOfAdmitOrVisit-ns-3-1-10",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-AHANUBCPriorityTypeOfAdmitOrVisit-ns-3-1-10",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-AHANUBCPriorityTypeOfAdmitOrVisit-ns-3-1-10\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-AHANUBCPriorityTypeOfAdmitOrVisit-ns-3-1-10</b></p><a name=\"hx1g-AHANUBCPriorityTypeOfAdmitOrVisit-ns-3-1-10\"> </a><a name=\"hchx1g-AHANUBCPriorityTypeOfAdmitOrVisit-ns-3-1-10\"> </a><p>Provenance for <a href=\"NamingSystem-AHANUBCPriorityTypeOfAdmitOrVisit.html\">NamingSystem AHA NUBC Priority (Type) of Admission or Visit</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-07-21</td></tr><tr><td>Recorded</td><td>2022-07-21 13:05:10-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>HTA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/AHANUBCPriorityTypeOfAdmitOrVisit"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-07-21"
        },
        "recorded" : "2022-07-21T13:05:10-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add NUBC Code Systems per HTA; UP-324"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "HTA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-AHANUBCRevenueCodes-cs-3-1-10",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-AHANUBCRevenueCodes-cs-3-1-10",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-AHANUBCRevenueCodes-cs-3-1-10\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-AHANUBCRevenueCodes-cs-3-1-10</b></p><a name=\"hx1g-AHANUBCRevenueCodes-cs-3-1-10\"> </a><a name=\"hchx1g-AHANUBCRevenueCodes-cs-3-1-10\"> </a><p>Provenance for <a href=\"CodeSystem/AHANUBCRevenueCodes\">CodeSystem/AHANUBCRevenueCodes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-07-21</td></tr><tr><td>Recorded</td><td>2022-07-21 13:05:36-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>HTA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/AHANUBCRevenueCodes"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-07-21"
        },
        "recorded" : "2022-07-21T13:05:36-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add NUBC Code Systems per HTA; UP-324"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "HTA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-AHANUBCRevenueCodes-ns-3-1-10",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-AHANUBCRevenueCodes-ns-3-1-10",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-AHANUBCRevenueCodes-ns-3-1-10\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-AHANUBCRevenueCodes-ns-3-1-10</b></p><a name=\"hx1g-AHANUBCRevenueCodes-ns-3-1-10\"> </a><a name=\"hchx1g-AHANUBCRevenueCodes-ns-3-1-10\"> </a><p>Provenance for <a href=\"NamingSystem-AHANUBCRevenueCodes.html\">NamingSystem AHA NUBC Revenue Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-07-21</td></tr><tr><td>Recorded</td><td>2022-07-21 13:05:36-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>HTA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/AHANUBCRevenueCodes"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-07-21"
        },
        "recorded" : "2022-07-21T13:05:36-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add NUBC Code Systems per HTA; UP-324"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "HTA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-operation-outcome-cs-3-1-7",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-operation-outcome-cs-3-1-7",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-operation-outcome-cs-3-1-7\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-operation-outcome-cs-3-1-7</b></p><a name=\"hx1g-operation-outcome-cs-3-1-7\"> </a><a name=\"hchx1g-operation-outcome-cs-3-1-7\"> </a><p>Provenance for <a href=\"CodeSystem-operation-outcome.html\">CodeSystem Operation Outcome Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-07-15</td></tr><tr><td>Recorded</td><td>2022-07-15 18:03:32-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Alexander Zautke</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>FHIR-I</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/operation-outcome"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-07-15"
        },
        "recorded" : "2022-07-15T18:03:32-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add OperationOutcome code for failed external references; UP-299/UP-293"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Alexander Zautke"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "FHIR-I"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-USEIN-ns-3-1-19",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-USEIN-ns-3-1-19",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-USEIN-ns-3-1-19\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-USEIN-ns-3-1-19</b></p><a name=\"hx1g-USEIN-ns-3-1-19\"> </a><a name=\"hchx1g-USEIN-ns-3-1-19\"> </a><p>Provenance for <a href=\"NamingSystem-USEIN.html\">NamingSystem United States Employer Identification Number</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-09-01</td></tr><tr><td>Recorded</td><td>2022-09-01 18:01:01-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>HTA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/USEIN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-09-01"
        },
        "recorded" : "2022-09-01T18:01:01-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add United States Employer Identification Number (EIN) per HTA; up-330"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "HTA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1g-v3-TribalEntityUS-cs-3-0-7",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1g-v3-TribalEntityUS-cs-3-0-7",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1g-v3-TribalEntityUS-cs-3-0-7\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1g-v3-TribalEntityUS-cs-3-0-7</b></p><a name=\"hx1g-v3-TribalEntityUS-cs-3-0-7\"> </a><a name=\"hchx1g-v3-TribalEntityUS-cs-3-0-7\"> </a><p>Provenance for <a href=\"CodeSystem-v3-TribalEntityUS.html\">CodeSystem TribalEntityUS</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-10-21</td></tr><tr><td>Recorded</td><td>2022-10-21 15:54:36-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocab</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-TribalEntityUS"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-10-21"
        },
        "recorded" : "2022-10-21T15:54:36-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Update TribalEntityUS Code System; up-357"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocab"
            }
          }
        ]
      }
    }
  ]
}

```
