# Unified Value Sets - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Value Sets**](valuesets.md)
* **Unified Value Sets**

## Unified Value Sets

 Value Sets defined and maintained by HL7 as part of all HL7 families of International Standards. Primarily intended for infrastructure material. 

* Identity: 
  * Name: 
  * Version: 
  * Status: 
  * Owner: 
  * Copyright: 
  * Date: 
  * Description: 
* Identity: [CMSPlaceOfServiceCo…](ValueSet-CMSPlaceOfServiceCodes.md)
  * Name: CMS Place of Service Codes (POS)
  * Version: 1.0.0
  * Status: active
  * Owner: [sd](http://www.hl7.org/Special/committees/structure)
  * Copyright: THO
  * Date: 2024-07-01
  * Description: This is the all codes value set for the CMS POS code system.
* Identity: [ILRSpeakingSkillSca…](ValueSet-ILRSpeakingSkillScale.md)
  * Name: Interagency Language Roundtable Speaking Skill Scale
  * Version: 1.0.0
  * Status: active
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2024-07-01
  * Description: This value set defines a set of codes for documenting spoken language proficiency based on the Inte…
* Identity: [Languages](ValueSet-Languages.md)
  * Name: Languages
  * Version: 1.0.0
  * Status: active
  * Owner: [cgp](http://www.hl7.org/Special/committees/cgp)
  * Copyright: THO
  * Date: 2024-07-01
  * Description: This value set defines a set of codes for the representation of the names of languages. It uses the…
* Identity: [USPS-State](ValueSet-USPS-State.md)
  * Name: USPS Two Letter Alphabetic Codes
  * Version: 1.0.0
  * Status: active
  * Owner: [cgp](http://www.hl7.org/Special/committees/cgp)
  * Copyright: THO
  * Date: 2025-05-27
  * Description: This value set defines two letter USPS alphabetic codes.
* Identity: [mif-conceptRelation…](ValueSet-mif-conceptRelationshipKind.md)
  * Name: MIF Concept Relationship Kind
  * Version: 2.0.0
  * Status: draft
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: Codes for use in the ext-mif-relationship-relationshipKind to capture V3 Model Interchange Format (…
* Identity: [mif-conceptRelation…](ValueSet-mif-conceptRelationshipReflexivity.md)
  * Name: MIF Concept Relationship Reflexivity
  * Version: 1.0.0
  * Status: draft
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: Codes for use in the ext-mif-relationship-reflexivity to capture V3 Model Interchange Format (MIF) …
* Identity: [mif-conceptRelation…](ValueSet-mif-conceptRelationshipSymmetry.md)
  * Name: MIF Concept Relationship Symmetry
  * Version: 1.0.0
  * Status: draft
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: Codes for use in the ext-mif-relationship-symmetry to capture V3 Model Interchange Format (MIF) Sup…
* Identity: [mif-conceptRelation…](ValueSet-mif-conceptRelationshipTransitivity.md)
  * Name: MIF Concept Relationship Transitivity
  * Version: 1.0.0
  * Status: draft
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: Codes for use in the ext-mif-relationship-transitivity to capture V3 Model Interchange Format (MIF)…
* Identity: [mif-conceptRelation…](ValueSet-mif-conceptRelationshipTransitivity.md)
  * Name: MIF Concept Relationship Transitivity
  * Version: 1.0.0
  * Status: draft
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: Codes for use in the ext-mif-relationship-transitivity to capture V3 Model Interchange Format (MIF)…
* Identity: [yes-no-unknown-not-…](ValueSet-yes-no-unknown-not-applicable.md)
  * Name: Yes No Unknown NotApplicable
  * Version: 1.0.0
  * Status: active
  * Owner: [pher](http://www.hl7.org/Special/committees/pher)
  * Copyright: THO
  * Date: 2025-02-17
  * Description: This valueset contains the set of codes used to respond to any question that can be answered Yes, N…
* Identity: [yes-no-unknown-not-…](ValueSet-yes-no-unknown-not-asked.md)
  * Name: Yes No Unknown NotAsked
  * Version: 1.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-06-17
  * Description: This value set contains 4 concepts commonly used as answers to items in a questionnaire.

Showing 11 of 11 entries

