# FHIR Value Sets - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Value Sets**](valuesets.md)
* **FHIR Value Sets**

## FHIR Value Sets

 Value Sets defined and maintained by HL7 as part of the FHIR International Standards, and labeled as "External FHIR". 

* Identity: 
  * Name: 
  * Version: 
  * Status: 
  * Owner: 
  * Copyright: 
  * Date: 
  * Description: 
* Identity: [accepting-patients](ValueSet-accepting-patients.md)
  * Name: Accepting Patients
  * Version: 1.0.0
  * Status: active
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: This value set defines a set of codes that can be used to indicate a practice is accepting new pati…
* Identity: [action-participant-…](ValueSet-action-participant-role.md)
  * Name: Action Participant Role
  * Version: 1.0.0
  * Status: draft
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2017-02-15
  * Description: Either a practitioner role or a relationship type. Note from UTG import - may have been a temporar…
* Identity: [action-type](ValueSet-action-type.md)
  * Name: ActionType
  * Version: 1.0.1
  * Status: active
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The type of action to be performed.
* Identity: [activity-definition…](ValueSet-activity-definition-category.md)
  * Name: ActivityDefinitionCategory
  * Version: 1.0.0
  * Status: draft
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: High-level categorization of the type of activity.
* Identity: [adjudication](ValueSet-adjudication.md)
  * Name: Adjudication Value Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set includes a smattering of Adjudication Value codes which includes codes to indicate t…
* Identity: [adjudication-error](ValueSet-adjudication-error.md)
  * Name: AdjudicationError
  * Version: 1.0.1
  * Status: active
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set includes a smattering of adjudication codes.
* Identity: [adjudication-reason](ValueSet-adjudication-reason.md)
  * Name: Adjudication Reason Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set includes smattering of Adjudication Reason codes.
* Identity: [adverse-event-categ…](ValueSet-adverse-event-category.md)
  * Name: AdverseEventCategory
  * Version: 1.0.1
  * Status: active
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Overall categorization of the event, e.g. product-related or situational.
* Identity: [adverse-event-causa…](ValueSet-adverse-event-causality-assess.md)
  * Name: AdverseEventCausalityAssessment
  * Version: 1.0.1
  * Status: active
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Codes for the assessment of whether the entity caused the event.
* Identity: [adverse-event-causa…](ValueSet-adverse-event-causality-method.md)
  * Name: AdverseEventCausalityMethod
  * Version: 1.0.1
  * Status: active
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: TODO.
* Identity: [adverse-event-clini…](ValueSet-adverse-event-clinical-research-causality-relatedness.md)
  * Name: Adverse Event Clinical Research Causality Relatedness
  * Version: 1.0.0
  * Status: active
  * Owner: [brr](http://www.hl7.org/Special/committees/rcrim)
  * Copyright: THO
  * Date: 2023-07-28
  * Description: Value set for stating if a suspected entity is Not Related, Unlikely Related, Possibly Related, or …
* Identity: [adverse-event-clini…](ValueSet-adverse-event-clinical-research-grades.md)
  * Name: Adverse Event Clinical Research Grades
  * Version: 1.0.0
  * Status: active
  * Owner: [brr](http://www.hl7.org/Special/committees/rcrim)
  * Copyright: THO
  * Date: 2023-07-28
  * Description: Value set of grades used in Adverse Event Clinical Research, especially in Oncology clinical trials
* Identity: [adverse-event-clini…](ValueSet-adverse-event-clinical-research-outcomes.md)
  * Name: Adverse Event Clinical Research Outcomes
  * Version: 1.0.0
  * Status: active
  * Owner: [brr](http://www.hl7.org/Special/committees/rcrim)
  * Copyright: THO
  * Date: 2023-07-28
  * Description: This value set includes codes that describe the type of outcome from the adverse event as typically…
* Identity: [adverse-event-clini…](ValueSet-adverse-event-clinical-research-seriousness-criteria.md)
  * Name: Adverse Event Clinical Research Seriousness Criteria
  * Version: 1.0.0
  * Status: active
  * Owner: [brr](http://www.hl7.org/Special/committees/rcrim)
  * Copyright: THO
  * Date: 2023-07-28
  * Description: Action criteria usually associated with serious events that pose a threat to a patient's life or fu…
* Identity: [adverse-event-serio…](ValueSet-adverse-event-seriousness.md)
  * Name: AdverseEventSeriousness
  * Version: 1.0.1
  * Status: active
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Overall seriousness of this event for the patient.
* Identity: [adverse-event-sever…](ValueSet-adverse-event-severity.md)
  * Name: AdverseEventSeverity
  * Version: 1.0.0
  * Status: draft
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: The severity of the adverse event itself, in direct relation to the subject.
* Identity: [allerg-intol-substa…](ValueSet-allerg-intol-substance-exp-risk.md)
  * Name: AllergyIntoleranceSubstanceExposureRisk
  * Version: 1.0.0
  * Status: draft
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: The risk of an adverse reaction (allergy or intolerance) for this patient upon exposure to the subs…
* Identity: [allergyintolerance-…](ValueSet-allergyintolerance-clinical.md)
  * Name: AllergyIntolerance Clinical Status Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Preferred value set for AllergyIntolerance Clinical Status.
* Identity: [allergyintolerance-…](ValueSet-allergyintolerance-verification.md)
  * Name: AllergyIntolerance Verification Status
  * Version: 1.0.1
  * Status: active
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The verification status to support or decline the clinical status of the allergy or intolerance.
* Identity: [appointment-cancell…](ValueSet-appointment-cancellation-reason.md)
  * Name: Appointment cancellation reason
  * Version: 1.0.1
  * Status: active
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This example value set defines a set of reasons for the cancellation of an appointment.
* Identity: [appropriateness-sco…](ValueSet-appropriateness-score.md)
  * Name: Appropriateness Score
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2022-10-19
  * Description: The scoring for appropriateness of an action based upon RAND.
* Identity: [artifact-contributi…](ValueSet-artifact-contribution-instance-type.md)
  * Name: Artifact Contribution Instance Type
  * Version: 1.0.0
  * Status: trial-use
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: Artifact Contribution Instance Type
* Identity: [artifact-identifier…](ValueSet-artifact-identifier-type.md)
  * Name: Artifact Identifier Type
  * Version: 1.0.0
  * Status: active
  * Owner: [cqi](http://www.hl7.org/Special/committees/cqi)
  * Copyright: THO
  * Date: 2024-02-20
  * Description: Identifier types for an artifact (e.g. version-independent, version-specific, short-name, endorser,…
* Identity: [artifact-relationsh…](ValueSet-artifact-relationship-type.md)
  * Name: Artifact Relationship Type
  * Version: 1.0.0
  * Status: active
  * Owner: [sd](http://www.hl7.org/Special/committees/structure)
  * Copyright: THO
  * Date: 2025-02-24
  * Description: Type of relationship to the related artifact.
* Identity: [artifact-url-classi…](ValueSet-artifact-url-classifier.md)
  * Name: Artifact Url Classifier
  * Version: 1.0.0
  * Status: trial-use
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: Code the reason for different URLs, eg abstract and full-text.
* Identity: [artifact-version-po…](ValueSet-artifact-version-policy.md)
  * Name: Artifact Version Policy
  * Version: 1.0.0
  * Status: trial-use
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: THO
  * Date: 2024-02-16
  * Description: The versioning policy of an artifact or set of artifacts (metadata or strict)
* Identity: [attribute-estimate-…](ValueSet-attribute-estimate-type.md)
  * Name: StatisticAttributeEstimateType
  * Version: 1.0.1
  * Status: active
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Method of reporting variability of estimates, such as confidence intervals, interquartile range or …
* Identity: [audit-event-outcome](ValueSet-audit-event-outcome.md)
  * Name: Audit Event Outcome
  * Version: 1.0.0
  * Status: active
  * Owner: [sec](http://www.hl7.org/Special/committees/secure)
  * Copyright: THO
  * Date: 2010-08-26
  * Description: The type of process where the audit event originated from.
* Identity: [audit-source-type](ValueSet-audit-source-type.md)
  * Name: Audit Event Source Type
  * Version: 1.0.0
  * Status: active
  * Owner: [sec](http://www.hl7.org/Special/committees/secure)
  * Copyright: THO
  * Date: 2010-08-26
  * Description: The type of process where the audit event originated from.
* Identity: [basic-resource-type](ValueSet-basic-resource-type.md)
  * Name: Basic Resource Types
  * Version: 1.0.1
  * Status: active
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set defines codes for resources not yet supported by (or which will never be supported b…
* Identity: [benefit-network](ValueSet-benefit-network.md)
  * Name: Network Type Codes
  * Version: 2.0.0
  * Status: active
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-05-09
  * Description: This value set includes the codes indicating the contractual relationship between a provider and pa…
* Identity: [benefit-term](ValueSet-benefit-term.md)
  * Name: Benefit Term Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set includes a smattering of Benefit Term codes.
* Identity: [benefit-type](ValueSet-benefit-type.md)
  * Name: Benefit Type Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set includes a smattering of Benefit type codes.
* Identity: [benefit-unit](ValueSet-benefit-unit.md)
  * Name: Unit Type Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set includes a smattering of Unit type codes.
* Identity: [care-service-access…](ValueSet-care-service-accessibility.md)
  * Name: Care Service Accessibility
  * Version: 1.0.0
  * Status: active
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: This value set defines a set of codes that can be used to describe care service accessibility optio…
* Identity: [catalogType](ValueSet-catalogType.md)
  * Name: CatalogType
  * Version: 1.0.1
  * Status: active
  * Owner: [sd](http://www.hl7.org/Special/committees/structure)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The type of catalog.
* Identity: [certainty-rating](ValueSet-certainty-rating.md)
  * Name: StatisticCertaintyRating
  * Version: 1.0.0
  * Status: draft
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: The relative quality of the statistic.
* Identity: [certainty-subcompon…](ValueSet-certainty-subcomponent-rating.md)
  * Name: StatisticCertaintySubcomponentRating
  * Version: 1.0.0
  * Status: draft
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: The quality rating of the subcomponent of a quality of evidence rating.
* Identity: [certainty-subcompon…](ValueSet-certainty-subcomponent-type.md)
  * Name: StatisticCertaintySubcomponentType
  * Version: 1.0.0
  * Status: draft
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: The subcomponent classification of quality of evidence rating systems.
* Identity: [certainty-type](ValueSet-certainty-type.md)
  * Name: Evidence Certainty Type
  * Version: 1.0.0
  * Status: trial-use
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: The aspect of quality, confidence, or certainty.
* Identity: [characteristic-meth…](ValueSet-characteristic-method.md)
  * Name: CharacteristicMethod
  * Version: 1.0.0
  * Status: draft
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: The method used to determine the characteristic(s) of the variable.
* Identity: [chargeitem-billingc…](ValueSet-chargeitem-billingcodes.md)
  * Name: ChargeItemCode
  * Version: 1.0.1
  * Status: active
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Example set of codes that can be used for billing purposes.
* Identity: [choice-list-orienta…](ValueSet-choice-list-orientation.md)
  * Name: ChoiceListOrientation
  * Version: 1.0.0
  * Status: draft
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: Direction in which lists of possible answers should be displayed.
* Identity: [chromosome-human](ValueSet-chromosome-human.md)
  * Name: chromosome-human
  * Version: 1.0.0
  * Status: draft
  * Owner: [cg](http://www.hl7.org/Special/committees/clingenomics)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: Chromosome number for human.
* Identity: [citation-artifact-c…](ValueSet-citation-artifact-classifier.md)
  * Name: Citation Artifact Classifier
  * Version: 1.0.0
  * Status: trial-use
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: Citation artifact classifier
* Identity: [citation-classifica…](ValueSet-citation-classification-type.md)
  * Name: Citation Classification Type
  * Version: 1.0.0
  * Status: trial-use
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: Citation classification type
* Identity: [citation-summary-st…](ValueSet-citation-summary-style.md)
  * Name: Citation Summary Style
  * Version: 1.0.0
  * Status: trial-use
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: The format for display of the citation.
* Identity: [cited-artifact-abst…](ValueSet-cited-artifact-abstract-type.md)
  * Name: Cited Artifact Abstract Type
  * Version: 1.0.0
  * Status: trial-use
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: Used to express the reason and specific aspect for the variant abstract, such as language and speci…
* Identity: [cited-artifact-clas…](ValueSet-cited-artifact-classification-type.md)
  * Name: Cited Artifact Classification Type
  * Version: 1.0.0
  * Status: trial-use
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: Cited Artifact Classification Type
* Identity: [cited-artifact-cont…](ValueSet-cited-artifact-contribution-type.md)
  * Name: Cited Artifact Contribution Type
  * Version: 1.0.0
  * Status: trial-use
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: Citation contribution.
* Identity: [cited-artifact-part…](ValueSet-cited-artifact-part-type.md)
  * Name: Cited Artifact Part Type
  * Version: 1.0.0
  * Status: trial-use
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: To describe the reason for the variant citation, such as version number or subpart specification.
* Identity: [cited-artifact-stat…](ValueSet-cited-artifact-status-type.md)
  * Name: Cited Artifact Status Type
  * Version: 1.0.0
  * Status: trial-use
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: Cited Artifact Status Type
* Identity: [cited-medium](ValueSet-cited-medium.md)
  * Name: Cited Medium
  * Version: 1.0.0
  * Status: trial-use
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: NLM codes Internet or Print.
* Identity: [claim-careteamrole](ValueSet-claim-careteamrole.md)
  * Name: Claim Care Team Role Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Claim roles of the care team members providing products and services.
* Identity: [claim-exception](ValueSet-claim-exception.md)
  * Name: Exception Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set includes sample Exception codes.
* Identity: [claim-informationca…](ValueSet-claim-informationcategory.md)
  * Name: Claim Information Category Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set includes sample Information Category codes.
* Identity: [claim-modifiers](ValueSet-claim-modifiers.md)
  * Name: Modifier type Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set includes sample Modifier type codes.
* Identity: [claim-subtype](ValueSet-claim-subtype.md)
  * Name: Example Claim SubType Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set includes sample Claim SubType codes which are used to distinguish the claim types fo…
* Identity: [claim-type](ValueSet-claim-type.md)
  * Name: Claim Type Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set includes Claim Type codes.
* Identity: [clinical-discharge-…](ValueSet-clinical-discharge-disposition.md)
  * Name: Clinical Discharge Disposition
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2022-07-04
  * Description: This value set defines a set of codes that can be used to where the patient left the hospital. Note…
* Identity: [codesystem-altcode-…](ValueSet-codesystem-altcode-kind.md)
  * Name: AlternativeCodeKind
  * Version: 1.0.0
  * Status: draft
  * Owner: [vocab](http://www.hl7.org/Special/committees/Vocab)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: Indicates the type of use for which the code is defined.
* Identity: [common-tags](ValueSet-common-tags.md)
  * Name: Common Tags
  * Version: 1.0.1
  * Status: active
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Common Tag Codes defined by FHIR project
* Identity: [communication-categ…](ValueSet-communication-category.md)
  * Name: CommunicationCategory
  * Version: 1.0.1
  * Status: active
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Codes for general categories of communications such as alerts, instructions, etc.
* Identity: [communication-not-d…](ValueSet-communication-not-done-reason.md)
  * Name: CommunicationNotDoneReason
  * Version: 1.0.1
  * Status: active
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Codes for the reason why a communication did not happen.
* Identity: [communication-topic](ValueSet-communication-topic.md)
  * Name: CommunicationTopic
  * Version: 1.0.1
  * Status: active
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Codes describing the purpose or content of the communication.
* Identity: [composite-measure-s…](ValueSet-composite-measure-scoring.md)
  * Name: CompositeMeasureScoring
  * Version: 1.0.1
  * Status: active
  * Owner: [cqi](http://www.hl7.org/Special/committees/cqi)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The composite scoring method of the measure.
* Identity: [composition-altcode…](ValueSet-composition-altcode-kind.md)
  * Name: AlternativeCodeKind
  * Version: 1.0.0
  * Status: draft
  * Owner: [sd](http://www.hl7.org/Special/committees/structure)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: Indicates the type of use for which the code is defined.
* Identity: [condition-category](ValueSet-condition-category.md)
  * Name: Condition Category Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Preferred value set for Condition Categories.
* Identity: [condition-clinical](ValueSet-condition-clinical.md)
  * Name: Condition Clinical Status Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Preferred value set for Condition Clinical Status.
* Identity: [condition-state](ValueSet-condition-state.md)
  * Name: ConditionState
  * Version: 1.0.0
  * Status: draft
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: Enumeration indicating whether the condition is currently active, inactive, or has been resolved.
* Identity: [condition-ver-status](ValueSet-condition-ver-status.md)
  * Name: ConditionVerificationStatus
  * Version: 1.0.1
  * Status: active
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The verification status to support or decline the clinical status of the condition or diagnosis.
* Identity: [conformance-expecta…](ValueSet-conformance-expectation.md)
  * Name: ConformanceExpectation
  * Version: 1.0.0
  * Status: draft
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: Indicates the degree of adherence to a specified behavior or capability expected for a system to be…
* Identity: [consent-action](ValueSet-consent-action.md)
  * Name: Consent Action Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [cbcc](http://www.hl7.org/Special/committees/cbcc)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set includes sample Consent Action codes.
* Identity: [consent-policy](ValueSet-consent-policy.md)
  * Name: Consent PolicyRule Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [cbcc](http://www.hl7.org/Special/committees/cbcc)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set includes sample Regulatory consent policy types from the US and other regions.
* Identity: [consent-scope](ValueSet-consent-scope.md)
  * Name: Consent Scope Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [cbcc](http://www.hl7.org/Special/committees/cbcc)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set includes the four Consent scope codes.
* Identity: [consent-verification](ValueSet-consent-verification.md)
  * Name: Consent Verification Codes
  * Version: 2.0.1
  * Status: active
  * Owner: [cbcc](http://www.hl7.org/Special/committees/cbcc)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set includes base Consent Verification codes.
* Identity: [contactentity-type](ValueSet-contactentity-type.md)
  * Name: Contact entity type
  * Version: 1.0.0
  * Status: draft
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: This example value set defines a set of codes that can be used to indicate the purpose for which yo…
* Identity: [container-cap](ValueSet-container-cap.md)
  * Name: ContainerCap
  * Version: 1.0.1
  * Status: active
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Color of the container cap.
* Identity: [contract-action](ValueSet-contract-action.md)
  * Name: Contract Action Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set includes sample Contract Action codes.
* Identity: [contract-actorrole](ValueSet-contract-actorrole.md)
  * Name: Contract Actor Role Codes
  * Version: 1.0.2
  * Status: active
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set includes sample Contract Actor Role codes.
* Identity: [contract-content-de…](ValueSet-contract-content-derivative.md)
  * Name: Contract Content Derivation Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This is an example set of Content Derivative type codes, which represent the minimal content derive…
* Identity: [contract-data-meani…](ValueSet-contract-data-meaning.md)
  * Name: ContractDataMeaning
  * Version: 1.0.0
  * Status: draft
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: How a resource reference is interpreted when evaluating contract offers.
* Identity: [contract-signer-type](ValueSet-contract-signer-type.md)
  * Name: Contract Signer Type Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set includes sample Contract Signer Type codes.
* Identity: [contract-subtype](ValueSet-contract-subtype.md)
  * Name: Contract Subtype Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set includes sample Contract Subtype codes.
* Identity: [contract-term-subty…](ValueSet-contract-term-subtype.md)
  * Name: Contract Term Subtype Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set includes sample Contract Term SubType codes.
* Identity: [contract-term-type](ValueSet-contract-term-type.md)
  * Name: Contract Term Type Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set includes sample Contract Term Type codes.
* Identity: [contract-type](ValueSet-contract-type.md)
  * Name: Contract Type Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set includes sample Contract Type codes.
* Identity: [contributor-role](ValueSet-contributor-role.md)
  * Name: Contributor Role
  * Version: 1.0.0
  * Status: trial-use
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: Used to code the format of the display string.
* Identity: [contributor-summary…](ValueSet-contributor-summary-source.md)
  * Name: Contributor Summary Source
  * Version: 1.0.0
  * Status: trial-use
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: Used to code the producer or rule for creating the display string.
* Identity: [contributor-summary…](ValueSet-contributor-summary-style.md)
  * Name: Contributor Summary Style
  * Version: 1.0.0
  * Status: trial-use
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: Used to code the format of the display string.
* Identity: [contributor-summary…](ValueSet-contributor-summary-type.md)
  * Name: Contributor Summary Type
  * Version: 1.0.0
  * Status: trial-use
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: Used to code author list statement, contributorship statement, and such.
* Identity: [copy-number-event](ValueSet-copy-number-event.md)
  * Name: CopyNumberEvent
  * Version: 1.0.0
  * Status: draft
  * Owner: [cg](http://www.hl7.org/Special/committees/clingenomics)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: Copy Number Event.
* Identity: [coverage-class](ValueSet-coverage-class.md)
  * Name: Coverage Class Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set includes Coverage Class codes.
* Identity: [coverage-copay-type](ValueSet-coverage-copay-type.md)
  * Name: Coverage Copay Type Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set includes sample Coverage Copayment Type codes.
* Identity: [coverage-financial-…](ValueSet-coverage-financial-exception.md)
  * Name: Example Coverage Financial Exception Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set includes Example Coverage Financial Exception Codes.
* Identity: [coverage-selfpay](ValueSet-coverage-selfpay.md)
  * Name: Coverage SelfPay Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set includes Coverage SelfPay codes.
* Identity: [coverageeligibility…](ValueSet-coverageeligibilityresponse-ex-auth-support.md)
  * Name: CoverageEligibilityResponse Auth Support Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set includes CoverageEligibilityResponse Auth Support codes.
* Identity: [cpt-all](ValueSet-cpt-all.md)
  * Name: AMA CPT All Codes
  * Version: 1.0.0
  * Status: active
  * Owner: [vocab](http://www.hl7.org/Special/committees/Vocab)
  * Copyright: other
  * Date: 2023-08-05
  * Description: All codes in CPT (including metadata, modifiers, etc).
* Identity: [cpt-base](ValueSet-cpt-base.md)
  * Name: AMA CPT Base Codes
  * Version: 1.0.0
  * Status: active
  * Owner: [vocab](http://www.hl7.org/Special/committees/Vocab)
  * Copyright: other
  * Date: 2023-08-05
  * Description: All codes in CPT that represent procedure codes (no modifiers allowed - e.g. for Claim.item.product…
* Identity: [cpt-modifiers](ValueSet-cpt-modifiers.md)
  * Name: AMA CPT Modifier Codes
  * Version: 1.0.0
  * Status: active
  * Owner: [vocab](http://www.hl7.org/Special/committees/Vocab)
  * Copyright: other
  * Date: 2023-08-05
  * Description: CPT modifiers (e.g. for Claim.item.modifier)
* Identity: [cpt-usable](ValueSet-cpt-usable.md)
  * Name: AMA CPT Usable Codes
  * Version: 1.0.0
  * Status: active
  * Owner: [vocab](http://www.hl7.org/Special/committees/Vocab)
  * Copyright: other
  * Date: 2023-08-05
  * Description: All CPT codes (no modifiers) that represent procedure codes (e.g. for Procedure.code).
* Identity: [definition-status](ValueSet-definition-status.md)
  * Name: DefinitionStatus
  * Version: 1.0.0
  * Status: draft
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: Codes identifying the lifecycle stage of a definition.
* Identity: [definition-topic](ValueSet-definition-topic.md)
  * Name: DefinitionTopic
  * Version: 1.0.1
  * Status: active
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: High-level categorization of the definition, used for searching, sorting, and filtering.
* Identity: [definition-use](ValueSet-definition-use.md)
  * Name: Structure Definition Use Codes / Keywords
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: Structure Definition Use Codes / Keywords
* Identity: [device-kind](ValueSet-device-kind.md)
  * Name: FHIR Device Types
  * Version: 1.0.1
  * Status: active
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Codes used to identify medical devices. Includes concepts from SNOMED CT (http://www.snomed.org/) …
* Identity: [device-status-reason](ValueSet-device-status-reason.md)
  * Name: FHIRDeviceStatusReason
  * Version: 1.0.0
  * Status: draft
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: The availability status reason of the device.
* Identity: [devicealert-activat…](ValueSet-devicealert-activationState.md)
  * Name: DeviceAlert Activation State Codes
  * Version: 1.0.0
  * Status: draft
  * Owner: [dev](http://www.hl7.org/Special/committees/healthcaredevices)
  * Copyright: n/a
  * Date: 2025-11-12
  * Description: DeviceAlert Activation State Codes
* Identity: [devicealert-conditi…](ValueSet-devicealert-condition.md)
  * Name: DeviceAlert Condition Codes
  * Version: 1.0.0
  * Status: draft
  * Owner: [dev](http://www.hl7.org/Special/committees/healthcaredevices)
  * Copyright: n/a
  * Date: 2025-11-12
  * Description: DeviceAlert Condition Codes
* Identity: [devicealert-priority](ValueSet-devicealert-priority.md)
  * Name: DeviceAlert Priority Codes
  * Version: 1.0.0
  * Status: draft
  * Owner: [dev](http://www.hl7.org/Special/committees/healthcaredevices)
  * Copyright: n/a
  * Date: 2025-11-12
  * Description: DeviceAlert Priority Codes
* Identity: [diagnosis-role](ValueSet-diagnosis-role.md)
  * Name: DiagnosisRole
  * Version: 1.0.1
  * Status: active
  * Owner: [vocab](http://www.hl7.org/Special/committees/Vocab)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set defines a set of codes that can be used to express the role of a diagnosis on the En…
* Identity: [diagnosistype](ValueSet-diagnosistype.md)
  * Name: Diagnosis Type Codes
  * Version: 1.0.0
  * Status: active
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-05-25
  * Description: This value set includes Diagnosis Type codes.
* Identity: [directness](ValueSet-directness.md)
  * Name: EvidenceDirectness
  * Version: 1.0.0
  * Status: draft
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: The quality of how direct the match is.
* Identity: [dose-rate-type](ValueSet-dose-rate-type.md)
  * Name: DoseAndRateType
  * Version: 1.0.0
  * Status: draft
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: The kind of dose or rate specified.
* Identity: [edible-substance-ty…](ValueSet-edible-substance-type.md)
  * Name: Types of Edible Substances
  * Version: 1.0.0
  * Status: active
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: SCT,THO
  * Date: 2025-11-12
  * Description: This value set represents codes for types of edible substances and is provided as a suggestive exam…
* Identity: [encounter-admit-sou…](ValueSet-encounter-admit-source.md)
  * Name: Admit source
  * Version: 1.0.1
  * Status: active
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set defines a set of codes that can be used to indicate from where the patient came in.
* Identity: [encounter-class](ValueSet-encounter-class.md)
  * Name: Encounter class
  * Version: 2.0.1
  * Status: active
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set defines a set of codes that can be used to indicate the class of encounter: a specif…
* Identity: [encounter-diet](ValueSet-encounter-diet.md)
  * Name: Diet
  * Version: 1.0.1
  * Status: active
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set defines a set of codes that can be used to indicate dietary preferences or restricti…
* Identity: [encounter-discharge…](ValueSet-encounter-discharge-disposition.md)
  * Name: Discharge disposition
  * Version: 1.0.1
  * Status: active
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set defines a set of codes that can be used to where the patient left the hospital.
* Identity: [encounter-special-a…](ValueSet-encounter-special-arrangements.md)
  * Name: Special arrangements
  * Version: 1.0.1
  * Status: active
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set defines a set of codes that can be used to indicate the kinds of special arrangement…
* Identity: [encounter-subject-s…](ValueSet-encounter-subject-status.md)
  * Name: Encounter subject status
  * Version: 1.0.1
  * Status: active
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This example value set defines a set of codes that can be used to indicate the status of the subjec…
* Identity: [encounter-type](ValueSet-encounter-type.md)
  * Name: Encounter type
  * Version: 1.0.1
  * Status: active
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This example value set defines a set of codes that can be used to indicate the type of encounter: a…
* Identity: [endpoint-connection…](ValueSet-endpoint-connection-type.md)
  * Name: Endpoint Connection Type
  * Version: 1.0.1
  * Status: active
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This is an example value set defined by the FHIR project, that could be used to represent possible …
* Identity: [entformula-additive](ValueSet-entformula-additive.md)
  * Name: Enteral Formula Additive Type Code
  * Version: 1.0.1
  * Status: active
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: EnteralFormulaAdditiveType: Codes for the type of modular component such as protein, carbohydrate o…
* Identity: [episodeofcare-type](ValueSet-episodeofcare-type.md)
  * Name: Episode of care type
  * Version: 1.0.1
  * Status: active
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This example value set defines a set of codes that can be used to express the usage type of an Epis…
* Identity: [evidence-quality](ValueSet-evidence-quality.md)
  * Name: QualityOfEvidenceRating
  * Version: 1.0.1
  * Status: active
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: A rating system that describes the quality of evidence such as the GRADE, DynaMed, or Oxford CEBM s…
* Identity: [ex-benefitcategory](ValueSet-ex-benefitcategory.md)
  * Name: Benefit Category Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set includes examples of Benefit Category codes.
* Identity: [ex-diagnosis-on-adm…](ValueSet-ex-diagnosis-on-admission.md)
  * Name: Example Diagnosis on Admission Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set includes example Diagnosis on Admission codes.
* Identity: [ex-diagnosisrelated…](ValueSet-ex-diagnosisrelatedgroup.md)
  * Name: Example Diagnosis Related Group Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set includes example Diagnosis Related Group codes.
* Identity: [ex-diagnosistype](ValueSet-ex-diagnosistype.md)
  * Name: Example Diagnosis Type Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set includes example Diagnosis Type codes.
* Identity: [ex-payee-resource-t…](ValueSet-ex-payee-resource-type.md)
  * Name: ClaimPayeeResourceType
  * Version: 1.0.0
  * Status: draft
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: The type of Claim payee Resource.
* Identity: [ex-paymenttype](ValueSet-ex-paymenttype.md)
  * Name: Example Payment Type Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set includes example Payment Type codes.
* Identity: [ex-procedure-type](ValueSet-ex-procedure-type.md)
  * Name: Example Procedure Type Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set includes example Procedure Type codes.
* Identity: [ex-program-code](ValueSet-ex-program-code.md)
  * Name: Example Program Reason Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set includes sample Program Reason Span codes.
* Identity: [ex-revenue-center](ValueSet-ex-revenue-center.md)
  * Name: Example Revenue Center Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set includes sample Revenue Center codes.
* Identity: [expansion-parameter…](ValueSet-expansion-parameter-source.md)
  * Name: ExpansionParameterSource
  * Version: 1.0.0
  * Status: draft
  * Owner: [vocab](http://www.hl7.org/Special/committees/Vocab)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: Declares what the source of a parameter is.
* Identity: [expansion-processin…](ValueSet-expansion-processing-rule.md)
  * Name: ExpansionProcessingRule
  * Version: 1.0.0
  * Status: draft
  * Owner: [vocab](http://www.hl7.org/Special/committees/Vocab)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: Defines how concepts are processed into the expansion when it's for UI presentation.
* Identity: [financial-taskcode](ValueSet-financial-taskcode.md)
  * Name: Financial Task Codes
  * Version: 1.0.0
  * Status: draft
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: This value set includes Financial Task codes.
* Identity: [financial-taskinput…](ValueSet-financial-taskinputtype.md)
  * Name: Financial Task Input Type Codes
  * Version: 1.0.0
  * Status: draft
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: This value set includes Financial Task Input Type codes.
* Identity: [flag-category](ValueSet-flag-category.md)
  * Name: Flag Category
  * Version: 1.0.1
  * Status: active
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Example list of general categories for flagged issues. (Not complete or necessarily appropriate.)
* Identity: [forms](ValueSet-forms.md)
  * Name: Forms
  * Version: 1.0.1
  * Status: active
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set includes a sample set of Forms codes.
* Identity: [fundsreserve](ValueSet-fundsreserve.md)
  * Name: Funds Reservation Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set includes sample funds reservation type codes.
* Identity: [gender-identity](ValueSet-gender-identity.md)
  * Name: Gender Identity
  * Version: 2.0.0
  * Status: active
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: Codes that indicate a individual's gender identity. This value set is a minimum set of commonly use…
* Identity: [goal-acceptance-sta…](ValueSet-goal-acceptance-status.md)
  * Name: GoalAcceptanceStatus
  * Version: 1.0.0
  * Status: draft
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: Codes indicating whether the goal has been accepted by a stakeholder.
* Identity: [goal-achievement](ValueSet-goal-achievement.md)
  * Name: Goal achievement status
  * Version: 1.0.1
  * Status: active
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Describes the progression, or lack thereof, towards the goal against the target.
* Identity: [goal-category](ValueSet-goal-category.md)
  * Name: Goal category
  * Version: 1.0.1
  * Status: active
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Example codes for grouping goals to use for filtering or presentation.
* Identity: [goal-priority](ValueSet-goal-priority.md)
  * Name: Goal priority
  * Version: 1.0.1
  * Status: active
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Indicates the level of importance associated with reaching or sustaining a goal.
* Identity: [goal-relationship-t…](ValueSet-goal-relationship-type.md)
  * Name: GoalRelationshipType
  * Version: 1.0.0
  * Status: draft
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: Types of relationships between two goals.
* Identity: [guide-parameter-code](ValueSet-guide-parameter-code.md)
  * Name: GuideParameterCode
  * Version: 1.0.0
  * Status: draft
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: Code of parameter that is input to the guide.
* Identity: [handling-condition](ValueSet-handling-condition.md)
  * Name: HandlingConditionSet
  * Version: 1.0.1
  * Status: active
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Set of handling instructions prior testing of the specimen.
* Identity: [history-absent-reas…](ValueSet-history-absent-reason.md)
  * Name: FamilyHistoryAbsentReason
  * Version: 1.0.1
  * Status: active
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Codes describing the reason why a family member's history is not available.
* Identity: [hl7-work-group](ValueSet-hl7-work-group.md)
  * Name: HL7Workgroup
  * Version: 1.0.1
  * Status: active
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: An HL7 administrative unit that owns artifacts in the FHIR specification.
* Identity: [immunization-evalua…](ValueSet-immunization-evaluation-dose-status.md)
  * Name: Immunization Evaluation Dose Status codes
  * Version: 1.0.1
  * Status: active
  * Owner: [pher](http://www.hl7.org/Special/committees/pher)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The value set to instantiate this attribute should be drawn from a terminologically robust code sys…
* Identity: [immunization-evalua…](ValueSet-immunization-evaluation-dose-status-reason.md)
  * Name: Immunization Evaluation Dose Status Reason codes
  * Version: 1.0.1
  * Status: active
  * Owner: [pher](http://www.hl7.org/Special/committees/pher)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The value set to instantiate this attribute should be drawn from a terminologically robust code sys…
* Identity: [immunization-fundin…](ValueSet-immunization-funding-source.md)
  * Name: Immunization Funding Source
  * Version: 1.0.1
  * Status: active
  * Owner: [pher](http://www.hl7.org/Special/committees/pher)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The value set to instantiate this attribute should be drawn from a terminologically robust code sys…
* Identity: [immunization-progra…](ValueSet-immunization-program-eligibility.md)
  * Name: Immunization Program Eligibility
  * Version: 1.0.1
  * Status: active
  * Owner: [pher](http://www.hl7.org/Special/committees/pher)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The value set to instantiate this attribute should be drawn from a terminologically robust code sys…
* Identity: [immunization-recomm…](ValueSet-immunization-recommendation-status.md)
  * Name: Immunization Recommendation Status Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [pher](http://www.hl7.org/Special/committees/pher)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The value set to instantiate this attribute should be drawn from a terminologically robust code sys…
* Identity: [immunization-subpot…](ValueSet-immunization-subpotent-reason.md)
  * Name: Immunization Subpotent Reason
  * Version: 1.0.1
  * Status: active
  * Owner: [pher](http://www.hl7.org/Special/committees/pher)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The value set to instantiate this attribute should be drawn from a terminologically robust code sys…
* Identity: [implantStatus](ValueSet-implantStatus.md)
  * Name: Implant Status
  * Version: 1.0.0
  * Status: draft
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: A set codes that define the functional status of an implanted device.
* Identity: [insurance-coverage-…](ValueSet-insurance-coverage-type.md)
  * Name: Insurance Coverage Type
  * Version: 1.0.0
  * Status: active
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: This value set defines a set of codes for Insurance Coverage Type
* Identity: [insurance-product-t…](ValueSet-insurance-product-type.md)
  * Name: Insurance Product Type
  * Version: 1.0.0
  * Status: active
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: This value set defines a set of codes for Insurance Product Type
* Identity: [insuranceplan-appli…](ValueSet-insuranceplan-applicability.md)
  * Name: Benefit cost applicability
  * Version: 1.0.1
  * Status: active
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Whether the cost applies to in-network or out-of-network providers.
* Identity: [insuranceplan-plan-…](ValueSet-insuranceplan-plan-type.md)
  * Name: Insuranceplan Plan Type
  * Version: 1.0.0
  * Status: active
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: This value set defines a set of codes for Insuranceplan Plan Type
* Identity: [insuranceplan-type](ValueSet-insuranceplan-type.md)
  * Name: Insurance plan type
  * Version: 1.0.1
  * Status: active
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This example value set defines a set of codes that can be used to indicate a type of insurance plan.
* Identity: [jurisdiction](ValueSet-jurisdiction.md)
  * Name: Jurisdiction ValueSet
  * Version: 1.0.0
  * Status: active
  * Owner: [vocab](http://www.hl7.org/Special/committees/Vocab)
  * Copyright: THO
  * Date: 2024-02-20
  * Description: This value set defines a base set of codes for country, country subdivision and region for indic…
* Identity: [library-type](ValueSet-library-type.md)
  * Name: LibraryType
  * Version: 1.0.1
  * Status: active
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The type of knowledge asset this library contains.
* Identity: [list-empty-reason](ValueSet-list-empty-reason.md)
  * Name: List Empty Reasons
  * Version: 1.0.1
  * Status: active
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: General reasons for a list to be empty. Reasons are either related to a summary list (i.e. problem …
* Identity: [list-example-codes](ValueSet-list-example-codes.md)
  * Name: Example Use Codes for List
  * Version: 1.0.1
  * Status: active
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Example use codes for the List resource - typical kinds of use.
* Identity: [list-order](ValueSet-list-order.md)
  * Name: List Order Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Base values for the order of the items in a list resource.
* Identity: [location-physical-t…](ValueSet-location-physical-type.md)
  * Name: Location type
  * Version: 1.0.1
  * Status: active
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This example value set defines a set of codes that can be used to indicate the physical form of the…
* Identity: [match-grade](ValueSet-match-grade.md)
  * Name: MatchGrade
  * Version: 1.0.0
  * Status: draft
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: A Master Patient Index (MPI) assessment of whether a candidate patient record is a match or not.
* Identity: [measure-data-usage](ValueSet-measure-data-usage.md)
  * Name: MeasureDataUsage
  * Version: 1.0.1
  * Status: active
  * Owner: [cqi](http://www.hl7.org/Special/committees/cqi)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The intended usage for supplemental data elements in the measure.
* Identity: [measure-improvement…](ValueSet-measure-improvement-notation.md)
  * Name: MeasureImprovementNotation
  * Version: 1.0.1
  * Status: active
  * Owner: [cqi](http://www.hl7.org/Special/committees/cqi)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Observation values that indicate what change in a measurement value or score is indicative of an im…
* Identity: [measure-population](ValueSet-measure-population.md)
  * Name: MeasurePopulationType
  * Version: 2.0.0
  * Status: active
  * Owner: [cqi](http://www.hl7.org/Special/committees/cqi)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The type of population.
* Identity: [measure-scoring](ValueSet-measure-scoring.md)
  * Name: Measure Scoring
  * Version: 2.0.0
  * Status: active
  * Owner: [cqi](http://www.hl7.org/Special/committees/cqi)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The scoring type of the measure.
* Identity: [measure-type](ValueSet-measure-type.md)
  * Name: MeasureType
  * Version: 1.0.1
  * Status: active
  * Owner: [cqi](http://www.hl7.org/Special/committees/cqi)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The type of measure (includes codes from 2.16.840.1.113883.1.11.20368).
* Identity: [med-admin-perform-f…](ValueSet-med-admin-perform-function.md)
  * Name: Medication administration performer function codes
  * Version: 1.0.1
  * Status: active
  * Owner: [phx](http://www.hl7.org/Special/committees/medication)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: MedicationAdministration Performer Function Codes
* Identity: [medical-management-…](ValueSet-medical-management-type.md)
  * Name: Medical Management Type
  * Version: 1.0.0
  * Status: active
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-05-26
  * Description: This value set includes types of medical management requirements or processes used by health insure…
* Identity: [medicationdispense-…](ValueSet-medicationdispense-performer-function.md)
  * Name: Medication dispense performer function codes
  * Version: 1.0.1
  * Status: active
  * Owner: [phx](http://www.hl7.org/Special/committees/medication)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: MedicationDispense Performer Function Codes
* Identity: [medicationknowledge…](ValueSet-medicationknowledge-characteristic.md)
  * Name: Medication knowledge characteristic codes
  * Version: 1.0.1
  * Status: active
  * Owner: [phx](http://www.hl7.org/Special/committees/medication)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: MedicationKnowledge Characteristic Codes
* Identity: [medicationknowledge…](ValueSet-medicationknowledge-package-type.md)
  * Name: Medication knowledge package type codes
  * Version: 1.0.0
  * Status: draft
  * Owner: [phx](http://www.hl7.org/Special/committees/medication)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: MedicationKnowledge Package Type Codes
* Identity: [medicationknowledge…](ValueSet-medicationknowledge-status.md)
  * Name: Medication knowledge status codes
  * Version: 1.0.0
  * Status: draft
  * Owner: [phx](http://www.hl7.org/Special/committees/medication)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: MedicationKnowledge Status Codes
* Identity: [medicationrequest-c…](ValueSet-medicationrequest-category.md)
  * Name: Medication request category codes
  * Version: 1.0.0
  * Status: draft
  * Owner: [phx](http://www.hl7.org/Special/committees/medication)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: MedicationRequest Category Codes
* Identity: [medicationrequest-c…](ValueSet-medicationrequest-course-of-therapy.md)
  * Name: Medication request course of therapy codes
  * Version: 1.0.1
  * Status: active
  * Owner: [phx](http://www.hl7.org/Special/committees/medication)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: MedicationRequest Course of Therapy Codes
* Identity: [medicationrequest-s…](ValueSet-medicationrequest-status-reason.md)
  * Name: Medication request status reason codes
  * Version: 1.0.1
  * Status: active
  * Owner: [phx](http://www.hl7.org/Special/committees/medication)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: MedicationRequest Status Reason Codes
* Identity: [message-reason-enco…](ValueSet-message-reason-encounter.md)
  * Name: Example Message Reason Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Example Message Reasons. These are the set of codes that might be used an updating an encounter usi…
* Identity: [missing-tooth-reason](ValueSet-missing-tooth-reason.md)
  * Name: Missing Tooth Reason Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set includes sample Missing Tooth Reason codes.
* Identity: [ndh-healthcare-serv…](ValueSet-ndh-healthcare-service-category.md)
  * Name: NDH Healthcare Service Category
  * Version: 1.0.0
  * Status: draft
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: This value set defines a set of codes for NDH Healthcare Service Category used in the National Dire…
* Identity: [nutrition-intake-ca…](ValueSet-nutrition-intake-category.md)
  * Name: Nutrition intake category codes
  * Version: 1.0.0
  * Status: draft
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: NutritionIntake Category Codes
* Identity: [object-role](ValueSet-object-role.md)
  * Name: AuditEventEntityRole
  * Version: 1.0.1
  * Status: active
  * Owner: [sec](http://www.hl7.org/Special/committees/secure)
  * Copyright: THO
  * Date: 2024-06-28
  * Description: Code representing the role the entity played in the audit event.
* Identity: [observation-category](ValueSet-observation-category.md)
  * Name: Observation Category Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Observation Category codes.
* Identity: [observation-statist…](ValueSet-observation-statistics.md)
  * Name: StatisticsCode
  * Version: 1.0.0
  * Status: draft
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: The statistical operation parameter -"statistic" codes.
* Identity: [organization-affili…](ValueSet-organization-affiliation-role.md)
  * Name: Organization Affiliation Role
  * Version: 1.0.0
  * Status: active
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: This value set defines a set of codes that can be used to indicate an organization affiliation role.
* Identity: [organization-alias-…](ValueSet-organization-alias-type.md)
  * Name: Organization Alias Type
  * Version: 1.0.0
  * Status: draft
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: This value set defines a set of codes for indicating oranization alias type.
* Identity: [organization-type](ValueSet-organization-type.md)
  * Name: Organization type
  * Version: 1.0.1
  * Status: active
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This example value set defines a set of codes that can be used to indicate a type of organization.
* Identity: [parameter-group](ValueSet-parameter-group.md)
  * Name: DeviceDefinitionParameterGroup
  * Version: 1.0.0
  * Status: draft
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: Codes identifying groupings of parameters; e.g. Cardiovascular.
* Identity: [payeetype](ValueSet-payeetype.md)
  * Name: Payee Type Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Codes indicating the type of party to be reimbursed for cost of the products and service.
* Identity: [payment-adjustment-…](ValueSet-payment-adjustment-reason.md)
  * Name: Payment Adjustment Reason Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set includes smattering of Payment Adjustment Reason codes.
* Identity: [payment-status](ValueSet-payment-status.md)
  * Name: Payment Status Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set includes a sample set of Payment Status codes.
* Identity: [payment-type](ValueSet-payment-type.md)
  * Name: Payment Type Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set includes sample Payment Type codes.
* Identity: [plan-definition-type](ValueSet-plan-definition-type.md)
  * Name: PlanDefinitionType
  * Version: 1.0.1
  * Status: active
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The type of PlanDefinition.
* Identity: [procedure-type](ValueSet-procedure-type.md)
  * Name: Procedure Type Codes
  * Version: 1.0.0
  * Status: active
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-05-21
  * Description: This value set includes Procedure Type codes.
* Identity: [process-priority](ValueSet-process-priority.md)
  * Name: Process Priority Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set includes the financial processing priority codes.
* Identity: [professional-creden…](ValueSet-professional-credential-status.md)
  * Name: rofessional Credential Status
  * Version: 1.0.0
  * Status: draft
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: This code system establishes a series of codes designed to represent the status of professional cre…
* Identity: [program](ValueSet-program.md)
  * Name: Program
  * Version: 1.0.1
  * Status: active
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set defines an example set of codes that could be can be used to classify groupings of s…
* Identity: [pronouns](ValueSet-pronouns.md)
  * Name: Personal Pronouns
  * Version: 2.0.0
  * Status: active
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: Codes that indicate the pronouns to be used when communicating with or about an individual.
* Identity: [provenance-agent-ty…](ValueSet-provenance-agent-type.md)
  * Name: Provenance participant type
  * Version: 1.0.1
  * Status: active
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2024-06-28
  * Description: The type of participation a provenance participant.
* Identity: [provider-qualificat…](ValueSet-provider-qualification.md)
  * Name: Example Provider Qualification Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set includes sample Provider Qualification codes.
* Identity: [published-in-type](ValueSet-published-in-type.md)
  * Name: Published In Type
  * Version: 1.0.0
  * Status: trial-use
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: The type of publication such as book, database, or journal.
* Identity: [question-max-occurs](ValueSet-question-max-occurs.md)
  * Name: MaxOccurs
  * Version: 1.0.0
  * Status: draft
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: Flags an element as having unlimited repetitions.
* Identity: [questionnaire-usage…](ValueSet-questionnaire-usage-mode.md)
  * Name: QuestionnaireItemUsageMode
  * Version: 1.0.0
  * Status: draft
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: Identifies the modes of usage of a questionnaire that should enable a particular questionnaire item.
* Identity: [reaction-event-cert…](ValueSet-reaction-event-certainty.md)
  * Name: AllergyIntoleranceCertainty
  * Version: 1.0.0
  * Status: draft
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: Statement about the degree of clinical certainty that a specific substance was the cause of the man…
* Identity: [reason-medication-g…](ValueSet-reason-medication-given-codes.md)
  * Name: Reason Medication Given Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [phx](http://www.hl7.org/Special/committees/medication)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set is provided as an example. The value set to instantiate this attribute should be dra…
* Identity: [recommendation-stre…](ValueSet-recommendation-strength.md)
  * Name: StrengthOfRecommendationRating
  * Version: 1.0.1
  * Status: active
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: A rating system that describes the strength of the recommendation, such as the GRADE, DynaMed, or H…
* Identity: [recorded-sex-or-gen…](ValueSet-recorded-sex-or-gender-type.md)
  * Name: Recorded Sex Or Gender Type
  * Version: 2.0.0
  * Status: active
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: Codes that represent the type of the recorded sex and gender.
* Identity: [referencerange-mean…](ValueSet-referencerange-meaning.md)
  * Name: Observation Reference Range Meaning Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set defines a set of codes that can be used to indicate the meaning/use of a reference r…
* Identity: [rejection-criteria](ValueSet-rejection-criteria.md)
  * Name: RejectionCriterion
  * Version: 1.0.1
  * Status: active
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Criterion for rejection of the specimen by laboratory.
* Identity: [related-claim-relat…](ValueSet-related-claim-relationship.md)
  * Name: Example Related Claim Relationship Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set includes sample Related Claim Relationship codes.
* Identity: [research-study-obje…](ValueSet-research-study-objective-type.md)
  * Name: ResearchStudyObjectiveType
  * Version: 1.0.0
  * Status: draft
  * Owner: [brr](http://www.hl7.org/Special/committees/rcrim)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: Codes for the kind of study objective.
* Identity: [research-study-phase](ValueSet-research-study-phase.md)
  * Name: ResearchStudyPhase
  * Version: 1.0.0
  * Status: draft
  * Owner: [brr](http://www.hl7.org/Special/committees/rcrim)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: Codes for the stage in the progression of a therapy from initial experimental use in humans in clin…
* Identity: [research-study-prim…](ValueSet-research-study-prim-purp-type.md)
  * Name: ResearchStudyPrimaryPurposeType
  * Version: 1.0.0
  * Status: draft
  * Owner: [brr](http://www.hl7.org/Special/committees/rcrim)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: Codes for the main intent of the study.
* Identity: [research-study-reas…](ValueSet-research-study-reason-stopped.md)
  * Name: ResearchStudyReasonStopped
  * Version: 1.0.0
  * Status: draft
  * Owner: [brr](http://www.hl7.org/Special/committees/rcrim)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: Codes for why the study ended prematurely.
* Identity: [research-subject-mi…](ValueSet-research-subject-milestone.md)
  * Name: ResearchSubjectMilestone
  * Version: 1.0.1
  * Status: active
  * Owner: [brr](http://www.hl7.org/Special/committees/rcrim)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Indicates the progression of a study subject through the study milestones.
* Identity: [research-subject-st…](ValueSet-research-subject-state.md)
  * Name: ResearchSubjectState
  * Version: 1.0.1
  * Status: active
  * Owner: [brr](http://www.hl7.org/Special/committees/rcrim)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Indicates the progression of a study subject through a study.
* Identity: [research-subject-st…](ValueSet-research-subject-state-type.md)
  * Name: ResearchSubjectStateType
  * Version: 1.0.1
  * Status: active
  * Owner: [brr](http://www.hl7.org/Special/committees/rcrim)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Identifies the kind of state being refered to.
* Identity: [resource-security-c…](ValueSet-resource-security-category.md)
  * Name: ResourceSecurityCategory
  * Version: 1.0.0
  * Status: draft
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: Provides general guidance around the kind of access Control to Read, Search, Create, Update, or Del…
* Identity: [resource-type-link](ValueSet-resource-type-link.md)
  * Name: PayeeResourceType
  * Version: 1.0.0
  * Status: draft
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: The type of payee Resource.
* Identity: [risk-probability](ValueSet-risk-probability.md)
  * Name: Risk Probability
  * Version: 1.0.1
  * Status: active
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Codes representing the likelihood of a particular outcome in a risk assessment.
* Identity: [service-category](ValueSet-service-category.md)
  * Name: Service category
  * Version: 1.0.1
  * Status: active
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set defines an example set of codes that can be used to classify groupings of service-ty…
* Identity: [service-delivery-me…](ValueSet-service-delivery-method.md)
  * Name: Service Delivery Method
  * Version: 1.0.0
  * Status: active
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: This value set defines a set of codes that can be used to indicate service delivery method.
* Identity: [service-place](ValueSet-service-place.md)
  * Name: Example Service Place Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set includes a smattering of Service Place codes.
* Identity: [service-provision-c…](ValueSet-service-provision-conditions.md)
  * Name: ServiceProvisionConditions
  * Version: 1.0.1
  * Status: active
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The code(s) that detail the conditions under which the healthcare service is available/offered.
* Identity: [service-referral-me…](ValueSet-service-referral-method.md)
  * Name: ReferralMethod
  * Version: 1.0.1
  * Status: active
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The methods of referral can be used when referring to a specific HealthCareService resource.
* Identity: [service-type](ValueSet-service-type.md)
  * Name: Service type
  * Version: 1.0.1
  * Status: active
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set defines an example set of codes of service-types.
* Identity: [service-uscls](ValueSet-service-uscls.md)
  * Name: USCLS Codes
  * Version: 1.0.0
  * Status: draft
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: This value set includes a smattering of USCLS codes.
* Identity: [sex-parameter-for-c…](ValueSet-sex-parameter-for-clinical-use.md)
  * Name: Sex Parameter for Clinical Use
  * Version: 2.0.0
  * Status: active
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: A summary parameter that provides guidance on how a receiver should apply settings or reference ran…
* Identity: [smart-capabilities](ValueSet-smart-capabilities.md)
  * Name: SmartCapabilities
  * Version: 1.0.1
  * Status: active
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Codes that define what the server is capable of.
* Identity: [software-system-type](ValueSet-software-system-type.md)
  * Name: Software System Type
  * Version: 1.0.0
  * Status: trial-use
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: THO
  * Date: 2024-02-16
  * Description: Types of software systems that support knowledge artifact authoring and evaluation (authoring, test…
* Identity: [special-values](ValueSet-special-values.md)
  * Name: SpecialValues
  * Version: 1.0.0
  * Status: draft
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: A set of generally useful codes defined so they can be included in value sets.
* Identity: [standards-status](ValueSet-standards-status.md)
  * Name: StandardsStatus
  * Version: 1.0.0
  * Status: draft
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: HL7 Ballot/Standards status of artifact.
* Identity: [state-change-reason](ValueSet-state-change-reason.md)
  * Name: StateChangeReason
  * Version: 1.0.0
  * Status: draft
  * Owner: [brr](http://www.hl7.org/Special/committees/rcrim)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: Indicates why the state of the subject changed.
* Identity: [statistic-model-code](ValueSet-statistic-model-code.md)
  * Name: Statistic Model Code
  * Version: 1.0.0
  * Status: trial-use
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: The handling of the variable in statistical analysis for exposures or outcomes.
* Identity: [statistic-type](ValueSet-statistic-type.md)
  * Name: StatisticStatisticType
  * Version: 1.0.1
  * Status: active
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The type of a specific statistic.
* Identity: [study-type](ValueSet-study-type.md)
  * Name: StatisticStudyType
  * Version: 1.0.0
  * Status: draft
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: The type of study a statistic was derived from.
* Identity: [subscriber-relation…](ValueSet-subscriber-relationship.md)
  * Name: SubscriberPolicyholder Relationship Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set includes codes for the relationship between the Subscriber and the Beneficiary (insu…
* Identity: [subscription-channe…](ValueSet-subscription-channel-type.md)
  * Name: SubscriptionChannel Type Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Codes to represent subscription error details
* Identity: [subscription-error](ValueSet-subscription-error.md)
  * Name: Subscription Error Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Codes to represent subscription error details
* Identity: [subscription-status…](ValueSet-subscription-status-at-event.md)
  * Name: SubscriptionStatusAtEvent
  * Version: 1.0.0
  * Status: draft
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: A status code for the state of the Subscription.
* Identity: [subscription-tag](ValueSet-subscription-tag.md)
  * Name: SubscriptionTag
  * Version: 1.0.0
  * Status: draft
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: Tags to put on a resource after subscriptions have been sent.
* Identity: [substance-category](ValueSet-substance-category.md)
  * Name: Substance Category Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Substance category codes
* Identity: [supplydelivery-type](ValueSet-supplydelivery-type.md)
  * Name: Supply Item Type
  * Version: 1.0.0
  * Status: draft
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: This value sets refers to a specific supply item.
* Identity: [supplyrequest-kind](ValueSet-supplyrequest-kind.md)
  * Name: Supply Type
  * Version: 1.0.1
  * Status: active
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value sets refers to a Category of supply.
* Identity: [supplyrequest-reason](ValueSet-supplyrequest-reason.md)
  * Name: SupplyRequestReason
  * Version: 1.0.1
  * Status: active
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The reason why the supply item was requested.
* Identity: [surface](ValueSet-surface.md)
  * Name: Surface Codes
  * Version: 1.0.0
  * Status: draft
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: This value set includes a smattering of FDI tooth surface codes.
* Identity: [synthesis-type](ValueSet-synthesis-type.md)
  * Name: StatisticSynthesisType
  * Version: 1.0.0
  * Status: draft
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: Types of combining results from a body of evidence (eg. summary data meta-analysis).
* Identity: [testscript-operatio…](ValueSet-testscript-operation-codes.md)
  * Name: Test script operation code
  * Version: 1.0.0
  * Status: draft
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: This value set defines a set of codes that are used to indicate the supported operations of a testi…
* Identity: [testscript-profile-…](ValueSet-testscript-profile-destination-types.md)
  * Name: Test script profile destination type
  * Version: 1.0.1
  * Status: active
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set defines a set of codes that are used to indicate the profile type of a test system w…
* Identity: [testscript-profile-…](ValueSet-testscript-profile-origin-types.md)
  * Name: Test script profile origin type
  * Version: 1.0.1
  * Status: active
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set defines a set of codes that are used to indicate the profile type of a test system w…
* Identity: [title-type](ValueSet-title-type.md)
  * Name: Title Type
  * Version: 1.0.0
  * Status: trial-use
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: Used to express the reason and specific aspect for the variant title, such as language and specific…
* Identity: [tooth](ValueSet-tooth.md)
  * Name: Oral Site Codes
  * Version: 1.0.0
  * Status: draft
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: This value set includes a smattering of FDI oral site codes.
* Identity: [ucum-common](ValueSet-ucum-common.md)
  * Name: Common UCUM units
  * Version: 1.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: Commonly encountered UCUM units (for purposes of helping populate look ups).
* Identity: [ucum-units](ValueSet-ucum-units.md)
  * Name: UCUM Codes
  * Version: 1.0.0
  * Status: active
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2023-11-29
  * Description: Unified Code for Units of Measure (UCUM). This value set includes all UCUM codes
* Identity: [usage-context-type](ValueSet-usage-context-type.md)
  * Name: UsageContextType
  * Version: 1.0.1
  * Status: active
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: A code that specifies a type of context being specified by a usage context.
* Identity: [variable-role](ValueSet-variable-role.md)
  * Name: EvidenceVariableRole
  * Version: 1.0.1
  * Status: active
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The role that the assertion variable plays.
* Identity: [variable-role-subty…](ValueSet-variable-role-subtype.md)
  * Name: EvidenceVariableRoleSubtype
  * Version: 1.0.1
  * Status: active
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The subclassification of the role that the assertion variable plays.
* Identity: [variant-state](ValueSet-variant-state.md)
  * Name: sequenceStatus
  * Version: 1.0.0
  * Status: draft
  * Owner: [cg](http://www.hl7.org/Special/committees/clingenomics)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: Codes providing the status of the variant test result.
* Identity: [verificationresult-…](ValueSet-verificationresult-can-push-updates.md)
  * Name: Can-push-updates
  * Version: 1.0.1
  * Status: active
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Ability of the primary source to push updates/alerts
* Identity: [verificationresult-…](ValueSet-verificationresult-communication-method.md)
  * Name: VerificationResult Communication Method
  * Version: 1.0.0
  * Status: active
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2018-10-31
  * Description: Attested information may be validated by process that are manual or automated. For automated proces…
* Identity: [verificationresult-…](ValueSet-verificationresult-failure-action.md)
  * Name: Failure-action
  * Version: 1.0.1
  * Status: active
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The result if validation fails
* Identity: [verificationresult-…](ValueSet-verificationresult-need.md)
  * Name: Need
  * Version: 1.0.1
  * Status: active
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The frequency with which the target must be validated
* Identity: [verificationresult-…](ValueSet-verificationresult-primary-source-type.md)
  * Name: Primary-source-type
  * Version: 1.0.1
  * Status: active
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Type of the validation primary source
* Identity: [verificationresult-…](ValueSet-verificationresult-push-type-available.md)
  * Name: Push-type-available
  * Version: 1.0.1
  * Status: active
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Type of alerts/updates the primary source can send
* Identity: [verificationresult-…](ValueSet-verificationresult-validation-process.md)
  * Name: Validation-process
  * Version: 1.0.1
  * Status: active
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The primary process by which the target is validated
* Identity: [verificationresult-…](ValueSet-verificationresult-validation-status.md)
  * Name: Validation-status
  * Version: 1.0.1
  * Status: active
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Status of the validation of the target against the primary source
* Identity: [verificationresult-…](ValueSet-verificationresult-validation-type.md)
  * Name: Validation-type
  * Version: 1.0.1
  * Status: active
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: What the target is validated against
* Identity: [virtual-healthcare-…](ValueSet-virtual-healthcare-delivery-method.md)
  * Name: Virtual Healthcare Delivery Method
  * Version: 1.0.0
  * Status: draft
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2020-02-24
  * Description: This value set defines a set of codes for virtual healthcare service delivery method.
* Identity: [vision-product](ValueSet-vision-product.md)
  * Name: Example Vision Prescription Product Codes
  * Version: 1.0.1
  * Status: active
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This value set includes a smattering of Prescription Product codes.

Showing 276 of 276 entries

