# CDA Value Sets - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Value Sets**](valuesets.md)
* **CDA Value Sets**

## CDA Value Sets

 CDA Value Sets defined and maintained by HL7 as part of the CDA family of Standards, and published in the International CDA r2 Base Standard. Please note that all of these value sets at this time are drawn from the masters published in the HL7 Version 3 International Standard through the coremif. 

* Identity: 
  * Name: 
  * Version: 
  * Status: 
  * Owner: 
  * Copyright: 
  * Date: 
  * Description: 
* Identity: [v3-ActClass](ValueSet-v3-ActClass.md)
  * Name: ActClass
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A code specifying the major type of Act that this Act-instance represents.**Constraints:**The cl…
* Identity: [v3-ActClassClinical…](ValueSet-v3-ActClassClinicalDocument.md)
  * Name: ActClassClinicalDocument
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A clinical document is a documentation of clinical observations and services, with the following ch…
* Identity: [v3-ActClassDocument](ValueSet-v3-ActClassDocument.md)
  * Name: ActClassDocument
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Specialization of Act to add the characteristics unique to document management services.
* Identity: [v3-ActClassObservat…](ValueSet-v3-ActClassObservation.md)
  * Name: ActClassObservation
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**An act that is intended to result in new information about a subject. The main diff…
* Identity: [v3-ActClassRoot](ValueSet-v3-ActClassRoot.md)
  * Name: ActClassRoot
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A record of something that is being done, has been done, can be done, or is intended or requested t…
* Identity: [v3-ActEncounterCode](ValueSet-v3-ActEncounterCode.md)
  * Name: ActEncounterCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Domain provides codes that qualify the ActEncounterClass (ENC)
* Identity: [v3-ActMood](ValueSet-v3-ActMood.md)
  * Name: ActMood
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A code distinguishing whether an Act is conceived of as a factual statement or in some other manner…
* Identity: [v3-ActRelationshipF…](ValueSet-v3-ActRelationshipFulfills.md)
  * Name: ActRelationshipFulfills
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The source act fulfills (in whole or in part) the target act. Source act must be in a mood equal or…
* Identity: [v3-ActRelationshipH…](ValueSet-v3-ActRelationshipHasComponent.md)
  * Name: ActRelationshipHasComponent
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A collection of sub-services as steps or subtasks performed for the source service. Services may be…
* Identity: [v3-ActRelationshipT…](ValueSet-v3-ActRelationshipType.md)
  * Name: ActRelationshipType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A code specifying the meaning and purpose of every ActRelationship instance. Each of its values imp…
* Identity: [v3-ActRelationshipT…](ValueSet-v3-ActRelationshipType.md)
  * Name: ActRelationshipType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A code specifying the meaning and purpose of every ActRelationship instance. Each of its values imp…
* Identity: [v3-ActStatus](ValueSet-v3-ActStatus.md)
  * Name: ActStatus
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Contains the names (codes) for each of the states in the state-machine of the RIM Act class.
* Identity: [v3-ContextControl](ValueSet-v3-ContextControl.md)
  * Name: ContextControl
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A code that specifies how an ActRelationship or Participation contributes to the context of an Act,…
* Identity: [v3-DischargeDisposi…](ValueSet-v3-DischargeDisposition.md)
  * Name: Discharge Disposition
  * Version: 1.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2024-09-11
  * Description: These codes are used to convey the patient discharge status
* Identity: [v3-DrugEntity](ValueSet-v3-DrugEntity.md)
  * Name: Drug Entity
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2022-10-11
  * Description: A value representing the specific kind of Drug Entity the instance represents.
* Identity: [v3-EntityClass](ValueSet-v3-EntityClass.md)
  * Name: EntityClass
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Classifies the Entity class and all of its subclasses. The terminology is hierarchical. At the top …
* Identity: [v3-EntityClassDevice](ValueSet-v3-EntityClassDevice.md)
  * Name: EntityClassDevice
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A subtype of ManufacturedMaterial used in an activity, without being substantially changed through …
* Identity: [v3-EntityClassManuf…](ValueSet-v3-EntityClassManufacturedMaterial.md)
  * Name: EntityClassManufacturedMaterial
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Corresponds to the ManufacturedMaterial class
* Identity: [v3-EntityClassOrgan…](ValueSet-v3-EntityClassOrganization.md)
  * Name: EntityClassOrganization
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A social or legal structure formed by human beings.
* Identity: [v3-EntityClassPlace](ValueSet-v3-EntityClassPlace.md)
  * Name: EntityClassPlace
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A physicial place or site with its containing structure. May be natural or man-made. The geographic…
* Identity: [v3-EntityClassRoot](ValueSet-v3-EntityClassRoot.md)
  * Name: EntityClassRoot
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Corresponds to the Entity class
* Identity: [v3-EntityDeterminer](ValueSet-v3-EntityDeterminer.md)
  * Name: EntityDeterminer
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: EntityDeterminer in natural language grammar is the class of words that comprises articles, demonst…
* Identity: [v3-EntityDeterminer…](ValueSet-v3-EntityDeterminerDetermined.md)
  * Name: EntityDeterminerDetermined
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The described determiner is used to indicate that the given Entity is taken as a general descriptio…
* Identity: [v3-EntityDeterminer…](ValueSet-v3-EntityDeterminerDetermined.md)
  * Name: EntityDeterminerDetermined
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The described determiner is used to indicate that the given Entity is taken as a general descriptio…
* Identity: [v3-HL7FormatCodes](ValueSet-v3-HL7FormatCodes.md)
  * Name: HL7 ValueSet of Format Codes for use with Document Sharing
  * Version: 2.1.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2024-02-16
  * Description: The HL7-FormatCodes value set is defined to be the set of FormatCode(s) defined by implementation g…
* Identity: [v3-HumanLanguage](ValueSet-v3-HumanLanguage.md)
  * Name: HumanLanguage
  * Version: 4.0.0
  * Status: retired
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2024-06-28
  * Description: Codes for the representation of the names of human languages.
* Identity: [v3-ManufacturerMode…](ValueSet-v3-ManufacturerModelNameExample.md)
  * Name: Manufacturer Model Name Example
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2022-10-11
  * Description: An example value set representing the ManufacturerModelName concept domain used to convey a coded …
* Identity: [v3-ParticipationPhy…](ValueSet-v3-ParticipationPhysicalPerformer.md)
  * Name: ParticipationPhysicalPerformer
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A person who actually and principally carries out the action. Need not be the principal responsible…
* Identity: [v3-ParticipationSig…](ValueSet-v3-ParticipationSignature.md)
  * Name: ParticipationSignature
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A code specifying whether and how the participant has attested his participation through a signatur…
* Identity: [v3-ParticipationTar…](ValueSet-v3-ParticipationTargetLocation.md)
  * Name: ParticipationTargetLocation
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The facility where the service is done. May be a static building (or room therein) or a moving loca…
* Identity: [v3-ParticipationTar…](ValueSet-v3-ParticipationTargetSubject.md)
  * Name: ParticipationTargetSubject
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The principle target that the service acts on. E.g. the patient in physical examination, a specimen…
* Identity: [v3-ParticipationType](ValueSet-v3-ParticipationType.md)
  * Name: ParticipationType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A code specifying the meaning and purpose of every Participation instance. Each of its values impli…
* Identity: [v3-ROIOverlayShape](ValueSet-v3-ROIOverlayShape.md)
  * Name: ROIOverlayShape
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Shape of the region on the object being referenced
* Identity: [v3-RoleClass](ValueSet-v3-RoleClass.md)
  * Name: RoleClass
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: This table includes codes for the Role class hierarchy. The values in this hierarchy, represent a R…
* Identity: [v3-RoleClassAssigne…](ValueSet-v3-RoleClassAssignedEntity.md)
  * Name: RoleClassAssignedEntity
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An agent role in which the agent is an Entity acting in the employ of an organization. The focus is…
* Identity: [v3-RoleClassAssigne…](ValueSet-v3-RoleClassAssignedEntity.md)
  * Name: RoleClassAssignedEntity
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An agent role in which the agent is an Entity acting in the employ of an organization. The focus is…
* Identity: [v3-RoleClassAssocia…](ValueSet-v3-RoleClassAssociative.md)
  * Name: RoleClassAssociative
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A general association between two entities that is neither partitive nor ontological.
* Identity: [v3-RoleClassContact](ValueSet-v3-RoleClassContact.md)
  * Name: RoleClassContact
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A person or an organization (player) which provides or receives information regarding another entit…
* Identity: [v3-RoleClassMutualR…](ValueSet-v3-RoleClassMutualRelationship.md)
  * Name: RoleClassMutualRelationship
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A relationship that is based on mutual behavior of the two Entities as being related. The basis of …
* Identity: [v3-RoleClassRoot](ValueSet-v3-RoleClassRoot.md)
  * Name: RoleClassRoot
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Corresponds to the Role class
* Identity: [v3-RoleClassService…](ValueSet-v3-RoleClassServiceDeliveryLocation.md)
  * Name: RoleClassServiceDeliveryLocation
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A role played by a place at which services may be provided.
* Identity: [v3-RoleClassSpecimen](ValueSet-v3-RoleClassSpecimen.md)
  * Name: RoleClassSpecimen
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A role played by a material entity that is a specimen for an act. It is scoped by the source of the…
* Identity: [v3-RoleStatus](ValueSet-v3-RoleStatus.md)
  * Name: RoleStatus
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Codes representing the defined possible states of an Role, as defined by the Role class state machi…
* Identity: [v3-RoleStatusActive](ValueSet-v3-RoleStatusActive.md)
  * Name: RoleStatusActive
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The state representing the fact that the Entity is currently active in the Role.
* Identity: [v3-ServiceDeliveryL…](ValueSet-v3-ServiceDeliveryLocationRoleType.md)
  * Name: ServiceDeliveryLocationRoleType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A role of a place that further classifies the setting (e.g., accident site, road side, work site, c…
* Identity: [v3-SoftwareNameExam…](ValueSet-v3-SoftwareNameExample.md)
  * Name: Software Name Example
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2022-10-11
  * Description: An example value set representing the SoftwareName concept domain used to convey a coded name for a…
* Identity: [v3-xActClassDocumen…](ValueSet-v3-xActClassDocumentEntryAct.md)
  * Name: x_ActClassDocumentEntryAct
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The set of Act class codes allowed for the ACT class clone in the CDA Clinical Statement model. The…
* Identity: [v3-xActClassDocumen…](ValueSet-v3-xActClassDocumentEntryOrganizer.md)
  * Name: x_ActClassDocumentEntryOrganizer
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ****No description****
* Identity: [v3-xActMoodDocument…](ValueSet-v3-xActMoodDocumentObservation.md)
  * Name: x_ActMoodDocumentObservation
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Used to enumerate the moods that an observation can take within the body of a clinical document.
* Identity: [v3-xActRelationship…](ValueSet-v3-xActRelationshipDocument.md)
  * Name: x_ActRelationshipDocument
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Used to enumerate the relationships between two clinical documents for document management.
* Identity: [v3-xActRelationship…](ValueSet-v3-xActRelationshipEntry.md)
  * Name: x_ActRelationshipEntry
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Used to enumerate the relationships between a CDA section and its contained entries.
* Identity: [v3-xActRelationship…](ValueSet-v3-xActRelationshipEntryRelationship.md)
  * Name: x_ActRelationshipEntryRelationship
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Used to enumerate the relationships between two CDA entries.
* Identity: [v3-xActRelationship…](ValueSet-v3-xActRelationshipExternalReference.md)
  * Name: x_ActRelationshipExternalReference
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Used to enumerate the relationships between a CDA entry and an externally referenced act.
* Identity: [v3-xBasicConfidenti…](ValueSet-v3-xBasicConfidentialityKind.md)
  * Name: x_BasicConfidentialityKind
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**Used to enumerate the typical confidentiality constraints placed upon a clinical d…
* Identity: [v3-xDocumentActMood](ValueSet-v3-xDocumentActMood.md)
  * Name: x_DocumentActMood
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Used to enumerate the moods that an act can take within the body of a clinical document.
* Identity: [v3-xDocumentEncount…](ValueSet-v3-xDocumentEncounterMood.md)
  * Name: x_DocumentEncounterMood
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Used to enumerate the moods that an encounter can take within the body of a clinical document.
* Identity: [v3-xDocumentProcedu…](ValueSet-v3-xDocumentProcedureMood.md)
  * Name: x_DocumentProcedureMood
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Used to enumerate the moods that a procedure can take within the body of a clinical document.
* Identity: [v3-xDocumentSubject](ValueSet-v3-xDocumentSubject.md)
  * Name: x_DocumentSubject
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ****No description****
* Identity: [v3-xDocumentSubstan…](ValueSet-v3-xDocumentSubstanceMood.md)
  * Name: x_DocumentSubstanceMood
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Used to enumerate the moods that a substance administration can take within the body of a clinical …
* Identity: [v3-xEncounterPartic…](ValueSet-v3-xEncounterParticipant.md)
  * Name: x_EncounterParticipant
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Clones using this x_domain should have a name "encounterParticipant".
* Identity: [v3-xInformationReci…](ValueSet-v3-xInformationRecipient.md)
  * Name: x_InformationRecipient
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Used to represent participant(s) who should receive a copy of a document.
* Identity: [v3-xInformationReci…](ValueSet-v3-xInformationRecipientRole.md)
  * Name: x_InformationRecipientRole
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Used to represent the role(s) of those who should receive a copy of a document.
* Identity: [v3-xServiceEventPer…](ValueSet-v3-xServiceEventPerformer.md)
  * Name: x_ServiceEventPerformer
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Clones using this x_domain should have a name "performer".

Showing 63 of 63 entries

