# External Code Systems - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**External Content**](external_content.md)
* **External Code Systems**

## External Code Systems

 The table below provides information about external Code Systems that are used with HL7 Standards. Each entry provides an overview of information about the external Code System, with links to additional information which is described below. 

 The Identification Records contain information for external Code Systems published in the HL7 Terminology pages, persisted as THO NamingSystem resources. The content includes details and history tracking for technical identifiers (URIs and OIDs and others) for external Code Systems. These identifiers are used in data elements of coded data types in the various HL7 product families. 

 The Code System Metadata Record associated with each external Code System in the table is the authoritative source of information regarding the correct use of external terminologies with FHIR and other HL7 standards including HL7 endorsed system URI and OID identifiers. 

 These Fragments contain published instances of Code Systems maintained by external (non-HL7) organizations, and are shown with content, which is known to be incomplete. This subset of their content is republished here under agreement between HL7 and the specific organization, and is for the convenience of HL7 IG authors and implementers. 

 These Complete Code Systems contain published instances of Code Systems maintained by external (non-HL7) organizations, and are shown here with content, which is believed to be complete. This content is republished here under agreement between HL7 and the specific organization, and is for the convenience of HL7 IG authors and implementers; it may be in the Public Domain. 

 The Use with HL7 Standards pages provide additional technical details on the correct use of the external Code System with FHIR and other HL7 standards, such as the correct use of properties for the Code System using FHIR. 

 The Terminology Services Management Group (TSMG) is responsible for the creation, implementation, and management of HL7 processes involving external terminology management. One of these processes is to liaise with the owners, stewards and publishers of external terminologies to obtain accurate business and technical metadata about the terminology for use in HL7 standards. This information is then published in these metadata records in HL7 Terminology. Changes to these records are strictly based on decisions of the TSMG. However, stakeholders may submit change requests to the TSMG for consideration. 


