# FHIR Code Systems - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**HL7 Code Systems**](codesystems.md)
* **FHIR Code Systems**

## FHIR Code Systems

 This page contains the FHIR code systems that are available for browsing through the HL7 Terminology pages. The docuemnttion here refers specifically to the use of this content in FHIR artifacts. 

 The code system names and their URIs may be used in the *system* element of the [Coding](http://hl7.org/fhir/datatypes.html#Coding) data type. If a URI is defined here, it SHALL be used in preference to any other identifying mechanisms. If a code system is not listed here, the correct URI may be determined by working through the following list, in order: 

* the HL7 OID Registry
* the documentation associated with the code system
* consulting the owner of the code system
* asking on the HL7 vocabulary mailing list

 See also the [list of known identifier systems](http://hl7.org/fhir/identifier-registry.html) that can be used in the *system* element of the [Identifier](http://hl7.org/fhir/datatypes.html#Identifier) data type. Additional identifier systems may be registered on the HL7 FHIR registry at [http://hl7.org/fhir/registry](http://hl7.org/fhir/registry). 

 **Important Notes:** 

* This list of names is incomplete and subject to change. Some values may be dropped, and others will likely be added in the coming months as HL7 institutes formal processes around URIs in vocabulary
* Note that some of the URNs in this list follow the URN specification in [RFC 5141](http://tools.ietf.org/html/rfc5141) for referring to standards published by ISO, such as urn:iso:std:iso:11073:10101. Where ISO standards define codes with meanings, and there is no entry in the list above, and they are not registered in the HL7 OID registry, the default URN for the code system is that defined by the RFC 5141.
* For several of the code systems in this list, multiple systems are given. This means that the variants identified are different code systems, not just variants of the same code system
* Any URL in `http://example.org` is reserved for testing and documentation purposes.

 Note that the code systems are available as FHIR resources - see the [Downloads Page](downloads.md) (as part of the FHIR definitions) (excluding the External code systems. 

 **UMLS Note**: The [UMLS](https://www.nlm.nih.gov/research/umls/sourcereleasedocs/index.html) includes many code systems that do not have an entry in the table below, or in the HL7 OID registry, or on http://registry.fhir.org. Until these code systems are registered, implementers may use the pattern `http://www.nlm.nih.gov/research/umls/[SAB]`, where [SAB] is the lowercase of abbreviation of the code system as provided by UMLS. e.g. The system for "Multum MediSource Lexicon" would then be `http://www.nlm.nih.gov/research/umls/mmsl`. Implementers choosing to use this pattern should be aware that very often, when the code system is registered, it will use a different system. 

 It has been noted that this UMLS statement above is not completely correct, and the UTG team is awaiting the correction. Stay tuned. 

 **Don't see what you're looking for here?** See [Registering Code Systems](https://confluence.hl7.org/display/FHIR/Registering+Code+Systems) for further advice. 

* Identity: 
  * Name: 
  * Version: 
  * Status: 
  * Content: 
  * Owner: 
  * Copyright: 
  * Date: 
  * Description: 
* Identity: [FDI-surface](CodeSystem-FDI-surface.md)
  * Name: Surface Codes
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes a smattering of FDI tooth surface codes.
* Identity: [accepting-patients](CodeSystem-accepting-patients.md)
  * Name: Accepting Patients
  * Version: 1.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This code system defines a set of codes that can be used to indicate a practice is accepting new pa…
* Identity: [action-type](CodeSystem-action-type.md)
  * Name: ActionType
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The type of action to be performed.
* Identity: [activity-definition…](CodeSystem-activity-definition-category.md)
  * Name: ActivityDefinitionCategory
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: High-level categorization of the type of activity.
* Identity: [adjudication](CodeSystem-adjudication.md)
  * Name: Adjudication Value Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes a smattering of Adjudication Value codes which includes codes to indicate t…
* Identity: [adjudication-error](CodeSystem-adjudication-error.md)
  * Name: Adjudication Error Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes a smattering of adjudication codes.
* Identity: [adjudication-reason](CodeSystem-adjudication-reason.md)
  * Name: Adjudication Reason Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes smattering of Adjudication Reason codes.
* Identity: [admit-source](CodeSystem-admit-source.md)
  * Name: Admit source
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set defines a set of codes that can be used to indicate from where the patient came in.
* Identity: [adverse-event-categ…](CodeSystem-adverse-event-category.md)
  * Name: AdverseEventCategory
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2024-08-28
  * Description: Overall categorization of the event, e.g. product-related or situational.
* Identity: [adverse-event-causa…](CodeSystem-adverse-event-causality-assess.md)
  * Name: AdverseEventCausalityAssessment
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Codes for the assessment of whether the entity caused the event.
* Identity: [adverse-event-causa…](CodeSystem-adverse-event-causality-method.md)
  * Name: AdverseEventCausalityMethod
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2024-08-28
  * Description: This code system contains methods for assessing causality.
* Identity: [adverse-event-serio…](CodeSystem-adverse-event-seriousness.md)
  * Name: AdverseEventSeriousness
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Overall seriousness of this event for the patient.
* Identity: [adverse-event-sever…](CodeSystem-adverse-event-severity.md)
  * Name: AdverseEventSeverity
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: The severity of the adverse event itself, in direct relation to the subject.
* Identity: [allerg-intol-substa…](CodeSystem-allerg-intol-substance-exp-risk.md)
  * Name: AllergyIntoleranceSubstanceExposureRisk
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: The risk of an adverse reaction (allergy or intolerance) for this patient upon exposure to the subs…
* Identity: [allergyintolerance-…](CodeSystem-allergyintolerance-clinical.md)
  * Name: AllergyIntolerance Clinical Status Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: Preferred value set for AllergyIntolerance Clinical Status.
* Identity: [allergyintolerance-…](CodeSystem-allergyintolerance-verification.md)
  * Name: AllergyIntolerance Verification Status
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: The verification status to support or decline the clinical status of the allergy or intolerance.
* Identity: [applicability](CodeSystem-applicability.md)
  * Name: Benefit cost applicability
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2018-06-05
  * Description: Whether the cost applies to in-network or out-of-network providers.
* Identity: [appointment-cancell…](CodeSystem-appointment-cancellation-reason.md)
  * Name: Appointment cancellation reason
  * Version: 2.1.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This example value set defines a set of reasons for the cancellation of an appointment.
* Identity: [appropriateness-sco…](CodeSystem-appropriateness-score.md)
  * Name: Appropriateness Score
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2022-10-18
  * Description: The scoring for appropriateness of an action based upon RAND.
* Identity: [artifact-contributi…](CodeSystem-artifact-contribution-instance-type.md)
  * Name: Artifact Contribution Instance Type
  * Version: 1.0.0
  * Status: trial-use
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: Artifact Contribution Instance Type
* Identity: [artifact-identifier…](CodeSystem-artifact-identifier-type.md)
  * Name: Artifact Identifier Type Codes
  * Version: 1.0.0
  * Status: active
  * Content: complete
  * Owner: [cqi](http://www.hl7.org/Special/committees/cqi)
  * Copyright: THO
  * Date: 2024-02-20
  * Description: Identifier types for an artifact (e.g. version-independent, version-specific, short-name, endorser,…
* Identity: [artifact-relationsh…](CodeSystem-artifact-relationship-type.md)
  * Name: Artifact Relationship Type
  * Version: 1.0.0
  * Status: trial-use
  * Content: complete
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: n/a
  * Date: 2025-02-24
  * Description: This artifact incorporates the target artifact. This artifact is constructed with the target artifa…
* Identity: [artifact-url-classi…](CodeSystem-artifact-url-classifier.md)
  * Name: Artifact Url Classifier
  * Version: 1.0.0
  * Status: trial-use
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: Code the reason for different URLs, eg abstract and full-text.
* Identity: [artifact-version-po…](CodeSystem-artifact-version-policy-codes.md)
  * Name: Artifact Version Policy Codes
  * Version: 1.0.0
  * Status: trial-use
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: THO
  * Date: 2024-02-16
  * Description: The versioning policy of an artifact (metadata, strict)
* Identity: [attribute-estimate-…](CodeSystem-attribute-estimate-type.md)
  * Name: StatisticAttribute Estimate Type
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Method of reporting variability of estimates, such as confidence intervals, interquartile range or …
* Identity: [audit-entity-type](CodeSystem-audit-entity-type.md)
  * Name: Audit event entity type
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [sec](http://www.hl7.org/Special/committees/secure)
  * Copyright: THO
  * Date: 2024-06-28
  * Description: Code for the entity type involved in the audit event.
* Identity: [audit-event-outcome](CodeSystem-audit-event-outcome.md)
  * Name: AuditEventOutcome
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [sec](http://www.hl7.org/Special/committees/secure)
  * Copyright: THO
  * Date: 2024-06-28
  * Description: Indicates whether the event succeeded or failed.
* Identity: [audit-event-type](CodeSystem-audit-event-type.md)
  * Name: Audit Event ID
  * Version: 1.0.0
  * Status: active
  * Content: complete
  * Owner: [sec](http://www.hl7.org/Special/committees/secure)
  * Copyright: DICOM
  * Date: 2015-03-26
  * Description: Event Types for Audit Events - defined by DICOM with some FHIR specific additions.
* Identity: [basic-resource-type](CodeSystem-basic-resource-type.md)
  * Name: Basic Resource Types
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set defines codes for resources not yet supported by (or which will never be supported b…
* Identity: [benefit-network](CodeSystem-benefit-network.md)
  * Name: Network Type Codes
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This code system represents the contractual relationship between a provider and payer for administr…
* Identity: [benefit-term](CodeSystem-benefit-term.md)
  * Name: Benefit Term Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes a smattering of Benefit Term codes.
* Identity: [benefit-type](CodeSystem-benefit-type.md)
  * Name: Benefit Type Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes a smattering of Benefit type codes.
* Identity: [benefit-unit](CodeSystem-benefit-unit.md)
  * Name: Unit Type Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes a smattering of Unit type codes.
* Identity: [can-push-updates](CodeSystem-can-push-updates.md)
  * Name: Can-push-updates
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Ability of the primary source to push updates/alerts
* Identity: [care-service-access…](CodeSystem-care-service-accessibility.md)
  * Name: Care Service Accessibility
  * Version: 1.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This code system defines a set of codes that can be used to describe care service accessibility opt…
* Identity: [catalogType](CodeSystem-catalogType.md)
  * Name: CatalogType
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The type of catalog.
* Identity: [certainty-rating](CodeSystem-certainty-rating.md)
  * Name: StatisticCertaintyRating
  * Version: 2.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: The relative quality of the statistic.
* Identity: [certainty-subcompon…](CodeSystem-certainty-subcomponent-rating.md)
  * Name: StatisticCertaintySubcomponentRating
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: The quality rating of the subcomponent of a quality of evidence rating.
* Identity: [certainty-subcompon…](CodeSystem-certainty-subcomponent-type.md)
  * Name: StatisticCertaintySubcomponentType
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: The subcomponent classification of quality of evidence rating systems.
* Identity: [certainty-type](CodeSystem-certainty-type.md)
  * Name: Evidence Certainty Type
  * Version: 1.0.0
  * Status: trial-use
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: The aspect of quality, confidence, or certainty.
* Identity: [characteristic-meth…](CodeSystem-characteristic-method.md)
  * Name: CharacteristicMethod
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: The method used to determine the characteristic(s) of the variable.
* Identity: [chargeitem-billingc…](CodeSystem-chargeitem-billingcodes.md)
  * Name: ChargeItemCode
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Example set of codes that can be used for billing purposes.
* Identity: [choice-list-orienta…](CodeSystem-choice-list-orientation.md)
  * Name: ChoiceListOrientation
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: Direction in which lists of possible answers should be displayed.
* Identity: [chromosome-human](CodeSystem-chromosome-human.md)
  * Name: chromosome-human
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [cg](http://www.hl7.org/Special/committees/clingenomics)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: Chromosome number for human.
* Identity: [citation-artifact-c…](CodeSystem-citation-artifact-classifier.md)
  * Name: Citation Artifact Classifier
  * Version: 1.0.0
  * Status: trial-use
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2020-01-20
  * Description: Citation artifact classifier
* Identity: [citation-classifica…](CodeSystem-citation-classification-type.md)
  * Name: Citation Classification Type
  * Version: 1.0.0
  * Status: trial-use
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: Citation classification type
* Identity: [citation-summary-st…](CodeSystem-citation-summary-style.md)
  * Name: Citation Summary Style
  * Version: 1.0.0
  * Status: trial-use
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: The format for display of the citation.
* Identity: [cited-artifact-abst…](CodeSystem-cited-artifact-abstract-type.md)
  * Name: Cited Artifact Abstract Type
  * Version: 1.0.0
  * Status: trial-use
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: Used to express the reason and specific aspect for the variant abstract, such as language and speci…
* Identity: [cited-artifact-clas…](CodeSystem-cited-artifact-classification-type.md)
  * Name: Cited Artifact Classification Type
  * Version: 1.0.0
  * Status: trial-use
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: Cited Artifact Classification Type
* Identity: [cited-artifact-cont…](CodeSystem-cited-artifact-contribution-type.md)
  * Name: Cited Artifact Contribution Type
  * Version: 1.0.0
  * Status: trial-use
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: Citation contribution.
* Identity: [cited-artifact-part…](CodeSystem-cited-artifact-part-type.md)
  * Name: Cited Artifact Part Type
  * Version: 1.0.0
  * Status: trial-use
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: To describe the reason for the variant citation, such as version number or subpart specification.
* Identity: [cited-artifact-stat…](CodeSystem-cited-artifact-status-type.md)
  * Name: Cited Artifact Status Type
  * Version: 1.0.0
  * Status: trial-use
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: Cited Artifact Status Type
* Identity: [cited-medium](CodeSystem-cited-medium.md)
  * Name: Cited Medium
  * Version: 1.0.0
  * Status: trial-use
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: NLM codes Internet or Print.
* Identity: [claim-exception](CodeSystem-claim-exception.md)
  * Name: Exception Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes sample Exception codes.
* Identity: [claim-type](CodeSystem-claim-type.md)
  * Name: Claim Type Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes Claim Type codes.
* Identity: [claimcareteamrole](CodeSystem-claimcareteamrole.md)
  * Name: Claim Care Team Role Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: Claim roles of the care team members providing products and services.
* Identity: [claiminformationcat…](CodeSystem-claiminformationcategory.md)
  * Name: Claim Information Category Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes sample Information Category codes.
* Identity: [codesystem-altcode-…](CodeSystem-codesystem-altcode-kind.md)
  * Name: AlternativeCodeKind
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: Indicates the type of use for which the code is defined.
* Identity: [common-tags](CodeSystem-common-tags.md)
  * Name: Common Tags
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: Common Tag Codes defined by FHIR project
* Identity: [communication-categ…](CodeSystem-communication-category.md)
  * Name: CommunicationCategory
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Codes for general categories of communications such as alerts, instructions, etc.
* Identity: [communication-not-d…](CodeSystem-communication-not-done-reason.md)
  * Name: CommunicationNotDoneReason
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Codes for the reason why a communication did not happen.
* Identity: [communication-topic](CodeSystem-communication-topic.md)
  * Name: CommunicationTopic
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Codes describing the purpose or content of the communication.
* Identity: [composite-measure-s…](CodeSystem-composite-measure-scoring.md)
  * Name: CompositeMeasureScoring
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [cqi](http://www.hl7.org/Special/committees/cqi)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The composite scoring method of the measure.
* Identity: [composition-altcode…](CodeSystem-composition-altcode-kind.md)
  * Name: AlternativeCodeKind
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: Indicates the type of use for which the code is defined.
* Identity: [condition-category](CodeSystem-condition-category.md)
  * Name: Condition Category Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: Preferred value set for Condition Categories.
* Identity: [condition-clinical](CodeSystem-condition-clinical.md)
  * Name: Condition Clinical Status Codes
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: Preferred value set for Condition Clinical Status.
* Identity: [condition-state](CodeSystem-condition-state.md)
  * Name: ConditionState
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: Enumeration indicating whether the condition is currently active, inactive, or has been resolved.
* Identity: [condition-ver-status](CodeSystem-condition-ver-status.md)
  * Name: ConditionVerificationStatus
  * Version: 2.0.1
  * Status: active
  * Content: complete
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The verification status to support or decline the clinical status of the condition or diagnosis.
* Identity: [conformance-expecta…](CodeSystem-conformance-expectation.md)
  * Name: ConformanceExpectation
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: Indicates the degree of adherence to a specified behavior or capability expected for a system to be…
* Identity: [consentaction](CodeSystem-consentaction.md)
  * Name: Consent Action Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [cbcc](http://www.hl7.org/Special/committees/cbcc)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes sample Consent Action codes.
* Identity: [consentcategorycodes](CodeSystem-consentcategorycodes.md)
  * Name: Consent Category Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [cbcc](http://www.hl7.org/Special/committees/cbcc)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes sample Consent Directive Type codes, including several consent directive re…
* Identity: [consentpolicycodes](CodeSystem-consentpolicycodes.md)
  * Name: Consent PolicyRule Codes
  * Version: 3.0.1
  * Status: active
  * Content: complete
  * Owner: [cbcc](http://www.hl7.org/Special/committees/cbcc)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes sample Regulatory consent policy types from the US and other regions.
* Identity: [consentscope](CodeSystem-consentscope.md)
  * Name: Consent Scope Codes
  * Version: 2.0.1
  * Status: active
  * Content: complete
  * Owner: [cbcc](http://www.hl7.org/Special/committees/cbcc)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes the four Consent scope codes.
* Identity: [consentverification](CodeSystem-consentverification.md)
  * Name: Consent Verification Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [cbcc](http://www.hl7.org/Special/committees/cbcc)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes base Consent Verification codes.
* Identity: [contactentity-type](CodeSystem-contactentity-type.md)
  * Name: Contact entity type
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This example value set defines a set of codes that can be used to indicate the purpose for which yo…
* Identity: [container-cap](CodeSystem-container-cap.md)
  * Name: ContainerCap
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Color of the container cap.
* Identity: [contract-content-de…](CodeSystem-contract-content-derivative.md)
  * Name: Contract Content Derivation Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This is an example set of Content Derivative type codes, which represent the minimal content derive…
* Identity: [contract-data-meani…](CodeSystem-contract-data-meaning.md)
  * Name: ContractDataMeaning
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: How a resource reference is interpreted when evaluating contract offers.
* Identity: [contract-type](CodeSystem-contract-type.md)
  * Name: Contract Type Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes sample Contract Type codes.
* Identity: [contractaction](CodeSystem-contractaction.md)
  * Name: Contract Action Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes sample Contract Action codes.
* Identity: [contractactorrole](CodeSystem-contractactorrole.md)
  * Name: Contract Actor Role Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes sample Contract Actor Role codes.
* Identity: [contractsignertypec…](CodeSystem-contractsignertypecodes.md)
  * Name: Contract Signer Type Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: other
  * Date: 2025-11-12
  * Description: This value set includes sample Contract Signer Type codes.
* Identity: [contractsubtypecodes](CodeSystem-contractsubtypecodes.md)
  * Name: Contract Subtype Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes sample Contract Subtype codes.
* Identity: [contracttermsubtype…](CodeSystem-contracttermsubtypecodes.md)
  * Name: Contract Term Subtype Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes sample Contract Term SubType codes.
* Identity: [contracttermtypecod…](CodeSystem-contracttermtypecodes.md)
  * Name: Contract Term Type Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes sample Contract Term Type codes.
* Identity: [contributor-role](CodeSystem-contributor-role.md)
  * Name: Contributor Role
  * Version: 1.0.0
  * Status: trial-use
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: Used to code the format of the display string.
* Identity: [contributor-summary…](CodeSystem-contributor-summary-source.md)
  * Name: Contributor Summary Source
  * Version: 1.0.0
  * Status: trial-use
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: Used to code the producer or rule for creating the display string.
* Identity: [contributor-summary…](CodeSystem-contributor-summary-style.md)
  * Name: Contributor Summary Style
  * Version: 1.0.0
  * Status: trial-use
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: Used to code the format of the display string.
* Identity: [contributor-summary…](CodeSystem-contributor-summary-type.md)
  * Name: Contributor Summary Type
  * Version: 1.0.0
  * Status: trial-use
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: Used to code author list statement, contributorship statement, and such.
* Identity: [copy-number-event](CodeSystem-copy-number-event.md)
  * Name: CopyNumberEvent
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: Copy Number Event.
* Identity: [coverage-class](CodeSystem-coverage-class.md)
  * Name: Coverage Class Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes Coverage Class codes.
* Identity: [coverage-copay-type](CodeSystem-coverage-copay-type.md)
  * Name: Coverage Copay Type Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes sample Coverage Copayment Type codes.
* Identity: [coverage-selfpay](CodeSystem-coverage-selfpay.md)
  * Name: Coverage SelfPay Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes Coverage SelfPay codes.
* Identity: [coverageeligibility…](CodeSystem-coverageeligibilityresponse-ex-auth-support.md)
  * Name: CoverageEligibilityResponse Auth Support Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes CoverageEligibilityResponse Auth Support codes.
* Identity: [data-absent-reason](CodeSystem-data-absent-reason.md)
  * Name: DataAbsentReason
  * Version: 1.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-11-01
  * Description: Used to specify why the normally expected content of the data element is missing.
* Identity: [definition-status](CodeSystem-definition-status.md)
  * Name: DefinitionStatus
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: Codes identifying the lifecycle stage of a definition.
* Identity: [definition-topic](CodeSystem-definition-topic.md)
  * Name: DefinitionTopic
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: High-level categorization of the definition, used for searching, sorting, and filtering.
* Identity: [definition-use](CodeSystem-definition-use.md)
  * Name: Structure Definition Use Codes / Keywords
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: Structure Definition Use Codes / Keywords
* Identity: [device-status-reason](CodeSystem-device-status-reason.md)
  * Name: FHIRDeviceStatusReason
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: The availability status reason of the device.
* Identity: [devicealert-activat…](CodeSystem-devicealert-activationState.md)
  * Name: Device Alert Activation State
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [dev](http://www.hl7.org/Special/committees/healthcaredevices)
  * Copyright: n/a
  * Date: 2023-12-10
  * Description: Describes the activation state of a DeviceAlert.
* Identity: [devicealert-priority](CodeSystem-devicealert-priority.md)
  * Name: Device Alert Priority
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [dev](http://www.hl7.org/Special/committees/healthcaredevices)
  * Copyright: n/a
  * Date: 2023-12-10
  * Description: Describes the priority of a DeviceAlert.
* Identity: [diagnosis-role](CodeSystem-diagnosis-role.md)
  * Name: Diagnosis Role
  * Version: 1.1.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set defines a set of codes that can be used to express the role of a diagnosis on the En…
* Identity: [diagnosistype](CodeSystem-diagnosistype.md)
  * Name: Diagnosis Type Codes
  * Version: 1.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes Diagnosis Type codes.
* Identity: [dicom-audit-lifecyc…](CodeSystem-dicom-audit-lifecycle.md)
  * Name: DICOM Audit Message Record Lifecycle Events
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: DICOM
  * Date: 2025-11-12
  * Description: Attached is vocabulary for the record lifecycle events, as per DICOM Audit Message,
* Identity: [diet](CodeSystem-diet.md)
  * Name: Diet
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set defines a set of codes that can be used to indicate dietary preferences or restricti…
* Identity: [directness](CodeSystem-directness.md)
  * Name: EvidenceDirectness
  * Version: 2.0.0
  * Status: draft
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: The quality of how direct the match is.
* Identity: [discharge-dispositi…](CodeSystem-discharge-disposition.md)
  * Name: Discharge disposition
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set defines a set of codes that can be used to where the patient left the hospital.
* Identity: [dose-rate-type](CodeSystem-dose-rate-type.md)
  * Name: DoseAndRateType
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: The kind of dose or rate specified.
* Identity: [encounter-special-a…](CodeSystem-encounter-special-arrangements.md)
  * Name: Special arrangements
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set defines a set of codes that can be used to indicate the kinds of special arrangement…
* Identity: [encounter-subject-s…](CodeSystem-encounter-subject-status.md)
  * Name: Encounter subject status
  * Version: 2.0.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This example value set defines a set of codes that can be used to indicate the status of the subjec…
* Identity: [encounter-type](CodeSystem-encounter-type.md)
  * Name: Encounter type
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This example value set defines a set of codes that can be used to indicate the type of encounter: a…
* Identity: [endpoint-connection…](CodeSystem-endpoint-connection-type.md)
  * Name: Endpoint Connection Type
  * Version: 2.1.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This is an example value set defined by the FHIR project, that could be used to represent possible …
* Identity: [endpoint-payload-ty…](CodeSystem-endpoint-payload-type.md)
  * Name: Endpoint Payload Type
  * Version: 2.0.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This is an example value set defined by the FHIR project, that could be used to represent possible …
* Identity: [entformula-additive](CodeSystem-entformula-additive.md)
  * Name: Enteral Formula Additive Type Code
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: EnteralFormulaAdditiveType: Codes for the type of modular component such as protein, carbohydrate o…
* Identity: [episodeofcare-type](CodeSystem-episodeofcare-type.md)
  * Name: Episode of care type
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This example value set defines a set of codes that can be used to express the usage type of an Epis…
* Identity: [evidence-quality](CodeSystem-evidence-quality.md)
  * Name: QualityOfEvidenceRating
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: A rating system that describes the quality of evidence such as the GRADE, DynaMed, or Oxford CEBM s…
* Identity: [ex-USCLS](CodeSystem-ex-USCLS.md)
  * Name: USCLS Codes
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes a smattering of USCLS codes.
* Identity: [ex-benefitcategory](CodeSystem-ex-benefitcategory.md)
  * Name: Benefit Category Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes examples of Benefit Category codes.
* Identity: [ex-claimsubtype](CodeSystem-ex-claimsubtype.md)
  * Name: Example Claim SubType Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes sample Claim SubType codes which are used to distinguish the claim types fo…
* Identity: [ex-coverage-financi…](CodeSystem-ex-coverage-financial-exception.md)
  * Name: Example Coverage Financial Exception Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes Example Coverage Financial Exception Codes.
* Identity: [ex-diagnosis-on-adm…](CodeSystem-ex-diagnosis-on-admission.md)
  * Name: Example Diagnosis on Admission Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes example Diagnosis on Admission codes.
* Identity: [ex-diagnosisrelated…](CodeSystem-ex-diagnosisrelatedgroup.md)
  * Name: Example Diagnosis Related Group Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes example Diagnosis Related Group codes.
* Identity: [ex-diagnosistype](CodeSystem-ex-diagnosistype.md)
  * Name: Example Diagnosis Type Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes example Diagnosis Type codes.
* Identity: [ex-payee-resource-t…](CodeSystem-ex-payee-resource-type.md)
  * Name: ClaimPayeeResourceType
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: The type of Claim payee Resource.
* Identity: [ex-paymenttype](CodeSystem-ex-paymenttype.md)
  * Name: Example Payment Type Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes example Payment Type codes.
* Identity: [ex-procedure-type](CodeSystem-ex-procedure-type.md)
  * Name: Example Procedure Type Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes example Procedure Type codes.
* Identity: [ex-programcode](CodeSystem-ex-programcode.md)
  * Name: Example Program Reason Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes sample Program Reason Span codes.
* Identity: [ex-providerqualific…](CodeSystem-ex-providerqualification.md)
  * Name: Example Provider Qualification Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes sample Provider Qualification codes.
* Identity: [ex-relatedclaimrela…](CodeSystem-ex-relatedclaimrelationship.md)
  * Name: Example Related Claim Relationship Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes sample Related Claim Relationship codes.
* Identity: [ex-revenue-center](CodeSystem-ex-revenue-center.md)
  * Name: Example Revenue Center Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes sample Revenue Center codes.
* Identity: [ex-serviceplace](CodeSystem-ex-serviceplace.md)
  * Name: Example Service Place Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes a smattering of Service Place codes.
* Identity: [ex-tooth](CodeSystem-ex-tooth.md)
  * Name: Oral Site Codes
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes a smattering of FDI oral site codes.
* Identity: [ex-visionprescripti…](CodeSystem-ex-visionprescriptionproduct.md)
  * Name: Example Vision Prescription Product Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes a smattering of Prescription Product codes.
* Identity: [expansion-parameter…](CodeSystem-expansion-parameter-source.md)
  * Name: ExpansionParameterSource
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: Declares what the source of a parameter is.
* Identity: [expansion-processin…](CodeSystem-expansion-processing-rule.md)
  * Name: ExpansionProcessingRule
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: Defines how concepts are processed into the expansion when it's for UI presentation.
* Identity: [extra-security-role…](CodeSystem-extra-security-role-type.md)
  * Name: Security Role Type
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This CodeSystem contains Additional FHIR-defined Security Role types not defined elsewhere
* Identity: [failure-action](CodeSystem-failure-action.md)
  * Name: Failure-action
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The result if validation fails
* Identity: [financialtaskcode](CodeSystem-financialtaskcode.md)
  * Name: Financial Task Codes
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes Financial Task codes.
* Identity: [financialtaskinputt…](CodeSystem-financialtaskinputtype.md)
  * Name: Financial Task Input Type Codes
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes Financial Task Input Type codes.
* Identity: [flag-category](CodeSystem-flag-category.md)
  * Name: Flag Category
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: Example list of general categories for flagged issues. (Not complete or necessarily appropriate.)
* Identity: [forms-codes](CodeSystem-forms-codes.md)
  * Name: Form Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes a sample set of Forms codes.
* Identity: [fundsreserve](CodeSystem-fundsreserve.md)
  * Name: Funds Reservation Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes sample funds reservation type codes.
* Identity: [goal-acceptance-sta…](CodeSystem-goal-acceptance-status.md)
  * Name: GoalAcceptanceStatus
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: Codes indicating whether the goal has been accepted by a stakeholder.
* Identity: [goal-achievement](CodeSystem-goal-achievement.md)
  * Name: Goal achievement status
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: Describes the progression, or lack thereof, towards the goal against the target.
* Identity: [goal-category](CodeSystem-goal-category.md)
  * Name: Goal category
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: Codes for grouping goals to use for filtering or presentation.
* Identity: [goal-priority](CodeSystem-goal-priority.md)
  * Name: Goal priority
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: Indicates the level of importance associated with reaching or sustaining a goal.
* Identity: [goal-relationship-t…](CodeSystem-goal-relationship-type.md)
  * Name: GoalRelationshipType
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: Types of relationships between two goals.
* Identity: [guide-parameter-code](CodeSystem-guide-parameter-code.md)
  * Name: GuideParameterCode
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: Code of parameter that is input to the guide.
* Identity: [handling-condition](CodeSystem-handling-condition.md)
  * Name: HandlingConditionSet
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Set of handling instructions prior testing of the specimen.
* Identity: [history-absent-reas…](CodeSystem-history-absent-reason.md)
  * Name: FamilyHistoryAbsentReason
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Codes describing the reason why a family member's history is not available.
* Identity: [hl7-work-group](CodeSystem-hl7-work-group.md)
  * Name: HL7Workgroup
  * Version: 8.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org/)
  * Copyright: THO
  * Date: 2024-08-19
  * Description: An HL7 administrative unit that owns artifacts in the FHIR specification.
* Identity: [immunization-evalua…](CodeSystem-immunization-evaluation-dose-status.md)
  * Name: Immunization Evaluation Dose Status codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pher](http://www.hl7.org/Special/committees/pher)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: The value set to instantiate this attribute should be drawn from a terminologically robust code sys…
* Identity: [immunization-evalua…](CodeSystem-immunization-evaluation-dose-status-reason.md)
  * Name: Immunization Evaluation Dose Status Reason codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pher](http://www.hl7.org/Special/committees/pher)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: The value set to instantiate this attribute should be drawn from a terminologically robust code sys…
* Identity: [immunization-fundin…](CodeSystem-immunization-funding-source.md)
  * Name: Immunization Funding Source
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pher](http://www.hl7.org/Special/committees/pher)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: The value set to instantiate this attribute should be drawn from a terminologically robust code sys…
* Identity: [immunization-origin](CodeSystem-immunization-origin.md)
  * Name: Immunization Origin Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pher](http://www.hl7.org/Special/committees/pher)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: The value set to instantiate this attribute should be drawn from a terminologically robust code sys…
* Identity: [immunization-progra…](CodeSystem-immunization-program-eligibility.md)
  * Name: Immunization Program Eligibility
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pher](http://www.hl7.org/Special/committees/pher)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: The value set to instantiate this attribute should be drawn from a terminologically robust code sys…
* Identity: [immunization-recomm…](CodeSystem-immunization-recommendation-status.md)
  * Name: Immunization Recommendation Status Codes
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pher](http://www.hl7.org/Special/committees/pher)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: The value set to instantiate this attribute should be drawn from a terminologically robust code sys…
* Identity: [immunization-subpot…](CodeSystem-immunization-subpotent-reason.md)
  * Name: Immunization Subpotent Reason
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pher](http://www.hl7.org/Special/committees/pher)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: The value set to instantiate this attribute should be drawn from a terminologically robust code sys…
* Identity: [implantStatus](CodeSystem-implantStatus.md)
  * Name: Implant Status
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: A set codes that define the functional status of an implanted device.
* Identity: [insurance-coverage-…](CodeSystem-insurance-coverage-type.md)
  * Name: Insurance Coverage Type
  * Version: 1.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This code system defines a set of codes for Insurance CoverageType.
* Identity: [insurance-plan-type](CodeSystem-insurance-plan-type.md)
  * Name: Insurance plan type
  * Version: 2.0.1
  * Status: active
  * Content: fragment
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This example value set defines a set of codes that can be used to indicate a type of insurance plan.
* Identity: [insurance-product-t…](CodeSystem-insurance-product-type.md)
  * Name: Insurance Product Type
  * Version: 1.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This code system defines a set of codes for Insurance Product Type.
* Identity: [insuranceplan-plan-…](CodeSystem-insuranceplan-plan-type.md)
  * Name: Insuranceplan Plan Type
  * Version: 1.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This code system defines a set of codes for Insuranceplan Plan Type.
* Identity: [iso-21089-lifecycle](CodeSystem-iso-21089-lifecycle.md)
  * Name: ISO 21089 2017 Health Record Lifecycle Events
  * Version: 1.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: ISO
  * Date: 2025-11-12
  * Description: Attached is vocabulary for the 27 record lifecycle events, as per ISO TS 21089-2017, Health Informa…
* Identity: [library-type](CodeSystem-library-type.md)
  * Name: LibraryType
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The type of knowledge asset this library contains.
* Identity: [list-empty-reason](CodeSystem-list-empty-reason.md)
  * Name: List Empty Reasons
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [sd](http://www.hl7.org/Special/committees/structure)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: General reasons for a list to be empty. Reasons are either related to a summary list (i.e. problem …
* Identity: [list-example-use-co…](CodeSystem-list-example-use-codes.md)
  * Name: Example Use Codes for List
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: Example use codes for the List resource - typical kinds of use.
* Identity: [list-order](CodeSystem-list-order.md)
  * Name: List Order Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [sd](http://www.hl7.org/Special/committees/structure)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: Base values for the order of the items in a list resource.
* Identity: [location-physical-t…](CodeSystem-location-physical-type.md)
  * Name: Location type
  * Version: 2.0.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This example value set defines a set of codes that can be used to indicate the physical form of the…
* Identity: [match-grade](CodeSystem-match-grade.md)
  * Name: MatchGrade
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: A Master Patient Index (MPI) assessment of whether a candidate patient record is a match or not.
* Identity: [measure-data-usage](CodeSystem-measure-data-usage.md)
  * Name: MeasureDataUsage
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [cqi](http://www.hl7.org/Special/committees/cqi)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The intended usage for supplemental data elements in the measure.
* Identity: [measure-improvement…](CodeSystem-measure-improvement-notation.md)
  * Name: MeasureImprovementNotation
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [cqi](http://www.hl7.org/Special/committees/cqi)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Observation values that indicate what change in a measurement value or score is indicative of an im…
* Identity: [measure-population](CodeSystem-measure-population.md)
  * Name: Measure Population Type
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [cqi](http://www.hl7.org/Special/committees/cqi)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: The type of population.
* Identity: [measure-scoring](CodeSystem-measure-scoring.md)
  * Name: Measure Scoring
  * Version: 4.0.0
  * Status: active
  * Content: complete
  * Owner: [cqi](http://www.hl7.org/Special/committees/cqi)
  * Copyright: THO
  * Date: 2021-03-26
  * Description: The scoring type of the measure.
* Identity: [measure-type](CodeSystem-measure-type.md)
  * Name: MeasureType
  * Version: 3.0.1
  * Status: active
  * Content: complete
  * Owner: [cqi](http://www.hl7.org/Special/committees/cqi)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The type of measure (includes codes from 2.16.840.1.113883.1.11.20368).
* Identity: [med-admin-perform-f…](CodeSystem-med-admin-perform-function.md)
  * Name: MedicationAdministration Performer Function Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [phx](http://www.hl7.org/Special/committees/medication)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: MedicationAdministration Performer Function Codes
* Identity: [media-category](CodeSystem-media-category.md)
  * Name: Digital Media Category
  * Version: 4.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-05-17
  * Description: Codes for high level media types - whether the media is an image, video, or audio.
* Identity: [medical-management-…](CodeSystem-medical-management-type.md)
  * Name: Medical Management Type
  * Version: 1.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: Types of medical management requirements or processes used by health insurers (payers) that may imp…
* Identity: [medication-admin-lo…](CodeSystem-medication-admin-location.md)
  * Name: MedicationAdministration Location Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [phx](http://www.hl7.org/Special/committees/medication)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: MedicationAdministration Location Codes
* Identity: [medication-usage-ad…](CodeSystem-medication-usage-admin-location.md)
  * Name: MedicationUsage Administration Location Codes
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [phx](http://www.hl7.org/Special/committees/medication)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: MedicationUsage Administration Location Codes
* Identity: [medicationdispense-…](CodeSystem-medicationdispense-performer-function.md)
  * Name: MedicationDispense Performer Function Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [phx](http://www.hl7.org/Special/committees/medication)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: MedicationDispense Performer Function Codes
* Identity: [medicationknowledge…](CodeSystem-medicationknowledge-characteristic.md)
  * Name: MedicationKnowledge Characteristic Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [phx](http://www.hl7.org/Special/committees/medication)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: MedicationKnowledge Characteristic Codes
* Identity: [medicationknowledge…](CodeSystem-medicationknowledge-package-type.md)
  * Name: MedicationKnowledge Package Type Codes
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [phx](http://www.hl7.org/Special/committees/medication)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: MedicationKnowledge Package Type Codes
* Identity: [medicationknowledge…](CodeSystem-medicationknowledge-status.md)
  * Name: MedicationKnowledge Status Codes
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [phx](http://www.hl7.org/Special/committees/medication)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: MedicationKnowledge Status Codes
* Identity: [medicationrequest-a…](CodeSystem-medicationrequest-admin-location.md)
  * Name: Medication request administration location codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [phx](http://www.hl7.org/Special/committees/medication)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: MedicationRequest Administration Location Codes
* Identity: [medicationrequest-c…](CodeSystem-medicationrequest-category.md)
  * Name: MedicationRequest Category Codes
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: MedicationRequest Category Codes
* Identity: [medicationrequest-c…](CodeSystem-medicationrequest-course-of-therapy.md)
  * Name: MedicationRequest Course of Therapy Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [phx](http://www.hl7.org/Special/committees/medication)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: MedicationRequest Course of Therapy Codes
* Identity: [medicationrequest-s…](CodeSystem-medicationrequest-status-reason.md)
  * Name: MedicationRequest Status Reason Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [phx](http://www.hl7.org/Special/committees/medication)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: MedicationRequest Status Reason Codes
* Identity: [message-reasons-enc…](CodeSystem-message-reasons-encounter.md)
  * Name: Example Message Reason Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: Example Message Reasons. These are the set of codes that might be used an updating an encounter usi…
* Identity: [missingtoothreason](CodeSystem-missingtoothreason.md)
  * Name: Missing Tooth Reason Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes sample Missing Tooth Reason codes.
* Identity: [modifiers](CodeSystem-modifiers.md)
  * Name: Modifier type Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes sample Modifier type codes.
* Identity: [name-assembly-order](CodeSystem-name-assembly-order.md)
  * Name: HumanNameAssemblyOrder
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: A code that represents the preferred display order of the components of a human name.
* Identity: [ndh-healthcare-serv…](CodeSystem-ndh-healthcare-service-category.md)
  * Name: NDH Healthcare Service Category
  * Version: 1.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This code system defines a set of codes for NDH Healthcare Service Category used in the National Di…
* Identity: [need](CodeSystem-need.md)
  * Name: Need
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The frequency with which the target must be validated
* Identity: [nutrition-intake-ca…](CodeSystem-nutrition-intake-category.md)
  * Name: Nutrition intake category codes
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: NutritionIntake Category Codes
* Identity: [object-role](CodeSystem-object-role.md)
  * Name: AuditEventEntityRole
  * Version: 1.1.0
  * Status: active
  * Content: complete
  * Owner: [sec](http://www.hl7.org/Special/committees/secure)
  * Copyright: THO
  * Date: 2025-05-13
  * Description: Code representing the role the entity played in the audit event.
* Identity: [observation-category](CodeSystem-observation-category.md)
  * Name: Observation Category Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: Observation Category codes.
* Identity: [observation-statist…](CodeSystem-observation-statistics.md)
  * Name: StatisticsCode
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: The statistical operation parameter -"statistic" codes.
* Identity: [operation-outcome](CodeSystem-operation-outcome.md)
  * Name: Operation Outcome Codes
  * Version: 3.0.0
  * Status: draft
  * Content: complete
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: Operation Outcome codes used by FHIR test servers (see Implementation file translations.xml)
* Identity: [organization-affili…](CodeSystem-organization-affiliation-role.md)
  * Name: Organization Affiliation Role
  * Version: 1.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This code system defines a set of codes that can be used to indicate an organization affiliation ro…
* Identity: [organization-affili…](CodeSystem-organization-affiliation-role-for-hie.md)
  * Name: Organization Affiliation Role for HIE
  * Version: 1.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This code system defines a set of codes that can be used to indicate an organization affiliation ro…
* Identity: [organization-alias-…](CodeSystem-organization-alias-type.md)
  * Name: Organization Alias Type
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This code system defines a set of codes for indicating oranization alias type.
* Identity: [organization-type](CodeSystem-organization-type.md)
  * Name: Organization type
  * Version: 2.0.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This example value set defines a set of codes that can be used to indicate a type of organization.
* Identity: [parameter-group](CodeSystem-parameter-group.md)
  * Name: DeviceDefinitionParameterGroup
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: Codes identifying groupings of parameters; e.g. Cardiovascular.
* Identity: [participant-type](CodeSystem-participant-type.md)
  * Name: Participant type
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set defines a set of codes that can be used to indicate how an individual participates i…
* Identity: [payeetype](CodeSystem-payeetype.md)
  * Name: Payee Type Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: Codes indicating the type of party to be reimbursed for cost of products and services.
* Identity: [payment-adjustment-…](CodeSystem-payment-adjustment-reason.md)
  * Name: Payment Adjustment Reason Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes smattering of Payment Adjustment Reason codes.
* Identity: [payment-type](CodeSystem-payment-type.md)
  * Name: Payment Type Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes sample Payment Type codes.
* Identity: [paymentstatus](CodeSystem-paymentstatus.md)
  * Name: Payment Status Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes a sample set of Payment Status codes.
* Identity: [plan-definition-type](CodeSystem-plan-definition-type.md)
  * Name: PlanDefinitionType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The type of PlanDefinition.
* Identity: [practitioner-role](CodeSystem-practitioner-role.md)
  * Name: Practitioner role
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This example value set defines a set of codes that can be used to indicate the role of a Practition…
* Identity: [primary-source-type](CodeSystem-primary-source-type.md)
  * Name: Primary-source-type
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Type of the validation primary source
* Identity: [procedure-type](CodeSystem-procedure-type.md)
  * Name: Procedure Type Codes
  * Version: 1.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes Procedure Type codes.
* Identity: [processpriority](CodeSystem-processpriority.md)
  * Name: Process Priority Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes the financial processing priority codes.
* Identity: [professional-creden…](CodeSystem-professional-credential-status.md)
  * Name: Professional Credential Status
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This code system establishes a series of codes designed to represent the status of professional cre…
* Identity: [program](CodeSystem-program.md)
  * Name: Program
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set defines an example set of codes that could be can be used to classify groupings of s…
* Identity: [provenance-particip…](CodeSystem-provenance-participant-type.md)
  * Name: Provenance participant type
  * Version: 1.1.0
  * Status: active
  * Content: complete
  * Owner: [sec](http://www.hl7.org/Special/committees/secure)
  * Copyright: THO
  * Date: 2024-06-28
  * Description: These codes define the type of participation by an agent in a provenance activity. An agent is some…
* Identity: [published-in-type](CodeSystem-published-in-type.md)
  * Name: Published In Type
  * Version: 1.0.0
  * Status: trial-use
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: The type of publication such as book, database, or journal.
* Identity: [push-type-available](CodeSystem-push-type-available.md)
  * Name: Push-type-available
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Type of alerts/updates the primary source can send
* Identity: [question-max-occurs](CodeSystem-question-max-occurs.md)
  * Name: MaxOccurs
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: Flags an element as having unlimited repetitions.
* Identity: [questionnaire-usage…](CodeSystem-questionnaire-usage-mode.md)
  * Name: QuestionnaireItemUsageMode
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: Identifies the modes of usage of a questionnaire that should enable a particular questionnaire item.
* Identity: [reaction-event-cert…](CodeSystem-reaction-event-certainty.md)
  * Name: AllergyIntoleranceCertainty
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: Statement about the degree of clinical certainty that a specific substance was the cause of the man…
* Identity: [reason-medication-g…](CodeSystem-reason-medication-given.md)
  * Name: Reason Medication Given Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [phx](http://www.hl7.org/Special/committees/medication)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set is provided as an example. The value set to instantiate this attribute should be dra…
* Identity: [recommendation-stre…](CodeSystem-recommendation-strength.md)
  * Name: StrengthOfRecommendationRating
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: A rating system that describes the strength of the recommendation, such as the GRADE, DynaMed, or H…
* Identity: [referencerange-mean…](CodeSystem-referencerange-meaning.md)
  * Name: Observation Reference Range Meaning Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set defines a set of codes that can be used to indicate the meaning/use of a reference r…
* Identity: [rejection-criteria](CodeSystem-rejection-criteria.md)
  * Name: RejectionCriterion
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Criterion for rejection of the specimen by laboratory.
* Identity: [research-study-obje…](CodeSystem-research-study-objective-type.md)
  * Name: ResearchStudyObjectiveType
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [brr](http://www.hl7.org/Special/committees/rcrim)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: Codes for the kind of study objective.
* Identity: [research-study-phase](CodeSystem-research-study-phase.md)
  * Name: ResearchStudyPhase
  * Version: 1.0.0
  * Status: active
  * Content: complete
  * Owner: [brr](http://www.hl7.org/Special/committees/rcrim)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: Codes for the stage in the progression of a therapy from initial experimental use in humans in clin…
* Identity: [research-study-prim…](CodeSystem-research-study-prim-purp-type.md)
  * Name: ResearchStudyPrimaryPurposeType
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [brr](http://www.hl7.org/Special/committees/rcrim)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: Codes for the main intent of the study.
* Identity: [research-study-reas…](CodeSystem-research-study-reason-stopped.md)
  * Name: ResearchStudyReasonStopped
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [brr](http://www.hl7.org/Special/committees/rcrim)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: Codes for why the study ended prematurely.
* Identity: [research-subject-mi…](CodeSystem-research-subject-milestone.md)
  * Name: ResearchSubjectMilestone
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [brr](http://www.hl7.org/Special/committees/rcrim)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Indicates the progression of a study subject through the study milestones.
* Identity: [research-subject-st…](CodeSystem-research-subject-state.md)
  * Name: ResearchSubjectState
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [brr](http://www.hl7.org/Special/committees/rcrim)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Indicates the progression of a study subject through a study.
* Identity: [research-subject-st…](CodeSystem-research-subject-state-type.md)
  * Name: ResearchSubjectStateType
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [brr](http://www.hl7.org/Special/committees/rcrim)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Identifies the kind of state being refered to.
* Identity: [resource-security-c…](CodeSystem-resource-security-category.md)
  * Name: ResourceSecurityCategory
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: Provides general guidance around the kind of access Control to Read, Search, Create, Update, or Del…
* Identity: [resource-type-link](CodeSystem-resource-type-link.md)
  * Name: PayeeResourceType
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: The type of payee Resource.
* Identity: [risk-probability](CodeSystem-risk-probability.md)
  * Name: Risk Probability
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: Codes representing the likelihood of a particular outcome in a risk assessment.
* Identity: [security-source-type](CodeSystem-security-source-type.md)
  * Name: Audit Event Source Type
  * Version: 1.0.0
  * Status: active
  * Content: complete
  * Owner: [sec](http://www.hl7.org/Special/committees/secure)
  * Copyright: THO
  * Date: 2010-08-26
  * Description: The type of process where the audit event originated from.
* Identity: [service-category](CodeSystem-service-category.md)
  * Name: Service category
  * Version: 1.1.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set defines an example set of codes that can be used to classify groupings of service-ty…
* Identity: [service-delivery-me…](CodeSystem-service-delivery-method.md)
  * Name: Service Delivery Method
  * Version: 1.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This code system defines a set of codes that can be used to indicate service delivery method
* Identity: [service-provision-c…](CodeSystem-service-provision-conditions.md)
  * Name: ServiceProvisionConditions
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The code(s) that detail the conditions under which the healthcare service is available/offered.
* Identity: [service-referral-me…](CodeSystem-service-referral-method.md)
  * Name: ReferralMethod
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The methods of referral can be used when referring to a specific HealthCareService resource.
* Identity: [service-type](CodeSystem-service-type.md)
  * Name: Service type
  * Version: 1.1.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set defines an example set of codes of service-types.
* Identity: [sex-parameter-for-c…](CodeSystem-sex-parameter-for-clinical-use.md)
  * Name: Sex Parameter For Clinical Use
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: A summary parameter that provides guidance on how a receiver should apply settings or reference ran…
* Identity: [smart-capabilities](CodeSystem-smart-capabilities.md)
  * Name: SmartCapabilities
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Codes that define what the server is capable of.
* Identity: [software-system-typ…](CodeSystem-software-system-type-codes.md)
  * Name: Software System Type Codes
  * Version: 1.0.0
  * Status: trial-use
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: THO
  * Date: 2024-02-16
  * Description: Types of software systems that support knowledge artifact authoring and evaluation (authoring, test…
* Identity: [special-values](CodeSystem-special-values.md)
  * Name: SpecialValues
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: A set of generally useful codes defined so they can be included in value sets.
* Identity: [standards-status](CodeSystem-standards-status.md)
  * Name: StandardsStatus
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: HL7 Ballot/Standards status of artifact.
* Identity: [state-change-reason](CodeSystem-state-change-reason.md)
  * Name: StateChangeReason
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [brr](http://www.hl7.org/Special/committees/rcrim)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: Indicates why the state of the subject changed.
* Identity: [statistic-model-code](CodeSystem-statistic-model-code.md)
  * Name: Statistic Model Code
  * Version: 1.0.0
  * Status: trial-use
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: The role that the assertion variable plays.
* Identity: [statistic-type](CodeSystem-statistic-type.md)
  * Name: StatisticStatisticType
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The type of a specific statistic.
* Identity: [study-type](CodeSystem-study-type.md)
  * Name: StatisticStudyType
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: The type of study a statistic was derived from.
* Identity: [subscriber-relation…](CodeSystem-subscriber-relationship.md)
  * Name: SubscriberPolicyholder Relationship Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set includes codes for the relationship between the Subscriber and the Beneficiary (insu…
* Identity: [subscription-channe…](CodeSystem-subscription-channel-type.md)
  * Name: SubscriptionChannel Type Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: The type of method used to execute a subscription
* Identity: [subscription-error](CodeSystem-subscription-error.md)
  * Name: Subscription Error Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: Codes to represent subscription error details
* Identity: [subscription-status…](CodeSystem-subscription-status-at-event.md)
  * Name: SubscriptionStatusAtEvent
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: A status code for the state of the Subscription.
* Identity: [subscription-tag](CodeSystem-subscription-tag.md)
  * Name: SubscriptionTag
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: Tags to put on a resource after subscriptions have been sent.
* Identity: [substance-category](CodeSystem-substance-category.md)
  * Name: Substance Category Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: Substance category codes
* Identity: [supply-item-type](CodeSystem-supply-item-type.md)
  * Name: Supply Item Type
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value sets refers to a specific supply item.
* Identity: [supply-kind](CodeSystem-supply-kind.md)
  * Name: Supply Type
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value sets refers to a Category of supply.
* Identity: [supplyrequest-reason](CodeSystem-supplyrequest-reason.md)
  * Name: SupplyRequestReason
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The reason why the supply item was requested.
* Identity: [synthesis-type](CodeSystem-synthesis-type.md)
  * Name: StatisticSynthesisType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: Types of combining results from a body of evidence (eg. summary data meta-analysis).
* Identity: [testscript-operatio…](CodeSystem-testscript-operation-codes.md)
  * Name: Test script operation code
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set defines a set of codes that are used to indicate the supported operations of a testi…
* Identity: [testscript-profile-…](CodeSystem-testscript-profile-destination-types.md)
  * Name: Test script profile destination type
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set defines a set of codes that are used to indicate the profile type of a test system w…
* Identity: [testscript-profile-…](CodeSystem-testscript-profile-origin-types.md)
  * Name: Test script profile origin type
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This value set defines a set of codes that are used to indicate the profile type of a test system w…
* Identity: [title-type](CodeSystem-title-type.md)
  * Name: Title Type
  * Version: 1.0.0
  * Status: trial-use
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: Used to express the reason and specific aspect for the variant title, such as language and specific…
* Identity: [usage-context-type](CodeSystem-usage-context-type.md)
  * Name: UsageContextType
  * Version: 2.0.1
  * Status: active
  * Content: complete
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: A code that specifies a type of context being specified by a usage context.
* Identity: [validation-process](CodeSystem-validation-process.md)
  * Name: Validation-process
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The primary process by which the target is validated
* Identity: [validation-status](CodeSystem-validation-status.md)
  * Name: Validation-status
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Status of the validation of the target against the primary source
* Identity: [validation-type](CodeSystem-validation-type.md)
  * Name: Validation-type
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: What the target is validated against
* Identity: [variable-role](CodeSystem-variable-role.md)
  * Name: EvidenceVariableRole
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The role that the assertion variable plays.
* Identity: [variable-role-subty…](CodeSystem-variable-role-subtype.md)
  * Name: EvidenceVariableRoleSubtype
  * Version: 1.0.0
  * Status: active
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The subclassification of the role that the assertion variable plays.
* Identity: [variant-state](CodeSystem-variant-state.md)
  * Name: sequenceStatus
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: Codes providing the status of the variant test result.
* Identity: [verificationresult-…](CodeSystem-verificationresult-communication-method.md)
  * Name: VerificationResult Communication Method
  * Version: 1.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2018-10-31
  * Description: Attested information may be validated by process that are manual or automated. For automated proces…
* Identity: [virtual-healthcare-…](CodeSystem-virtual-healthcare-delivery-method.md)
  * Name: Virtual Healthcare Delivery Method
  * Version: 1.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-12
  * Description: This code system defines a set of codes for virtual healthcare service delivery method.

Showing 274 of 274 entries

