# x_ActBillableCode - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **x_ActBillableCode**

## ValueSet: x_ActBillableCode 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/v3-xActBillableCode | *Version*:3.0.0 | |
| Active as of 2014-03-26 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:XActBillableCode |
| *Other Identifiers:*OID:2.16.840.1.113883.1.11.19820 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
****No description**** 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

Language: en

This value set includes codes based on the following rules:

* Import all the codes that are contained in [ActEncounterCode](ValueSet-v3-ActEncounterCode.md)
* Import all the codes that are contained in [ActEncounterAccommodationCode](ValueSet-v3-ActEncounterAccommodationCode.md)
* Import all the codes that are contained in [ObservationType](ValueSet-v3-ObservationType.md)
* Import all the codes that are contained in [ActTransportationModeCode](ValueSet-v3-ActTransportationModeCode.md)

This value set excludes codes based on the following rules:

* Exclude these codes as defined in [`http://terminology.hl7.org/CodeSystem/v3-ActCode`](http://tx.fhir.org/r5)version ⏿9.0.0

 

### Expansion

Expansion from tx.fhir.org based on:

* [codesystem ActCode v9.0.0 (CodeSystem)](http://tx.fhir.org/r5/ValueSet/v3-ActCode)
* [valueset ActEncounterAccommodationCode v3.0.0 (ValueSet)](ValueSet-v3-ActEncounterAccommodationCode.md)
* [valueset ActEncounterCode v3.0.0 (ValueSet)](ValueSet-v3-ActEncounterCode.md)
* [valueset ActTransportationModeCode v3.0.0 (ValueSet)](ValueSet-v3-ActTransportationModeCode.md)
* [valueset ObservationDiagnosisTypes v3.0.0 (ValueSet)](ValueSet-v3-ObservationDiagnosisTypes.md)
* [valueset ObservationType v3.0.0 (ValueSet)](ValueSet-v3-ObservationType.md)

This value set contains 329 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v3-xActBillableCode",
  "language" : "en",
  "url" : "http://terminology.hl7.org/ValueSet/v3-xActBillableCode",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.1.11.19820"
    }
  ],
  "version" : "3.0.0",
  "name" : "XActBillableCode",
  "title" : "x_ActBillableCode",
  "status" : "active",
  "experimental" : false,
  "date" : "2014-03-26",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "***No description***",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "valueSet" : ["http://terminology.hl7.org/ValueSet/v3-ActEncounterCode"]
      },
      {
        "valueSet" : [
          "http://terminology.hl7.org/ValueSet/v3-ActEncounterAccommodationCode"
        ]
      },
      {
        "valueSet" : ["http://terminology.hl7.org/ValueSet/v3-ObservationType"]
      },
      {
        "valueSet" : [
          "http://terminology.hl7.org/ValueSet/v3-ActTransportationModeCode"
        ]
      }
    ],
    "exclude" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
        "concept" : [
          {
            "code" : "_ActTransportationModeCode"
          }
        ]
      }
    ]
  }
}

```
