# SecurityDataIntegrityObservationValue - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SecurityDataIntegrityObservationValue**

## ValueSet: SecurityDataIntegrityObservationValue 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/v3-SecurityDataIntegrityObservationValue | *Version*:3.1.0 | |
| Active as of 2024-02-28 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:SecurityDataIntegrityObservationValue |
| *Other Identifiers:*OID:2.16.840.1.113883.1.11.20483 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Type of security metadata observation made about the data integrity of an IT resource (data, information object, service, or system capability), which indicates the security mechanism used to preserve resource accuracy and consistency. Data integrity is defined by ISO 22600-23.3.21 as: "The property that data has not been altered or destroyed in an unauthorized manner", and by ISO/IEC 2382-8: The property of data whose accuracy and consistency are preserved regardless of changes made." 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

Language: en

* Include codes from[`http://terminology.hl7.org/CodeSystem/v3-ObservationValue`](CodeSystem-v3-ObservationValue.md)version 📦4.0.0 where concept is-a [_SECDATINTOBV](CodeSystem-v3-ObservationValue.md#v3-ObservationValue-_SECDATINTOBV)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v3-SecurityDataIntegrityObservationValue",
  "language" : "en",
  "url" : "http://terminology.hl7.org/ValueSet/v3-SecurityDataIntegrityObservationValue",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.1.11.20483"
    }
  ],
  "version" : "3.1.0",
  "name" : "SecurityDataIntegrityObservationValue",
  "title" : "SecurityDataIntegrityObservationValue",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-02-28",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Type of security metadata observation made about the data integrity of an IT resource (data, information object, service, or system capability), which indicates the security mechanism used to preserve resource accuracy and consistency. Data integrity is defined by ISO 22600-23.3.21 as: \"The property that data has not been altered or destroyed in an unauthorized manner\", and by ISO/IEC 2382-8: The property of data whose accuracy and consistency are preserved regardless of changes made.\"",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationValue",
        "filter" : [
          {
            "property" : "concept",
            "op" : "is-a",
            "value" : "_SECDATINTOBV"
          }
        ]
      }
    ]
  }
}

```
