# ObservationMethod - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ObservationMethod**

## ValueSet: ObservationMethod 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/v3-ObservationMethod | *Version*:3.0.0 | |
| Active as of 2014-03-26 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ObservationMethod |
| *Other Identifiers:*OID:2.16.840.1.113883.1.11.14079 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
A code that provides additional detail about the means or technique used to ascertain the observation. 
**Examples:**Blood pressure measurement method: arterial puncture vs. sphygmomanometer (Riva-Rocci), sitting vs. supine position, etc. 
**Constraints:**In all observations the method is already partially specified by the Act.code. In this case, the methodCode NEED NOT be used at all. The methodCode MAY still be used to identify this method more clearly in addition to what is implied from the Act.code. However, an information consumer system or process SHOULD NOT depend on this methodCode information for method detail that is implied by the Act.code. 
If the methodCode is used to express method detail that is also implied by the Act.code, the methodCode MUST NOT be in conflict with the implied method of the Act.code. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

This value set contains 289 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v3-ObservationMethod",
  "language" : "en",
  "url" : "http://terminology.hl7.org/ValueSet/v3-ObservationMethod",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.1.11.14079"
    }
  ],
  "version" : "3.0.0",
  "name" : "ObservationMethod",
  "title" : "ObservationMethod",
  "status" : "active",
  "experimental" : false,
  "date" : "2014-03-26",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "A code that provides additional detail about the means or technique used to ascertain the observation.\r\n\r\n*Examples:* Blood pressure measurement method: arterial puncture vs. sphygmomanometer (Riva-Rocci), sitting vs. supine position, etc.\r\n\r\n*Constraints:* In all observations the method is already partially specified by the Act.code. In this case, the methodCode NEED NOT be used at all. The methodCode MAY still be used to identify this method more clearly in addition to what is implied from the Act.code. However, an information consumer system or process SHOULD NOT depend on this methodCode information for method detail that is implied by the Act.code.\r\n\r\nIf the methodCode is used to express method detail that is also implied by the Act.code, the methodCode MUST NOT be in conflict with the implied method of the Act.code.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationMethod",
        "concept" : [
          {
            "code" : "0001"
          },
          {
            "code" : "0002"
          },
          {
            "code" : "0003"
          },
          {
            "code" : "0004"
          },
          {
            "code" : "0005"
          },
          {
            "code" : "0006"
          },
          {
            "code" : "0007"
          },
          {
            "code" : "0008"
          },
          {
            "code" : "0009"
          },
          {
            "code" : "0010"
          },
          {
            "code" : "0011"
          },
          {
            "code" : "0012"
          },
          {
            "code" : "0013"
          },
          {
            "code" : "0014"
          },
          {
            "code" : "0015"
          },
          {
            "code" : "0016"
          },
          {
            "code" : "0017"
          },
          {
            "code" : "0018"
          },
          {
            "code" : "0019"
          },
          {
            "code" : "0020"
          },
          {
            "code" : "0021"
          },
          {
            "code" : "0022"
          },
          {
            "code" : "0023"
          },
          {
            "code" : "0024"
          },
          {
            "code" : "0025"
          },
          {
            "code" : "0026"
          },
          {
            "code" : "0027"
          },
          {
            "code" : "0028"
          },
          {
            "code" : "0029"
          },
          {
            "code" : "0030"
          },
          {
            "code" : "0031"
          },
          {
            "code" : "0032"
          },
          {
            "code" : "0033"
          },
          {
            "code" : "0034"
          },
          {
            "code" : "0035"
          },
          {
            "code" : "0036"
          },
          {
            "code" : "0037"
          },
          {
            "code" : "0038"
          },
          {
            "code" : "0039"
          },
          {
            "code" : "0040"
          },
          {
            "code" : "0041"
          },
          {
            "code" : "0042"
          },
          {
            "code" : "0043"
          },
          {
            "code" : "0044"
          },
          {
            "code" : "0045"
          },
          {
            "code" : "0046"
          },
          {
            "code" : "0047"
          },
          {
            "code" : "0048"
          },
          {
            "code" : "0049"
          },
          {
            "code" : "0050"
          },
          {
            "code" : "0051"
          },
          {
            "code" : "0052"
          },
          {
            "code" : "0053"
          },
          {
            "code" : "0054"
          },
          {
            "code" : "0055"
          },
          {
            "code" : "0056"
          },
          {
            "code" : "0057"
          },
          {
            "code" : "0058"
          },
          {
            "code" : "0059"
          },
          {
            "code" : "0060"
          },
          {
            "code" : "0061"
          },
          {
            "code" : "0062"
          },
          {
            "code" : "0063"
          },
          {
            "code" : "0064"
          },
          {
            "code" : "0065"
          },
          {
            "code" : "0066"
          },
          {
            "code" : "0067"
          },
          {
            "code" : "0068"
          },
          {
            "code" : "0069"
          },
          {
            "code" : "0070"
          },
          {
            "code" : "0071"
          },
          {
            "code" : "0072"
          },
          {
            "code" : "0073"
          },
          {
            "code" : "0074"
          },
          {
            "code" : "0075"
          },
          {
            "code" : "0076"
          },
          {
            "code" : "0077"
          },
          {
            "code" : "0078"
          },
          {
            "code" : "0079"
          },
          {
            "code" : "0080"
          },
          {
            "code" : "0081"
          },
          {
            "code" : "0082"
          },
          {
            "code" : "0083"
          },
          {
            "code" : "0084"
          },
          {
            "code" : "0085"
          },
          {
            "code" : "0086"
          },
          {
            "code" : "0087"
          },
          {
            "code" : "0088"
          },
          {
            "code" : "0089"
          },
          {
            "code" : "0090"
          },
          {
            "code" : "0091"
          },
          {
            "code" : "0092"
          },
          {
            "code" : "0093"
          },
          {
            "code" : "0094"
          },
          {
            "code" : "0095"
          },
          {
            "code" : "0096"
          },
          {
            "code" : "0097"
          },
          {
            "code" : "0098"
          },
          {
            "code" : "0099"
          },
          {
            "code" : "0100"
          },
          {
            "code" : "0101"
          },
          {
            "code" : "0102"
          },
          {
            "code" : "0103"
          },
          {
            "code" : "0104"
          },
          {
            "code" : "0105"
          },
          {
            "code" : "0106"
          },
          {
            "code" : "0107"
          },
          {
            "code" : "0108"
          },
          {
            "code" : "0109"
          },
          {
            "code" : "0110"
          },
          {
            "code" : "0111"
          },
          {
            "code" : "0112"
          },
          {
            "code" : "0113"
          },
          {
            "code" : "0114"
          },
          {
            "code" : "0115"
          },
          {
            "code" : "0116"
          },
          {
            "code" : "0117"
          },
          {
            "code" : "0118"
          },
          {
            "code" : "0119"
          },
          {
            "code" : "0120"
          },
          {
            "code" : "0121"
          },
          {
            "code" : "0122"
          },
          {
            "code" : "0123"
          },
          {
            "code" : "0124"
          },
          {
            "code" : "0125"
          },
          {
            "code" : "0126"
          },
          {
            "code" : "0127"
          },
          {
            "code" : "0128"
          },
          {
            "code" : "0129"
          },
          {
            "code" : "0130"
          },
          {
            "code" : "0131"
          },
          {
            "code" : "0132"
          },
          {
            "code" : "0133"
          },
          {
            "code" : "0134"
          },
          {
            "code" : "0135"
          },
          {
            "code" : "0136"
          },
          {
            "code" : "0137"
          },
          {
            "code" : "0138"
          },
          {
            "code" : "0139"
          },
          {
            "code" : "0140"
          },
          {
            "code" : "0141"
          },
          {
            "code" : "0142"
          },
          {
            "code" : "0143"
          },
          {
            "code" : "0144"
          },
          {
            "code" : "0145"
          },
          {
            "code" : "0146"
          },
          {
            "code" : "0147"
          },
          {
            "code" : "0148"
          },
          {
            "code" : "0149"
          },
          {
            "code" : "0150"
          },
          {
            "code" : "0151"
          },
          {
            "code" : "0152"
          },
          {
            "code" : "0153"
          },
          {
            "code" : "0154"
          },
          {
            "code" : "0155"
          },
          {
            "code" : "0156"
          },
          {
            "code" : "0157"
          },
          {
            "code" : "0158"
          },
          {
            "code" : "0159"
          },
          {
            "code" : "0160"
          },
          {
            "code" : "0161"
          },
          {
            "code" : "0162"
          },
          {
            "code" : "0163"
          },
          {
            "code" : "0164"
          },
          {
            "code" : "0165"
          },
          {
            "code" : "0166"
          },
          {
            "code" : "0167"
          },
          {
            "code" : "0168"
          },
          {
            "code" : "0169"
          },
          {
            "code" : "0170"
          },
          {
            "code" : "0171"
          },
          {
            "code" : "0172"
          },
          {
            "code" : "0173"
          },
          {
            "code" : "0174"
          },
          {
            "code" : "0175"
          },
          {
            "code" : "0176"
          },
          {
            "code" : "0177"
          },
          {
            "code" : "0178"
          },
          {
            "code" : "0179"
          },
          {
            "code" : "0180"
          },
          {
            "code" : "0181"
          },
          {
            "code" : "0182"
          },
          {
            "code" : "0183"
          },
          {
            "code" : "0184"
          },
          {
            "code" : "0185"
          },
          {
            "code" : "0186"
          },
          {
            "code" : "0187"
          },
          {
            "code" : "0188"
          },
          {
            "code" : "0189"
          },
          {
            "code" : "0190"
          },
          {
            "code" : "0191"
          },
          {
            "code" : "0192"
          },
          {
            "code" : "0193"
          },
          {
            "code" : "0194"
          },
          {
            "code" : "0195"
          },
          {
            "code" : "0196"
          },
          {
            "code" : "0197"
          },
          {
            "code" : "0198"
          },
          {
            "code" : "0199"
          },
          {
            "code" : "0200"
          },
          {
            "code" : "0201"
          },
          {
            "code" : "0202"
          },
          {
            "code" : "0203"
          },
          {
            "code" : "0204"
          },
          {
            "code" : "0205"
          },
          {
            "code" : "0206"
          },
          {
            "code" : "0207"
          },
          {
            "code" : "0208"
          },
          {
            "code" : "0209"
          },
          {
            "code" : "0210"
          },
          {
            "code" : "0211"
          },
          {
            "code" : "0212"
          },
          {
            "code" : "0213"
          },
          {
            "code" : "0214"
          },
          {
            "code" : "0215"
          },
          {
            "code" : "0216"
          },
          {
            "code" : "0217"
          },
          {
            "code" : "0218"
          },
          {
            "code" : "0219"
          },
          {
            "code" : "0220"
          },
          {
            "code" : "0221"
          },
          {
            "code" : "0222"
          },
          {
            "code" : "0223"
          },
          {
            "code" : "0224"
          },
          {
            "code" : "0225"
          },
          {
            "code" : "0226"
          },
          {
            "code" : "0227"
          },
          {
            "code" : "0228"
          },
          {
            "code" : "0229"
          },
          {
            "code" : "0230"
          },
          {
            "code" : "0231"
          },
          {
            "code" : "0232"
          },
          {
            "code" : "0233"
          },
          {
            "code" : "0234"
          },
          {
            "code" : "0235"
          },
          {
            "code" : "0236"
          },
          {
            "code" : "0237"
          },
          {
            "code" : "0238"
          },
          {
            "code" : "0239"
          },
          {
            "code" : "0240"
          },
          {
            "code" : "0241"
          },
          {
            "code" : "0242"
          },
          {
            "code" : "0243"
          },
          {
            "code" : "0244"
          },
          {
            "code" : "0245"
          },
          {
            "code" : "0246"
          },
          {
            "code" : "0247"
          },
          {
            "code" : "0248"
          },
          {
            "code" : "0249"
          },
          {
            "code" : "0250"
          },
          {
            "code" : "0251"
          },
          {
            "code" : "0252"
          },
          {
            "code" : "0253"
          },
          {
            "code" : "0254"
          },
          {
            "code" : "0255"
          },
          {
            "code" : "0256"
          },
          {
            "code" : "0257"
          },
          {
            "code" : "0258"
          },
          {
            "code" : "0259"
          },
          {
            "code" : "0260"
          },
          {
            "code" : "0261"
          },
          {
            "code" : "0262"
          },
          {
            "code" : "0263"
          },
          {
            "code" : "0264"
          },
          {
            "code" : "0265"
          },
          {
            "code" : "0266"
          },
          {
            "code" : "0267"
          },
          {
            "code" : "0268"
          },
          {
            "code" : "0269"
          },
          {
            "code" : "0270"
          },
          {
            "code" : "0271"
          }
        ]
      },
      {
        "valueSet" : [
          "http://terminology.hl7.org/ValueSet/v3-xAdverseEventCausalityAssessmentMethods"
        ]
      },
      {
        "valueSet" : ["http://terminology.hl7.org/ValueSet/v3-tst0272"]
      },
      {
        "valueSet" : ["http://terminology.hl7.org/ValueSet/v3-tst0275a"]
      },
      {
        "valueSet" : ["http://terminology.hl7.org/ValueSet/v3-tst0280"]
      },
      {
        "valueSet" : [
          "http://terminology.hl7.org/ValueSet/v3-DecisionObservationMethod"
        ]
      },
      {
        "valueSet" : ["http://terminology.hl7.org/ValueSet/v3-VerificationMethod"]
      },
      {
        "valueSet" : [
          "http://terminology.hl7.org/ValueSet/v3-GeneticObservationMethod"
        ]
      }
    ],
    "exclude" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationMethod",
        "concept" : [
          {
            "code" : "_VerificationMethod"
          }
        ]
      },
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationMethod",
        "concept" : [
          {
            "code" : "_GeneticObservationMethod"
          }
        ]
      }
    ]
  }
}

```
