# KnowledgeSubtopicObservationValue - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **KnowledgeSubtopicObservationValue**

## ValueSet: KnowledgeSubtopicObservationValue 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/v3-KnowledgeSubtopicObservationValue | *Version*:4.0.0 | |
| Active as of 2010-03-16 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:KnowledgeSubtopicObservationValue |
| *Other Identifiers:*OID:2.16.840.1.113883.11.77 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Observation values used to indicate a knowledge subtopic of interest for which knowledge content is requested (e.g., treatment, etiology, prognosis). 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

No Expansion for this valueset (not supported by Publication Tooling)

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v3-KnowledgeSubtopicObservationValue",
  "url" : "http://terminology.hl7.org/ValueSet/v3-KnowledgeSubtopicObservationValue",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.11.77"
    }
  ],
  "version" : "4.0.0",
  "name" : "KnowledgeSubtopicObservationValue",
  "title" : "KnowledgeSubtopicObservationValue",
  "status" : "active",
  "experimental" : false,
  "date" : "2010-03-16",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Observation values used to indicate a knowledge subtopic of interest for which knowledge content is requested (e.g., treatment, etiology, prognosis).",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "https://www.nlm.nih.gov/mesh",
        "concept" : [
          {
            "code" : "Q000008"
          },
          {
            "code" : "Q000744"
          },
          {
            "code" : "Q000009"
          },
          {
            "code" : "D004347"
          },
          {
            "code" : "Q000145"
          },
          {
            "code" : "Q000209"
          },
          {
            "code" : "Q000175"
          },
          {
            "code" : "Q000628"
          },
          {
            "code" : "D011379"
          },
          {
            "code" : "Q000627"
          },
          {
            "code" : "Q000493"
          },
          {
            "code" : "Q000494"
          },
          {
            "code" : "Q000633"
          },
          {
            "code" : "Q000506"
          }
        ]
      },
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "79899007"
          },
          {
            "code" : "47965005"
          },
          {
            "code" : "404204005"
          },
          {
            "code" : "95907004"
          },
          {
            "code" : "95906008"
          }
        ]
      }
    ]
  }
}

```
