# AdministrableDrugForm - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **AdministrableDrugForm**

## ValueSet: AdministrableDrugForm 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/v3-AdministrableDrugForm | *Version*:3.0.0 | |
| Active as of 2014-03-26 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:AdministrableDrugForm |
| *Other Identifiers:*OID:2.16.840.1.113883.1.11.14570 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Indicates the form in which the drug product should be administered. 
This element only needs to be specified when (a) the form in which the drug is measured for dispensing differs from the form in which the drug is administered; and (b) the form in which the quantity of the administered drug being administered is not expressed as a discrete measured mass or volume.**Usage:** 

 **References** 

* Included into [OrderableDrugForm](ValueSet-v3-OrderableDrugForm.md)

### Logical Definition (CLD)

 

### Expansion

This value set contains 9 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v3-AdministrableDrugForm",
  "language" : "en",
  "url" : "http://terminology.hl7.org/ValueSet/v3-AdministrableDrugForm",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.1.11.14570"
    }
  ],
  "version" : "3.0.0",
  "name" : "AdministrableDrugForm",
  "title" : "AdministrableDrugForm",
  "status" : "active",
  "experimental" : false,
  "date" : "2014-03-26",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Indicates the form in which the drug product should be administered.\r\n\r\nThis element only needs to be specified when (a) the form in which the drug is measured for dispensing differs from the form in which the drug is administered; and (b) the form in which the quantity of the administered drug being administered is not expressed as a discrete measured mass or volume.*Usage:*",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-orderableDrugForm",
        "concept" : [
          {
            "code" : "APPFUL"
          },
          {
            "code" : "PUFF"
          },
          {
            "code" : "SCOOP"
          },
          {
            "code" : "SPRY"
          }
        ]
      },
      {
        "valueSet" : ["http://terminology.hl7.org/ValueSet/v3-DropsDrugForm"]
      }
    ]
  }
}

```
