# ActInvoiceDetailCode - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ActInvoiceDetailCode**

## ValueSet: ActInvoiceDetailCode 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/v3-ActInvoiceDetailCode | *Version*:3.0.0 | |
| Active as of 2014-03-26 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ActInvoiceDetailCode |
| *Other Identifiers:*OID:2.16.840.1.113883.1.11.19401 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Codes representing a service or product that is being invoiced (billed). The code can represent such concepts as "office visit", "drug X", "wheelchair" and other billable items such as taxes, service charges and discounts. 

 **References** 

* Included into [ActInvoiceElementCode](ValueSet-v3-ActInvoiceElementCode.md)

### Logical Definition (CLD)

Language: en

This value set includes codes based on the following rules:

* Include codes from[`http://terminology.hl7.org/CodeSystem/v3-ActCode`](http://tx.fhir.org/r5)version ⏿9.0.0 where concept is-a [_ActInvoiceDetailCode](http://tx.fhir.org/r5/ValueSet/v3-ActCode#v3-ActCode-_ActInvoiceDetailCode)
* Import all the codes that are contained in [ActInvoiceDetailDrugProductCode](ValueSet-v3-ActInvoiceDetailDrugProductCode.md)
* Import all the codes that are contained in [ActInvoiceDetailClinicalProductCode](ValueSet-v3-ActInvoiceDetailClinicalProductCode.md)
* Import all the codes that are contained in [ActInvoiceDetailPreferredAccommodationCode](ValueSet-v3-ActInvoiceDetailPreferredAccommodationCode.md)
* Import all the codes that are contained in [ActInvoiceDetailGenericCode](ValueSet-v3-ActInvoiceDetailGenericCode.md)
* Import all the codes that are contained in [x_ActInvoiceDetailPharmacyCode](ValueSet-v3-xActInvoiceDetailPharmacyCode.md)
* Import all the codes that are contained in [x_ActInvoiceDetailPreferredAccommodationCode](ValueSet-v3-xActInvoiceDetailPreferredAccommodationCode.md)

This value set excludes codes based on the following rules:

* Exclude these codes as defined in [`http://terminology.hl7.org/CodeSystem/v3-ActCode`](http://tx.fhir.org/r5)version ⏿9.0.0

 

### Expansion

This value set contains 999 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v3-ActInvoiceDetailCode",
  "language" : "en",
  "url" : "http://terminology.hl7.org/ValueSet/v3-ActInvoiceDetailCode",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.1.11.19401"
    }
  ],
  "version" : "3.0.0",
  "name" : "ActInvoiceDetailCode",
  "title" : "ActInvoiceDetailCode",
  "status" : "active",
  "experimental" : false,
  "date" : "2014-03-26",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Codes representing a service or product that is being invoiced (billed). The code can represent such concepts as \"office visit\", \"drug X\", \"wheelchair\" and other billable items such as taxes, service charges and discounts.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
        "filter" : [
          {
            "property" : "concept",
            "op" : "is-a",
            "value" : "_ActInvoiceDetailCode"
          }
        ]
      },
      {
        "valueSet" : [
          "http://terminology.hl7.org/ValueSet/v3-ActInvoiceDetailDrugProductCode"
        ]
      },
      {
        "valueSet" : [
          "http://terminology.hl7.org/ValueSet/v3-ActInvoiceDetailClinicalProductCode"
        ]
      },
      {
        "valueSet" : [
          "http://terminology.hl7.org/ValueSet/v3-ActInvoiceDetailPreferredAccommodationCode"
        ]
      },
      {
        "valueSet" : [
          "http://terminology.hl7.org/ValueSet/v3-ActInvoiceDetailGenericCode"
        ]
      },
      {
        "valueSet" : [
          "http://terminology.hl7.org/ValueSet/v3-xActInvoiceDetailPharmacyCode"
        ]
      },
      {
        "valueSet" : [
          "http://terminology.hl7.org/ValueSet/v3-xActInvoiceDetailPreferredAccommodationCode"
        ]
      }
    ],
    "exclude" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
        "concept" : [
          {
            "code" : "_ActInvoiceDetailCode"
          }
        ]
      }
    ]
  }
}

```
