# InformationSensitivityPolicy - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **InformationSensitivityPolicy**

## ValueSet: InformationSensitivityPolicy 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/v2-0719 | *Version*:3.0.0 | |
| Retired as of 2019-12-01 | *Responsible:*[HL7, Inc](https://github.com/HL7/UTG) | *Computable Name*:InformationSensitivityPolicy |
| *Other Identifiers:*OID:2.16.840.1.113883.1.11.20428 | | |
| **Copyright/Legal**: Copyright HL7. Licensed under creative commons public domain | | |

 
Value Set of codes that specify the reason for the restricted access. Sensitivity codes are not useful for interoperability outside of a policy domain because sensitivity policies are typically localized and vary drastically across policy domains even for the same information category because of differing organizational business rules, security policies, and jurisdictional requirements. For example, an "employee" sensitivity code would make little sense for use outside of a policy domain. "Taboo" would rarely be useful outside of a policy domain unless there are jurisdictional requirements requiring that a provider disclose sensitive information to a patient directly. Sensitivity codes may be more appropriate in a legacy system's Master Files in order to notify those who access a patient's orders and observations about the sensitivity policies that apply. Newer systems may have a security engine that uses a sensitivity policy's criteria directly. The specializable Sensitivity Act.code may be useful in some scenarious if used in combination with a sensitivity identifier and/or Act.titleValue Set of codes that specify the reason for the restricted access. Note that this resource was created in THO in error due to an oversight in the import processing. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

* Include all codes defined in [`http://terminology.hl7.org/CodeSystem/v3-ActCode`](http://tx.fhir.org/r5)version 📍9.0.0

 

### Expansion

Expansions are not generated for retired value sets

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v2-0719",
  "url" : "http://terminology.hl7.org/ValueSet/v2-0719",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.1.11.20428"
    }
  ],
  "version" : "3.0.0",
  "name" : "InformationSensitivityPolicy",
  "title" : "InformationSensitivityPolicy",
  "status" : "retired",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "HL7, Inc",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://github.com/HL7/UTG"
        }
      ]
    }
  ],
  "description" : "Value Set of codes that specify the reason for the restricted access.\r\nSensitivity codes are not useful for interoperability outside of a policy domain because sensitivity policies are typically localized and vary drastically across policy domains even for the same information category because of differing organizational business rules, security policies, and jurisdictional requirements. For example, an \"employee\" sensitivity code would make little sense for use outside of a policy domain. \"Taboo\" would rarely be useful outside of a policy domain unless there are jurisdictional requirements requiring that a provider disclose sensitive information to a patient directly. Sensitivity codes may be more appropriate in a legacy system's Master Files in order to notify those who access a patient's orders and observations about the sensitivity policies that apply. Newer systems may have a security engine that uses a sensitivity policy's criteria directly. The specializable Sensitivity Act.code may be useful in some scenarious if used in combination with a sensitivity identifier and/or Act.titleValue Set of codes that specify the reason for the    restricted access.  Note that this resource was created in THO in error due to an oversight in the import processing.",
  "copyright" : "Copyright HL7. Licensed under creative commons public domain",
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
        "version" : "2.139.0"
      }
    ]
  }
}

```
