# FHIR Device Types - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **FHIR Device Types**

## ValueSet: FHIR Device Types 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/device-kind | *Version*:1.0.1 | | |
| Active as of 2024-04-24 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:FHIRDeviceTypes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.3.208 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | | |

 
Codes used to identify medical devices. Includes concepts from SNOMED CT (http://www.snomed.org/) where concept is-a 49062001 (Device) and is provided as a suggestive example. 

 **References** 

* Included into [DeviceType](ValueSet-v2-0961.md)

### Logical Definition (CLD)

Last updated: 2024-04-24 00:00:00+0000

Profile: [Shareable ValueSet](http://hl7.org/fhir/R5/shareablevalueset.html)

* Include codes from[`http://snomed.info/sct`](http://www.snomed.org/)version Not Stated (use latest from terminology server) where concept is-a 49062001 (Device)

 

### Expansion

Expansion from tx.fhir.org based on SNOMED CT International edition 01-Aug 2024

This value set has >1000 codes in it. In order to keep the publication size manageable, only a selection (1000 codes) of the whole set of codes is shown

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "device-kind",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : ["http://hl7.org/fhir/StructureDefinition/shareablevalueset"]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/ValueSet/device-kind",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.3.208"
    }
  ],
  "version" : "1.0.1",
  "name" : "FHIRDeviceTypes",
  "title" : "FHIR Device Types",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-04-24T00:00:00+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Codes used to identify medical devices. Includes concepts from SNOMED CT (http://www.snomed.org/)    where concept is-a 49062001 (Device)  and is provided as a suggestive example.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "http://snomed.info/sct",
        "filter" : [
          {
            "property" : "concept",
            "op" : "is-a",
            "value" : "49062001"
          }
        ]
      }
    ]
  }
}

```
