# Adverse Event Clinical Research Grades - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Adverse Event Clinical Research Grades**

## ValueSet: Adverse Event Clinical Research Grades 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/adverse-event-clinical-research-grades | *Version*:1.0.0 | | |
| Active as of 2023-07-28 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:AdverseEventClinicalResearchGrades |
| *Other Identifiers:*OID:2.16.840.1.113883.11.21027 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | | |

 
Value set of grades used in Adverse Event Clinical Research, especially in Oncology clinical trials 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

This value set contains 5 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "adverse-event-clinical-research-grades",
  "meta" : {
    "profile" : ["http://hl7.org/fhir/StructureDefinition/shareablevalueset"]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "brr"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/ValueSet/adverse-event-clinical-research-grades",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.11.21027"
    }
  ],
  "version" : "1.0.0",
  "name" : "AdverseEventClinicalResearchGrades",
  "title" : "Adverse Event Clinical Research Grades",
  "status" : "active",
  "experimental" : false,
  "date" : "2023-07-28T19:27:19+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Value set of grades used in Adverse Event Clinical Research, especially in Oncology clinical trials",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl",
        "concept" : [
          {
            "code" : "C41338",
            "display" : "Grade 1 Mild Adverse Event"
          },
          {
            "code" : "C41339",
            "display" : "Grade 2 Moderate Adverse Event"
          },
          {
            "code" : "C41340",
            "display" : "Grade 3 Severe Adverse Event"
          },
          {
            "code" : "C41337",
            "display" : "Grade 4 Life Threatening or Disabling Adverse Event"
          },
          {
            "code" : "C48275",
            "display" : "Grade 5 Death Related to Adverse Event"
          }
        ]
      }
    ]
  }
}

```
