# Policy Holder Role - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Policy Holder Role**

## NamingSystem: Policy Holder Role 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/v3-policyHolderRole | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:PolicyHolderRole |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
This vocabulary is defined by Implementation Guide for CDA Release 2 - Level 1 - Care Record Summary (US realm). 
It describes roles recognized through the issuance of an insurance policy to a policyholder who a relationship with the covered party, such as spouse, child, etc. This vocabulary is essentially an inversion of the role relations of the HL7 CoverageRoleType vocabulary. It provides more detailed roles with respect to the underwriter (the scoping organization) for those participants in the policyholder role for a patient. 
**Open Issue:** 
The code values for this coding system must be extracted from the CDA documentation and brought forward through Harmonization for instantiation in this repository. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/v3-policyHolderRole |
| Version | 3.0.0 |
| Name | PolicyHolderRole |
| Title | Policy Holder Role |
| Status | active |
| Definition | This vocabulary is defined by Implementation Guide for CDA Release 2 - Level 1 - Care Record Summary (US realm).It describes roles recognized through the issuance of an insurance policy to a policyholder who a relationship with the covered party, such as spouse, child, etc. This vocabulary is essentially an inversion of the role relations of the HL7 CoverageRoleType vocabulary. It provides more detailed roles with respect to the underwriter (the scoping organization) for those participants in the policyholder role for a patient.**Open Issue:**The code values for this coding system must be extracted from the CDA documentation and brought forward through Harmonization for instantiation in this repository. |
| Publisher | Health Level Seven International |
| Copyright | This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.5.1128
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/v3-policyHolderRole
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "v3-policyHolderRole",
  "url" : "http://terminology.hl7.org/NamingSystem/v3-policyHolderRole",
  "version" : "3.0.0",
  "name" : "PolicyHolderRole",
  "title" : "Policy Holder Role",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2019-03-20T00:00:00-04:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "responsible" : "HL7",
  "description" : "This vocabulary is defined by Implementation Guide for CDA Release 2 - Level 1 - Care Record Summary (US realm).\r\n\r\nIt describes roles recognized through the issuance of an insurance policy to a policyholder who a relationship with the covered party, such as spouse, child, etc. This vocabulary is essentially an inversion of the role relations of the HL7 CoverageRoleType vocabulary. It provides more detailed roles with respect to the underwriter (the scoping organization) for those participants in the policyholder role for a patient.\r\n\r\n*Open Issue:* \r\n\r\nThe code values for this coding system must be extracted from the CDA documentation and brought forward through Harmonization for instantiation in this repository.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.5.1128",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/v3-policyHolderRole",
      "preferred" : true
    }
  ]
}

```
