# ISO 11073-10101 Health informatics - Point-of-care - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ISO 11073-10101 Health informatics - Point-of-care**

## NamingSystem: ISO 11073-10101 Health informatics - Point-of-care 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/v3-mdc | *Version*:2.1.0 | |
| Active as of 2019-03-20 | *Responsible:*IEEE 1073 General Committee | *Computable Name*:Mdc |

 
The nomenclature relates primarily to vital signs monitoring, but also includes semantics of other medical devices that are commonly used in acute care settings. There are multiple coding partitions each of which has a systematic name consisting of a set of base concepts and differentiating criteria. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/v3-mdc |
| Version | 2.1.0 |
| Name | Mdc |
| Title | ISO 11073-10101 Health informatics - Point-of-care |
| Status | active |
| Definition | The nomenclature relates primarily to vital signs monitoring, but also includes semantics of other medical devices that are commonly used in acute care settings. There are multiple coding partitions each of which has a systematic name consisting of a set of base concepts and differentiating criteria. |
| Publisher | IEEE 1073 General Committee |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.6.24
  * **Preferred**: true
* **Type**: URI
  * **Value**: urn:iso:std:iso:11073:10101
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "v3-mdc",
  "url" : "http://terminology.hl7.org/NamingSystem/v3-mdc",
  "version" : "2.1.0",
  "name" : "Mdc",
  "title" : "ISO 11073-10101 Health informatics - Point-of-care",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2019-03-20T00:00:00-04:00",
  "publisher" : "IEEE 1073 General Committee",
  "contact" : [
    {
      "name" : "Melvin Reynolds"
    }
  ],
  "responsible" : "IEEE 1073 General Committee",
  "description" : "The nomenclature relates primarily to vital signs monitoring, but also includes semantics of other medical devices that are commonly used in acute care settings. There are multiple coding partitions each of which has a systematic name consisting of a set of base concepts and differentiating criteria.",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.24",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "urn:iso:std:iso:11073:10101",
      "preferred" : true
    }
  ]
}

```
