# HUGO Gene Nomenclature Committee Genes - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **HUGO Gene Nomenclature Committee Genes**

## NamingSystem: HUGO Gene Nomenclature Committee Genes 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/v3-hgnc | *Version*:3.1.0 | |
| Active as of 2024-08-22 | *Responsible:*[HUGO Gene Nomenclature Committee](https://www.genenames.org/) | *Computable Name*:HGNCGenes |
| **Copyright/Legal**: It is a condition of HGNC funding from NIH and the Welcome Trust that the nomenclature and information provided is freely available to all. Anyone may use the HGNC data, but we request that they reference the**"HUGO Gene Nomenclature Committee at the European Bioinformatics Institute"**and the website where possible. | | |

 
"The HGNC is responsible for approving unique symbols and names for human loci, including protein coding genes, ncRNA genes and pseudogenes, to allow unambiguous scientific communication." 
The HGNC gene table carries gene IDs, gene symbols and full gene names. Guidance from HGNC confirms that gene symbols are not unique across species and have been known to change in some instances. Thus the commonly used gene symbols should be encoded in FHIR as "displays" with the corresponding IDs (beginning with "HGNC:") as the "codes". 
"For each known human gene we approve a gene name and symbol (short-form abbreviation). All approved symbols are stored in the HGNC database,[www.genenames.org](https://www.genenames.org/tools/search), a curated online repository of HGNC-approved gene nomenclature, gene groups and associated resources including links to genomic, proteomic and phenotypic information. Each symbol is unique and we ensure that each gene is only given one approved gene symbol. It is necessary to provide a unique symbol for each gene so that we and others can talk about them, and this also facilitates electronic data retrieval from publications and databases." 
HGNC also provides an index on gene families/groups. GeneGroup IDs do not begin with "HGNC:", so care must be made to ensure alignment of concepts when viewing an HGNC ID from an older system that may be referring to the GeneID and not a gene group. For example, 588 refers to the HLA gene family, but HGNC:588 identifies the ATG12 gene. To provide clarity for systems that do not distinguish codes from genes and gene families, use "http://www.genenames.org" for genes and "http://www.genenames.org/genegroup" for gene families as code system URIs. 
For more information on HGNC Gene Groups, see[https://terminology.hl7.org/CodeSystem-HGNCGeneGroup.html](https://terminology.hl7.org/CodeSystem-HGNCGeneGroup.html). 
Historically, HGNC gene symbols were used with the HL7 coded data type. For example, in the HL7 messages specified according to the HL7 V2 Clinical Genomics Fully LOINC-Qualified Genetic Variation Model Implementation Guide, HGNC gene symbols were used as the observation values for gene identifiers. For example, OBX 1 CWE 48018-6^Gene identifier^ BRCA1^HGNC. Please note that gene symbols may be present in legacy systems, but GeneID should be used to exchange HGNC gene information in current implementations. 
HGNC is a free database for the public. 
Versioning Information: The version of the HGNC database is reported using the last updated date. The last updated date is posted on the main HGNC Search screen in the format like "2024-07-25". 
Current, monthly and quarterly HGNC dataset files are published. 
Please see https://www.genenames.org/ for more info. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/v3-hgnc |
| Version | 3.1.0 |
| Name | HGNCGenes |
| Title | HUGO Gene Nomenclature Committee Genes |
| Status | active |
| Definition | "The HGNC is responsible for approving unique symbols and names for human loci, including protein coding genes, ncRNA genes and pseudogenes, to allow unambiguous scientific communication."The HGNC gene table carries gene IDs, gene symbols and full gene names. Guidance from HGNC confirms that gene symbols are not unique across species and have been known to change in some instances. Thus the commonly used gene symbols should be encoded in FHIR as "displays" with the corresponding IDs (beginning with "HGNC:") as the "codes"."For each known human gene we approve a gene name and symbol (short-form abbreviation). All approved symbols are stored in the HGNC database,[www.genenames.org](https://www.genenames.org/tools/search), a curated online repository of HGNC-approved gene nomenclature, gene groups and associated resources including links to genomic, proteomic and phenotypic information. Each symbol is unique and we ensure that each gene is only given one approved gene symbol. It is necessary to provide a unique symbol for each gene so that we and others can talk about them, and this also facilitates electronic data retrieval from publications and databases."HGNC also provides an index on gene families/groups. GeneGroup IDs do not begin with "HGNC:", so care must be made to ensure alignment of concepts when viewing an HGNC ID from an older system that may be referring to the GeneID and not a gene group. For example, 588 refers to the HLA gene family, but HGNC:588 identifies the ATG12 gene. To provide clarity for systems that do not distinguish codes from genes and gene families, use "http://www.genenames.org" for genes and "http://www.genenames.org/genegroup" for gene families as code system URIs.For more information on HGNC Gene Groups, see [https://terminology.hl7.org/CodeSystem-HGNCGeneGroup.html](https://terminology.hl7.org/CodeSystem-HGNCGeneGroup.html).Historically, HGNC gene symbols were used with the HL7 coded data type. For example, in the HL7 messages specified according to the HL7 V2 Clinical Genomics Fully LOINC-Qualified Genetic Variation Model Implementation Guide, HGNC gene symbols were used as the observation values for gene identifiers. For example, OBX 1 CWE 48018-6^Gene identifier^ BRCA1^HGNC. Please note that gene symbols may be present in legacy systems, but GeneID should be used to exchange HGNC gene information in current implementations.HGNC is a free database for the public.Versioning Information: The version of the HGNC database is reported using the last updated date. The last updated date is posted on the main HGNC Search screen in the format like "2024-07-25".Current, monthly and quarterly HGNC dataset files are published.Please see https://www.genenames.org/ for more info. |
| Publisher | HUGO Gene Nomenclature Committee |
| Copyright | It is a condition of HGNC funding from NIH and the Welcome Trust that the nomenclature and information provided is freely available to all. Anyone may use the HGNC data, but we request that they reference the **"HUGO Gene Nomenclature Committee at the European Bioinformatics Institute"** and the website where possible. |

### Identifiers

* **Type**: URI
  * **Value**: http://www.genenames.org
  * **Preferred**: true
  * **Period**: 2022-08-25 --> (ongoing)
  * **Comment**: This is the URL as specified by the terminology owner, and is considered authoritative.
* **Type**: URI
  * **Value**: http://www.genenames.org/geneId
  * **Preferred**: false
  * **Period**: 
  * **Comment**: 
* **Type**: OID
  * **Value**: 2.16.840.1.113883.6.281
  * **Preferred**: true
  * **Period**: 
  * **Comment**: 

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "v3-hgnc",
  "url" : "http://terminology.hl7.org/NamingSystem/v3-hgnc",
  "version" : "3.1.0",
  "name" : "HGNCGenes",
  "title" : "HUGO Gene Nomenclature Committee Genes",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2024-08-22T00:00:00-00:00",
  "publisher" : "HUGO Gene Nomenclature Committee",
  "contact" : [
    {
      "name" : "HUGO Gene Nomenclature Committee",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.genenames.org/"
        },
        {
          "system" : "email",
          "value" : "hgnc@genenames.org"
        }
      ]
    }
  ],
  "responsible" : "HUGO Gene Nomenclature Committee",
  "description" : "\"The HGNC is responsible for approving unique symbols and names for human loci, including protein coding genes, ncRNA genes and pseudogenes, to allow unambiguous scientific communication.\"\r\n\r\nThe HGNC gene table carries gene IDs, gene symbols and full gene names. Guidance from HGNC confirms that gene symbols are not unique across species and have been known to change in some instances. Thus the commonly used gene symbols should be encoded in FHIR as \"displays\" with the corresponding IDs (beginning with \"HGNC:\") as the \"codes\".\r\n\r\n\"For each known human gene we approve a gene name and symbol (short-form abbreviation). All approved symbols are stored in the HGNC database,[www.genenames.org](https://www.genenames.org/tools/search), a curated online repository of HGNC-approved gene nomenclature, gene groups and associated resources including links to genomic, proteomic and phenotypic information. Each symbol is unique and we ensure that each gene is only given one approved gene symbol. It is necessary to provide a unique symbol for each gene so that we and others can talk about them, and this also facilitates electronic data retrieval from publications and databases.\"\r\n\r\nHGNC also provides an index on gene families/groups. GeneGroup IDs do not begin with \"HGNC:\", so care must be made to ensure alignment of concepts when viewing an HGNC ID from an older system that may be referring to the GeneID and not a gene group. For example, 588 refers to the HLA gene family, but HGNC:588 identifies the ATG12 gene. To provide clarity for systems that do not distinguish codes from genes and gene families, use \"http://www.genenames.org\" for genes and \"http://www.genenames.org/genegroup\" for gene families as code system URIs.\r\n\r\nFor more information on HGNC Gene Groups, see [https://terminology.hl7.org/CodeSystem-HGNCGeneGroup.html](https://terminology.hl7.org/CodeSystem-HGNCGeneGroup.html).\r\n\r\nHistorically, HGNC gene symbols were used with the HL7 coded data type. For example, in the HL7 messages specified according to the HL7 V2 Clinical Genomics Fully LOINC-Qualified Genetic Variation Model Implementation Guide, HGNC gene symbols were used as the observation values for gene identifiers. For example, OBX 1 CWE 48018-6^Gene identifier^ BRCA1^HGNC. Please note that gene symbols may be present in legacy systems, but GeneID should be used to exchange HGNC gene information in current implementations.\r\n\r\nHGNC is a free database for the public.\r\n\r\nVersioning Information: The version of the HGNC database is reported using the last updated date. The last updated date is posted on the main HGNC Search screen in the format like \"2024-07-25\".\r\n\r\nCurrent, monthly and quarterly HGNC dataset files are published.\r\n\r\nPlease see https://www.genenames.org/ for more info.",
  "copyright" : "It is a condition of HGNC funding from NIH and the Welcome Trust that the nomenclature and information provided is freely available to all. Anyone may use the HGNC data, but we request that they reference the *\"HUGO Gene Nomenclature Committee at the European Bioinformatics Institute\"* and the website where possible.",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "http://www.genenames.org",
      "preferred" : true,
      "comment" : "This is the URL as specified by the terminology owner, and is considered authoritative.",
      "period" : {
        "start" : "2022-08-25"
      }
    },
    {
      "type" : "uri",
      "value" : "http://www.genenames.org/geneId",
      "preferred" : false
    },
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.281",
      "preferred" : true
    }
  ]
}

```
