# nubc-PresentOnAdmission - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **nubc-PresentOnAdmission**

## NamingSystem: nubc-PresentOnAdmission 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/v2-0895 | *Version*:1.0.0 | |
| Active as of 2019-12-01 | *Responsible:*HL7, Inc | *Computable Name*:NubcPresentOnAdmission |

 
National Uniform Billing Committee (NUBC) UB-04 Data Specifications Manual, UB form locator 67, Present on Admission (POA) Indicator. Code identifying a diagnosis that was present at the time the order for inpatient admission occurs. POA indicator is assigned to all diagnoses as defined in Appendix I of the "ICD-9-CM Official Guidelines for Coding and Reporting" or "ICD-10-CM Official Guidelines for Coding and Reporting (appropriate to the ICD revision used). 
The UB-04 Data Specifications Manual with the codes is available by subscription from NUBC at http://www.nubc.org/become.html. Used in HL7 Version 2.x messaging in the DG1 segment. Note that this content was previously published in HL7 artifacts in violaton of IP restrictions; the content has been removed in version 2.2.0 pending finalization of a republication permission request to AHA/NUBC. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/v2-0895 |
| Version | 1.0.0 |
| Name | NubcPresentOnAdmission |
| Title | nubc-PresentOnAdmission |
| Status | active |
| Definition | National Uniform Billing Committee (NUBC) UB-04 Data Specifications Manual, UB form locator 67, Present on Admission (POA) Indicator. Code identifying a diagnosis that was present at the time the order for inpatient admission occurs. POA indicator is assigned to all diagnoses as defined in Appendix I of the "ICD-9-CM Official Guidelines for Coding and Reporting" or "ICD-10-CM Official Guidelines for Coding and Reporting (appropriate to the ICD revision used).The UB-04 Data Specifications Manual with the codes is available by subscription from NUBC at http://www.nubc.org/become.html. Used in HL7 Version 2.x messaging in the DG1 segment. Note that this content was previously published in HL7 artifacts in violaton of IP restrictions; the content has been removed in version 2.2.0 pending finalization of a republication permission request to AHA/NUBC. |
| Publisher | HL7, Inc |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.6.301.11
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/v2-0895
  * **Preferred**: true



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "v2-0895",
  "url" : "http://terminology.hl7.org/NamingSystem/v2-0895",
  "version" : "1.0.0",
  "name" : "NubcPresentOnAdmission",
  "title" : "nubc-PresentOnAdmission",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2019-12-01",
  "publisher" : "HL7, Inc",
  "contact" : [
    {
      "name" : "National Uniform Billing Committee (NUBC)"
    }
  ],
  "responsible" : "NUBC",
  "description" : "National Uniform Billing Committee (NUBC) UB-04 Data Specifications Manual, UB form locator 67, Present on Admission (POA) Indicator. Code identifying a diagnosis that  was present at the time the order for inpatient admission occurs. POA indicator is assigned to all diagnoses as defined in Appendix I of the \"ICD-9-CM Official Guidelines for Coding and Reporting\" or \"ICD-10-CM Official Guidelines for Coding and Reporting (appropriate to the ICD revision used).\r\n \r\nThe UB-04 Data Specifications Manual with the codes is available by subscription from NUBC at http://www.nubc.org/become.html.  Used in HL7 Version 2.x messaging in the DG1 segment. Note that this content was previously published in HL7 artifacts in violaton of IP restrictions; the content has been removed in version 2.2.0 pending finalization of a republication permission request to AHA/NUBC.",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.301.11",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/v2-0895",
      "preferred" : true
    }
  ]
}

```
