# US EPA Substance Registry System - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US EPA Substance Registry System**

## NamingSystem: US EPA Substance Registry System 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/usEPAsrs | *Version*:2.1.0 |
| Retired as of 2021-11-09 | *Computable Name*:UsEPAsrs |

 
The United States Environmental Protection Agency's (US EPA) Substance Registry System (SRS) provides information on substances and how they are represented in US environmental statutes, in US EPA information systems, and in information systems owned by other organizations. The SRS provides standardized identification for each substance to improve data quality in US EPA systems and elsewhere. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/usEPAsrs |
| Version | 2.1.0 |
| Name | UsEPAsrs |
| Title | US EPA Substance Registry System |
| Status | retired |
| Definition | The United States Environmental Protection Agency's (US EPA) Substance Registry System (SRS) provides information on substances and how they are represented in US environmental statutes, in US EPA information systems, and in information systems owned by other organizations. The SRS provides standardized identification for each substance to improve data quality in US EPA systems and elsewhere. |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.6.275
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/usEPAsrs
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "usEPAsrs",
  "url" : "http://terminology.hl7.org/NamingSystem/usEPAsrs",
  "version" : "2.1.0",
  "name" : "UsEPAsrs",
  "title" : "US EPA Substance Registry System",
  "status" : "retired",
  "kind" : "codesystem",
  "date" : "2021-11-09T10:00:00+10:00",
  "description" : "The United States Environmental Protection Agency's (US EPA) Substance Registry System (SRS) provides information on substances and how they are represented in US environmental statutes, in US EPA information systems, and in information systems owned by other organizations. The SRS provides standardized identification for each substance to improve data quality in US EPA systems and elsewhere.",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.275",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/usEPAsrs",
      "preferred" : true
    }
  ]
}

```
