# Passport Numbers Namespace for TOGO - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Passport Numbers Namespace for TOGO**

## NamingSystem: Passport Numbers Namespace for TOGO 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/passportNumNS-TGO | *Version*:1.0.0 |
| Active as of 2022-02-07 | *Computable Name*:PassportNumNS_TGO |

 
Identifier of the namespace for Passport Numbers issued by the country of TOGO. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/passportNumNS-TGO |
| Version | 1.0.0 |
| Name | PassportNumNS_TGO |
| Title | Passport Numbers Namespace for TOGO |
| Status | active |
| Definition | Identifier of the namespace for Passport Numbers issued by the country of TOGO. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.4.330.768
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://hl7.org/fhir/sid/passport-TGO
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "passportNumNS-TGO",
  "url" : "http://terminology.hl7.org/NamingSystem/passportNumNS-TGO",
  "version" : "1.0.0",
  "name" : "PassportNumNS_TGO",
  "title" : "Passport Numbers Namespace for TOGO",
  "status" : "active",
  "kind" : "identifier",
  "date" : "2022-02-07T00:00:00-00:00",
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
        "code" : "PPN"
      }
    ]
  },
  "description" : "Identifier of the namespace for Passport Numbers issued by the country of TOGO.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.4.330.768",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://hl7.org/fhir/sid/passport-TGO",
      "preferred" : true
    }
  ]
}

```
