# Passport Numbers Namespace for SERBIA - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Passport Numbers Namespace for SERBIA**

## NamingSystem: Passport Numbers Namespace for SERBIA 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/passportNumNS-SRB | *Version*:1.0.0 |
| Active as of 2022-02-07 | *Computable Name*:PassportNumNS_SRB |

 
Identifier of the namespace for Passport Numbers issued by the country of SERBIA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/passportNumNS-SRB |
| Version | 1.0.0 |
| Name | PassportNumNS_SRB |
| Title | Passport Numbers Namespace for SERBIA |
| Status | active |
| Definition | Identifier of the namespace for Passport Numbers issued by the country of SERBIA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.4.330.688
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://hl7.org/fhir/sid/passport-SRB
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "passportNumNS-SRB",
  "url" : "http://terminology.hl7.org/NamingSystem/passportNumNS-SRB",
  "version" : "1.0.0",
  "name" : "PassportNumNS_SRB",
  "title" : "Passport Numbers Namespace for SERBIA",
  "status" : "active",
  "kind" : "identifier",
  "date" : "2022-02-07T00:00:00-00:00",
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
        "code" : "PPN"
      }
    ]
  },
  "description" : "Identifier of the namespace for Passport Numbers issued by the country of SERBIA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.4.330.688",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://hl7.org/fhir/sid/passport-SRB",
      "preferred" : true
    }
  ]
}

```
