# Passport Numbers Namespace for FRENCH SOUTHERN TERRITORIES - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Passport Numbers Namespace for FRENCH SOUTHERN TERRITORIES**

## NamingSystem: Passport Numbers Namespace for FRENCH SOUTHERN TERRITORIES 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/passportNumNS-ATF | *Version*:1.0.0 |
| Active as of 2022-02-07 | *Computable Name*:PassportNumNS_ATF |

 
Identifier of the namespace for Passport Numbers issued by the country of FRENCH SOUTHERN TERRITORIES. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/passportNumNS-ATF |
| Version | 1.0.0 |
| Name | PassportNumNS_ATF |
| Title | Passport Numbers Namespace for FRENCH SOUTHERN TERRITORIES |
| Status | active |
| Definition | Identifier of the namespace for Passport Numbers issued by the country of FRENCH SOUTHERN TERRITORIES. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.4.330.260
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://hl7.org/fhir/sid/passport-ATF
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "passportNumNS-ATF",
  "url" : "http://terminology.hl7.org/NamingSystem/passportNumNS-ATF",
  "version" : "1.0.0",
  "name" : "PassportNumNS_ATF",
  "title" : "Passport Numbers Namespace for FRENCH SOUTHERN TERRITORIES",
  "status" : "active",
  "kind" : "identifier",
  "date" : "2022-02-07T00:00:00-00:00",
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
        "code" : "PPN"
      }
    ]
  },
  "description" : "Identifier of the namespace for Passport Numbers issued by the country of FRENCH SOUTHERN TERRITORIES.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.4.330.260",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://hl7.org/fhir/sid/passport-ATF",
      "preferred" : true
    }
  ]
}

```
