# METABOLIC SYNDROME - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **METABOLIC SYNDROME**

## NamingSystem: METABOLIC SYNDROME 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/metabolicSyndrome | *Version*:2.1.0 | |
| Retired as of 2021-11-09 | *Responsible:*WHICH | *Computable Name*:MetabolicSyndrome |

 
A collection of metabolic risk factors in one individual. The root causes of metabolic syndrome are overweight / obesity, physical inactivity, and genetic factors. Various risk factors have been included in metabolic syndrome. Factors generally accepted as being characteristic of this syndrome include abdominal obesity, atherogenic dyslipidemia, raised blood pressure, insulin resistence with or without glucose intolerance, prothrombotic state, and proinflammatory state. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/metabolicSyndrome |
| Version | 2.1.0 |
| Name | MetabolicSyndrome |
| Title | METABOLIC SYNDROME |
| Status | retired |
| Definition | A collection of metabolic risk factors in one individual. The root causes of metabolic syndrome are overweight / obesity, physical inactivity, and genetic factors. Various risk factors have been included in metabolic syndrome. Factors generally accepted as being characteristic of this syndrome include abdominal obesity, atherogenic dyslipidemia, raised blood pressure, insulin resistence with or without glucose intolerance, prothrombotic state, and proinflammatory state. |
| Publisher | WHICH |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.6.249
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/metabolicSyndrome
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "metabolicSyndrome",
  "url" : "http://terminology.hl7.org/NamingSystem/metabolicSyndrome",
  "version" : "2.1.0",
  "name" : "MetabolicSyndrome",
  "title" : "METABOLIC SYNDROME",
  "status" : "retired",
  "kind" : "codesystem",
  "date" : "2021-11-09T10:00:00+10:00",
  "publisher" : "WHICH",
  "contact" : [
    {
      "name" : "WHIC,WHIC"
    }
  ],
  "responsible" : "WHICH",
  "description" : "A collection of metabolic risk factors in one individual. The root causes of metabolic syndrome are overweight / obesity, physical inactivity, and genetic factors. Various risk factors have been included in metabolic syndrome. Factors generally accepted as being characteristic of this syndrome include abdominal obesity, atherogenic dyslipidemia, raised blood pressure, insulin resistence with or without glucose intolerance, prothrombotic state, and proinflammatory state.",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.249",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/metabolicSyndrome",
      "preferred" : true
    }
  ]
}

```
