# United States Medicare Number - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **United States Medicare Number**

## NamingSystem: United States Medicare Number 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/medicareHIC | *Version*:1.0.0 | |
| Active as of 2022-02-07 | *Responsible:*Center for Medicare and Medicaid Services (CMS) | *Computable Name*:MedicareHIC |

 
Medicare Health Insurance Claim # (HIC) is a unique identifier of a beneficiary used for Medicare entitlement and billing purposes. Medicare Numbers (HIC or HICN) are represented without any spaces or dashes. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/medicareHIC |
| Version | 1.0.0 |
| Name | MedicareHIC |
| Title | United States Medicare Number |
| Status | active |
| Definition | Medicare Health Insurance Claim # (HIC) is a unique identifier of a beneficiary used for Medicare entitlement and billing purposes. Medicare Numbers (HIC or HICN) are represented without any spaces or dashes. |
| Publisher | Center for Medicare and Medicaid Services (CMS) |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.4.572
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://hl7.org/fhir/sid/us-medicare
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "medicareHIC",
  "url" : "http://terminology.hl7.org/NamingSystem/medicareHIC",
  "version" : "1.0.0",
  "name" : "MedicareHIC",
  "title" : "United States Medicare Number",
  "status" : "active",
  "kind" : "identifier",
  "date" : "2022-02-07T00:00:00-00:00",
  "publisher" : "Center for Medicare and Medicaid Services (CMS)",
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
        "code" : "SB"
      }
    ]
  },
  "description" : "Medicare Health Insurance Claim # (HIC) is a unique identifier of a beneficiary used for Medicare entitlement and billing purposes. Medicare Numbers (HIC or HICN) are represented without any spaces or dashes.",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.4.572",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://hl7.org/fhir/sid/us-medicare",
      "preferred" : true
    }
  ]
}

```
