# ISO 3166 Part 2 Country Subdivision Codes - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ISO 3166 Part 2 Country Subdivision Codes**

## NamingSystem: ISO 3166 Part 2 Country Subdivision Codes 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/iso3166-2 | *Version*:2.1.0 | |
| Retired as of 2022-08-23 | *Responsible:*ISO | *Computable Name*:Iso31662 |

 
Identifies the coding system published in the ISO 3166-2 Standard for Country Subdivision codes. This standard is released periodically, and a new OID will be assigned by ISO for new editions. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/iso3166-2 |
| Version | 2.1.0 |
| Name | Iso31662 |
| Title | ISO 3166 Part 2 Country Subdivision Codes |
| Status | retired |
| Definition | Identifies the coding system published in the ISO 3166-2 Standard for Country Subdivision codes. This standard is released periodically, and a new OID will be assigned by ISO for new editions. |
| Publisher | ISO |

### Identifiers

* **Type**: OID
  * **Value**: 1.0.3166.2
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/iso3166-2
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "iso3166-2",
  "url" : "http://terminology.hl7.org/NamingSystem/iso3166-2",
  "version" : "2.1.0",
  "name" : "Iso31662",
  "title" : "ISO 3166 Part 2 Country Subdivision Codes",
  "status" : "retired",
  "kind" : "codesystem",
  "date" : "2022-08-23T00:00:00-04:00",
  "publisher" : "ISO",
  "contact" : [
    {
      "name" : "International Standards Organization (ISO),International Standards Organization (ISO)"
    }
  ],
  "responsible" : "ISO",
  "description" : "Identifies the coding system published in the ISO 3166-2 Standard for Country Subdivision codes. This standard is released periodically, and a new OID will be assigned by ISO for new editions.",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "1.0.3166.2",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/iso3166-2",
      "preferred" : true
    }
  ]
}

```
