# ISO 3166 Part 1 Country Codes, 2nd Edition - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ISO 3166 Part 1 Country Codes, 2nd Edition**

## NamingSystem: ISO 3166 Part 1 Country Codes, 2nd Edition 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/iso3166-1edition2 | *Version*:2.1.0 | |
| Retired as of 2022-08-23 | *Responsible:*ISO | *Computable Name*:Iso31661edition2 |

 
This OID identifies the coding system published in the ISO 3166-1 Standard for Country codes. It contains 3 sets of synonyms for the country codes: 2-character alphabetic, 3-character alphabetic, and numeric. Note that this is the 2nd edition of the standard. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/iso3166-1edition2 |
| Version | 2.1.0 |
| Name | Iso31661edition2 |
| Title | ISO 3166 Part 1 Country Codes, 2nd Edition |
| Status | retired |
| Definition | This OID identifies the coding system published in the ISO 3166-1 Standard for Country codes. It contains 3 sets of synonyms for the country codes: 2-character alphabetic, 3-character alphabetic, and numeric. Note that this is the 2nd edition of the standard. |
| Publisher | ISO |

### Identifiers

* **Type**: OID
  * **Value**: 1.0.3166.1.2
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/iso3166-1edition2
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "iso3166-1edition2",
  "url" : "http://terminology.hl7.org/NamingSystem/iso3166-1edition2",
  "version" : "2.1.0",
  "name" : "Iso31661edition2",
  "title" : "ISO 3166 Part 1 Country Codes, 2nd Edition",
  "status" : "retired",
  "kind" : "codesystem",
  "date" : "2022-08-23T00:00:00-04:00",
  "publisher" : "ISO",
  "contact" : [
    {
      "name" : "International Standards Organization (ISO)"
    }
  ],
  "responsible" : "ISO",
  "description" : "This OID identifies the coding system published in the ISO 3166-1 Standard for Country codes. It contains 3 sets of synonyms for the country codes: 2-character alphabetic, 3-character alphabetic, and numeric. Note that this is the 2nd edition of the standard.",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "1.0.3166.1.2",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/iso3166-1edition2",
      "preferred" : true
    }
  ]
}

```
