# International Civil Aviation Organization Sex - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **International Civil Aviation Organization Sex**

## NamingSystem: International Civil Aviation Organization Sex 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/icaosex | *Version*:1.0.0 | |
| Active as of 2022-04-21 | *Responsible:*[International Civil Aviation Organization (ICAO)](https://www.icao.int/Pages/default.aspx) | *Computable Name*:ICAO_Sex |
| **Copyright/Legal**: Copyright © ICAO 2021. All rights reserved. None of the materials provided on this web site may be used, reproduced or transmitted, in whole or in part, in any form or by any means, electronic or mechanical, including photocopying, recording or the use of any information storage and retrieval system, except as provided for in the site[Terms and Conditions](https://www.icao.int/pages/Disclaimer.aspx)without permission in writing from ICAO.ICAO grants permission to Users to visit the Site [https://www.icao.int/Pages/default.aspx] and to download, preprint and copy the information, documents and materials (collectively, "Materials") from the Site for the User’s personal, non-commercial use, without any right to resell or redistribute them or to compile or create derivative works therefrom, subject to the terms and conditions outlined [https://www.icao.int/pages/Disclaimer.aspx], and also subject to more specific restrictions that may apply to specific Material within the Site. | | |

 
ICAO is funded and directed by 193 national governments to support their diplomacy and cooperation in air transport as signatory states to the[Chicago Convention (1944)](https://www.icao.int/about-icao/History/Pages/default.aspx) 
Its core function is to maintain an administrative and expert bureaucracy (the[ICAO Secretariat](https://www.icao.int/secretariat/Pages/default.aspx)supporting these diplomatic interactions, and to research new air transport policy and standardization innovations as directed and endorsed by governments through the[ICAO Assembly](https://www.icao.int/about-icao/assembly/Pages/default.aspx), or by the[ICAO Council](https://www.icao.int/about-icao/Council/Pages/council.aspx)which the assembly elects. 
ICAO has developed a technical specification (sample version form 2021[here](https://www.icao.int/publications/Documents/9303_p7_cons_en.pdf)) to "allow compatibility and global interchange using both visual (eye readable) and machine readable means. The specifications lay down standards for visas which can, where issued by a State and accepted by a receiving State, be used for travel purposes. The MRV[Machine Readable Visa] shall, as a minimum, contain the data specified herein in a form that is legible both visually and by optical character recognition methods.." 
Further, defining that "Sex of MRV-A[Format A - Machine Readable Visa] holder, when included, is to be specified by use of the single initial commonly used in the language of the State of issue. If translation into English, French or Spanish is necessary, followed by an oblique and the capital letter F for female, M for male, or X for unspecified." 
Sex of MRV-B[Format B - Machine Readable Visa] holder, when included, is to be specified by use of the single initial commonly used in the language of the State of issue. If translation into English, French or Spanish is necessary, followed by an oblique and the capital letter F for female, M for male, or X for unspecified. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/icaosex |
| Version | 1.0.0 |
| Name | ICAO_Sex |
| Title | International Civil Aviation Organization Sex |
| Status | active |
| Definition | ICAO is funded and directed by 193 national governments to support their diplomacy and cooperation in air transport as signatory states to the [Chicago Convention (1944)](https://www.icao.int/about-icao/History/Pages/default.aspx)Its core function is to maintain an administrative and expert bureaucracy (the [ICAO Secretariat](https://www.icao.int/secretariat/Pages/default.aspx) supporting these diplomatic interactions, and to research new air transport policy and standardization innovations as directed and endorsed by governments through the [ICAO Assembly](https://www.icao.int/about-icao/assembly/Pages/default.aspx), or by the [ICAO Council](https://www.icao.int/about-icao/Council/Pages/council.aspx) which the assembly elects.ICAO has developed a technical specification (sample version form 2021 [here](https://www.icao.int/publications/Documents/9303_p7_cons_en.pdf) ) to "allow compatibility and global interchange using both visual (eye readable) and machine readable means. The specifications lay down standards for visas which can, where issued by a State and accepted by a receiving State, be used for travel purposes. The MRV[Machine Readable Visa] shall, as a minimum, contain the data specified herein in a form that is legible both visually and by optical character recognition methods.."Further, defining that "Sex of MRV-A[Format A - Machine Readable Visa] holder, when included, is to be specified by use of the single initial commonly used in the language of the State of issue. If translation into English, French or Spanish is necessary, followed by an oblique and the capital letter F for female, M for male, or X for unspecified."Sex of MRV-B[Format B - Machine Readable Visa] holder, when included, is to be specified by use of the single initial commonly used in the language of the State of issue. If translation into English, French or Spanish is necessary, followed by an oblique and the capital letter F for female, M for male, or X for unspecified. |
| Publisher | International Civil Aviation Organization (ICAO) |
| Copyright | Copyright © ICAO 2021. All rights reserved. None of the materials provided on this web site may be used, reproduced or transmitted, in whole or in part, in any form or by any means, electronic or mechanical, including photocopying, recording or the use of any information storage and retrieval system, except as provided for in the site [Terms and Conditions](https://www.icao.int/pages/Disclaimer.aspx) without permission in writing from ICAO.ICAO grants permission to Users to visit the Site [https://www.icao.int/Pages/default.aspx] and to download, preprint and copy the information, documents and materials (collectively, "Materials") from the Site for the User’s personal, non-commercial use, without any right to resell or redistribute them or to compile or create derivative works therefrom, subject to the terms and conditions outlined [https://www.icao.int/pages/Disclaimer.aspx], and also subject to more specific restrictions that may apply to specific Material within the Site. |

### Identifiers

* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/icaosex
  * **Preferred**: true
  * **Period**: 2022-04-21 --> (ongoing)
  * **Comment**: This is the URL as specified by the terminology owner, and is considered authoritative.

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "icaosex",
  "url" : "http://terminology.hl7.org/NamingSystem/icaosex",
  "version" : "1.0.0",
  "name" : "ICAO_Sex",
  "title" : "International Civil Aviation Organization Sex",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2022-04-21T00:00:00-00:00",
  "publisher" : "International Civil Aviation Organization (ICAO)",
  "contact" : [
    {
      "name" : "International Civil Aviation Organization (ICAO); 999 Robert-Bourassa Boulevard, Montréal, Québec H3C 5H7, Canada",
      "telecom" : [
        {
          "system" : "email",
          "value" : "icaohq@icao.int"
        },
        {
          "system" : "phone",
          "value" : "+1 514-954-8219"
        },
        {
          "system" : "url",
          "value" : "https://www.icao.int/Pages/default.aspx"
        }
      ]
    }
  ],
  "responsible" : "International Civil Aviation Organization (ICAO)",
  "description" : "ICAO is funded and directed by 193 national governments to support their diplomacy and cooperation in air transport as signatory states to the [Chicago Convention (1944)](https://www.icao.int/about-icao/History/Pages/default.aspx)\r\n\r\nIts core function is to maintain an administrative and expert bureaucracy (the [ICAO Secretariat](https://www.icao.int/secretariat/Pages/default.aspx) supporting these diplomatic interactions, and to research new air transport policy and standardization innovations as directed and endorsed by governments through the [ICAO Assembly](https://www.icao.int/about-icao/assembly/Pages/default.aspx), or by the [ICAO Council](https://www.icao.int/about-icao/Council/Pages/council.aspx) which the assembly elects.\r\n\r\nICAO has developed a technical specification (sample version form 2021 [here](https://www.icao.int/publications/Documents/9303_p7_cons_en.pdf) ) to \"allow compatibility and global interchange using both visual (eye readable) and machine readable means. The specifications lay down standards for visas which can, where issued by a State and accepted by a receiving State, be used for travel purposes. The MRV[Machine Readable Visa] shall, as a minimum, contain the data specified herein in a form that is legible both visually and by optical character recognition methods..\" \r\n\r\nFurther, defining that \"Sex of MRV-A[Format A - Machine Readable Visa] holder, when included, is to be specified by use of the single initial commonly used in the language of the State of issue. If translation into English, French or Spanish is necessary, followed by an oblique and the capital letter F for female, M for male, or X for unspecified.\"\r\n\r\nSex of MRV-B[Format B - Machine Readable Visa] holder, when included, is to be specified by use of the single initial commonly used in the language of the State of issue. If translation into English, French or Spanish is necessary, followed by an oblique and the capital letter F for female, M for male, or X for unspecified.",
  "copyright" : "Copyright © ICAO 2021. All rights reserved. None of the materials provided on this web site may be used, reproduced or transmitted, in whole or in part, in any form or by any means, electronic or mechanical, including photocopying, recording or the use of any information storage and retrieval system, except as provided for in the site [Terms and Conditions](https://www.icao.int/pages/Disclaimer.aspx) without permission in writing from ICAO.\r\n\r\nICAO  grants permission to Users to visit the Site [https://www.icao.int/Pages/default.aspx] and to download, preprint and copy the information, documents and materials (collectively, \"Materials\") from the Site for the User’s personal, non-commercial use, without any right to resell or redistribute them or to compile or create derivative works therefrom, subject to the terms and conditions outlined [https://www.icao.int/pages/Disclaimer.aspx], and also subject to more specific restrictions that may apply to specific Material within the Site.",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/icaosex",
      "preferred" : true,
      "comment" : "This is the URL as specified by the terminology owner, and is considered authoritative.",
      "period" : {
        "start" : "2022-04-21"
      }
    }
  ]
}

```
