# ISBT - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ISBT**

## NamingSystem: ISBT 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/ib | *Version*:2.1.0 | |
| Active as of 2019-03-20 | *Responsible:*ICCBBA | *Computable Name*:Ib |

 
ISBT 128 is a coding system for blood components, hematopoietic progenitor cells and other tissues. It is comprised of an overall Application Specification, and labeling and coding documents for the separate sections: blood components, hematopoietic progenitor cells (draft), source plasma (draft) and tissues (draft). The documentation is supported by databases: Country/Collection Facility, Product Code (blood components), Product Code (hematopoietic progenitor sells), Product Code (source plasma), Product Code (tissues) and Special Testing. ISBT 128 is designed as a series of data structures that are designed to be technology-independent and can be used for bar coding, radio frequency tag encoding and electronic data interchange. The HL7 Blood Bank SIG is currently designing example messages that incorporate ISBT 128 coding. No changes of any kind will be needed to use ISBT 128 in HL7 messages. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/ib |
| Version | 2.1.0 |
| Name | Ib |
| Title | ISBT |
| Status | active |
| Definition | ISBT 128 is a coding system for blood components, hematopoietic progenitor cells and other tissues. It is comprised of an overall Application Specification, and labeling and coding documents for the separate sections: blood components, hematopoietic progenitor cells (draft), source plasma (draft) and tissues (draft). The documentation is supported by databases: Country/Collection Facility, Product Code (blood components), Product Code (hematopoietic progenitor sells), Product Code (source plasma), Product Code (tissues) and Special Testing. ISBT 128 is designed as a series of data structures that are designed to be technology-independent and can be used for bar coding, radio frequency tag encoding and electronic data interchange. The HL7 Blood Bank SIG is currently designing example messages that incorporate ISBT 128 coding. No changes of any kind will be needed to use ISBT 128 in HL7 messages. |
| Publisher | ICCBBA |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.6.18
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/ib
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "ib",
  "url" : "http://terminology.hl7.org/NamingSystem/ib",
  "version" : "2.1.0",
  "name" : "Ib",
  "title" : "ISBT",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2019-03-20T00:00:00-04:00",
  "publisher" : "ICCBBA",
  "responsible" : "ICCBBA",
  "description" : "ISBT 128 is a coding system for blood components, hematopoietic progenitor cells and other tissues. It is comprised of an overall Application Specification, and labeling and coding documents for the separate sections: blood components, hematopoietic progenitor cells (draft), source plasma (draft) and tissues (draft). The documentation is supported by databases: Country/Collection Facility, Product Code (blood components), Product Code (hematopoietic progenitor sells), Product Code (source plasma), Product Code (tissues) and Special Testing. ISBT 128 is designed as a series of data structures that are designed to be technology-independent and can be used for bar coding, radio frequency tag encoding and electronic data interchange. The HL7 Blood Bank SIG is currently designing example messages that incorporate ISBT 128 coding. No changes of any kind will be needed to use ISBT 128 in HL7 messages.",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.18",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/ib",
      "preferred" : true
    }
  ]
}

```
