# DICOM Unique Id - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **DICOM Unique Id**

## NamingSystem: DICOM Unique Id 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/dui | *Version*:1.0.0 |
| Active as of 2022-02-07 | *Computable Name*:DUI |

 
An OID issued under DICOM OID rules. DICOM OIDs are represented as plain OIDs, with a prefix of "urn:oid:". See https://www.dicomstandard.org/ 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/dui |
| Version | 1.0.0 |
| Name | DUI |
| Title | DICOM Unique Id |
| Status | active |
| Definition | An OID issued under DICOM OID rules. DICOM OIDs are represented as plain OIDs, with a prefix of "urn:oid:". See https://www.dicomstandard.org/ |

### Identifiers

* **Type**: URI
  * **Value**: urn:dicom:uid
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "dui",
  "url" : "http://terminology.hl7.org/NamingSystem/dui",
  "version" : "1.0.0",
  "name" : "DUI",
  "title" : "DICOM Unique Id",
  "status" : "active",
  "kind" : "identifier",
  "date" : "2022-02-07T00:00:00-00:00",
  "description" : "An OID issued under DICOM OID rules. DICOM OIDs are represented as plain OIDs, with a prefix of \"urn:oid:\". See https://www.dicomstandard.org/",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "urn:dicom:uid",
      "preferred" : true
    }
  ]
}

```
