# Health Canada Drug Product Database - Schedule - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Health Canada Drug Product Database - Schedule**

## NamingSystem: Health Canada Drug Product Database - Schedule 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/ca-hc-dpd-schedule | *Version*:1.0.0 | |
| Active as of 2024-11-04 | *Responsible:*Health Canada | *Computable Name*:Health_Canada_DPD_Schedule |
| **Copyright/Legal**: https://healthycanadians.gc.ca/important-eng.php#a4 | | |

 
The Code System describes the characteristics of drugs for use in Canada.\r\n\r\nDrugs in Canada are assigned one or more of the following schedules, according to the Food and Drug Regulations, and the Controlled Drugs and Substances Act.\r\n\r\n- Prescription (prescription drugs included in the Prescription Drug List)\r\n\r\n- Prescription Recommended (drugs that are recommended to be listed on the Prescription Drug List)\r\n\r\n- Schedule G (control drugs)\r\n\r\n- Schedule G (Controlled Drugs and Substances Act [CDSA] III)\r\n\r\n- Schedule G (CDSA IV)\r\n\r\n- Schedule C (drugs listed in Schedule C of the Food and Drugs Act, for example, radiopharmaceutical drugs)\r\n\r\n- Schedule D (drugs listed in Schedule D of the Food and Drugs Act, ie. biological products)\r\n\r\n- Narcotic (Narcotic Control Act)\r\n\r\n- Narcotic (CDSA I)\r\n\r\n- Narcotic (CDSA II)\r\n\r\n- Targeted (CDSA IV)\r\n\r\n- CDSA Recommended- Undergoing Regulatory Amendment to add this new substance to Controlled Drugs Substances Act\r\n\r\n- OTC (over the counter drugs that do not appear on a schedule or are not recommended to appear on any schedule)\r\n\r\n- Ethical: a drug that, in accordance with Federal Legislation, does not require a prescription, but that is generally prescribed by a medical practitioner. Ethical products are unscheduled non-prescription professional use products (e.g. MRI contrast agents, hemodialysis solutions) and a few emergency use products (e.g. nitroglycerine) 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/ca-hc-dpd-schedule |
| Version | 1.0.0 |
| Name | Health_Canada_DPD_Schedule |
| Title | Health Canada Drug Product Database - Schedule |
| Status | active |
| Definition | The Code System describes the characteristics of drugs for use in Canada.\r\n\r\nDrugs in Canada are assigned one or more of the following schedules, according to the Food and Drug Regulations, and the Controlled Drugs and Substances Act.\r\n\r\n- Prescription (prescription drugs included in the Prescription Drug List)\r\n\r\n- Prescription Recommended (drugs that are recommended to be listed on the Prescription Drug List)\r\n\r\n- Schedule G (control drugs)\r\n\r\n- Schedule G (Controlled Drugs and Substances Act [CDSA] III)\r\n\r\n- Schedule G (CDSA IV)\r\n\r\n- Schedule C (drugs listed in Schedule C of the Food and Drugs Act, for example, radiopharmaceutical drugs)\r\n\r\n- Schedule D (drugs listed in Schedule D of the Food and Drugs Act, ie. biological products)\r\n\r\n- Narcotic (Narcotic Control Act)\r\n\r\n- Narcotic (CDSA I)\r\n\r\n- Narcotic (CDSA II)\r\n\r\n- Targeted (CDSA IV)\r\n\r\n- CDSA Recommended- Undergoing Regulatory Amendment to add this new substance to Controlled Drugs Substances Act\r\n\r\n- OTC (over the counter drugs that do not appear on a schedule or are not recommended to appear on any schedule)\r\n\r\n- Ethical: a drug that, in accordance with Federal Legislation, does not require a prescription, but that is generally prescribed by a medical practitioner. Ethical products are unscheduled non-prescription professional use products (e.g. MRI contrast agents, hemodialysis solutions) and a few emergency use products (e.g. nitroglycerine) |
| Publisher | Health Canada |
| Copyright | https://healthycanadians.gc.ca/important-eng.php#a4 |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.5.1151
  * **Preferred**: true
  * **Comment**: 
* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/ca-hc-dpd-schedule
  * **Preferred**: true
  * **Comment**: Official canonical URL going forward.



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "ca-hc-dpd-schedule",
  "url" : "http://terminology.hl7.org/NamingSystem/ca-hc-dpd-schedule",
  "version" : "1.0.0",
  "name" : "Health_Canada_DPD_Schedule",
  "title" : "Health Canada Drug Product Database - Schedule",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2024-11-04T00:00:00-00:00",
  "publisher" : "Health Canada",
  "contact" : [
    {
      "name" : "Health Canada"
    }
  ],
  "responsible" : "HL7",
  "description" : "The Code System describes the characteristics of drugs for use in Canada.\\r\\n\\r\\nDrugs in Canada are assigned one or more of the following schedules, according to the Food and Drug Regulations, and the Controlled Drugs and Substances Act.\\r\\n\\r\\n- Prescription (prescription drugs included in the Prescription Drug List)\\r\\n\\r\\n- Prescription Recommended (drugs that are recommended to be listed on the Prescription Drug List)\\r\\n\\r\\n- Schedule G (control drugs)\\r\\n\\r\\n- Schedule G (Controlled Drugs and Substances Act [CDSA] III)\\r\\n\\r\\n- Schedule G (CDSA IV)\\r\\n\\r\\n- Schedule C (drugs listed in Schedule C of the Food and Drugs Act, for example, radiopharmaceutical drugs)\\r\\n\\r\\n- Schedule D (drugs listed in Schedule D of the Food and Drugs Act, ie. biological products)\\r\\n\\r\\n- Narcotic (Narcotic Control Act)\\r\\n\\r\\n- Narcotic (CDSA I)\\r\\n\\r\\n- Narcotic (CDSA II)\\r\\n\\r\\n- Targeted (CDSA IV)\\r\\n\\r\\n- CDSA Recommended- Undergoing Regulatory Amendment to add this new substance to Controlled Drugs Substances Act\\r\\n\\r\\n- OTC (over the counter drugs that do not appear on a schedule or are not recommended to appear on any schedule)\\r\\n\\r\\n- Ethical: a drug that, in accordance with Federal Legislation, does not require a prescription, but that is generally prescribed by a medical practitioner. Ethical products are unscheduled non-prescription professional use products (e.g. MRI contrast agents, hemodialysis solutions) and a few emergency use products (e.g. nitroglycerine)",
  "copyright" : "https://healthycanadians.gc.ca/important-eng.php#a4",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.5.1151",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/ca-hc-dpd-schedule",
      "preferred" : true,
      "comment" : "Official canonical URL going forward."
    }
  ]
}

```
