# United States Drug Enforcement Agency (DEA) Number - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **United States Drug Enforcement Agency (DEA) Number**

## NamingSystem: United States Drug Enforcement Agency (DEA) Number 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/USDEANumber | *Version*:1.0.0 |
| Active as of 2024-06-03 | *Computable Name*:USDEANumber |

 
A DEA number is a number assigned to a health care provider (such as a medical practitioner, dentist, or veterinarian) by the U.S. Drug Enforcement Administration allowing them to write prescriptions for controlled substances. Legally, the DEA number is solely to be used for tracking controlled substance prescribers and prescriptions. It is often used by the industry, however, as a general "prescriber number". 
A single person may have multiple DEA numbers. In particular, a prescriber who practices in multiple states or jurisdictions must have a DEA-issued number specific to each state or jurisdiction. 
A DEA number can be structurally validated: 
1. Add together the first, third, and fifth digits.
1. Add together the second, fourth, and sixth digits. Multiply the sum by 2.
1. Add together the totals from Step 1 and Step 2.
1. Verify that the last digit of the result of Step 3 matches the check digit of the DEA number.
 
This validates that the number is a valid DEA number, but does not confirm that the DEA number is active or assigned to the person presenting it. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/USDEANumber |
| Version | 1.0.0 |
| Name | USDEANumber |
| Title | United States Drug Enforcement Agency (DEA) Number |
| Status | active |
| Definition | A DEA number is a number assigned to a health care provider (such as a medical practitioner, dentist, or veterinarian) by the U.S. Drug Enforcement Administration allowing them to write prescriptions for controlled substances. Legally, the DEA number is solely to be used for tracking controlled substance prescribers and prescriptions. It is often used by the industry, however, as a general "prescriber number".A single person may have multiple DEA numbers. In particular, a prescriber who practices in multiple states or jurisdictions must have a DEA-issued number specific to each state or jurisdiction.A DEA number can be structurally validated:1. Add together the first, third, and fifth digits.
1. Add together the second, fourth, and sixth digits. Multiply the sum by 2.
1. Add together the totals from Step 1 and Step 2.
1. Verify that the last digit of the result of Step 3 matches the check digit of the DEA number.
This validates that the number is a valid DEA number, but does not confirm that the DEA number is active or assigned to the person presenting it. |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.4.814
  * **Preferred**: true
  * **Period**: 
* **Type**: URI
  * **Value**: http://terminology.hl7.org/NamingSystem/USDEANumber
  * **Preferred**: true
  * **Period**: 2024-06-03 --> (ongoing)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "USDEANumber",
  "url" : "http://terminology.hl7.org/NamingSystem/USDEANumber",
  "version" : "1.0.0",
  "name" : "USDEANumber",
  "title" : "United States Drug Enforcement Agency (DEA) Number",
  "status" : "active",
  "kind" : "identifier",
  "date" : "2024-06-03T00:00:00-00:00",
  "contact" : [
    {
      "name" : "U.S. Department of Justice; Drug Enforcement Administration; DEA Office of Diversion Control; 8701 Morrissette Drive, Springfield, VA 22152",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.deadiversion.usdoj.gov/index.html"
        }
      ]
    }
  ],
  "description" : "  A DEA number is a number assigned to a health care provider (such as a medical practitioner, dentist, or veterinarian) by the U.S. Drug Enforcement Administration allowing them to write prescriptions for controlled substances. Legally, the DEA number is solely to be used for tracking controlled substance prescribers and prescriptions. It is often used by the industry, however, as a general \"prescriber number\".\r\n\r\nA single person may have multiple DEA numbers.  In particular, a prescriber who practices in multiple states or jurisdictions must have a DEA-issued number specific to each state or jurisdiction.\r\n\r\nA DEA number can be structurally validated:\r\n\r\n1. Add together the first, third, and fifth digits.\r\n\r\n2. Add together the second, fourth, and sixth digits. Multiply the sum by 2.\r\n\r\n3. Add together the totals from Step 1 and Step 2.\r\n\r\n4. Verify that the last digit of the result of Step 3 matches the check digit of the DEA number.\r\n\r\nThis validates that the number is a valid DEA number, but does not confirm that the DEA number is active or assigned to the person presenting it.",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.4.814",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/NamingSystem/USDEANumber",
      "preferred" : true,
      "period" : {
        "start" : "2024-06-03"
      }
    }
  ]
}

```
