# RadLex radiology lexicon - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **RadLex radiology lexicon**

## NamingSystem: RadLex radiology lexicon 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/RadLex | *Version*:1.0.1 | |
| Active as of 2022-03-31 | *Responsible:*[RSNA (Radiological Society of North America)](https://www.rsna.org/) | *Computable Name*:RadLex |
| **Copyright/Legal**: Copyright 2014 – The Radiological Society of North America (RSNA), all rights reserved. Licensed under RadLex License Version 2.0. You may obtain a copy of the license at: http://www.rsna.org/radlexdownloads/This work is distributed under the above noted license on an “AS IS” basis, WITHOUT WARRANTIES OF ANY KIND, either express or implied. Please see the license for complete terms and conditions.Subject to the terms and conditions of this Agreement, Licensor hereby grants to You a worldwide, non-exclusive, no-charge, royalty-free copyright license to reproduce, prepare Adaptations of, publicly display, publicly perform, sublicense, and distribute the Work and such Adaptations in any medium.RadLex is licensed freely for commercial and non-commercial users. Review and download the license: http://www.rsna.org/uploadedFiles/RSNA/Content/Informatics/RadLex_License_Agreement_and_Terms_of_Use_V2_Final.pdf | | |

 
RadLex is a comprehensive set of radiology terms for use in radiology reporting, decision support, data mining, data registries, education and research. 
RadLex Playbook is a project of the Radiological Society of North America (RSNA), and constitutes a portion of the RadLex ontology. Playbook aims to provide a standard system for naming radiology procedures, based on the elements which define an imaging exam such as modality and body part. By providing standard names and codes for radiologic studies, Playbook is intended to facilitate a variety of operational and quality improvement efforts, including workflow optimization, chargemaster management, radiation dose tracking, enterprise integration and image exchange. 
As of RadLex Playbook version 2.5, a four-year project to harmonize RadLex Playbook with the radiology portion of the LOINC standard has been concluded, leading to the LOINC-RSNA Radiology Playbook which is jointly managed by the Regenstrief Institute (publisher of LOINC) and RSNA. This harmonized Playbook defines a new information model for describing imaging procedures, and identifies correspondences between RadLex Playbook codes and LOINC codes. (See https://loinc.org/download/loinc-users-guide and http://pubs.rsna.org/doi/pdf/10.1148/rg.2017160188 for details.) Note that RadLex Playbook codes start with "RPID" followed by a numerical value. LOINC codes consist of a numerical code, followed by a hyphen and a single additional digit (called the check digit). Note that in the future, new codes will be created in the LOINC format only, not the RPID format. New adopters are encouraged to use LOINC-format codes. 
LOINC-format codes may be accessed at http://search.loinc.org. New code requests may be submitted to the joint Regenstrief-RSNA governance committee at https://loinc.org/submissions/. 
From the RSNA website: 
"We (RSNA) recognize the benefits that come from radiologists using common language to communicate diagnostic results. For this reason, RSNA produced RadLex®, a comprehensive set of radiology terms for use in radiology reporting, decision support, data mining, data registries, education and research. 
RadLex provides the foundation for vital data resources used in radiology: 
* The LOINC/RSNA Radiology Playbook (http://playbook.radlex.org/playbook/SearchRadlexAction)
* RadElement Common Data Elements (http://www.radelement.org/)
* RadReport Radiology Reporting Templates (http://radreport.org/)
 
The development of RadLex has been supported by the National Institute of Biomedical Imaging and Bioengineering (NIBIB) and the cancer Biomedical Informatics Grid (caBIG) project.;" 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/RadLex |
| Version | 1.0.1 |
| Name | RadLex |
| Title | RadLex radiology lexicon |
| Status | active |
| Definition | RadLex is a comprehensive set of radiology terms for use in radiology reporting, decision support, data mining, data registries, education and research.RadLex Playbook is a project of the Radiological Society of North America (RSNA), and constitutes a portion of the RadLex ontology. Playbook aims to provide a standard system for naming radiology procedures, based on the elements which define an imaging exam such as modality and body part. By providing standard names and codes for radiologic studies, Playbook is intended to facilitate a variety of operational and quality improvement efforts, including workflow optimization, chargemaster management, radiation dose tracking, enterprise integration and image exchange.As of RadLex Playbook version 2.5, a four-year project to harmonize RadLex Playbook with the radiology portion of the LOINC standard has been concluded, leading to the LOINC-RSNA Radiology Playbook which is jointly managed by the Regenstrief Institute (publisher of LOINC) and RSNA. This harmonized Playbook defines a new information model for describing imaging procedures, and identifies correspondences between RadLex Playbook codes and LOINC codes. (See https://loinc.org/download/loinc-users-guide and http://pubs.rsna.org/doi/pdf/10.1148/rg.2017160188 for details.) Note that RadLex Playbook codes start with "RPID" followed by a numerical value. LOINC codes consist of a numerical code, followed by a hyphen and a single additional digit (called the check digit). Note that in the future, new codes will be created in the LOINC format only, not the RPID format. New adopters are encouraged to use LOINC-format codes.LOINC-format codes may be accessed at http://search.loinc.org. New code requests may be submitted to the joint Regenstrief-RSNA governance committee at https://loinc.org/submissions/.From the RSNA website:"We (RSNA) recognize the benefits that come from radiologists using common language to communicate diagnostic results. For this reason, RSNA produced RadLex®, a comprehensive set of radiology terms for use in radiology reporting, decision support, data mining, data registries, education and research.RadLex provides the foundation for vital data resources used in radiology:* The LOINC/RSNA Radiology Playbook (http://playbook.radlex.org/playbook/SearchRadlexAction)
* RadElement Common Data Elements (http://www.radelement.org/)
* RadReport Radiology Reporting Templates (http://radreport.org/)
The development of RadLex has been supported by the National Institute of Biomedical Imaging and Bioengineering (NIBIB) and the cancer Biomedical Informatics Grid (caBIG) project.;" |
| Publisher | RSNA (Radiological Society of North America) |
| Copyright | Copyright 2014 – The Radiological Society of North America (RSNA), all rights reserved. Licensed under RadLex License Version 2.0. You may obtain a copy of the license at: http://www.rsna.org/radlexdownloads/This work is distributed under the above noted license on an “AS IS” basis, WITHOUT WARRANTIES OF ANY KIND, either express or implied. Please see the license for complete terms and conditions.Subject to the terms and conditions of this Agreement, Licensor hereby grants to You a worldwide, non-exclusive, no-charge, royalty-free copyright license to reproduce, prepare Adaptations of, publicly display, publicly perform, sublicense, and distribute the Work and such Adaptations in any medium.RadLex is licensed freely for commercial and non-commercial users. Review and download the license: http://www.rsna.org/uploadedFiles/RSNA/Content/Informatics/RadLex_License_Agreement_and_Terms_of_Use_V2_Final.pdf |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.6.256
  * **Preferred**: true
  * **Period**: 
  * **Comment**: 
* **Type**: URI
  * **Value**: http://radlex.org
  * **Preferred**: true
  * **Period**: 2019-05-05 --> (ongoing)
  * **Comment**: This is the URL as specified by the terminology owner, and is considered authoritative.

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "RadLex",
  "url" : "http://terminology.hl7.org/NamingSystem/RadLex",
  "version" : "1.0.1",
  "name" : "RadLex",
  "title" : "RadLex radiology lexicon",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2022-03-31T00:00:00-00:00",
  "publisher" : "RSNA (Radiological Society of North America)",
  "contact" : [
    {
      "name" : "RSNA (Radiological Society of North America); 820 Jorie Blvd., Suite 200, Oak Brook, IL 60523-2251 USA",
      "telecom" : [
        {
          "system" : "email",
          "value" : "informatics@rsna.org"
        },
        {
          "system" : "url",
          "value" : "https://www.rsna.org/"
        },
        {
          "system" : "phone",
          "value" : "1-800-381-6660"
        }
      ]
    }
  ],
  "responsible" : "RSNA (Radiological Society of North America)",
  "description" : "RadLex is a comprehensive set of radiology terms for use in radiology reporting, decision support, data mining, data registries, education and research.\r\n\r\nRadLex Playbook is a project of the Radiological Society of North America (RSNA), and constitutes a portion of the RadLex ontology. Playbook aims to provide a standard system for naming radiology procedures, based on the elements which define an imaging exam such as modality and body part. By providing standard names and codes for radiologic studies, Playbook is intended to facilitate a variety of operational and quality improvement efforts, including workflow optimization, chargemaster management, radiation dose tracking, enterprise integration and image exchange.\r\n\r\nAs of RadLex Playbook version 2.5, a four-year project to harmonize RadLex Playbook with the radiology portion of the LOINC standard has been concluded, leading to the LOINC-RSNA Radiology Playbook which is jointly managed by the Regenstrief Institute (publisher of LOINC) and RSNA. This harmonized Playbook defines a new information model for describing imaging procedures, and identifies correspondences between RadLex Playbook codes and LOINC codes. (See https://loinc.org/download/loinc-users-guide and http://pubs.rsna.org/doi/pdf/10.1148/rg.2017160188 for details.) Note that RadLex Playbook codes start with \"RPID\" followed by a numerical value. LOINC codes consist of a numerical code, followed by a hyphen and a single additional digit (called the check digit). Note that in the future, new codes will be created in the LOINC format only, not the RPID format. New adopters are encouraged to use LOINC-format codes.\r\n\r\nLOINC-format codes may be accessed at http://search.loinc.org. New code requests may be submitted to the joint Regenstrief-RSNA governance committee at https://loinc.org/submissions/. \r\n\r\nFrom the RSNA website:\r\n\r\n\"We (RSNA) recognize the benefits that come from radiologists using common language to communicate diagnostic results. For this reason, RSNA produced RadLex®, a comprehensive set of radiology terms for use in radiology reporting, decision support, data mining, data registries, education and research.\r\n\r\nRadLex provides the foundation for vital data resources used in radiology:\r\n\r\n *  The LOINC/RSNA Radiology Playbook (http://playbook.radlex.org/playbook/SearchRadlexAction) \r\n *  RadElement Common Data Elements (http://www.radelement.org/) \r\n *  RadReport Radiology Reporting Templates (http://radreport.org/) \r\n\r\nThe development of RadLex has been supported by the National Institute of Biomedical Imaging and Bioengineering (NIBIB) and the cancer Biomedical Informatics Grid (caBIG) project.;\"",
  "copyright" : "Copyright 2014 – The Radiological Society of North America (RSNA), all rights reserved. Licensed under RadLex License Version 2.0. You may obtain a copy of the license at: http://www.rsna.org/radlexdownloads/ \r\n\r\nThis work is distributed under the above noted license on an “AS IS” basis, WITHOUT WARRANTIES OF ANY KIND, either express or implied. Please see the license for complete terms and conditions.\r\n\r\nSubject to the terms and conditions of this Agreement, Licensor hereby grants to You a worldwide, non-exclusive, no-charge, royalty-free copyright license to reproduce, prepare Adaptations of, publicly display, publicly perform, sublicense, and distribute the Work and such Adaptations in any medium.\r\n\r\nRadLex is licensed freely for commercial and non-commercial users. Review and download the license: http://www.rsna.org/uploadedFiles/RSNA/Content/Informatics/RadLex_License_Agreement_and_Terms_of_Use_V2_Final.pdf",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.256",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://radlex.org",
      "preferred" : true,
      "comment" : "This is the URL as specified by the terminology owner, and is considered authoritative.",
      "period" : {
        "start" : "2019-05-05"
      }
    }
  ]
}

```
