# Pharmacogene Variation - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Pharmacogene Variation**

## NamingSystem: Pharmacogene Variation 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/PharmVar | *Version*:1.0.0 | |
| Active as of 2024-04-29 | *Responsible:*[Pharmacogene Variation Consortium](https://www.pharmvar.org/) | *Computable Name*:PharmVar |
| **Copyright/Legal**: The PharmVar database content is licensed under a[Creative Commons Attribution-ShareAlike 4.0 International license](https://creativecommons.org/licenses/by-sa/4.0/)that allows for the sharing and adaptation of our information with proper attribution.See[https://www.pharmvar.org/terms-and-conditions](https://www.pharmvar.org/terms-and-conditions)for Terms and Conditions. | | |

 
"The major focus of the Pharmacogene Consortium (PharmVar) is to serve as a repository for allelic variation, providing an official and unified allele designation system for the Pharmacogenetics (PGx) community and facilitating the translation of genotype into phenotype and clinical implementation of PGx. While the majority of pharmacogenes in PharmVar utilize the star nomenclature to describe variation, the provision of single nucleotide variants (SNVs), rather than haplotype, is preferred for some genes. Thus, PharmVar has two different page formats, A) using star nomenclature and B) using rs ID# as allele (referred to as ‘rs-format’). 
PharmVar designates human pharmacogene variation and houses allelic variants in the PharmVar database. 
* All submissions to PharmVar must use the submission form available on [www.PharmVar.org](https://www.pharmvar.org/) and be submitted to [submissions@PharmVar.org](mailto:submissions@PharmVar.org). Only complete submission requests will be accepted and processed.
* PharmVar Gene Expert Panels will review each submission and make a recommendation to the PharmVar Steering Committee.
* In this ‘Allele Designation Criteria and Evidence level’ document, we collectively refer to deviations from the RefSeq as “sequence variations” or "SNVs", including single nucleotide polymorphisms (SNPs) and small nucleotide insertions and deletions (indels) up to 50 bp. Copy number variants (i.e. entire or partial gene deletions and duplications), hybrid genes (e.g. CYP2D6/2D7 hybrids) and duplications containing non-identical gene copies (e.g. CYP2D6*36+*10) are referred to as CNVs or structural variants.
* PharmVar applies the following criteria for allele designation. In rare cases, exceptions may be made to accommodate established star allele definitions to minimize impact on research, clinical labs and/or PGx implementation."
 
PharmVar is released monthly (or more frequently) and uses a numbered database version format for each release. 
Note on updates to variants: The variants defined in association with a given PharmVar ID are immutable. When it is necessary to update the variant definitions for an associated concept, the existing allele and PharmVar ID are marked as "retired" and a new PharmVar ID is issued with the updated variant definitions. 
In the context of the representation of PharmVar in HL7 standards: 
* The concept identifier is the PharmVar ID
* The concept display name is the Allele Name
* There are several concept properties associated with PharmVar concepts (Legacy Label, Variants, etc.)
* The code system is represented with an is-a hierarchy
 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/PharmVar |
| Version | 1.0.0 |
| Name | PharmVar |
| Title | Pharmacogene Variation |
| Status | active |
| Definition | "The major focus of the Pharmacogene Consortium (PharmVar) is to serve as a repository for allelic variation, providing an official and unified allele designation system for the Pharmacogenetics (PGx) community and facilitating the translation of genotype into phenotype and clinical implementation of PGx. While the majority of pharmacogenes in PharmVar utilize the star nomenclature to describe variation, the provision of single nucleotide variants (SNVs), rather than haplotype, is preferred for some genes. Thus, PharmVar has two different page formats, A) using star nomenclature and B) using rs ID# as allele (referred to as ‘rs-format’).PharmVar designates human pharmacogene variation and houses allelic variants in the PharmVar database.* All submissions to PharmVar must use the submission form available on [www.PharmVar.org](https://www.pharmvar.org/) and be submitted to [submissions@PharmVar.org](mailto:submissions@PharmVar.org). Only complete submission requests will be accepted and processed.
* PharmVar Gene Expert Panels will review each submission and make a recommendation to the PharmVar Steering Committee.
* In this ‘Allele Designation Criteria and Evidence level’ document, we collectively refer to deviations from the RefSeq as “sequence variations” or "SNVs", including single nucleotide polymorphisms (SNPs) and small nucleotide insertions and deletions (indels) up to 50 bp. Copy number variants (i.e. entire or partial gene deletions and duplications), hybrid genes (e.g. CYP2D6/2D7 hybrids) and duplications containing non-identical gene copies (e.g. CYP2D6*36+*10) are referred to as CNVs or structural variants.
* PharmVar applies the following criteria for allele designation. In rare cases, exceptions may be made to accommodate established star allele definitions to minimize impact on research, clinical labs and/or PGx implementation."
PharmVar is released monthly (or more frequently) and uses a numbered database version format for each release.Note on updates to variants: The variants defined in association with a given PharmVar ID are immutable. When it is necessary to update the variant definitions for an associated concept, the existing allele and PharmVar ID are marked as "retired" and a new PharmVar ID is issued with the updated variant definitions.In the context of the representation of PharmVar in HL7 standards:* The concept identifier is the PharmVar ID
* The concept display name is the Allele Name
* There are several concept properties associated with PharmVar concepts (Legacy Label, Variants, etc.)
* The code system is represented with an is-a hierarchy
 |
| Publisher | Pharmacogene Variation Consortium |
| Copyright | The PharmVar database content is licensed under a [Creative Commons Attribution-ShareAlike 4.0 International license](https://creativecommons.org/licenses/by-sa/4.0/) that allows for the sharing and adaptation of our information with proper attribution.See [https://www.pharmvar.org/terms-and-conditions](https://www.pharmvar.org/terms-and-conditions) for Terms and Conditions. |

### Identifiers

* **Type**: URI
  * **Value**: http://www.pharmvar.org
  * **Preferred**: true
  * **Period**: 2024-04-29 --> (ongoing)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "PharmVar",
  "url" : "http://terminology.hl7.org/NamingSystem/PharmVar",
  "version" : "1.0.0",
  "name" : "PharmVar",
  "title" : "Pharmacogene Variation",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2024-04-29T00:00:00-00:00",
  "publisher" : "Pharmacogene Variation Consortium",
  "contact" : [
    {
      "name" : "Pharmacogene Variation Consortium",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pharmvar.org/"
        },
        {
          "system" : "email",
          "value" : "submissions@PharmVar.org"
        }
      ]
    }
  ],
  "description" : "\"The major focus of the Pharmacogene Consortium (PharmVar) is to serve as a repository for allelic variation, providing an official and unified allele designation system for the Pharmacogenetics (PGx) community and facilitating the translation of genotype into phenotype and clinical implementation of PGx. While the majority of pharmacogenes in PharmVar utilize the star nomenclature to describe variation, the provision of single nucleotide variants (SNVs), rather than haplotype, is preferred for some genes. Thus, PharmVar has two different page formats, A) using star nomenclature and B) using rs ID# as allele (referred to as ‘rs-format’).\r\n\r\nPharmVar designates human pharmacogene variation and houses allelic variants in the PharmVar database.\r\n\r\n* All submissions to PharmVar must use the submission form available on [www.PharmVar.org](https://www.pharmvar.org/) and be submitted to [submissions@PharmVar.org](mailto:submissions@PharmVar.org). Only complete submission requests will be accepted and processed.\r\n\r\n* PharmVar Gene Expert Panels will review each submission and make a recommendation to the PharmVar Steering Committee.\r\n\r\n* In this ‘Allele Designation Criteria and Evidence level’ document, we collectively refer to deviations from the RefSeq as “sequence variations” or \"SNVs\", including single nucleotide polymorphisms (SNPs) and small nucleotide insertions and deletions (indels) up to 50 bp. Copy number variants (i.e. entire or partial gene deletions and duplications), hybrid genes (e.g. CYP2D6/2D7 hybrids) and duplications containing non-identical gene copies (e.g. CYP2D6\\*36+\\*10) are referred to as CNVs or structural variants.\r\n\r\n* PharmVar applies the following criteria for allele designation. In rare cases, exceptions may be made to accommodate established star allele definitions to minimize impact on research, clinical labs and/or PGx implementation.\"\r\n\r\nPharmVar is released monthly (or more frequently) and uses a numbered database version format for each release.\r\n\r\nNote on updates to variants: The variants defined in association with a given PharmVar ID are immutable. When it is necessary to update the variant definitions for an associated concept, the existing allele and PharmVar ID are marked as \"retired\" and a new PharmVar ID is issued with the updated variant definitions.\r\n\r\nIn the context of the representation of PharmVar in HL7 standards:\r\n\r\n* The concept identifier is the PharmVar ID\r\n\r\n* The concept display name is the Allele Name\r\n\r\n* There are several concept properties associated with PharmVar concepts (Legacy Label, Variants, etc.)\r\n\r\n* The code system is represented with an is-a hierarchy",
  "copyright" : "The PharmVar database content is licensed under a [Creative Commons Attribution-ShareAlike 4.0 International license](https://creativecommons.org/licenses/by-sa/4.0/) that allows for the sharing and adaptation of our information with proper attribution.\r\n\r\nSee [https://www.pharmvar.org/terms-and-conditions](https://www.pharmvar.org/terms-and-conditions) for Terms and Conditions.",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "http://www.pharmvar.org",
      "preferred" : true,
      "period" : {
        "start" : "2024-04-29"
      }
    }
  ]
}

```
