# NCPDP Brand Generic Indicator - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NCPDP Brand Generic Indicator**

## NamingSystem: NCPDP Brand Generic Indicator 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/NCPDPBrandGenericIndicator | *Version*:1.0.1 | |
| Active as of 2021-03-10 | *Responsible:*National Council for Prescription Drug Programs | *Computable Name*:NCPDPBrandGenericIndicator |

 
Denotes brand or generic drug dispensed. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/NCPDPBrandGenericIndicator |
| Version | 1.0.1 |
| Name | NCPDPBrandGenericIndicator |
| Title | NCPDP Brand Generic Indicator |
| Status | active |
| Definition | Denotes brand or generic drug dispensed. |
| Publisher | National Council for Prescription Drug Programs |

### Identifiers

* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/NCPDPBrandGenericIndicator
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "NCPDPBrandGenericIndicator",
  "url" : "http://terminology.hl7.org/NamingSystem/NCPDPBrandGenericIndicator",
  "version" : "1.0.1",
  "name" : "NCPDPBrandGenericIndicator",
  "title" : "NCPDP Brand Generic Indicator",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2021-03-10T00:00:00-04:00",
  "publisher" : "National Council for Prescription Drug Programs",
  "contact" : [
    {
      "name" : "National Council for Prescription Drug Programs",
      "telecom" : [
        {
          "system" : "phone",
          "value" : "480.477.1000"
        },
        {
          "system" : "email",
          "value" : "info@ncpdp.org"
        }
      ]
    }
  ],
  "responsible" : "National Council for Prescription Drug Programs",
  "description" : "Denotes brand or generic drug dispensed.",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/NCPDPBrandGenericIndicator",
      "preferred" : true
    }
  ]
}

```
