# ISBT 128 Standard Terminology for Medical Products of Human Origin Product Description Codes - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ISBT 128 Standard Terminology for Medical Products of Human Origin Product Description Codes**

## NamingSystem: ISBT 128 Standard Terminology for Medical Products of Human Origin Product Description Codes 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/ISBT128ProductDescriptionCodes | *Version*:1.1.0 | |
| Active as of 2025-10-30 | *Responsible:*[ICCBBA](https://www.isbt128.org/) | *Computable Name*:ISBT128ProductDescriptionCodes |
| **Copyright/Legal**: ISBT 128 is owned by ICCBBA and protected by copyright.The ISBT 128 information standard and its accompanying databases, reference tables, documentation, and software tools are licensed and not sold. ISBT 128 is owned by ICCBBA and protected by copyright.ICCBBA grants three types of licenses for the use of ISBT 128; Vendor, Limited Use Vendor, and Facility. Each license category has unique limitations as to how licensees can use ISBT 128. See[https://www.isbt128.org/registration-licensing](https://www.isbt128.org/registration-licensing). | | |

 
The ISBT 128 Standard provides for the identification, terminology, coding, labeling, and data exchange for medical products of human origin. ISBT 128 Product Description Codes (PDCs) are associated with product descriptions in the ISBT 128 PDC Database based on standardized terminology. The ISBT 128 PDC Database is an international database protected by copyright that contains PDCs that may not apply to all countries. Note that the existence of a PDC does not imply that a product is acceptable to produce and distribute in your region. It is the responsibility of the user to observe national regulations, guidelines, and standards. For more information, see[https://www.isbt128.org/uri/productdescriptioncode](https://www.isbt128.org/uri/productdescriptioncode). 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/ISBT128ProductDescriptionCodes |
| Version | 1.1.0 |
| Name | ISBT128ProductDescriptionCodes |
| Title | ISBT 128 Standard Terminology for Medical Products of Human Origin Product Description Codes |
| Status | active |
| Definition | The ISBT 128 Standard provides for the identification, terminology, coding, labeling, and data exchange for medical products of human origin. ISBT 128 Product Description Codes (PDCs) are associated with product descriptions in the ISBT 128 PDC Database based on standardized terminology. The ISBT 128 PDC Database is an international database protected by copyright that contains PDCs that may not apply to all countries. Note that the existence of a PDC does not imply that a product is acceptable to produce and distribute in your region. It is the responsibility of the user to observe national regulations, guidelines, and standards. For more information, see [https://www.isbt128.org/uri/productdescriptioncode](https://www.isbt128.org/uri/productdescriptioncode). |
| Publisher | ICCBBA |
| Copyright | ISBT 128 is owned by ICCBBA and protected by copyright.The ISBT 128 information standard and its accompanying databases, reference tables, documentation, and software tools are licensed and not sold. ISBT 128 is owned by ICCBBA and protected by copyright.ICCBBA grants three types of licenses for the use of ISBT 128; Vendor, Limited Use Vendor, and Facility. Each license category has unique limitations as to how licensees can use ISBT 128. See [https://www.isbt128.org/registration-licensing](https://www.isbt128.org/registration-licensing). |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.6.18.2.6
  * **Preferred**: true
  * **Period**: 2025-10-30 --> (ongoing)
  * **Comment**: 
* **Type**: URI
  * **Value**: https://www.isbt128.org/uri/productdescriptioncode
  * **Preferred**: true
  * **Period**: 2025-10-30 --> (ongoing)
  * **Comment**: This is the URL as specified by the terminology owner, and is considered authoritative.



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "ISBT128ProductDescriptionCodes",
  "url" : "http://terminology.hl7.org/NamingSystem/ISBT128ProductDescriptionCodes",
  "version" : "1.1.0",
  "name" : "ISBT128ProductDescriptionCodes",
  "title" : "ISBT 128 Standard Terminology for Medical Products of Human Origin Product Description Codes",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2025-10-30T00:00:00-00:00",
  "publisher" : "ICCBBA",
  "contact" : [
    {
      "name" : "ICCBBA; P.O. Box 11309, San Bernardino, CA 92374, United States",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.isbt128.org/"
        },
        {
          "system" : "email",
          "value" : "iccbba@iccbba.org"
        },
        {
          "system" : "phone",
          "value" : "+1 909 793 6516"
        }
      ]
    }
  ],
  "responsible" : "ICCBBA",
  "description" : "The ISBT 128 Standard provides for the identification, terminology, coding, labeling, and data exchange for medical products of human origin. ISBT 128 Product Description Codes (PDCs) are associated with product descriptions in the ISBT 128 PDC Database based on standardized terminology. The ISBT 128 PDC Database is an international database protected by copyright that contains PDCs that may not apply to all countries. Note that the existence of a PDC does not imply that a product is acceptable to produce and distribute in your region. It is the responsibility of the user to observe national regulations, guidelines, and standards. For more information, see [https://www.isbt128.org/uri/productdescriptioncode](https://www.isbt128.org/uri/productdescriptioncode).",
  "copyright" : "ISBT 128 is owned by ICCBBA and protected by copyright.\r\n\r\nThe ISBT 128 information standard and its accompanying databases, reference tables, documentation, and software tools are licensed and not sold. ISBT 128 is owned by ICCBBA and protected by copyright.\r\n\r\nICCBBA grants three types of licenses for the use of ISBT 128; Vendor, Limited Use Vendor, and Facility. Each license category has unique limitations as to how licensees can use ISBT 128. See [https://www.isbt128.org/registration-licensing](https://www.isbt128.org/registration-licensing).",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.18.2.6",
      "preferred" : true,
      "period" : {
        "start" : "2025-10-30"
      }
    },
    {
      "type" : "uri",
      "value" : "https://www.isbt128.org/uri/productdescriptioncode",
      "preferred" : true,
      "comment" : "This is the URL as specified by the terminology owner, and is considered authoritative.",
      "period" : {
        "start" : "2025-10-30"
      }
    }
  ]
}

```
