# ICD-9 Dual Coding - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ICD-9 Dual Coding**

## NamingSystem: ICD-9 Dual Coding 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/ICD-9DualCoding | *Version*:2.1.0 | |
| Retired as of 2021-11-09 | *Responsible:*HL7 | *Computable Name*:ICD9DualCoding |

 
ICD-9 Dual Coding Expression Syntax", description: ICD-9 allows dual coding. Refer to Section ?? of the ICD-9 Instruction Manual (ref?). 
This OID identifies the code system that describes how to encode Dual Coding in a CD compatible expression (for Datatypes R2 CD only). 
An ICD-9 dual code expression SHALL consist of two ICD-9 codes separated by space. This code system SHALL NOT be used for single ICD-9 codes; the normal ICD-9 code system oid which is 2.16.840.1.113883.6.3 should be used in this case. DisplayName SHALL not be used. 
Dual code expressions SHALL only be used per the rules described in the ICD-9 instruction manual. 
**An example CD:** 

```
<example code="989.5 E905.9" codeSystem="2.16.840.1.113883.6.260">
  <originalText value="ANAPHYLAXIS DUE TO BITE OR STING"/>
</example>

```

 
Where: 
* 989.5 is: "Toxic effect of venom"
* E905.9 is: "Bite or sting"
 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/ICD-9DualCoding |
| Version | 2.1.0 |
| Name | ICD9DualCoding |
| Title | ICD-9 Dual Coding |
| Status | retired |
| Definition | ICD-9 Dual Coding Expression Syntax", description: ICD-9 allows dual coding. Refer to Section ?? of the ICD-9 Instruction Manual (ref?).This OID identifies the code system that describes how to encode Dual Coding in a CD compatible expression (for Datatypes R2 CD only).An ICD-9 dual code expression SHALL consist of two ICD-9 codes separated by space. This code system SHALL NOT be used for single ICD-9 codes; the normal ICD-9 code system oid which is 2.16.840.1.113883.6.3 should be used in this case. DisplayName SHALL not be used.Dual code expressions SHALL only be used per the rules described in the ICD-9 instruction manual.**An example CD:**```
\<example code="989.5 E905.9" codeSystem="2.16.840.1.113883.6.260">
  \<originalText value="ANAPHYLAXIS DUE TO BITE OR STING"/>
\</example>

```
Where:* 989.5 is: "Toxic effect of venom"
* E905.9 is: "Bite or sting"
 |
| Publisher | HL7 |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.6.261
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/ICD-9DualCoding
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "ICD-9DualCoding",
  "url" : "http://terminology.hl7.org/NamingSystem/ICD-9DualCoding",
  "version" : "2.1.0",
  "name" : "ICD9DualCoding",
  "title" : "ICD-9 Dual Coding",
  "status" : "retired",
  "kind" : "codesystem",
  "date" : "2021-11-09T10:00:00+10:00",
  "publisher" : "HL7",
  "contact" : [
    {
      "name" : "HL7,HL7,HL7,HL7"
    }
  ],
  "responsible" : "HL7",
  "description" : "ICD-9 Dual Coding Expression Syntax\", description: ICD-9 allows dual coding. Refer to Section ?? of the ICD-9 Instruction Manual (ref?).\r\n\r\nThis OID identifies the code system that describes how to encode Dual Coding in a CD compatible expression (for Datatypes R2 CD only).\r\n\r\nAn ICD-9 dual code expression SHALL consist of two ICD-9 codes separated by space. This code system SHALL NOT be used for single ICD-9 codes; the normal ICD-9 code system oid which is 2.16.840.1.113883.6.3 should be used in this case. DisplayName SHALL not be used.\r\n\r\nDual code expressions SHALL only be used per the rules described in the ICD-9 instruction manual.\r\n\r\n**An example CD:**\r\n\r\n```\r\n<example code=\"989.5 E905.9\" codeSystem=\"2.16.840.1.113883.6.260\">\r\n  <originalText value=\"ANAPHYLAXIS DUE TO BITE OR STING\"/>\r\n</example>\r\n```\r\nWhere:\r\n* 989.5 is: \"Toxic effect of venom\"\r\n* E905.9 is: \"Bite or sting\"",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.261",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/ICD-9DualCoding",
      "preferred" : true
    }
  ]
}

```
