# IANA Time Zone Database - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **IANA Time Zone Database**

## NamingSystem: IANA Time Zone Database 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/IANATimeZoneDatabase | *Version*:1.0.0 | |
| Active as of 2024-11-04 | *Responsible:*[IANA](https://www.iana.org/) | *Computable Name*:IANATimeZoneDatabase |
| **Copyright/Legal**: Public domain | | |

 
The Time Zone Database (often called tz or zoneinfo) contains code and data that represent the history of local time for many representative locations around the globe. It is updated periodically to reflect changes made by political bodies to time zone boundaries, UTC offsets, and daylight-saving rules. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/IANATimeZoneDatabase |
| Version | 1.0.0 |
| Name | IANATimeZoneDatabase |
| Title | IANA Time Zone Database |
| Status | active |
| Definition | The Time Zone Database (often called tz or zoneinfo) contains code and data that represent the history of local time for many representative locations around the globe. It is updated periodically to reflect changes made by political bodies to time zone boundaries, UTC offsets, and daylight-saving rules. |
| Publisher | IANA |
| Copyright | Public domain |

### Identifiers

* **Type**: URI
  * **Value**: https://www.iana.org/time-zones
  * **Preferred**: true
  * **Period**: 2024-11-04 --> (ongoing)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "IANATimeZoneDatabase",
  "url" : "http://terminology.hl7.org/NamingSystem/IANATimeZoneDatabase",
  "version" : "1.0.0",
  "name" : "IANATimeZoneDatabase",
  "title" : "IANA Time Zone Database",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2024-11-04T23:00:00+10:00",
  "publisher" : "IANA",
  "contact" : [
    {
      "name" : "Internet Assigned Numbers Authority",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.iana.org/"
        },
        {
          "system" : "email",
          "value" : "iana@iana.org"
        },
        {
          "system" : "phone",
          "value" : "+14242545300"
        }
      ]
    }
  ],
  "description" : "The Time Zone Database (often called tz or zoneinfo) contains code and data that represent the history of local time for many representative locations around the globe. It is updated periodically to reflect changes made by political bodies to time zone boundaries, UTC offsets, and daylight-saving rules.",
  "copyright" : "Public domain",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "https://www.iana.org/time-zones",
      "preferred" : true,
      "period" : {
        "start" : "2024-11-04"
      }
    }
  ]
}

```
