# Federal Information Processing Standards Publication: Codes for the Identification of the States, the District of Columbia and the Outlying Areas of the United States, and Associated Areas (FIPS 5-2) - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Federal Information Processing Standards Publication: Codes for the Identification of the States, the District of Columbia and the Outlying Areas of the United States, and Associated Areas (FIPS 5-2)**

## NamingSystem: Federal Information Processing Standards Publication: Codes for the Identification of the States, the District of Columbia and the Outlying Areas of the United States, and Associated Areas (FIPS 5-2) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/FIPS52 | *Version*:1.0.0 | |
| Active as of 2024-10-21 | *Responsible:*[U.S. Department of Commerce; National Institute of Standards and Technology (NIST)](https://www.nist.gov/about-nist) | *Computable Name*:FIPS5_2 |
| **Copyright/Legal**: Data/works created by NIST employees that are not covered by the Standard Reference Data Act are subject to[17 U.S.C. §105](https://www.govinfo.gov/content/pkg/USCODE-2014-title17/pdf/USCODE-2014-title17-chap1-sec105.pdf)and generally are not subject to copyright protection within the United States. NIST data or other works may be subject to copyright protection in foreign countries. NIST may also obtain and hold copyright in data/works created by non-NIST employees (e.g., NIST contractors) when copyright is assigned to NIST. | | |

 
"This standard provides a set of two-digit numeric codes and a set of two-letter alphabetic codes for representing the 50 states, the District of Columbia and the outlying areas of the United States, and associated areas. The standard covers all land areas under the sovereignty of the United States, the freely associated states of Federated States of Micronesia and Marshall Islands, and the trust territory of Palau. This revision supersedes FIPS PUB 5-1 in its entirety." 
For more information, see[https://nvlpubs.nist.gov/nistpubs/Legacy/FIPS/fipspub5-2.pdf](https://nvlpubs.nist.gov/nistpubs/Legacy/FIPS/fipspub5-2.pdf) 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/FIPS52 |
| Version | 1.0.0 |
| Name | FIPS5_2 |
| Title | Federal Information Processing Standards Publication: Codes for the Identification of the States, the District of Columbia and the Outlying Areas of the United States, and Associated Areas (FIPS 5-2) |
| Status | active |
| Definition | "This standard provides a set of two-digit numeric codes and a set of two-letter alphabetic codes for representing the 50 states, the District of Columbia and the outlying areas of the United States, and associated areas. The standard covers all land areas under the sovereignty of the United States, the freely associated states of Federated States of Micronesia and Marshall Islands, and the trust territory of Palau. This revision supersedes FIPS PUB 5-1 in its entirety."For more information, see [https://nvlpubs.nist.gov/nistpubs/Legacy/FIPS/fipspub5-2.pdf](https://nvlpubs.nist.gov/nistpubs/Legacy/FIPS/fipspub5-2.pdf) |
| Publisher | U.S. Department of Commerce; National Institute of Standards and Technology (NIST) |
| Copyright | Data/works created by NIST employees that are not covered by the Standard Reference Data Act are subject to [17 U.S.C. §105](https://www.govinfo.gov/content/pkg/USCODE-2014-title17/pdf/USCODE-2014-title17-chap1-sec105.pdf) and generally are not subject to copyright protection within the United States. NIST data or other works may be subject to copyright protection in foreign countries. NIST may also obtain and hold copyright in data/works created by non-NIST employees (e.g., NIST contractors) when copyright is assigned to NIST. |

### Identifiers

* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/FIPS52
  * **Preferred**: true
  * **Period**: 2024-10-21 --> (ongoing)
* **Type**: OID
  * **Value**: 2.16.840.1.113883.6.92
  * **Preferred**: true
  * **Period**: 

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "FIPS52",
  "url" : "http://terminology.hl7.org/NamingSystem/FIPS52",
  "version" : "1.0.0",
  "name" : "FIPS5_2",
  "title" : "Federal Information Processing Standards Publication: Codes for the Identification of the States, the District of Columbia and the Outlying Areas of the United States, and Associated Areas (FIPS 5-2)",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2024-10-21T00:00:00-00:00",
  "publisher" : "U.S. Department of Commerce; National Institute of Standards and Technology (NIST)",
  "contact" : [
    {
      "name" : "National Institute of Standards and Technology (NIST); 100 Bureau Drive, Gaithersburg, MD 20899",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nist.gov/about-nist"
        },
        {
          "system" : "phone",
          "value" : "301-975-2000"
        }
      ]
    }
  ],
  "responsible" : "National Institute of Standards and Technology (NIST)",
  "description" : "\"This standard provides a set of two-digit numeric codes and a set of two-letter alphabetic codes for representing the 50 states, the District of Columbia and the outlying areas of the United States, and associated areas. The standard covers all land areas under the sovereignty of the United States, the freely associated states of Federated States of Micronesia and Marshall Islands, and the trust territory of Palau. This revision supersedes FIPS PUB 5-1 in its entirety.\"\r\n\r\nFor more information, see [https://nvlpubs.nist.gov/nistpubs/Legacy/FIPS/fipspub5-2.pdf](https://nvlpubs.nist.gov/nistpubs/Legacy/FIPS/fipspub5-2.pdf)",
  "copyright" : "Data/works created by NIST employees that are not covered by the Standard Reference Data Act are subject to [17 U.S.C. §105](https://www.govinfo.gov/content/pkg/USCODE-2014-title17/pdf/USCODE-2014-title17-chap1-sec105.pdf) and generally are not subject to copyright protection within the United States.  NIST data or other works may be subject to copyright protection in foreign countries.  NIST may also obtain and hold copyright in data/works created by non-NIST employees (e.g., NIST contractors) when copyright is assigned to NIST.",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/FIPS52",
      "preferred" : true,
      "period" : {
        "start" : "2024-10-21"
      }
    },
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.92",
      "preferred" : true
    }
  ]
}

```
