# EPSG Geodetic Parameter Dataset - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **EPSG Geodetic Parameter Dataset**

## NamingSystem: EPSG Geodetic Parameter Dataset 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/EPSG-GeodeticParameterDataset | *Version*:2.0.1 | |
| Retired as of 2021-11-09 | *Responsible:*HL7 | *Computable Name*:EPSGGeodeticParameterDataset |

 
**Description:**The EPSG (European Petroleum Survey Group) dataset represents all Datums, coordinate references (projected and 2D geographic) and coordinate systems (including Cartesian coordinate systems) used in surveying worldwide. Each record includes a 4-8 digit unique identifier. The current version is available from http://www.epsg.org/. The database contains over 4000 records covering spatial data applications worldwide. 
**Deprecation Comment:**This has been superceded by the two code systems EPSG-CRS and EPSG-CA 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/EPSG-GeodeticParameterDataset |
| Version | 2.0.1 |
| Name | EPSGGeodeticParameterDataset |
| Title | EPSG Geodetic Parameter Dataset |
| Status | retired |
| Definition | **Description:** The EPSG (European Petroleum Survey Group) dataset represents all Datums, coordinate references (projected and 2D geographic) and coordinate systems (including Cartesian coordinate systems) used in surveying worldwide. Each record includes a 4-8 digit unique identifier. The current version is available from http://www.epsg.org/. The database contains over 4000 records covering spatial data applications worldwide.**Deprecation Comment:** This has been superceded by the two code systems EPSG-CRS and EPSG-CA |
| Publisher | HL7 |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.6.242
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/EPSG-GeodeticParameterDataset
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "EPSG-GeodeticParameterDataset",
  "url" : "http://terminology.hl7.org/NamingSystem/EPSG-GeodeticParameterDataset",
  "version" : "2.0.1",
  "name" : "EPSGGeodeticParameterDataset",
  "title" : "EPSG Geodetic Parameter Dataset",
  "status" : "retired",
  "kind" : "codesystem",
  "date" : "2021-11-09T10:00:00+10:00",
  "publisher" : "HL7",
  "contact" : [
    {
      "name" : "OGP Surveying and Positioning Committee"
    }
  ],
  "responsible" : "HL7",
  "description" : "**Description:** The EPSG (European Petroleum Survey Group) dataset represents all Datums, coordinate references (projected and 2D geographic) and coordinate systems (including Cartesian coordinate systems) used in surveying worldwide. Each record includes a 4-8 digit unique identifier. The current version is available from http://www.epsg.org/. The database contains over 4000 records covering spatial data applications worldwide.\r\n\r\n**Deprecation Comment:** This has been superceded by the two code systems EPSG-CRS and EPSG-CA",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.242",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/EPSG-GeodeticParameterDataset",
      "preferred" : true
    }
  ]
}

```
