# Canadian Triage and Acuity Scale - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Canadian Triage and Acuity Scale**

## NamingSystem: Canadian Triage and Acuity Scale 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/CTAS | *Version*:1.0.0 | |
| Active as of 2025-10-31 | *Responsible:*[The CTAS National Advisory Committee, a partnership between NENA and CAEP](https://ctas-phctas.ca/) | *Computable Name*:CTAS |
| **Copyright/Legal**: © Canadian Association of Emergency Physicians (CAEP). Used with permission of the CTAS National Working Group. Reuse of CTAS materials (including educational content) requires express permission from CAEP/CTAS. | | |

 
The Canadian Triage and Acuity Scale (CTAS) provides a standardized, five-level method for prioritizing patients who present to emergency departments, ensuring that those in greatest need receive the fastest care. The system evolved from military triage principles, adapted for hospitals in the 1960s, and formally standardized in 1999 through collaboration among CAEP, NENA, and AMUQ. It replaced the earlier three-level model to improve national consistency, reliability, and patient outcomes. 
Triage is defined as a rapid, structured assessment process guided by critical thinking, where an experienced nurse evaluates a patient’s condition, determines severity, assigns a CTAS category, and directs them to appropriate care. This process improves safety, efficiency, and communication while helping manage limited emergency resources. The five CTAS levels range from Level 1 (Resuscitation) for life-threatening emergencies to Level 5 (Non-Urgent) for minor complaints. 
Effective triage depends on both system design and nurse expertise. Triage nurses must balance speed and accuracy, applying cognitive, behavioral, and interpersonal skills—critical thinking, autonomy, composure under pressure, compassion, and clear communication. Their role includes assessment, initiation of basic interventions, collaboration with physicians, documentation, and ongoing patient reassessment. They serve as patient advocates and frontline decision-makers in dynamic, often crowded environments. 
The triage process begins with a “critical look”—a 3-to-5-second across-the-room assessment of airway, breathing, circulation, and neurological status—followed by infection control screening, subjective (patient-reported) and objective (observed) assessments, and the selection of a CEDIS Presenting Complaint. Modifiers such as vital-sign deviations or risk factors help refine acuity assignment. Clear documentation of findings and CTAS level is essential, and reassessment intervals are defined: continuous for Level 1 patients, every 15 minutes for Level 2, and progressively less frequent for lower levels. 
Triage reliability can be affected by ED overcrowding or access block, leading to “triage drift,” where acuity scores may be subconsciously adjusted to fit available space. Strategies such as lean “streaming” processes, internal waiting rooms, and rapid assessment zones help mitigate these pressures. 
Ultimately, CTAS is more than a categorization tool—it is a cornerstone of emergency care quality and accountability. By integrating standardized assessment with professional judgment, it ensures that patients receive timely, appropriate care while supporting system efficiency, data benchmarking, and continuous improvement across Canadian emergency departments. 
For more information, see[https://share.google/PedyLtc66nmDyt3a7](https://share.google/PedyLtc66nmDyt3a7). 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/CTAS |
| Version | 1.0.0 |
| Name | CTAS |
| Title | Canadian Triage and Acuity Scale |
| Status | active |
| Definition | The Canadian Triage and Acuity Scale (CTAS) provides a standardized, five-level method for prioritizing patients who present to emergency departments, ensuring that those in greatest need receive the fastest care. The system evolved from military triage principles, adapted for hospitals in the 1960s, and formally standardized in 1999 through collaboration among CAEP, NENA, and AMUQ. It replaced the earlier three-level model to improve national consistency, reliability, and patient outcomes.Triage is defined as a rapid, structured assessment process guided by critical thinking, where an experienced nurse evaluates a patient’s condition, determines severity, assigns a CTAS category, and directs them to appropriate care. This process improves safety, efficiency, and communication while helping manage limited emergency resources. The five CTAS levels range from Level 1 (Resuscitation) for life-threatening emergencies to Level 5 (Non-Urgent) for minor complaints.Effective triage depends on both system design and nurse expertise. Triage nurses must balance speed and accuracy, applying cognitive, behavioral, and interpersonal skills—critical thinking, autonomy, composure under pressure, compassion, and clear communication. Their role includes assessment, initiation of basic interventions, collaboration with physicians, documentation, and ongoing patient reassessment. They serve as patient advocates and frontline decision-makers in dynamic, often crowded environments.The triage process begins with a “critical look”—a 3-to-5-second across-the-room assessment of airway, breathing, circulation, and neurological status—followed by infection control screening, subjective (patient-reported) and objective (observed) assessments, and the selection of a CEDIS Presenting Complaint. Modifiers such as vital-sign deviations or risk factors help refine acuity assignment. Clear documentation of findings and CTAS level is essential, and reassessment intervals are defined: continuous for Level 1 patients, every 15 minutes for Level 2, and progressively less frequent for lower levels.Triage reliability can be affected by ED overcrowding or access block, leading to “triage drift,” where acuity scores may be subconsciously adjusted to fit available space. Strategies such as lean “streaming” processes, internal waiting rooms, and rapid assessment zones help mitigate these pressures.Ultimately, CTAS is more than a categorization tool—it is a cornerstone of emergency care quality and accountability. By integrating standardized assessment with professional judgment, it ensures that patients receive timely, appropriate care while supporting system efficiency, data benchmarking, and continuous improvement across Canadian emergency departments.For more information, see [https://share.google/PedyLtc66nmDyt3a7](https://share.google/PedyLtc66nmDyt3a7). |
| Publisher | The CTAS National Advisory Committee, a partnership between NENA and CAEP |
| Copyright | © Canadian Association of Emergency Physicians (CAEP). Used with permission of the CTAS National Working Group. Reuse of CTAS materials (including educational content) requires express permission from CAEP/CTAS. |

### Identifiers

* **Type**: URI
  * **Value**: https://fhir.infoway-inforoute.ca/CodeSystem/ctas
  * **Preferred**: true
  * **Period**: 2025-10-02 --> (ongoing)
  * **Comment**: This is the URL as specified by the terminology owner, and is considered authoritative.



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "CTAS",
  "url" : "http://terminology.hl7.org/NamingSystem/CTAS",
  "version" : "1.0.0",
  "name" : "CTAS",
  "title" : "Canadian Triage and Acuity Scale",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2025-10-31T00:00:00-00:00",
  "publisher" : "The CTAS National Advisory Committee, a partnership between NENA and CAEP",
  "contact" : [
    {
      "name" : "The CTAS National Advisory Committee, a partnership between NENA and CAEP; 09-350 Sparks St, Ottawa, ON K1R 7S8, Canada",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://ctas-phctas.ca/"
        },
        {
          "system" : "phone",
          "value" : "1-(613) 523-3343"
        },
        {
          "system" : "email",
          "value" : "ctas@nena.ca"
        }
      ]
    }
  ],
  "responsible" : "Canada Health Infoway",
  "description" : "The Canadian Triage and Acuity Scale (CTAS) provides a standardized, five-level method for prioritizing patients who present to emergency departments, ensuring that those in greatest need receive the fastest care. The system evolved from military triage principles, adapted for hospitals in the 1960s, and formally standardized in 1999 through collaboration among CAEP, NENA, and AMUQ. It replaced the earlier three-level model to improve national consistency, reliability, and patient outcomes.\r\n\r\nTriage is defined as a rapid, structured assessment process guided by critical thinking, where an experienced nurse evaluates a patient’s condition, determines severity, assigns a CTAS category, and directs them to appropriate care. This process improves safety, efficiency, and communication while helping manage limited emergency resources. The five CTAS levels range from Level 1 (Resuscitation) for life-threatening emergencies to Level 5 (Non-Urgent) for minor complaints.\r\n\r\nEffective triage depends on both system design and nurse expertise. Triage nurses must balance speed and accuracy, applying cognitive, behavioral, and interpersonal skills—critical thinking, autonomy, composure under pressure, compassion, and clear communication. Their role includes assessment, initiation of basic interventions, collaboration with physicians, documentation, and ongoing patient reassessment. They serve as patient advocates and frontline decision-makers in dynamic, often crowded environments.\r\n\r\nThe triage process begins with a “critical look”—a 3-to-5-second across-the-room assessment of airway, breathing, circulation, and neurological status—followed by infection control screening, subjective (patient-reported) and objective (observed) assessments, and the selection of a CEDIS Presenting Complaint. Modifiers such as vital-sign deviations or risk factors help refine acuity assignment. Clear documentation of findings and CTAS level is essential, and reassessment intervals are defined: continuous for Level 1 patients, every 15 minutes for Level 2, and progressively less frequent for lower levels.\r\n\r\nTriage reliability can be affected by ED overcrowding or access block, leading to “triage drift,” where acuity scores may be subconsciously adjusted to fit available space. Strategies such as lean “streaming” processes, internal waiting rooms, and rapid assessment zones help mitigate these pressures.\r\n\r\nUltimately, CTAS is more than a categorization tool—it is a cornerstone of emergency care quality and accountability. By integrating standardized assessment with professional judgment, it ensures that patients receive timely, appropriate care while supporting system efficiency, data benchmarking, and continuous improvement across Canadian emergency departments.\r\n\r\nFor more information, see [https://share.google/PedyLtc66nmDyt3a7](https://share.google/PedyLtc66nmDyt3a7).",
  "copyright" : "© Canadian Association of Emergency Physicians (CAEP). Used with permission of the CTAS National Working Group. Reuse of CTAS materials (including educational content) requires express permission from CAEP/CTAS.",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "https://fhir.infoway-inforoute.ca/CodeSystem/ctas",
      "preferred" : true,
      "comment" : "This is the URL as specified by the terminology owner, and is considered authoritative.",
      "period" : {
        "start" : "2025-10-02"
      }
    }
  ]
}

```
