# Code on Dental Procedures and Nomenclature - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Code on Dental Procedures and Nomenclature**

## NamingSystem: Code on Dental Procedures and Nomenclature 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/CDT | *Version*:3.0.1 | |
| Active as of 2022-06-07 | *Responsible:*[American Dental Association](https://www.ada.org/) | *Computable Name*:CDT |

 
The purpose of the CDT Code is to achieve uniformity, consistency and specificity in accurately documenting dental treatment. One use of the CDT Code is to provide for the efficient processing of dental claims, and another is to populate an Electronic Health Record. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/CDT |
| Version | 3.0.1 |
| Name | CDT |
| Title | Code on Dental Procedures and Nomenclature |
| Status | active |
| Definition | The purpose of the CDT Code is to achieve uniformity, consistency and specificity in accurately documenting dental treatment. One use of the CDT Code is to provide for the efficient processing of dental claims, and another is to populate an Electronic Health Record. |
| Publisher | American Dental Association |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.6.13
  * **Preferred**: true
  * **Period**: 
  * **Comment**: 
* **Type**: URI
  * **Value**: http://www.ada.org/cdt
  * **Preferred**: true
  * **Period**: 2021-04-05 --> (ongoing)
  * **Comment**: Official canonical URL going forward.
* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/CD2
  * **Preferred**: false
  * **Period**: 
  * **Comment**: Maintained for backward compatibility.

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "CDT",
  "url" : "http://terminology.hl7.org/NamingSystem/CDT",
  "version" : "3.0.1",
  "name" : "CDT",
  "title" : "Code on Dental Procedures and Nomenclature",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2022-06-07T00:00:00-00:00",
  "publisher" : "American Dental Association",
  "contact" : [
    {
      "name" : "American Dental Association",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.ada.org/"
        },
        {
          "system" : "email",
          "value" : "dentalcode@ada.org"
        }
      ]
    }
  ],
  "description" : "The purpose of the CDT Code is to achieve uniformity, consistency and specificity in accurately documenting dental treatment. One use of the CDT Code is to provide for the efficient processing of dental claims, and another is to populate an Electronic Health Record.",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.13",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://www.ada.org/cdt",
      "preferred" : true,
      "comment" : "Official canonical URL going forward.",
      "period" : {
        "start" : "2021-04-05"
      }
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/CD2",
      "preferred" : false,
      "comment" : "Maintained for backward compatibility."
    }
  ]
}

```
